/*
 * Decompiled with CFR 0.152.
 */
package ambience.logviewer;

import ambience.gravity.GravityHelper$;
import ambience.logviewer.DownloadRequest;
import ambience.logviewer.LogRequest;
import ambience.logviewer.LogsModule;
import ambience.logviewer.LogsModule$;
import ambience.module.Module;
import ambience.module.ProjectConfig;
import ambience.module.RouteHelper$;
import ambience.module.UserDB;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityRoute;
import com.elixirtech.gravity.GravityRoute$;
import com.elixirtech.gravity.GravitySystem$;
import com.elixirtech.mongodb.RichMongoCollection;
import com.elixirtech.webserver.CodeLoader;
import com.elixirtech.webserver.DynamicCodeLoader;
import io.circe.Json;
import java.io.Serializable;
import monix.eval.Task;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

public class EventsLogViewer
implements Module {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(EventsLogViewer.class.getDeclaredField("indexHtml$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(EventsLogViewer.class.getDeclaredField("events$lzy1"));
    private final String id;
    private final String name;
    private final String url;
    private volatile Object events$lzy1;
    private final Function1 route = RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> this.authRoute((UserDB.User)user));
    private volatile Object indexHtml$lzy1;

    public EventsLogViewer(ProjectConfig projectConfig) {
        this.id = "events-log-viewer";
        this.name = "Event Logs";
        this.url = "events-log-viewer/index.html";
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String url() {
        return this.url;
    }

    public RichMongoCollection events() {
        Object object = this.events$lzy1;
        if (object instanceof RichMongoCollection) {
            return (RichMongoCollection)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RichMongoCollection)this.events$lzyINIT1();
    }

    private Object events$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.events$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RichMongoCollection richMongoCollection = null;
                    try {
                        richMongoCollection = LogsModule$.MODULE$.Database().getRichCollection("LogEvents");
                        object2 = richMongoCollection == null ? LazyVals.NullValue$.MODULE$ : richMongoCollection;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.events$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return richMongoCollection;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Function1<GravityRequest, Task<GravityResponse>> route() {
        return this.route;
    }

    public Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>> indexHtml() {
        Object object = this.indexHtml$lzy1;
        if (object instanceof Function1) {
            return (Function1)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Function1)this.indexHtml$lzyINIT1();
    }

    private Object indexHtml$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.indexHtml$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Function1 & Serializable intersect = null;
                    Function1 & Serializable intersect2 = null;
                    try {
                        DynamicCodeLoader dynamicCodeLoader = LogsModule$.MODULE$.codeLoader();
                        PartialFunction<String, String> partialFunction = LogsModule$.MODULE$.timeZone();
                        intersect2 = (Function1 & Serializable)user -> RouteHelper$.MODULE$.buildIndexHtml((CodeLoader)dynamicCodeLoader, this.id(), partialFunction, user);
                        intersect = intersect2 == null ? LazyVals.NullValue$.MODULE$ : intersect2;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, (Object)intersect)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.indexHtml$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, (Object)intersect);
                            waiting.countDown();
                        }
                    }
                    return intersect2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Function1<GravityRequest, Task<GravityResponse>> authRoute(UserDB.User user) {
        return GravitySystem$.MODULE$.fromRoutes((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GravityRoute[]{LogsModule$.MODULE$.codeLoader().route(), GravityRoute$.MODULE$.path("index.html", (Function1)this.indexHtml().apply((Object)user)), GravityRoute$.MODULE$.pathOnly(Gravity$.MODULE$.POST(), "events", this.getEvents()), GravityRoute$.MODULE$.pathOnly(Gravity$.MODULE$.POST(), "events-download", this.eventsDownload())})), GravitySystem$.MODULE$.fromRoutes$default$2());
    }

    public Function1<GravityRequest, Task<GravityResponse>> getEvents() {
        return (Function1 & Serializable)request -> GravityHelper$.MODULE$.jsonT(request).map((Function1 & Serializable)_$1 -> _$1.flatMap((Function1 & Serializable)json -> LogsModule$.MODULE$.logRequest((Json)json))).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                LogRequest logRequest = (LogRequest)((Some)option).value();
                return LogsModule$.MODULE$.handleError((Task<GravityResponse>)LogsModule$.MODULE$.get(this.events(), logRequest, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)LogsModule$.MODULE$.Limit()))).flatMap((Function1 & Serializable)result -> LogsModule$.MODULE$.buildResultResponse((LogsModule.Result)result)));
            }
            if (None$.MODULE$.equals(option)) {
                return Gravity$.MODULE$.BadRequestResponseT("Invalid request");
            }
            throw new MatchError((Object)option);
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> eventsDownload() {
        return (Function1 & Serializable)request -> GravityHelper$.MODULE$.jsonT(request).map((Function1 & Serializable)_$2 -> _$2.flatMap((Function1 & Serializable)json -> LogsModule$.MODULE$.downloadRequest((Json)json))).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                DownloadRequest dlRequest = (DownloadRequest)((Some)option).value();
                return LogsModule$.MODULE$.get(this.events(), dlRequest).flatMap((Function1 & Serializable)result -> LogsModule$.MODULE$.buildDownloadResponse("Events", dlRequest, (LogsModule.Result)result));
            }
            if (None$.MODULE$.equals(option)) {
                return Gravity$.MODULE$.BadRequestResponseT("Invalid request");
            }
            throw new MatchError((Object)option);
        });
    }
}

