/*
 * Decompiled with CFR 0.152.
 */
package monix.tail.batches;

import java.io.Serializable;
import monix.tail.batches.ArrayBatch;
import monix.tail.batches.Batch;
import monix.tail.batches.BatchCursor;
import monix.tail.batches.BatchCursor$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ArrayCursor<A>
extends BatchCursor<A> {
    private final Object _array;
    private final int _offset;
    private final int _length;
    private final Function0<ArrayBuilder<A>> newBuilder;
    private final int recommendedBatchSize;
    private final int limit;
    private int index;

    public ArrayCursor(Object _array, int _offset, int _length, Function0<ArrayBuilder<A>> newBuilder) {
        this._array = _array;
        this._offset = _offset;
        this._length = _length;
        this.newBuilder = newBuilder;
        Predef$.MODULE$.require(_offset + _length <= ScalaRunTime$.MODULE$.array_length(_array), ArrayCursor::$init$$$anonfun$1);
        Predef$.MODULE$.require(0 <= _offset && _offset <= ScalaRunTime$.MODULE$.array_length(_array), ArrayCursor::$init$$$anonfun$2);
        this.recommendedBatchSize = Integer.MAX_VALUE;
        this.limit = _offset + _length;
        this.index = -1;
    }

    public ArrayCursor(Object array, int offset, int length, ClassTag<A> tag) {
        this(array, offset, length, ArrayCursor.ArrayCursor$superArg$1(array, offset, length, tag));
    }

    public ArrayCursor(Object array, ClassTag<A> tag) {
        this(array, 0, ScalaRunTime$.MODULE$.array_length(array), tag);
    }

    @Override
    public int recommendedBatchSize() {
        return this.recommendedBatchSize;
    }

    public Object array() {
        return this._array;
    }

    public int offset() {
        return this._offset;
    }

    public int length() {
        return this._length;
    }

    @Override
    public boolean hasNext() {
        return this.getNextIndex() < this.limit;
    }

    @Override
    public A next() {
        this.index = this.getNextIndex();
        return (A)ScalaRunTime$.MODULE$.array_apply(this.array(), this.index);
    }

    @Override
    public ArrayCursor<A> take(int n) {
        int start = this.getNextIndex();
        int newLimit = package$.MODULE$.min(start + n, this.limit);
        return new ArrayCursor<A>(this._array, start, newLimit - start, this.newBuilder);
    }

    @Override
    public ArrayCursor<A> drop(int n) {
        int start = this.getNextIndex();
        int newOffset = package$.MODULE$.min(start + n, this.limit);
        int newLength = this.limit - newOffset;
        return new ArrayCursor<A>(this._array, newOffset, newLength, this.newBuilder);
    }

    @Override
    public ArrayCursor<A> slice(int from, int until) {
        return ((ArrayCursor)this.drop(from)).take(until - from);
    }

    @Override
    public <B> ArrayCursor<B> map(Function1<A, B> f) {
        ArrayCursor arrayCursor;
        int oldOffset = this.getNextIndex();
        int newLength = this.limit - oldOffset;
        if (newLength <= 0) {
            arrayCursor = BatchCursor$.MODULE$.fromAnyArray(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Object.class)), 0, 0);
        } else {
            Object[] copy = new Object[newLength];
            for (int i = 0; i < newLength; ++i) {
                copy[i] = f.apply(ScalaRunTime$.MODULE$.array_apply(this._array, i + oldOffset));
            }
            arrayCursor = BatchCursor$.MODULE$.fromAnyArray(copy, 0, newLength);
        }
        return arrayCursor;
    }

    @Override
    public ArrayCursor<A> filter(Function1<A, Object> p) {
        int oldOffset = this.getNextIndex();
        ArrayBuilder buffer = (ArrayBuilder)this.newBuilder.apply();
        for (int oldIndex = oldOffset; oldIndex < this.limit; ++oldIndex) {
            Object elem = ScalaRunTime$.MODULE$.array_apply(this._array, oldIndex);
            if (!BoxesRunTime.unboxToBoolean((Object)p.apply(elem))) continue;
            buffer.$plus$eq(ScalaRunTime$.MODULE$.array_apply(this._array, oldIndex));
        }
        Object copy = buffer.result();
        return new ArrayCursor<A>(copy, 0, ScalaRunTime$.MODULE$.array_length(copy), this.newBuilder);
    }

    @Override
    public <B> ArrayCursor<B> collect(PartialFunction<A, B> pf) {
        int oldOffset = this.getNextIndex();
        ArrayBuilder buffer = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Object.class));
        for (int oldIndex = oldOffset; oldIndex < this.limit; ++oldIndex) {
            Object elem = ScalaRunTime$.MODULE$.array_apply(this._array, oldIndex);
            if (!pf.isDefinedAt(elem)) continue;
            buffer.$plus$eq(pf.apply(ScalaRunTime$.MODULE$.array_apply(this._array, oldIndex)));
        }
        return BatchCursor$.MODULE$.fromArray(buffer.result());
    }

    @Override
    public Batch<A> toBatch() {
        int newOffset = this.getNextIndex();
        int newLength = this.limit - newOffset;
        return new ArrayBatch<A>(this._array, newOffset, newLength, this.newBuilder);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterator<A> toIterator() {
        Iterator iterator;
        int newOffset = this.getNextIndex();
        int newLength = this.limit - newOffset;
        if (newLength <= 0) {
            iterator = scala.package$.MODULE$.Iterator().empty();
        } else {
            void var3_4;
            Object object = Predef$.MODULE$.genericArrayOps(this._array);
            Iterator ref = ArrayOps$.MODULE$.iterator$extension(object);
            if (newOffset > 0) {
                ref = ref.drop(newOffset);
            }
            if (newLength < ScalaRunTime$.MODULE$.array_length(this._array)) {
                ref = ref.take(newLength);
            }
            iterator = var3_4;
        }
        return iterator;
    }

    private int getNextIndex() {
        return this.index < this._offset ? this._offset : this.index + 1;
    }

    private static <A> Function0<ArrayBuilder<A>> ArrayCursor$superArg$1(Object array, int offset, int length, ClassTag<A> tag) {
        return (Function0 & Serializable)() -> ArrayBuilder$.MODULE$.make(tag);
    }

    private static final String $init$$$anonfun$1() {
        return "offset + length <= array.length";
    }

    private static final String $init$$$anonfun$2() {
        return "0 <= offset <= length";
    }
}

