/*
 * Decompiled with CFR 0.152.
 */
package monix.tail.internal;

import cats.effect.Sync;
import cats.syntax.package;
import monix.execution.internal.collection.ChunkedArrayStack;
import monix.execution.internal.collection.ChunkedArrayStack$;
import monix.tail.Iterant;
import monix.tail.Iterant$;
import monix.tail.Iterant$NextCursor$;
import monix.tail.batches.BatchCursor;
import monix.tail.internal.IterantBuffer$;
import monix.tail.internal.package$;
import monix.tail.internal.package$ScopeExtensions$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class IterantBuffer {
    public static <F, A> Iterant<F, A> batched(Iterant<F, A> iterant, int n, Sync<F> sync) {
        return IterantBuffer$.MODULE$.batched(iterant, n, sync);
    }

    public static <F, A> Iterant<F, Seq<A>> sliding(Iterant<F, A> iterant, int n, int n2, Sync<F> sync) {
        return IterantBuffer$.MODULE$.sliding(iterant, n, n2, sync);
    }

    private static class BatchVisitor<F, A, B>
    extends Iterant.Visitor<F, A, F> {
        private final Function2<Object, F, Iterant<F, B>> f;
        private final Function1<Object, Iterant<F, B>> last;
        private final Sync<F> F;
        private final Buffer<A> buffer;
        private final ChunkedArrayStack<F> stack;

        public BatchVisitor(int count, int skip, Function2<Object, Object, Iterant<F, B>> f, Function1<Object, Iterant<F, B>> last, Sync<F> F) {
            this.f = f;
            this.last = last;
            this.F = F;
            this.buffer = new Buffer(count, skip);
            this.stack = ChunkedArrayStack$.MODULE$.apply(ChunkedArrayStack$.MODULE$.apply$default$1());
        }

        @Override
        public F visit(Iterant.Next<F, A> ref) {
            Object seq = this.buffer.push(ref.item());
            return (F)(seq != null ? this.F.pure(this.f.apply(seq, package.all$.MODULE$.toFlatMapOps(ref.rest(), this.F).flatMap((Function1)this))) : package.all$.MODULE$.toFlatMapOps(ref.rest(), this.F).flatMap((Function1)this));
        }

        @Override
        public F visit(Iterant.NextBatch<F, A> ref) {
            return this.processCursor(ref.toNextCursor());
        }

        @Override
        public F visit(Iterant.NextCursor<F, A> ref) {
            return this.processCursor(ref);
        }

        @Override
        public F visit(Iterant.Suspend<F, A> ref) {
            return (F)package.all$.MODULE$.toFlatMapOps(ref.rest(), this.F).flatMap((Function1)this);
        }

        @Override
        public F visit(Iterant.Concat<F, A> ref) {
            this.stack.push(ref.rh());
            return (F)package.all$.MODULE$.toFlatMapOps(ref.lh(), this.F).flatMap((Function1)this);
        }

        @Override
        public <S> F visit(Iterant.Scope<F, S, A> ref) {
            Iterant.Scope scope = package$.MODULE$.ScopeExtensions(ref);
            return (F)package$ScopeExtensions$.MODULE$.runFlatMap$extension(scope, this, this.F);
        }

        @Override
        public F visit(Iterant.Last<F, A> ref) {
            Object object;
            Object seq = this.buffer.push(ref.item());
            if (this.stack.isEmpty()) {
                if (seq == null) {
                    seq = this.buffer.rest();
                }
                object = this.F.pure(seq != null && ScalaRunTime$.MODULE$.array_length(seq) > 0 ? this.last.apply(seq) : Iterant$.MODULE$.empty());
            } else {
                Object rest = this.stack.pop();
                object = seq != null ? this.F.pure(this.f.apply(seq, package.all$.MODULE$.toFlatMapOps(rest, this.F).flatMap((Function1)this))) : package.all$.MODULE$.toFlatMapOps(rest, this.F).flatMap((Function1)this);
            }
            return (F)object;
        }

        @Override
        public F visit(Iterant.Halt<F, A> ref) {
            Object object;
            Option<Throwable> e = ref.e();
            if (this.stack.isEmpty() || e.isDefined()) {
                Iterant self = ref;
                Object seq = this.buffer.rest();
                object = this.F.pure(seq != null && ScalaRunTime$.MODULE$.array_length(seq) > 0 ? this.f.apply(seq, this.F.pure((Object)self)) : self);
            } else {
                object = package.all$.MODULE$.toFlatMapOps(this.stack.pop(), this.F).flatMap((Function1)this);
            }
            return (F)object;
        }

        @Override
        public F fail(Throwable e) {
            return (F)this.F.pure(Iterant$.MODULE$.raiseError(e));
        }

        private F processCursor(Iterant.NextCursor<F, A> fa) {
            Iterant.NextCursor<F, A> nextCursor = fa;
            if (nextCursor == null) {
                throw new MatchError(nextCursor);
            }
            Iterant.NextCursor<F, A> nextCursor2 = Iterant$NextCursor$.MODULE$.unapply(nextCursor);
            BatchCursor<A> batchCursor = nextCursor2._1();
            F f = nextCursor2._2();
            BatchCursor<A> cursor = batchCursor;
            F rest = f;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(cursor, rest);
            BatchCursor cursor2 = (BatchCursor)tuple2._1();
            Object rest2 = tuple2._2();
            while (cursor2.hasNext()) {
                Object seq = this.buffer.push(cursor2.next());
                if (seq == null) continue;
                Object next = cursor2.hasNext() ? this.F.pure(fa) : rest2;
                return (F)this.F.pure(this.f.apply(seq, package.all$.MODULE$.toFlatMapOps(next, this.F).flatMap((Function1)this)));
            }
            return (F)package.all$.MODULE$.toFlatMapOps(rest2, this.F).flatMap((Function1)this);
        }
    }

    private static final class Buffer<A> {
        private final int count;
        private final int toDrop;
        private final int toRepeat;
        private boolean isBufferNew;
        private Object[] buffer;
        private int dropped;
        private int length;

        public Buffer(int count, int skip) {
            this.count = count;
            this.toDrop = count > skip ? 0 : skip - count;
            this.toRepeat = skip > count ? 0 : count - skip;
            this.isBufferNew = true;
            this.buffer = new Object[count];
            this.dropped = 0;
            this.length = 0;
        }

        /*
         * WARNING - void declaration
         */
        public Object push(A elem) {
            Object v0;
            if (this.dropped > 0) {
                --this.dropped;
                v0 = null;
            } else {
                this.buffer[this.length] = elem;
                ++this.length;
                if (this.length < this.count) {
                    v0 = null;
                } else {
                    void var2_2;
                    Object[] oldBuffer = this.buffer;
                    this.buffer = new Object[this.count];
                    if (this.toRepeat > 0) {
                        System.arraycopy(oldBuffer, this.count - this.toRepeat, this.buffer, 0, this.toRepeat);
                        this.length = this.toRepeat;
                    } else {
                        this.dropped = this.toDrop;
                        this.length = 0;
                    }
                    if (this.isBufferNew) {
                        this.isBufferNew = false;
                    }
                    v0 = var2_2;
                }
            }
            return v0;
        }

        public Object rest() {
            Object object;
            int threshold;
            int n = threshold = this.isBufferNew ? 0 : this.toRepeat;
            if (this.length > threshold) {
                Object object2 = Predef$.MODULE$.refArrayOps(this.buffer);
                object = ArrayOps$.MODULE$.take$extension(object2, this.length);
            } else {
                object = null;
            }
            return object;
        }
    }
}

