/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.concurrent;

import cats.arrow.FunctionK;
import cats.effect.Async;
import cats.effect.Concurrent;
import cats.effect.Sync;
import cats.effect.concurrent.Deferred;
import cats.effect.concurrent.Deferred$;
import cats.effect.concurrent.Deferred$State$;
import cats.effect.concurrent.Deferred$State$Set$;
import cats.effect.concurrent.Deferred$State$Unset$;
import cats.effect.concurrent.TryableDeferred;
import cats.effect.internals.Callback$;
import cats.effect.internals.TrampolineEC;
import cats.effect.internals.TrampolineEC$;
import cats.syntax.RightOps$;
import cats.syntax.package;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.Iterator;
import scala.collection.immutable.LongMap;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Promise;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

public abstract class Deferred<F, A> {
    public static <F, A> Object apply(Concurrent<F> concurrent) {
        return Deferred$.MODULE$.apply(concurrent);
    }

    public static <F, G, A> Object in(Sync<F> sync, Concurrent<G> concurrent) {
        return Deferred$.MODULE$.in(sync, concurrent);
    }

    public static <F, A> Object tryable(Concurrent<F> concurrent) {
        return Deferred$.MODULE$.tryable(concurrent);
    }

    public static <F, A> Object tryableUncancelable(Async<F> async) {
        return Deferred$.MODULE$.tryableUncancelable(async);
    }

    public static <F, A> Object uncancelable(Async<F> async) {
        return Deferred$.MODULE$.uncancelable(async);
    }

    public static <F, G, A> Object uncancelableIn(Sync<F> sync, Async<G> async) {
        return Deferred$.MODULE$.uncancelableIn(sync, async);
    }

    public static <F, A> Deferred<F, A> unsafe(Concurrent<F> concurrent) {
        return Deferred$.MODULE$.unsafe(concurrent);
    }

    public static <F, A> Deferred<F, A> unsafeUncancelable(Async<F> async) {
        return Deferred$.MODULE$.unsafeUncancelable(async);
    }

    public abstract F get();

    public abstract F complete(A var1);

    public <G> Deferred<G, A> mapK(FunctionK<F, G> f) {
        return new TransformedDeferred(this, f);
    }

    private static final class ConcurrentDeferred<F, A>
    extends TryableDeferred<F, A> {
        private final AtomicReference<State<A>> ref;
        private final Concurrent<F> F;
        private final Function1<Object, BoxedUnit> mapUnit;

        public ConcurrentDeferred(AtomicReference<State<A>> ref, Concurrent<F> F) {
            this.ref = ref;
            this.F = F;
            this.mapUnit = (JProcedure1 & Serializable)_$18 -> {};
        }

        @Override
        public F get() {
            return this.F.defer(this::get$$anonfun$1);
        }

        @Override
        public F tryGet() {
            return this.F.delay(this::tryGet$$anonfun$1);
        }

        private long unsafeRegister(Function1<Either<Throwable, A>, BoxedUnit> cb) {
            long l;
            Either either = this.register$1(cb);
            if (either instanceof Left) {
                long id;
                l = id = BoxesRunTime.unboxToLong((Object)((Left)either).value());
            } else if (either instanceof Right) {
                Right r = (Right)either;
                Right right = package.all$.MODULE$.catsSyntaxRight(r);
                cb.apply((Object)RightOps$.MODULE$.leftCast$extension(right));
                l = 0L;
            } else {
                throw new MatchError((Object)either);
            }
            return l;
        }

        @Override
        public F complete(A a) {
            return this.F.defer(() -> this.complete$$anonfun$1(a));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private F unsafeComplete(A a) {
            ConcurrentDeferred concurrentDeferred = this;
            while (true) {
                Object object;
                State<A> state;
                if ((state = concurrentDeferred.ref.get()) instanceof State.Set) {
                    State.Set set = Deferred$State$Set$.MODULE$.unapply((State.Set)state);
                    Object a2 = set._1();
                    throw new IllegalStateException("Attempting to complete a Deferred that has already been completed");
                }
                if (!(state instanceof State.Unset)) throw new MatchError(state);
                State.Unset unset = Deferred$State$Unset$.MODULE$.unapply((State.Unset)state);
                LongMap longMap = unset._1();
                long l = unset._2();
                State.Unset s = (State.Unset)state;
                if (!concurrentDeferred.ref.compareAndSet(s, Deferred$State$Set$.MODULE$.apply(a))) continue;
                LongMap readers = s.waiting();
                if (readers.nonEmpty()) {
                    object = concurrentDeferred.notifyReadersLoop(a, readers);
                    return (F)object;
                }
                object = concurrentDeferred.F.unit();
                return (F)object;
            }
        }

        /*
         * WARNING - void declaration
         */
        private F notifyReadersLoop(A a, LongMap<Function1<A, BoxedUnit>> r) {
            void var3_3;
            Object acc = this.F.unit();
            Iterator cursor = r.valuesIterator();
            while (cursor.hasNext()) {
                Function1 next = (Function1)cursor.next();
                Object task = this.F.map(this.F.start(this.F.delay(() -> this.$anonfun$1(a, next))), this.mapUnit);
                acc = this.F.flatMap(acc, (Function1 & Serializable)_$17 -> task);
            }
            return var3_3;
        }

        private final void unregister$1(long id$1) {
            block2: {
                State<A> state;
                block3: {
                    LongMap longMap;
                    LongMap waiting;
                    State.Unset updated;
                    State.Unset unset;
                    State.Unset s;
                    do {
                        if ((state = this.ref.get()) instanceof State.Set) {
                            State.Set set = Deferred$State$Set$.MODULE$.unapply((State.Set)state);
                            Object a = set._1();
                            break block2;
                        }
                        if (!(state instanceof State.Unset)) break block3;
                        unset = (State.Unset)state;
                        State.Unset unset2 = Deferred$State$Unset$.MODULE$.unapply(unset);
                        longMap = unset2._1();
                        long l = unset2._2();
                    } while (!this.ref.compareAndSet(s = unset, updated = s.copy((LongMap)(waiting = longMap).$minus((Object)BoxesRunTime.boxToLong((long)id$1)), s.copy$default$2())));
                    break block2;
                }
                throw new MatchError(state);
            }
        }

        private final void get$$anonfun$2$$anonfun$1$$anonfun$1(long id$2) {
            this.unregister$1(id$2);
        }

        private final Object get$$anonfun$1() {
            Object object;
            State<A> state = this.ref.get();
            if (state instanceof State.Set) {
                Object a;
                State.Set set = Deferred$State$Set$.MODULE$.unapply((State.Set)state);
                Object a2 = a = set._1();
                object = this.F.pure(a2);
            } else if (state instanceof State.Unset) {
                State.Unset unset = Deferred$State$Unset$.MODULE$.unapply((State.Unset)state);
                LongMap longMap = unset._1();
                long l = unset._2();
                object = this.F.cancelable((Function1 & Serializable)cb -> {
                    long id = this.unsafeRegister((Function1<Either<Throwable, A>, BoxedUnit>)cb);
                    return this.F.delay(() -> this.get$$anonfun$2$$anonfun$1$$anonfun$1(id));
                });
            } else {
                throw new MatchError(state);
            }
            return object;
        }

        private final Option tryGet$$anonfun$1() {
            Some some;
            State<A> state = this.ref.get();
            if (state instanceof State.Set) {
                Object a;
                State.Set set = Deferred$State$Set$.MODULE$.unapply((State.Set)state);
                Object a2 = a = set._1();
                some = Some$.MODULE$.apply(a2);
            } else if (state instanceof State.Unset) {
                State.Unset unset = Deferred$State$Unset$.MODULE$.unapply((State.Unset)state);
                LongMap longMap = unset._1();
                long l = unset._2();
                some = None$.MODULE$;
            } else {
                throw new MatchError(state);
            }
            return some;
        }

        private final Either register$1(Function1 cb$1) {
            Right right;
            block2: {
                State<A> state;
                block3: {
                    long l;
                    long nextId;
                    State.Unset unset;
                    LongMap longMap;
                    LongMap waiting;
                    State.Unset updated;
                    State.Unset unset2;
                    State.Unset s;
                    do {
                        if ((state = this.ref.get()) instanceof State.Set) {
                            Object a2;
                            State.Set set = Deferred$State$Set$.MODULE$.unapply((State.Set)state);
                            Object a3 = a2 = set._1();
                            right = package$.MODULE$.Right().apply(a3);
                            break block2;
                        }
                        if (!(state instanceof State.Unset)) break block3;
                    } while (!this.ref.compareAndSet(s = (unset2 = (State.Unset)state), updated = Deferred$State$Unset$.MODULE$.apply((waiting = (longMap = (unset = Deferred$State$Unset$.MODULE$.unapply(unset2))._1())).updated(nextId = (l = unset._2()), (JProcedure1 & Serializable)a -> cb$1.apply((Object)package$.MODULE$.Right().apply(a))), nextId + 1L)));
                    right = package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToLong((long)nextId));
                    break block2;
                }
                throw new MatchError(state);
            }
            return right;
        }

        private final Object complete$$anonfun$1(Object a$1) {
            return this.unsafeComplete(a$1);
        }

        private final void $anonfun$1(Object a$2, Function1 next$1) {
            next$1.apply(a$2);
        }
    }

    private static abstract class State<A> {
        public static int ordinal(State state) {
            return Deferred$State$.MODULE$.ordinal(state);
        }
    }

    private static final class TransformedDeferred<F, G, A>
    extends Deferred<G, A> {
        private final Deferred<F, A> underlying;
        private final FunctionK<F, G> trans;

        public TransformedDeferred(Deferred<F, A> underlying, FunctionK<F, G> trans) {
            this.underlying = underlying;
            this.trans = trans;
        }

        @Override
        public G get() {
            return (G)this.trans.apply(this.underlying.get());
        }

        @Override
        public G complete(A a) {
            return (G)this.trans.apply(this.underlying.complete(a));
        }
    }

    private static final class UncancelableDeferred<F, A>
    extends TryableDeferred<F, A> {
        private final Promise<A> p;
        private final Async<F> F;
        private final F asyncBoundary;

        public UncancelableDeferred(Promise<A> p, Async<F> F) {
            this.p = p;
            this.F = F;
            this.asyncBoundary = F.async((JProcedure1 & Serializable)cb -> cb.apply(Callback$.MODULE$.rightUnit()));
        }

        @Override
        public F get() {
            return this.F.async((JProcedure1 & Serializable)cb -> {
                TrampolineEC ec = TrampolineEC$.MODULE$.immediate();
                this.p.future().onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Try try_ = x$1;
                    if (try_ instanceof Success) {
                        Object a = ((Success)try_).value();
                        cb.apply((Object)package$.MODULE$.Right().apply(a));
                    } else if (try_ instanceof Failure) {
                        Throwable t = ((Failure)try_).exception();
                        cb.apply((Object)package$.MODULE$.Left().apply((Object)t));
                    } else {
                        throw new MatchError((Object)try_);
                    }
                }, (ExecutionContext)ec);
            });
        }

        @Override
        public F tryGet() {
            return this.F.delay(this::tryGet$$anonfun$1);
        }

        @Override
        public F complete(A a) {
            return (F)this.F.map(this.asyncBoundary, (Function1)(JProcedure1 & Serializable)_$21 -> this.p.success(a));
        }

        private final Option tryGet$$anonfun$1() {
            return this.p.future().value().flatMap((Function1 & Serializable)_$20 -> _$20.toOption());
        }
    }
}

