/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.concurrent;

import cats.arrow.FunctionK;
import cats.effect.Async;
import cats.effect.Concurrent;
import cats.effect.Sync;
import cats.effect.concurrent.MVar$;
import cats.effect.concurrent.MVar$ApplyBuilders$;
import cats.effect.concurrent.MVar2;
import cats.effect.concurrent.MVarDocumentation;
import java.io.Serializable;
import scala.Function1;

public abstract class MVar<F, A>
implements MVarDocumentation {
    public static <F> Concurrent apply(Concurrent<F> concurrent) {
        return MVar$.MODULE$.apply(concurrent);
    }

    public static <F, A> Object empty(Concurrent<F> concurrent) {
        return MVar$.MODULE$.empty(concurrent);
    }

    public static <F, G, A> Object emptyIn(Sync<F> sync, Concurrent<G> concurrent) {
        return MVar$.MODULE$.emptyIn(sync, concurrent);
    }

    public static <F, G, A> Object in(A a, Sync<F> sync, Concurrent<G> concurrent) {
        return MVar$.MODULE$.in(a, sync, concurrent);
    }

    public static <F, A> Object of(A a, Concurrent<F> concurrent) {
        return MVar$.MODULE$.of(a, concurrent);
    }

    public static <F, A> Object uncancelableEmpty(Async<F> async) {
        return MVar$.MODULE$.uncancelableEmpty(async);
    }

    public static <F, G, A> Object uncancelableEmptyIn(Sync<F> sync, Async<G> async) {
        return MVar$.MODULE$.uncancelableEmptyIn(sync, async);
    }

    public static <F, G, A> Object uncancelableIn(A a, Sync<F> sync, Async<G> async) {
        return MVar$.MODULE$.uncancelableIn(a, sync, async);
    }

    public static <F, A> Object uncancelableOf(A a, Async<F> async) {
        return MVar$.MODULE$.uncancelableOf(a, async);
    }

    public abstract F isEmpty();

    public abstract F put(A var1);

    public abstract F tryPut(A var1);

    public abstract F take();

    public abstract F tryTake();

    public abstract F read();

    public <G> MVar<G, A> mapK(FunctionK<F, G> f) {
        return new TransformedMVar(this, f);
    }

    public static final class ApplyBuilders<F> {
        private final Concurrent F;

        public static <A, F> Object empty$extension(Concurrent concurrent) {
            return MVar$ApplyBuilders$.MODULE$.empty$extension(concurrent);
        }

        public static <F> boolean equals$extension(Concurrent concurrent, Object object) {
            return MVar$ApplyBuilders$.MODULE$.equals$extension(concurrent, object);
        }

        public static <F> int hashCode$extension(Concurrent concurrent) {
            return MVar$ApplyBuilders$.MODULE$.hashCode$extension(concurrent);
        }

        public static <A, F> Object of$extension(Concurrent concurrent, A a) {
            return MVar$ApplyBuilders$.MODULE$.of$extension(concurrent, a);
        }

        public ApplyBuilders(Concurrent<F> F) {
            this.F = F;
        }

        public int hashCode() {
            return MVar$ApplyBuilders$.MODULE$.hashCode$extension(this.F());
        }

        public boolean equals(Object x$0) {
            return MVar$ApplyBuilders$.MODULE$.equals$extension(this.F(), x$0);
        }

        public Concurrent<F> F() {
            return this.F;
        }

        public <A> F of(A a) {
            return (F)MVar$ApplyBuilders$.MODULE$.of$extension(this.F(), a);
        }

        public <A> F empty() {
            return (F)MVar$ApplyBuilders$.MODULE$.empty$extension(this.F());
        }
    }

    public static final class TransformedMVar<F, G, A>
    extends MVar<G, A> {
        private final MVar<F, A> underlying;
        private final FunctionK<F, G> trans;

        public TransformedMVar(MVar<F, A> underlying, FunctionK<F, G> trans) {
            this.underlying = underlying;
            this.trans = trans;
        }

        @Override
        public G isEmpty() {
            return (G)this.trans.apply(this.underlying.isEmpty());
        }

        @Override
        public G put(A a) {
            return (G)this.trans.apply(this.underlying.put(a));
        }

        @Override
        public G tryPut(A a) {
            return (G)this.trans.apply(this.underlying.tryPut(a));
        }

        @Override
        public G take() {
            return (G)this.trans.apply(this.underlying.take());
        }

        @Override
        public G tryTake() {
            return (G)this.trans.apply(this.underlying.tryTake());
        }

        @Override
        public G read() {
            return (G)this.trans.apply(this.underlying.read());
        }
    }

    public static final class TransformedMVar2<F, G, A>
    extends MVar2<G, A> {
        private final MVar2<F, A> underlying;
        private final FunctionK<F, G> trans;
        private final FunctionK<G, F> inverse;

        public TransformedMVar2(MVar2<F, A> underlying, FunctionK<F, G> trans, FunctionK<G, F> inverse) {
            this.underlying = underlying;
            this.trans = trans;
            this.inverse = inverse;
        }

        @Override
        public G isEmpty() {
            return (G)this.trans.apply(this.underlying.isEmpty());
        }

        @Override
        public G put(A a) {
            return (G)this.trans.apply(this.underlying.put(a));
        }

        @Override
        public G tryPut(A a) {
            return (G)this.trans.apply(this.underlying.tryPut(a));
        }

        @Override
        public G take() {
            return (G)this.trans.apply(this.underlying.take());
        }

        @Override
        public G tryTake() {
            return (G)this.trans.apply(this.underlying.tryTake());
        }

        @Override
        public G read() {
            return (G)this.trans.apply(this.underlying.read());
        }

        @Override
        public G tryRead() {
            return (G)this.trans.apply(this.underlying.tryRead());
        }

        @Override
        public G swap(A newValue) {
            return (G)this.trans.apply(this.underlying.swap(newValue));
        }

        @Override
        public <B> G use(Function1<A, G> f) {
            return (G)this.trans.apply(this.underlying.use((Function1 & Serializable)a -> this.inverse.apply(f.apply(a))));
        }

        @Override
        public <B> G modify(Function1<A, G> f) {
            return (G)this.trans.apply(this.underlying.modify((Function1 & Serializable)a -> this.inverse.apply(f.apply(a))));
        }

        @Override
        public G modify_(Function1<A, G> f) {
            return (G)this.trans.apply(this.underlying.modify_((Function1 & Serializable)a -> this.inverse.apply(f.apply(a))));
        }
    }
}

