/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.concurrent;

import cats.arrow.FunctionK;
import cats.effect.Async;
import cats.effect.Concurrent;
import cats.effect.ExitCase$Canceled$;
import cats.effect.Sync;
import cats.effect.concurrent.Deferred;
import cats.effect.concurrent.Deferred$;
import cats.effect.concurrent.Ref;
import cats.effect.concurrent.Semaphore$;
import cats.syntax.FlattenOps$;
import cats.syntax.package;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Queue$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public abstract class Semaphore<F> {
    public static <F> Object apply(long l, Concurrent<F> concurrent) {
        return Semaphore$.MODULE$.apply(l, concurrent);
    }

    public static <F, G> Object in(long l, Sync<F> sync, Concurrent<G> concurrent) {
        return Semaphore$.MODULE$.in(l, sync, concurrent);
    }

    public static <F> Object uncancelable(long l, Async<F> async) {
        return Semaphore$.MODULE$.uncancelable(l, async);
    }

    public static <F, G> Object uncancelableIn(long l, Sync<F> sync, Async<G> async) {
        return Semaphore$.MODULE$.uncancelableIn(l, sync, async);
    }

    public abstract F available();

    public abstract F count();

    public abstract F acquireN(long var1);

    public F acquire() {
        return this.acquireN(1L);
    }

    public abstract F tryAcquireN(long var1);

    public F tryAcquire() {
        return this.tryAcquireN(1L);
    }

    public abstract F releaseN(long var1);

    public F release() {
        return this.releaseN(1L);
    }

    public abstract <A> F withPermit(F var1);

    public <G> Semaphore<G> imapK(FunctionK<F, G> f, FunctionK<G, F> g) {
        return new TransformedSemaphore<F, G>(this, f, g);
    }

    private static abstract class AbstractSemaphore<F>
    extends Semaphore<F> {
        private final Ref<F, Either<Queue<Tuple2<Object, Deferred<F, BoxedUnit>>>, Object>> state;
        private final Async<F> F;

        public AbstractSemaphore(Ref<F, Either<Queue<Tuple2<Object, Deferred<F, BoxedUnit>>>, Object>> state, Async<F> F) {
            this.state = state;
            this.F = F;
        }

        public abstract F mkGate();

        private F open(Deferred<F, BoxedUnit> gate) {
            return gate.complete(BoxedUnit.UNIT);
        }

        @Override
        public F count() {
            return (F)package.all$.MODULE$.toFunctorOps(this.state.get(), this.F).map((Function1 & Serializable)s -> this.count_((Either<Queue<Tuple2<Object, Deferred<F, BoxedUnit>>>, Object>)s));
        }

        private long count_(Either<Queue<Tuple2<Object, Deferred<F, BoxedUnit>>>, Object> s) {
            long l;
            Either<Queue<Tuple2<Object, Deferred<F, BoxedUnit>>>, Object> either = s;
            if (either instanceof Left) {
                Queue waiting = (Queue)((Left)either).value();
                l = -BoxesRunTime.unboxToLong((Object)((IterableOnceOps)waiting.map((Function1 & Serializable)_$12 -> BoxesRunTime.unboxToLong((Object)_$12._1()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            } else if (either instanceof Right) {
                long available;
                l = available = BoxesRunTime.unboxToLong((Object)((Right)either).value());
            } else {
                throw new MatchError(either);
            }
            return l;
        }

        @Override
        public F acquireN(long n) {
            return this.F.bracketCase(this.acquireNInternal(n), (Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object g = tuple2._1();
                return g;
            }, (Function2 & Serializable)(x$1, x$2) -> {
                Object object;
                Tuple2 tuple2;
                Tuple2 tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                    Object c = tuple2._2();
                    if (ExitCase$Canceled$.MODULE$.equals(tuple22._2())) {
                        object = c;
                        return object;
                    }
                }
                object = this.F.unit();
                return object;
            });
        }

        public F acquireNInternal(long n) {
            return (F)package.all$.MODULE$.catsSyntaxApply(Semaphore$.MODULE$.cats$effect$concurrent$Semaphore$$$assertNonNegative(n, this.F), this.F).$times$greater(n == 0L ? this.F.pure(Tuple2$.MODULE$.apply(this.F.unit(), this.F.unit())) : package.all$.MODULE$.toFlatMapOps(this.mkGate(), this.F).flatMap((Function1 & Serializable)gate -> package.all$.MODULE$.toFunctorOps(this.state.modify((Function1 & Serializable)old -> {
                Right right;
                Either either = old;
                if (either instanceof Left) {
                    Queue waiting = (Queue)((Left)either).value();
                    Long l = (Long)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)n));
                    right = package$.MODULE$.Left().apply(waiting.$colon$plus((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)l, gate)));
                } else if (either instanceof Right) {
                    long m = BoxesRunTime.unboxToLong((Object)((Right)either).value());
                    if (n <= m) {
                        right = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)(m - n)));
                    } else {
                        Object[] objectArray = new Tuple2[1];
                        Long l = (Long)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)(n - m)));
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)l, gate);
                        right = package$.MODULE$.Left().apply((Object)Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
                    }
                } else {
                    throw new MatchError((Object)either);
                }
                Right u = right;
                return Tuple2$.MODULE$.apply((Object)u, (Object)u);
            }), this.F).map((Function1 & Serializable)x$12 -> {
                Tuple2 tuple2;
                Either either = x$12;
                if (either instanceof Left) {
                    Queue waiting = (Queue)((Left)either).value();
                    Object object = package.all$.MODULE$.catsSyntaxFlatten(this.state.modify((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2;
                        Either either = x$1;
                        if (either instanceof Left) {
                            Queue waiting = (Queue)((Left)either).value();
                            Option option = waiting.find((Function1 & Serializable)_$13 -> _$13._2() == gate).map((Function1 & Serializable)_$14 -> BoxesRunTime.unboxToLong((Object)_$14._1()));
                            if (None$.MODULE$.equals(option)) {
                                tuple2 = Tuple2$.MODULE$.apply((Object)package$.MODULE$.Left().apply((Object)waiting), this.releaseN(n));
                                return tuple2;
                            } else {
                                if (!(option instanceof Some)) throw new MatchError((Object)option);
                                long m = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                                tuple2 = Tuple2$.MODULE$.apply((Object)package$.MODULE$.Left().apply(waiting.filterNot((Function1 & Serializable)_$15 -> _$15._2() == gate)), this.releaseN(n - m));
                            }
                            return tuple2;
                        } else {
                            if (!(either instanceof Right)) throw new MatchError((Object)either);
                            long m = BoxesRunTime.unboxToLong((Object)((Right)either).value());
                            tuple2 = Tuple2$.MODULE$.apply((Object)package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)(m + n))), this.F.unit());
                        }
                        return tuple2;
                    }), this.F);
                    Object cleanup = FlattenOps$.MODULE$.flatten$extension(object, this.F);
                    Tuple2 entry = (Tuple2)waiting.lastOption().getOrElse(this::$anonfun$5);
                    Object object2 = Predef$.MODULE$.ArrowAssoc(((Deferred)entry._2()).get());
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object2, cleanup);
                } else if (either instanceof Right) {
                    Object object = Predef$.MODULE$.ArrowAssoc(this.F.unit());
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, this.releaseN(n));
                } else {
                    throw new MatchError((Object)either);
                }
                return tuple2;
            })));
        }

        @Override
        public F tryAcquireN(long n) {
            return (F)package.all$.MODULE$.catsSyntaxApply(Semaphore$.MODULE$.cats$effect$concurrent$Semaphore$$$assertNonNegative(n, this.F), this.F).$times$greater(n == 0L ? this.F.pure(BoxesRunTime.boxToBoolean((boolean)true)) : this.state.modify((Function1 & Serializable)old -> {
                long m;
                Either either = old;
                Tuple2 tuple2 = either instanceof Right && (m = BoxesRunTime.unboxToLong((Object)((Right)either).value())) >= n ? Tuple2$.MODULE$.apply((Object)package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)(m - n))), (Object)BoxesRunTime.boxToBoolean((boolean)true)) : Tuple2$.MODULE$.apply(old, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                Either newState = (Either)tuple2._1();
                boolean result = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                return Tuple2$.MODULE$.apply((Object)newState, (Object)BoxesRunTime.boxToBoolean((boolean)result));
            }));
        }

        @Override
        public F releaseN(long n) {
            return (F)package.all$.MODULE$.catsSyntaxApply(Semaphore$.MODULE$.cats$effect$concurrent$Semaphore$$$assertNonNegative(n, this.F), this.F).$times$greater(n == 0L ? this.F.unit() : package.all$.MODULE$.toFlatMapOps(this.state.modify((Function1 & Serializable)old -> {
                Object object;
                Either either = old;
                if (either instanceof Left) {
                    Queue waiting = (Queue)((Left)either).value();
                    long m = n;
                    Queue waiting2 = waiting;
                    while (waiting2.nonEmpty() && m > 0L) {
                        Tuple2 tuple2 = (Tuple2)waiting2.head();
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        long k = BoxesRunTime.unboxToLong((Object)tuple2._1());
                        Deferred gate = (Deferred)tuple2._2();
                        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)k), (Object)gate);
                        long k2 = BoxesRunTime.unboxToLong((Object)tuple22._1());
                        Deferred gate2 = (Deferred)tuple22._2();
                        if (k2 > m) {
                            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(k2 - m)), (Object)gate2);
                            waiting2 = (Queue)waiting2.tail().$plus$colon((Object)tuple23);
                            m = 0L;
                            continue;
                        }
                        m -= k2;
                        waiting2 = waiting2.tail();
                    }
                    object = waiting2.nonEmpty() ? package$.MODULE$.Left().apply((Object)waiting2) : package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)m));
                } else if (either instanceof Right) {
                    long m = BoxesRunTime.unboxToLong((Object)((Right)either).value());
                    object = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)(m + n)));
                } else {
                    throw new MatchError((Object)either);
                }
                Right u = object;
                return Tuple2$.MODULE$.apply((Object)u, (Object)Tuple2$.MODULE$.apply(old, (Object)u));
            }), this.F).flatMap((Function1 & Serializable)x$1 -> {
                Object object;
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Either previous = (Either)tuple2._1();
                Either now = (Either)tuple2._2();
                Either either = previous;
                if (either instanceof Left) {
                    int n;
                    Queue waiting = (Queue)((Left)either).value();
                    Either either2 = now;
                    if (either2 instanceof Left) {
                        Queue w = (Queue)((Left)either2).value();
                        n = w.size();
                    } else {
                        if (!(either2 instanceof Right)) throw new MatchError((Object)either2);
                        n = 0;
                    }
                    int newSize = n;
                    int released = waiting.size() - newSize;
                    object = ((IterableOnceOps)waiting.take(released)).foldRight(this.F.unit(), (Function2 & Serializable)(hd, tl) -> package.all$.MODULE$.catsSyntaxApply(this.open((Deferred)hd._2()), this.F).$times$greater(tl));
                    return object;
                } else {
                    if (!(either instanceof Right)) throw new MatchError((Object)either);
                    object = this.F.unit();
                }
                return object;
            }));
        }

        @Override
        public F available() {
            return (F)package.all$.MODULE$.toFunctorOps(this.state.get(), this.F).map((Function1 & Serializable)x$1 -> {
                long l;
                Either either = x$1;
                if (either instanceof Left) {
                    l = 0L;
                } else if (either instanceof Right) {
                    long n;
                    l = n = BoxesRunTime.unboxToLong((Object)((Right)either).value());
                } else {
                    throw new MatchError((Object)either);
                }
                return l;
            });
        }

        @Override
        public <A> F withPermit(F t) {
            return this.F.bracket(this.acquireNInternal(1L), (Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object g = tuple2._1();
                return package.all$.MODULE$.catsSyntaxApply(g, this.F).$times$greater(t);
            }, (Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object c = tuple2._2();
                return c;
            });
        }

        private final Tuple2 $anonfun$5() {
            throw scala.sys.package$.MODULE$.error("Semaphore has empty waiting queue rather than 0 count");
        }
    }

    private static final class AsyncSemaphore<F>
    extends AbstractSemaphore<F> {
        private final Async<F> F;

        public AsyncSemaphore(Ref<F, Either<Queue<Tuple2<Object, Deferred<F, BoxedUnit>>>, Object>> state, Async<F> F) {
            this.F = F;
            super(state, F);
        }

        @Override
        public F mkGate() {
            return (F)Deferred$.MODULE$.uncancelable(this.F);
        }
    }

    private static final class ConcurrentSemaphore<F>
    extends AbstractSemaphore<F> {
        private final Concurrent<F> F;

        public ConcurrentSemaphore(Ref<F, Either<Queue<Tuple2<Object, Deferred<F, BoxedUnit>>>, Object>> state, Concurrent<F> F) {
            this.F = F;
            super(state, F);
        }

        @Override
        public F mkGate() {
            return (F)Deferred$.MODULE$.apply(this.F);
        }
    }

    public static final class TransformedSemaphore<F, G>
    extends Semaphore<G> {
        private final Semaphore<F> underlying;
        private final FunctionK<F, G> trans;
        private final FunctionK<G, F> inverse;

        public TransformedSemaphore(Semaphore<F> underlying, FunctionK<F, G> trans, FunctionK<G, F> inverse) {
            this.underlying = underlying;
            this.trans = trans;
            this.inverse = inverse;
        }

        @Override
        public G available() {
            return (G)this.trans.apply(this.underlying.available());
        }

        @Override
        public G count() {
            return (G)this.trans.apply(this.underlying.count());
        }

        @Override
        public G acquireN(long n) {
            return (G)this.trans.apply(this.underlying.acquireN(n));
        }

        @Override
        public G tryAcquireN(long n) {
            return (G)this.trans.apply(this.underlying.tryAcquireN(n));
        }

        @Override
        public G releaseN(long n) {
            return (G)this.trans.apply(this.underlying.releaseN(n));
        }

        @Override
        public <A> G withPermit(G t) {
            return (G)this.trans.apply(this.underlying.withPermit(this.inverse.apply(t)));
        }
    }
}

