/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.internals;

import cats.effect.internals.Callback$;
import cats.effect.internals.Callback$Extensions$;
import cats.effect.internals.IOConnection;
import cats.effect.internals.Logger$;
import cats.effect.internals.TrampolineEC$;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function1;
import scala.MatchError;
import scala.concurrent.Promise;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

public final class Callback {
    public static <A> Function1 Extensions(Function1<Either<Throwable, A>, BoxedUnit> function1) {
        return Callback$.MODULE$.Extensions(function1);
    }

    public static <A> Function1<Either<Throwable, A>, BoxedUnit> async(Function1<Either<Throwable, A>, BoxedUnit> function1) {
        return Callback$.MODULE$.async(function1);
    }

    public static <A> Function1<Either<Throwable, A>, BoxedUnit> async(IOConnection iOConnection, Function1<Either<Throwable, A>, BoxedUnit> function1) {
        return Callback$.MODULE$.async(iOConnection, function1);
    }

    public static <A> Function1<Either<Throwable, A>, BoxedUnit> asyncIdempotent(IOConnection iOConnection, Function1<Either<Throwable, A>, BoxedUnit> function1) {
        return Callback$.MODULE$.asyncIdempotent(iOConnection, function1);
    }

    public static Function1<Object, BoxedUnit> dummy1() {
        return Callback$.MODULE$.dummy1();
    }

    public static <A> Function1<Either<Throwable, A>, BoxedUnit> promise(Promise<A> promise) {
        return Callback$.MODULE$.promise(promise);
    }

    public static <A> Function1<Either<Throwable, A>, BoxedUnit> report() {
        return Callback$.MODULE$.report();
    }

    public static Right<Nothing$, BoxedUnit> rightUnit() {
        return Callback$.MODULE$.rightUnit();
    }

    public static Success<BoxedUnit> successUnit() {
        return Callback$.MODULE$.successUnit();
    }

    private static final class AsyncIdempotentCallback<A>
    implements Function1<Either<Throwable, A>, BoxedUnit>,
    Runnable {
        private final IOConnection conn;
        private final Function1<Either<Throwable, A>, BoxedUnit> cb;
        private final AtomicBoolean canCall;
        private Either<Throwable, A> value;

        public AsyncIdempotentCallback(IOConnection conn, Function1<Either<Throwable, A>, BoxedUnit> cb) {
            this.conn = conn;
            this.cb = cb;
            this.canCall = new AtomicBoolean(true);
        }

        @Override
        public void run() {
            this.cb.apply(this.value);
        }

        public void apply(Either<Throwable, A> value) {
            if (this.canCall.getAndSet(false)) {
                if (this.conn != null) {
                    this.conn.pop();
                }
                this.value = value;
                TrampolineEC$.MODULE$.immediate().execute(this);
            } else {
                Either<Throwable, A> either = value;
                if (!(either instanceof Right)) {
                    if (either instanceof Left) {
                        Throwable e = (Throwable)((Left)either).value();
                        Logger$.MODULE$.reportFailure(e);
                    } else {
                        throw new MatchError(either);
                    }
                }
            }
        }
    }

    public static final class Extensions<A> {
        private final Function1 self;

        public static <A> void async$extension(Function1 function1, Either<Throwable, A> either) {
            Callback$Extensions$.MODULE$.async$extension(function1, either);
        }

        public static <A> void completeWithTry$extension(Function1 function1, Try<A> try_) {
            Callback$Extensions$.MODULE$.completeWithTry$extension(function1, try_);
        }

        public static <A> void completeWithTryAsync$extension(Function1 function1, Try<A> try_) {
            Callback$Extensions$.MODULE$.completeWithTryAsync$extension(function1, try_);
        }

        public static <A> boolean equals$extension(Function1 function1, Object object) {
            return Callback$Extensions$.MODULE$.equals$extension(function1, object);
        }

        public static <A> int hashCode$extension(Function1 function1) {
            return Callback$Extensions$.MODULE$.hashCode$extension(function1);
        }

        public Extensions(Function1<Either<Throwable, A>, BoxedUnit> self) {
            this.self = self;
        }

        public int hashCode() {
            return Callback$Extensions$.MODULE$.hashCode$extension(this.self());
        }

        public boolean equals(Object x$0) {
            return Callback$Extensions$.MODULE$.equals$extension(this.self(), x$0);
        }

        public Function1<Either<Throwable, A>, BoxedUnit> self() {
            return this.self;
        }

        public void async(Either<Throwable, A> value) {
            Callback$Extensions$.MODULE$.async$extension(this.self(), value);
        }

        public void completeWithTry(Try<A> result) {
            Callback$Extensions$.MODULE$.completeWithTry$extension(this.self(), result);
        }

        public void completeWithTryAsync(Try<A> result) {
            Callback$Extensions$.MODULE$.completeWithTryAsync$extension(this.self(), result);
        }
    }
}

