/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.internals;

import cats.effect.IO;
import cats.effect.IO$Async$;
import cats.effect.IO$Bind$;
import cats.effect.IO$ContextSwitch$;
import cats.effect.IO$Delay$;
import cats.effect.IO$Map$;
import cats.effect.IO$Pure$;
import cats.effect.IO$RaiseError$;
import cats.effect.IO$Suspend$;
import cats.effect.IO$Trace$;
import cats.effect.internals.ArrayStack;
import cats.effect.internals.IOConnection;
import cats.effect.internals.IOConnection$;
import cats.effect.internals.IOContext;
import cats.effect.internals.IOFrame;
import cats.effect.internals.IORunLoop;
import cats.effect.internals.TracingPlatform;
import cats.effect.tracing.IOEvent;
import cats.effect.tracing.IOTrace$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.NameTransformer$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure3;
import scala.util.Either;
import scala.util.control.NonFatal$;

public final class IORunLoop$
implements Serializable {
    private static final List<String> runLoopFilter;
    private static final int maxAutoCancelableBatchSize;
    public static final IORunLoop$ MODULE$;

    private IORunLoop$() {
    }

    static {
        MODULE$ = new IORunLoop$();
        runLoopFilter = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"cats.effect.", "scala.runtime."}));
        maxAutoCancelableBatchSize = 512;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IORunLoop$.class);
    }

    public <A> void start(IO<A> source, Function1<Either<Throwable, A>, BoxedUnit> cb) {
        this.cats$effect$internals$IORunLoop$$$loop(source, IOConnection$.MODULE$.uncancelable(), cb, null, null, null, null);
    }

    public <A> void restart(IO<A> source, IOContext ctx, Function1<Either<Throwable, A>, BoxedUnit> cb) {
        this.cats$effect$internals$IORunLoop$$$loop(source, IOConnection$.MODULE$.uncancelable(), cb, ctx, null, null, null);
    }

    public <A> void startCancelable(IO<A> source, IOConnection conn, Function1<Either<Throwable, A>, BoxedUnit> cb) {
        this.cats$effect$internals$IORunLoop$$$loop(source, conn, cb, null, null, null, null);
    }

    public <A> void restartCancelable(IO<A> source, IOConnection conn, IOContext ctx, Function1<Either<Throwable, A>, BoxedUnit> cb) {
        this.cats$effect$internals$IORunLoop$$$loop(source, conn, cb, ctx, null, null, null);
    }

    public void cats$effect$internals$IORunLoop$$$loop(IO<Object> source, IOConnection cancelable, Function1<Either<Throwable, Object>, BoxedUnit> cb, IOContext ctxRef, IORunLoop.RestartCallback rcbRef, Function1<Object, IO<Object>> bFirstRef, ArrayStack<Function1<Object, IO<Object>>> bRestRef) {
        IO currentIO = source;
        IOConnection conn = cancelable;
        IOContext ctx = ctxRef;
        Function1 bFirst = bFirstRef;
        ArrayStack<Object> bRest = bRestRef;
        IORunLoop.RestartCallback rcb = rcbRef;
        boolean hasUnboxed = false;
        Object unboxed = null;
        int currentIndex = 0;
        do {
            IO<Object> iO;
            if ((iO = currentIO) instanceof IO.Bind) {
                IO.Bind bind = (IO.Bind)iO;
                IO.Bind bind2 = IO$Bind$.MODULE$.unapply(bind);
                IO iO2 = bind2._1();
                Function1 function1 = bind2._2();
                Object object = bind2._3();
                IO fa = iO2;
                Function1 bindNext = function1;
                IO.Bind bind3 = bind;
                if (TracingPlatform.isStackTracing) {
                    Object trace;
                    if (ctx == null) {
                        ctx = new IOContext();
                    }
                    if ((trace = bind3.trace()) != null) {
                        ctx.pushEvent((IOEvent)trace);
                    }
                }
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = new ArrayStack();
                    }
                    bRest.push(bFirst);
                }
                bFirst = bindNext;
                currentIO = fa;
            } else if (iO instanceof IO.Pure) {
                Object a;
                IO.Pure pure = IO$Pure$.MODULE$.unapply((IO.Pure)iO);
                Object value = a = pure._1();
                unboxed = value;
                hasUnboxed = true;
            } else if (iO instanceof IO.Delay) {
                IO.Delay delay = IO$Delay$.MODULE$.unapply((IO.Delay)iO);
                Function0 function0 = delay._1();
                Object object = delay._2();
                Function0 thunk = function0;
                Object trace = object;
                try {
                    if (TracingPlatform.isStackTracing) {
                        if (ctx == null) {
                            ctx = new IOContext();
                        }
                        if (trace != null) {
                            ctx.pushEvent((IOEvent)trace);
                        }
                    }
                    unboxed = thunk.apply();
                    hasUnboxed = true;
                    currentIO = null;
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable e = throwable3 = (Throwable)option.get();
                        currentIO = IO$RaiseError$.MODULE$.apply(e);
                    }
                    throw throwable;
                }
            } else if (iO instanceof IO.Suspend) {
                IO.RaiseError raiseError;
                IO.Suspend suspend = IO$Suspend$.MODULE$.unapply((IO.Suspend)iO);
                Function0 function0 = suspend._1();
                Object object = suspend._2();
                Function0 thunk = function0;
                Object trace = object;
                try {
                    if (TracingPlatform.isStackTracing) {
                        if (ctx == null) {
                            ctx = new IOContext();
                        }
                        if (trace != null) {
                            ctx.pushEvent((IOEvent)trace);
                        }
                    }
                    raiseError = (IO.RaiseError)thunk.apply();
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable4 = throwable;
                    if (throwable4 != null && !(option = NonFatal$.MODULE$.unapply(throwable4)).isEmpty()) {
                        Throwable throwable5;
                        Throwable ex = throwable5 = (Throwable)option.get();
                        raiseError = IO$RaiseError$.MODULE$.apply(ex);
                    }
                    throw throwable;
                }
                currentIO = raiseError;
            } else if (iO instanceof IO.RaiseError) {
                IO.RaiseError raiseError;
                IOFrame<Object, IO<Object>> iOFrame;
                Throwable throwable;
                IO.RaiseError raiseError2 = IO$RaiseError$.MODULE$.unapply((IO.RaiseError)iO);
                Throwable ex = throwable = raiseError2._1();
                if (TracingPlatform.isStackTracing && TracingPlatform.enhancedExceptions && ctx != null) {
                    this.augmentException(ex, ctx);
                }
                if ((iOFrame = this.findErrorHandler(bFirst, bRest)) == null) {
                    cb.apply((Object)package$.MODULE$.Left().apply((Object)ex));
                    return;
                }
                IOFrame<Object, IO<Object>> bind = iOFrame;
                try {
                    raiseError = bind.recover(ex);
                }
                catch (Throwable throwable6) {
                    Option option;
                    Throwable throwable7 = throwable6;
                    if (throwable7 != null && !(option = NonFatal$.MODULE$.unapply(throwable7)).isEmpty()) {
                        Throwable throwable8;
                        Throwable e = throwable8 = (Throwable)option.get();
                        raiseError = IO$RaiseError$.MODULE$.apply(e);
                    }
                    throw throwable6;
                }
                IO.RaiseError fa = raiseError;
                bFirst = null;
                currentIO = fa;
            } else if (iO instanceof IO.Map) {
                IO.Map map = (IO.Map)iO;
                IO.Map map2 = IO$Map$.MODULE$.unapply(map);
                IO iO3 = map2._1();
                Function1 function1 = map2._2();
                Object object = map2._3();
                IO fa = iO3;
                IO.Map bindNext = map;
                if (TracingPlatform.isStackTracing) {
                    Object trace;
                    if (ctx == null) {
                        ctx = new IOContext();
                    }
                    if ((trace = bindNext.trace()) != null) {
                        ctx.pushEvent((IOEvent)trace);
                    }
                }
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = new ArrayStack();
                    }
                    bRest.push((Function1<Object, IO<Object>>)bFirst);
                }
                bFirst = bindNext;
                currentIO = fa;
            } else {
                if (iO instanceof IO.Async) {
                    Object trace;
                    IO.Async async = IO$Async$.MODULE$.unapply((IO.Async)iO);
                    Function3 function3 = async._1();
                    boolean bl = async._2();
                    Object object = async._3();
                    IO.Async async2 = (IO.Async)iO;
                    if (conn == null) {
                        conn = IOConnection$.MODULE$.apply();
                    }
                    if (ctx == null) {
                        ctx = new IOContext();
                    }
                    if (rcb == null) {
                        rcb = new IORunLoop.RestartCallback(conn, cb);
                    }
                    if (TracingPlatform.isStackTracing && (trace = async2.trace()) != null) {
                        ctx.pushEvent((IOEvent)trace);
                    }
                    rcb.start(async2, ctx, (Function1<Object, IO<Object>>)bFirst, bRest);
                    return;
                }
                if (iO instanceof IO.ContextSwitch) {
                    IO.ContextSwitch contextSwitch = IO$ContextSwitch$.MODULE$.unapply((IO.ContextSwitch)iO);
                    IO iO4 = contextSwitch._1();
                    Function1<IOConnection, IOConnection> function1 = contextSwitch._2();
                    Function4 function4 = contextSwitch._3();
                    IO next = iO4;
                    Function1<IOConnection, IOConnection> modify = function1;
                    Function4 restore = function4;
                    IOConnection old = conn != null ? conn : IOConnection$.MODULE$.apply();
                    conn = (IOConnection)modify.apply((Object)old);
                    currentIO = next;
                    if (conn != old) {
                        if (rcb != null) {
                            rcb.contextSwitch(conn);
                        }
                        if (restore != null) {
                            currentIO = IO$Bind$.MODULE$.apply(next, new IORunLoop.RestoreContext(old, restore), null);
                        }
                    }
                } else if (iO instanceof IO.Trace) {
                    IO.Trace trace = IO$Trace$.MODULE$.unapply((IO.Trace)iO);
                    IO iO5 = trace._1();
                    IOEvent iOEvent = trace._2();
                    IO source2 = iO5;
                    IOEvent frame = iOEvent;
                    if (ctx == null) {
                        ctx = new IOContext();
                    }
                    ctx.pushEvent(frame);
                    currentIO = source2;
                } else {
                    throw new MatchError(iO);
                }
            }
            if (hasUnboxed) {
                IO iO6;
                Function1 function1 = this.popNextBind(bFirst, bRest);
                if (function1 == null) {
                    cb.apply((Object)package$.MODULE$.Right().apply(unboxed));
                    return;
                }
                Function1 bind = function1;
                try {
                    iO6 = (IO)bind.apply(unboxed);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable9 = throwable;
                    if (throwable9 != null && !(option = NonFatal$.MODULE$.unapply(throwable9)).isEmpty()) {
                        Throwable throwable10;
                        Throwable ex = throwable10 = (Throwable)option.get();
                        iO6 = IO$RaiseError$.MODULE$.apply(ex);
                    }
                    throw throwable;
                }
                IO fa = iO6;
                hasUnboxed = false;
                unboxed = null;
                bFirst = null;
                currentIO = fa;
            }
            if (++currentIndex != maxAutoCancelableBatchSize) continue;
            if (conn.isCanceled()) {
                return;
            }
            currentIndex = 0;
        } while (true);
    }

    public <A> IO<A> step(IO<A> source) {
        IO.RaiseError currentIO = source;
        Function1 bFirst = null;
        ArrayStack<Function1> bRest = null;
        IOContext ctx = null;
        boolean hasUnboxed = false;
        Object unboxed = null;
        do {
            IO.RaiseError raiseError;
            IO<A> iO;
            if ((iO = currentIO) instanceof IO.Bind) {
                IO.Bind bind = (IO.Bind)iO;
                IO.Bind bind2 = IO$Bind$.MODULE$.unapply(bind);
                IO iO2 = bind2._1();
                Function1 function1 = bind2._2();
                Object object = bind2._3();
                IO fa = iO2;
                Function1 bindNext = function1;
                IO.Bind bind3 = bind;
                if (TracingPlatform.isStackTracing) {
                    Object trace;
                    if (ctx == null) {
                        ctx = new IOContext();
                    }
                    if ((trace = bind3.trace()) != null) {
                        ctx.pushEvent((IOEvent)trace);
                    }
                }
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = new ArrayStack<Function1>();
                    }
                    bRest.push(bFirst);
                }
                bFirst = bindNext;
                currentIO = fa;
            } else if (iO instanceof IO.Pure) {
                Object a;
                IO.Pure pure = IO$Pure$.MODULE$.unapply((IO.Pure)iO);
                Object value = a = pure._1();
                unboxed = value;
                hasUnboxed = true;
            } else if (iO instanceof IO.Delay) {
                IO.Delay delay = IO$Delay$.MODULE$.unapply((IO.Delay)iO);
                Function0 function0 = delay._1();
                Object object = delay._2();
                Function0 thunk = function0;
                Object trace = object;
                try {
                    if (TracingPlatform.isStackTracing) {
                        if (ctx == null) {
                            ctx = new IOContext();
                        }
                        if (trace != null) {
                            ctx.pushEvent((IOEvent)trace);
                        }
                    }
                    unboxed = thunk.apply();
                    hasUnboxed = true;
                    currentIO = null;
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable e = throwable3 = (Throwable)option.get();
                        currentIO = IO$RaiseError$.MODULE$.apply(e);
                    }
                    throw throwable;
                }
            } else if (iO instanceof IO.Suspend) {
                IO.RaiseError raiseError2;
                IO.Suspend suspend = IO$Suspend$.MODULE$.unapply((IO.Suspend)iO);
                Function0 function0 = suspend._1();
                Object object = suspend._2();
                Function0 thunk = function0;
                Object trace = object;
                try {
                    if (TracingPlatform.isStackTracing) {
                        if (ctx == null) {
                            ctx = new IOContext();
                        }
                        if (trace != null) {
                            ctx.pushEvent((IOEvent)trace);
                        }
                    }
                    raiseError2 = (IO.RaiseError)thunk.apply();
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable4 = throwable;
                    if (throwable4 != null && !(option = NonFatal$.MODULE$.unapply(throwable4)).isEmpty()) {
                        Throwable throwable5;
                        Throwable ex = throwable5 = (Throwable)option.get();
                        raiseError2 = IO$RaiseError$.MODULE$.apply(ex);
                    }
                    throw throwable;
                }
                currentIO = raiseError2;
            } else if (iO instanceof IO.RaiseError) {
                IO.RaiseError raiseError3;
                IOFrame<Object, IO<Object>> iOFrame;
                Throwable throwable;
                IO.RaiseError raiseError4 = IO$RaiseError$.MODULE$.unapply((IO.RaiseError)iO);
                Throwable ex = throwable = raiseError4._1();
                if (TracingPlatform.isStackTracing && TracingPlatform.enhancedExceptions && ctx != null) {
                    this.augmentException(ex, ctx);
                }
                if ((iOFrame = this.findErrorHandler(bFirst, bRest)) == null) {
                    return currentIO;
                }
                IOFrame<Object, IO<Object>> bind = iOFrame;
                try {
                    raiseError3 = bind.recover(ex);
                }
                catch (Throwable throwable6) {
                    Option option;
                    Throwable throwable7 = throwable6;
                    if (throwable7 != null && !(option = NonFatal$.MODULE$.unapply(throwable7)).isEmpty()) {
                        Throwable throwable8;
                        Throwable e = throwable8 = (Throwable)option.get();
                        raiseError3 = IO$RaiseError$.MODULE$.apply(e);
                    }
                    throw throwable6;
                }
                IO.RaiseError fa = raiseError3;
                bFirst = null;
                currentIO = fa;
            } else if (iO instanceof IO.Map) {
                IO.Map map = (IO.Map)iO;
                IO.Map map2 = IO$Map$.MODULE$.unapply(map);
                IO iO3 = map2._1();
                Function1 function1 = map2._2();
                Object object = map2._3();
                IO fa = iO3;
                IO.Map bindNext = map;
                if (TracingPlatform.isStackTracing) {
                    Object trace;
                    if (ctx == null) {
                        ctx = new IOContext();
                    }
                    if ((trace = bindNext.trace()) != null) {
                        ctx.pushEvent((IOEvent)trace);
                    }
                }
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = new ArrayStack();
                    }
                    bRest.push(bFirst);
                }
                bFirst = bindNext;
                currentIO = fa;
                if (ctx == null) {
                    ctx = new IOContext();
                }
            } else if (iO instanceof IO.Trace) {
                IO.Trace trace = IO$Trace$.MODULE$.unapply((IO.Trace)iO);
                IO.RaiseError raiseError5 = trace._1();
                IOEvent iOEvent = trace._2();
                IO.RaiseError source2 = raiseError5;
                IOEvent frame = iOEvent;
                if (ctx == null) {
                    ctx = new IOContext();
                }
                ctx.pushEvent(frame);
                currentIO = source2;
            } else {
                return this.suspendAsync(currentIO, ctx, bFirst, bRest);
            }
            if (!hasUnboxed) continue;
            Function1 function1 = this.popNextBind(bFirst, bRest);
            if (function1 == null) {
                return currentIO != null ? currentIO : IO$Pure$.MODULE$.apply(unboxed);
            }
            Function1 bind = function1;
            try {
                raiseError = (IO.RaiseError)bind.apply(unboxed);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable9 = throwable;
                if (throwable9 != null && !(option = NonFatal$.MODULE$.unapply(throwable9)).isEmpty()) {
                    Throwable throwable10;
                    Throwable ex = throwable10 = (Throwable)option.get();
                    raiseError = IO$RaiseError$.MODULE$.apply(ex);
                }
                throw throwable;
            }
            IO.RaiseError fa = raiseError;
            hasUnboxed = false;
            unboxed = null;
            bFirst = null;
            currentIO = fa;
        } while (true);
        return null;
    }

    private <A> IO<A> suspendAsync(IO<A> currentIO, IOContext ctx, Function1<Object, IO<Object>> bFirst, ArrayStack<Function1<Object, IO<Object>>> bRest) {
        return IO$Async$.MODULE$.apply((JProcedure3 & Serializable)(conn, _$1, cb) -> this.cats$effect$internals$IORunLoop$$$loop(currentIO, (IOConnection)conn, (Function1<Either<Throwable, Object>, BoxedUnit>)cb, ctx, null, bFirst, bRest), IO$Async$.MODULE$.$lessinit$greater$default$2(), IO$Async$.MODULE$.$lessinit$greater$default$3());
    }

    private Function1 popNextBind(Function1 bFirst, ArrayStack bRest) {
        if (bFirst != null && !(bFirst instanceof IOFrame.ErrorHandler)) {
            return bFirst;
        }
        if (bRest == null) {
            return null;
        }
        do {
            Function1 next;
            if ((next = (Function1)bRest.pop()) == null) {
                return null;
            }
            if (next instanceof IOFrame.ErrorHandler) continue;
            return next;
        } while (true);
        return null;
    }

    private IOFrame<Object, IO<Object>> findErrorHandler(Function1<Object, IO<Object>> bFirst, ArrayStack<Function1<Object, IO<Object>>> bRest) {
        IOFrame iOFrame;
        Function1<Object, IO<Object>> function1 = bFirst;
        if (function1 instanceof IOFrame) {
            IOFrame ref;
            iOFrame = ref = (IOFrame)function1;
        } else {
            Object v1;
            if (bRest == null) {
                v1 = null;
            } else {
                do {
                    Function1<Object, IO<Object>> ref;
                    if ((ref = bRest.pop()) == null) {
                        return null;
                    }
                    if (!(ref instanceof IOFrame)) continue;
                    return (IOFrame)ref;
                } while (true);
                v1 = null;
            }
            iOFrame = null;
        }
        return iOFrame;
    }

    private void augmentException(Throwable ex, IOContext ctx) {
        Object[] stackTrace = ex.getStackTrace();
        Object object = Predef$.MODULE$.refArrayOps(stackTrace);
        if (!ArrayOps$.MODULE$.isEmpty$extension(object)) {
            boolean augmented;
            boolean bl = augmented = ((StackTraceElement)stackTrace[stackTrace.length - 1]).getClassName().indexOf(64) != -1;
            if (!augmented) {
                Object[] prefix = this.dropRunLoopFrames((StackTraceElement[])stackTrace);
                StackTraceElement[] suffix = (StackTraceElement[])ctx.getStackTraces().flatMap((Function1 & Serializable)t -> IOTrace$.MODULE$.getOpAndCallSite(t.stackTrace())).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    StackTraceElement methodSite = (StackTraceElement)tuple2._1();
                    StackTraceElement callSite = (StackTraceElement)tuple2._2();
                    String op = NameTransformer$.MODULE$.decode(methodSite.getMethodName());
                    return new StackTraceElement(op + " @ " + callSite.getClassName(), callSite.getMethodName(), callSite.getFileName(), callSite.getLineNumber());
                }).toArray(ClassTag$.MODULE$.apply(StackTraceElement.class));
                Object object2 = Predef$.MODULE$.refArrayOps(prefix);
                ex.setStackTrace((StackTraceElement[])ArrayOps$.MODULE$.$plus$plus$extension(object2, (Object)suffix, ClassTag$.MODULE$.apply(StackTraceElement.class)));
            }
        }
    }

    private StackTraceElement[] dropRunLoopFrames(StackTraceElement[] frames) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])frames);
        return (StackTraceElement[])ArrayOps$.MODULE$.takeWhile$extension(object, (Function1 & Serializable)ste -> !runLoopFilter.exists((Function1 & Serializable)_$2 -> ste.getClassName().startsWith((String)_$2)));
    }
}

