/*
 * Decompiled with CFR 0.152.
 */
package ambience.ingester.kafka;

import ambience.ambience.ingester.IngestionController;
import ambience.ambience.ingester.IngestionController$NotStarted$;
import ambience.ambience.ingester.IngestionController$Paused$;
import ambience.ambience.ingester.IngestionController$Running$;
import ambience.etl.kafka.KafkaCategory$;
import ambience.etl.mongodb.ConnectionPool$;
import ambience.ingester.kafka.KafkaIngester$;
import ambience.ingester.kafka.KafkaIngester$Structure$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.RichMongoCollection;
import com.typesafe.config.Config;
import io.circe.Json;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler$;
import monix.kafka.Deserializer$;
import monix.kafka.KafkaConsumerConfig;
import monix.kafka.KafkaConsumerObservable;
import monix.kafka.KafkaConsumerObservable$;
import monix.reactive.Observable;
import monix.reactive.subjects.PublishSubject;
import monix.reactive.subjects.PublishSubject$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.bson.BsonDateTime;
import org.mongodb.scala.MongoDatabase;
import org.mongodb.scala.bson.BsonBinary$;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonInt32$;
import org.mongodb.scala.bson.BsonInt64$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public class KafkaIngester
implements IngestionController,
LoggingHelper2 {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(KafkaIngester.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(KafkaIngester.class.getDeclaredField("cltn$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(KafkaIngester.class.getDeclaredField("targetDB$lzy1"));
    private volatile Object log$lzy1;
    private final Structure structure;
    private IngestionController.Status _status;
    private volatile Object targetDB$lzy1;
    private volatile Object cltn$lzy1;
    private final String name;
    private final KafkaConsumerConfig kafkaConfig;
    private final KafkaConsumerObservable consumer;
    private final PublishSubject pauser;

    public static Either<String, Structure> structureFromConfig(Config config) {
        return KafkaIngester$.MODULE$.structureFromConfig(config);
    }

    public static Either<String, Structure> structureFromJson(Json json) {
        return KafkaIngester$.MODULE$.structureFromJson(json);
    }

    public KafkaIngester(Structure structure) {
        this.structure = structure;
        this._status = IngestionController$NotStarted$.MODULE$;
        this.name = structure.name();
        this.kafkaConfig = (KafkaConsumerConfig)KafkaCategory$.MODULE$.getConsumerConfig(structure.server()).getOrElse(KafkaIngester::$init$$$anonfun$1);
        this.consumer = KafkaConsumerObservable$.MODULE$.apply(this.kafkaConfig(), (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{structure.topic()}))), Deserializer$.MODULE$.forByteArray(), Deserializer$.MODULE$.forByteArray());
        this.pauser = PublishSubject$.MODULE$.apply();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public MongoDatabase targetDB() {
        Object object = this.targetDB$lzy1;
        if (object instanceof MongoDatabase) {
            return (MongoDatabase)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (MongoDatabase)this.targetDB$lzyINIT1();
    }

    private Object targetDB$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.targetDB$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    MongoDatabase mongoDatabase = null;
                    try {
                        mongoDatabase = (MongoDatabase)ConnectionPool$.MODULE$.getPool(this.structure.database()).getOrElse(this::targetDB$lzyINIT1$$anonfun$1);
                        object2 = mongoDatabase == null ? LazyVals.NullValue$.MODULE$ : mongoDatabase;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.targetDB$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return mongoDatabase;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public RichMongoCollection cltn() {
        Object object = this.cltn$lzy1;
        if (object instanceof RichMongoCollection) {
            return (RichMongoCollection)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RichMongoCollection)this.cltn$lzyINIT1();
    }

    private Object cltn$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.cltn$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RichMongoCollection richMongoCollection = null;
                    try {
                        richMongoCollection = new RichMongoCollection(this.targetDB().getCollection(this.structure.collection(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
                        object2 = richMongoCollection == null ? LazyVals.NullValue$.MODULE$ : richMongoCollection;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.cltn$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return richMongoCollection;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public String name() {
        return this.name;
    }

    public KafkaConsumerConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public KafkaConsumerObservable<byte[], byte[], ConsumerRecord<byte[], byte[]>> consumer() {
        return this.consumer;
    }

    public PublishSubject<BoxedUnit> pauser() {
        return this.pauser;
    }

    @Override
    public Task<BoxedUnit> start() {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.start$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Task<BoxedUnit> pause() {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.pause$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Task<BoxedUnit> resume() {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.resume$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Task<IngestionController.Status> status() {
        return Task$.MODULE$.apply(this::status$$anonfun$1);
    }

    public Task<BoxedUnit> run(Observable<ConsumerRecord<byte[], byte[]>> ob) {
        return ob.mapEval((Function1 & Serializable)rec -> {
            BsonDateTime now = BsonDateTime$.MODULE$.apply(System.currentTimeMillis());
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[6];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"topic");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(rec.topic())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"topicOffset");
            objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonInt64$.MODULE$.apply(rec.offset())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"topicPartition");
            objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonInt32$.MODULE$.apply(rec.partition())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"key");
            objectArray[3] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)BsonBinary$.MODULE$.apply((byte[])rec.key())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"bytes");
            objectArray[4] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)BsonBinary$.MODULE$.apply((byte[])rec.value())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"added");
            objectArray[5] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)now), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            Document doc = org.mongodb.scala.bson.package$.MODULE$.Document().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            return this.cltn().insertOneT(doc).void();
        }).completedL();
    }

    private static final KafkaConsumerConfig $init$$$anonfun$1() {
        throw new RuntimeException("Bad config");
    }

    private final MongoDatabase targetDB$lzyINIT1$$anonfun$1() {
        throw new RuntimeException("database " + this.structure.database() + " not found");
    }

    private final void start$$anonfun$1() {
        this._status = IngestionController$Running$.MODULE$;
        this.run((Observable<ConsumerRecord<byte[], byte[]>>)((Observable)this.consumer()).takeUntil(this.pauser())).runToFuture(Scheduler$.MODULE$.global());
    }

    private final void pause$$anonfun$1() {
        this._status = IngestionController$Paused$.MODULE$;
        this.pauser().onNext((Object)BoxedUnit.UNIT);
    }

    private final void resume$$anonfun$1() {
        this._status = IngestionController$Running$.MODULE$;
        this.run((Observable<ConsumerRecord<byte[], byte[]>>)((Observable)this.consumer()).takeUntil(this.pauser())).runToFuture(Scheduler$.MODULE$.global());
    }

    private final IngestionController.Status status$$anonfun$1() {
        return this._status;
    }

    public static final class Structure
    implements Product,
    Serializable {
        private final String name;
        private final String server;
        private final String topic;
        private final String database;
        private final String collection;

        public static Structure apply(String string, String string2, String string3, String string4, String string5) {
            return KafkaIngester$Structure$.MODULE$.apply(string, string2, string3, string4, string5);
        }

        public static Structure fromProduct(Product product) {
            return KafkaIngester$Structure$.MODULE$.fromProduct(product);
        }

        public static Structure unapply(Structure structure) {
            return KafkaIngester$Structure$.MODULE$.unapply(structure);
        }

        public Structure(String name, String server, String topic, String database, String collection) {
            this.name = name;
            this.server = server;
            this.topic = topic;
            this.database = database;
            this.collection = collection;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Structure)) return false;
            Structure structure = (Structure)object;
            String string = this.name();
            String string2 = structure.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.server();
            String string4 = structure.server();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.topic();
            String string6 = structure.topic();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.database();
            String string8 = structure.database();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.collection();
            String string10 = structure.collection();
            if (string9 == null) {
                if (string10 == null) return true;
                return false;
            } else {
                if (!string9.equals(string10)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Structure;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "Structure";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "server";
                }
                case 2: {
                    return "topic";
                }
                case 3: {
                    return "database";
                }
                case 4: {
                    return "collection";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public String server() {
            return this.server;
        }

        public String topic() {
            return this.topic;
        }

        public String database() {
            return this.database;
        }

        public String collection() {
            return this.collection;
        }

        public Structure copy(String name, String server, String topic, String database, String collection) {
            return new Structure(name, server, topic, database, collection);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.server();
        }

        public String copy$default$3() {
            return this.topic();
        }

        public String copy$default$4() {
            return this.database();
        }

        public String copy$default$5() {
            return this.collection();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.server();
        }

        public String _3() {
            return this.topic();
        }

        public String _4() {
            return this.database();
        }

        public String _5() {
            return this.collection();
        }
    }
}

