/*
 * Decompiled with CFR 0.152.
 */
package monix.kafka;

import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.Future;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Callback;
import monix.execution.Callback$;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.Scheduler;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.cancelables.SingleAssignCancelable;
import monix.execution.cancelables.SingleAssignCancelable$;
import monix.execution.cancelables.StackedCancelable;
import monix.execution.cancelables.StackedCancelable$;
import monix.kafka.KafkaProducer$;
import monix.kafka.KafkaProducerConfig;
import monix.kafka.Serializer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import scala.Function0;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure2;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;
import sourcecode.FullName$;
import sourcecode.Line$;

public interface KafkaProducer<K, V>
extends Serializable {
    public static <K, V> KafkaProducer<K, V> apply(KafkaProducerConfig kafkaProducerConfig, Scheduler scheduler, Serializer<K> serializer, Serializer<V> serializer2) {
        return KafkaProducer$.MODULE$.apply(kafkaProducerConfig, scheduler, serializer, serializer2);
    }

    public Task<org.apache.kafka.clients.producer.KafkaProducer<K, V>> underlying();

    public Task<Option<RecordMetadata>> send(String var1, V var2);

    public Task<Option<RecordMetadata>> send(String var1, K var2, V var3);

    public Task<Option<RecordMetadata>> send(ProducerRecord<K, V> var1);

    public Task<BoxedUnit> close();

    public static final class Implementation<K, V>
    implements KafkaProducer<K, V>,
    LoggingHelper2 {
        public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Implementation.class.getDeclaredField("log$lzy1"));
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Implementation.class.getDeclaredField("producerRef$lzy1"));
        private volatile Object log$lzy1;
        private final KafkaProducerConfig config;
        private final Scheduler sc;
        private final Serializer<K> K;
        private final Serializer<V> V;
        private final AtomicBoolean isCanceled;
        private volatile Object producerRef$lzy1;

        public Implementation(KafkaProducerConfig config, Scheduler sc, Serializer<K> K, Serializer<V> V) {
            this.config = config;
            this.sc = sc;
            this.K = K;
            this.V = V;
            this.isCanceled = AtomicBuilder.AtomicBooleanBuilder$.MODULE$.buildInstance(false, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
        }

        public LoggingInterface log() {
            Object object = this.log$lzy1;
            if (object instanceof LoggingInterface) {
                return (LoggingInterface)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (LoggingInterface)this.log$lzyINIT1();
        }

        private Object log$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.log$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        LoggingInterface loggingInterface = null;
                        try {
                            loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                            object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return loggingInterface;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        private org.apache.kafka.clients.producer.KafkaProducer<K, V> producerRef() {
            Object object = this.producerRef$lzy1;
            if (object instanceof org.apache.kafka.clients.producer.KafkaProducer) {
                return (org.apache.kafka.clients.producer.KafkaProducer)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (org.apache.kafka.clients.producer.KafkaProducer)this.producerRef$lzyINIT1();
        }

        private Object producerRef$lzyINIT1() {
            Object object;
            block7: {
                while (true) {
                    if ((object = this.producerRef$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        org.apache.kafka.clients.producer.KafkaProducer kafkaProducer = null;
                        try {
                            this.log().info(this::producerRef$lzyINIT1$$anonfun$1, Line$.MODULE$.apply(72), FullName$.MODULE$.apply("monix.kafka.KafkaProducer.Implementation.producerRef"));
                            org.apache.kafka.common.serialization.Serializer<K> keySerializer = this.K.create();
                            org.apache.kafka.common.serialization.Serializer<V> valueSerializer = this.V.create();
                            Map<String, Object> configJavaMap = this.config.toJavaMap();
                            keySerializer.configure(configJavaMap, true);
                            valueSerializer.configure(configJavaMap, false);
                            kafkaProducer = new org.apache.kafka.clients.producer.KafkaProducer(configJavaMap, keySerializer, valueSerializer);
                            object2 = kafkaProducer == null ? LazyVals.NullValue$.MODULE$ : kafkaProducer;
                        }
                        catch (Throwable throwable) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.producerRef$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                            throw throwable;
                        }
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.producerRef$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        return kafkaProducer;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public Task<org.apache.kafka.clients.producer.KafkaProducer<K, V>> underlying() {
            return Task$.MODULE$.eval(this::underlying$$anonfun$1);
        }

        @Override
        public Task<Option<RecordMetadata>> send(String topic, V value) {
            return this.send(new ProducerRecord(topic, value));
        }

        @Override
        public Task<Option<RecordMetadata>> send(String topic, K key, V value) {
            return this.send(new ProducerRecord(topic, key, value));
        }

        @Override
        public Task<Option<RecordMetadata>> send(ProducerRecord<K, V> record) {
            boolean bl = Task$.MODULE$.create();
            return Task.AsyncBuilder$.CreatePartiallyApplied$.MODULE$.apply$extension(bl, (Function2 & Serializable)(s, cb) -> {
                Callback asyncCb = Callback$.MODULE$.forked(cb, (ExecutionContext)s);
                StackedCancelable connection = StackedCancelable$.MODULE$.apply();
                this.sc.execute(() -> {
                    if (this.isCanceled.get()) {
                        asyncCb.onSuccess((Object)None$.MODULE$);
                        return;
                    }
                    AtomicBoolean isActive = AtomicBuilder.AtomicBooleanBuilder$.MODULE$.buildInstance(true, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
                    SingleAssignCancelable cancelable = SingleAssignCancelable$.MODULE$.apply();
                    try {
                        org.apache.kafka.clients.producer.KafkaProducer<K, V> producer = this.producerRef();
                        Future future = producer.send(record, new org.apache.kafka.clients.producer.Callback(isActive, connection, asyncCb, (Scheduler)s){
                            private final AtomicBoolean isActive$1;
                            private final StackedCancelable connection$2;
                            private final Callback asyncCb$2;
                            private final Scheduler s$2;
                            {
                                this.isActive$1 = isActive$2;
                                this.connection$2 = connection$3;
                                this.asyncCb$2 = asyncCb$4;
                                this.s$2 = s$3;
                            }

                            public void onCompletion(RecordMetadata meta, Exception exception) {
                                if (this.isActive$1.getAndSet(false)) {
                                    this.connection$2.pop();
                                    if (exception != null) {
                                        this.asyncCb$2.onError((Object)exception);
                                        return;
                                    }
                                    this.asyncCb$2.onSuccess((Object)Option$.MODULE$.apply((Object)meta));
                                    return;
                                }
                                if (exception != null) {
                                    this.s$2.reportFailure((Throwable)exception);
                                    return;
                                }
                            }
                        });
                        cancelable.$colon$eq(Cancelable$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> future.cancel(false)));
                        connection.push((Cancelable)cancelable);
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable ex = throwable3 = (Throwable)option.get();
                            if (isActive.compareAndSet(true, false)) {
                                connection.pop();
                                Throwable throwable4 = ex;
                                if (throwable4 instanceof IllegalStateException && this.isCanceled.get()) {
                                    asyncCb.onSuccess((Object)None$.MODULE$);
                                } else {
                                    asyncCb.onError((Object)ex);
                                }
                            } else {
                                s.reportFailure(ex);
                            }
                        }
                        throw throwable;
                    }
                });
                return connection;
            }, Task.AsyncBuilder$.MODULE$.forCancelable());
        }

        @Override
        public Task<BoxedUnit> close() {
            boolean bl = Task$.MODULE$.create();
            return Task.AsyncBuilder$.CreatePartiallyApplied$.MODULE$.apply$extension(bl, (Function2)(JProcedure2 & Serializable)(s, cb) -> {
                Callback asyncCb = Callback$.MODULE$.forked(cb, (ExecutionContext)s);
                this.sc.execute(() -> {
                    if (!this.isCanceled.compareAndSet(false, true)) {
                        asyncCb.onSuccess((Object)BoxedUnit.UNIT);
                        return;
                    }
                    try {
                        this.producerRef().close();
                        asyncCb.onSuccess((Object)BoxedUnit.UNIT);
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable ex = throwable3 = (Throwable)option.get();
                            asyncCb.onError((Object)ex);
                        }
                        throw throwable;
                    }
                });
            }, Task.AsyncBuilder$.MODULE$.forUnit());
        }

        private final Object producerRef$lzyINIT1$$anonfun$1() {
            return "Kafka producer connecting to servers: " + this.config.bootstrapServers().mkString(",");
        }

        private final org.apache.kafka.clients.producer.KafkaProducer underlying$$anonfun$1() {
            return this.producerRef();
        }
    }
}

