/*
 * Decompiled with CFR 0.152.
 */
package ambience.chunk;

import ambience.chunk.ChunkAPI;
import ambience.chunk.ChunkAPI$ChunkId$;
import ambience.chunk.ChunkAPI$DefaultChunkBuilder$;
import ambience.chunk.ChunkNotFoundException;
import ambience.chunk.ChunkSHAException;
import ambience.chunk.ObservableChunker;
import ambience.util.DuplicateKeyHandler$;
import com.elixirtech.arch.LoggingMixin;
import com.elixirtech.mongodb.FindOptions$;
import com.elixirtech.mongodb.MongoDB;
import com.elixirtech.mongodb.RichMongoCollection;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Projections$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class ChunkDB
implements ChunkAPI.ChunkBuilder {
    private final MongoDB mongoDB;
    private final int chunkSize;
    private final RichMongoCollection chunks;

    public ChunkDB(MongoDB mongoDB, String collectionName, int chunkSize) {
        this.mongoDB = mongoDB;
        this.chunkSize = chunkSize;
        this.chunks = com.elixirtech.mongodb.package$.MODULE$.enrichDatabase(mongoDB.database()).getRichCollection(collectionName);
        this.init();
    }

    public MongoDB mongoDB() {
        return this.mongoDB;
    }

    public int chunkSize() {
        return this.chunkSize;
    }

    public RichMongoCollection chunks() {
        return this.chunks;
    }

    public void init() {
    }

    @Override
    public ChunkAPI.Chunk buildChunk(byte[] bytes) {
        return ChunkAPI$DefaultChunkBuilder$.MODULE$.buildChunk(bytes);
    }

    public Task<List<String>> write(Observable<byte[]> in) {
        return this.writeFromChunks((Observable<ChunkAPI.Chunk>)new ObservableChunker(this.chunkSize()).apply(in).map((Function1 & Serializable)bytes -> this.buildChunk((byte[])bytes)));
    }

    public Task<List<String>> writeFromChunks(Observable<ChunkAPI.Chunk> in) {
        return in.mapEval((Function1 & Serializable)chunk -> this.insert((ChunkAPI.Chunk)chunk)).toListL();
    }

    public Task<List<String>> writeFile(File file) {
        if (file.length() <= (long)this.chunkSize()) {
            ChunkAPI.Chunk chunk = this.buildChunk(com.elixirtech.arch.package$.MODULE$.enrichFile(file).data());
            return this.insert(chunk).map((Function1 & Serializable)_$1 -> ChunkDB.writeFile$$anonfun$1(chunk, _$1 == null ? null : ((ChunkAPI.ChunkId)_$1).value()));
        }
        byte[] chunkBuffer = new byte[this.chunkSize()];
        FileInputStream fis = new FileInputStream(file);
        return this.loop$1(fis, chunkBuffer).map((Function1 & Serializable)fs -> {
            fis.close();
            return fs;
        }).onErrorHandle((Function1 & Serializable)x$1 -> {
            Throwable throwable = x$1;
            if (throwable != null) {
                Throwable ex = throwable;
                fis.close();
                throw ex;
            }
            throw new MatchError((Object)throwable);
        });
    }

    public Task<List<String>> writeFromInputStream(InputStream is) {
        byte[] chunkBuffer = new byte[this.chunkSize()];
        return this.loop$2(is, chunkBuffer);
    }

    public Task<List<String>> append(String sha, InputStream is) {
        return this.get(sha).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                ChunkAPI.Chunk chunk = (ChunkAPI.Chunk)((Some)option).value();
                return this.writeFromInputStream(new SequenceInputStream(new ByteArrayInputStream(chunk.bytes()), is));
            }
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException("Append found no sha: " + new ChunkAPI.ChunkId(sha));
            }
            throw new MatchError((Object)option);
        });
    }

    public Observable<ChunkAPI.Chunk> read(List<String> shas) {
        return Observable$.MODULE$.fromIterable(shas).flatMap((Function1 & Serializable)sha -> this.read$$anonfun$1(sha == null ? null : ((ChunkAPI.ChunkId)sha).value()));
    }

    public Task<BoxedUnit> readToFile(List<String> shas, File file) {
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));
        return this.readToOutputStream(shas, fos).map((Function1)(JProcedure1 & Serializable)_$5 -> fos.close());
    }

    public Task<BoxedUnit> readToOutputStream(List<String> shas, OutputStream os) {
        return this.read(shas).map((Function1)(JProcedure1 & Serializable)chunk -> os.write(chunk.bytes())).completedL();
    }

    public Task<String> insert(ChunkAPI.Chunk c) {
        return this.chunks().findO(this.whereId(c.id())).firstOptionL().map((Function1 & Serializable)_$6 -> _$6.isDefined()).flatMap((Function1 & Serializable)exists -> this.insert$$anonfun$2(c, BoxesRunTime.unboxToBoolean((Object)exists)));
    }

    public Task<Option<ChunkAPI.Chunk>> get(String id) {
        return this.chunks().findO(this.whereId(id)).map((Function1 & Serializable)doc -> this.toChunk((Document)doc)).firstOptionL().onErrorRecover((PartialFunction)new Serializable(id, this){
            private final String id$1;
            private final /* synthetic */ ChunkDB $outer;
            {
                this.id$1 = id$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable ex = throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable ex = throwable;
                    ((LoggingMixin)this.$outer).log().error(this::applyOrElse$$anonfun$1, Line$.MODULE$.apply(127), FullName$.MODULE$.apply("ambience.chunk.ChunkDB.get"));
                    throw ex;
                }
                return function1.apply((Object)x);
            }

            private final Object applyOrElse$$anonfun$1() {
                return "Error loading sha=" + new ChunkAPI.ChunkId(this.id$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1()}, serializedLambda);
            }
        });
    }

    public Task<Set<String>> names() {
        return this.chunks().findO(FindOptions$.MODULE$.projections(Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_id"})))).map((Function1 & Serializable)doc -> new ChunkAPI.ChunkId(ChunkAPI$ChunkId$.MODULE$.apply(doc.apply("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).asString().getValue()))).toListL().map((Function1 & Serializable)_$8 -> _$8.toSet());
    }

    public Task<BoxedUnit> delete(String id) {
        return this.chunks().deleteOneT(this.whereId(id)).map((Function1)(JProcedure1 & Serializable)_$9 -> {});
    }

    public Document toChunkDoc(ChunkAPI.Chunk c) {
        BsonDocument doc = new BsonDocument();
        doc.append("_id", (BsonValue)new BsonString(c.id()));
        doc.append("bytes", (BsonValue)new BsonBinary(c.bytes()));
        return Document$.MODULE$.apply(doc);
    }

    public ChunkAPI.Chunk toChunk(Document doc) {
        String id = ChunkAPI$ChunkId$.MODULE$.apply(doc.apply("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).asString().getValue());
        ChunkAPI.Chunk ch = this.buildChunk(doc.apply("bytes", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).asBinary().getData());
        String string = ch.id();
        String string2 = id;
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new ChunkSHAException(id, ch.id());
        }
        return ch;
    }

    public Task<BoxedUnit> validateAll() {
        return this.names().flatMap((Function1 & Serializable)ids -> {
            ((LoggingMixin)this).log().info(() -> ChunkDB.validateAll$$anonfun$1$$anonfun$1(ids), Line$.MODULE$.apply(160), FullName$.MODULE$.apply("ambience.chunk.ChunkDB.validateAll"));
            return this.validateLoop((List<String>)ids.toList());
        });
    }

    private Task<BoxedUnit> validateLoop(List<String> ids) {
        if (ids.isEmpty()) {
            return Task$.MODULE$.unit();
        }
        List group = ids.take(50);
        List rest = (List)ids.drop(50);
        List fs = group.map((Function1 & Serializable)sha -> this.$anonfun$3(ids, sha == null ? null : ((ChunkAPI.ChunkId)sha).value()));
        return Task$.MODULE$.parSequence((Iterable)fs, BuildFrom$.MODULE$.buildFromIterableOps()).flatMap((Function1 & Serializable)_$11 -> this.validateLoop((List<String>)rest));
    }

    public Bson whereId(String id) {
        return Filters$.MODULE$.eq("_id", (Object)BsonString$.MODULE$.apply(id));
    }

    private static final /* synthetic */ List writeFile$$anonfun$1(ChunkAPI.Chunk chunk$1, String _$1) {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new ChunkAPI.ChunkId[]{new ChunkAPI.ChunkId(chunk$1.id())}));
    }

    private static final /* synthetic */ List loop$1$$anonfun$1(ChunkAPI.Chunk chunk$2, String _$2) {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new ChunkAPI.ChunkId[]{new ChunkAPI.ChunkId(chunk$2.id())}));
    }

    private final /* synthetic */ Task loop$1$$anonfun$2(FileInputStream fis$4, byte[] chunkBuffer$3, String s) {
        return this.loop$1(fis$4, chunkBuffer$3).map((Function1 & Serializable)s2 -> s2.$colon$colon((Object)new ChunkAPI.ChunkId(s)));
    }

    private final Task loop$1(FileInputStream fis$1, byte[] chunkBuffer$1) {
        int bytesRead = fis$1.read(chunkBuffer$1);
        if (bytesRead == 0) {
            return Task$.MODULE$.now((Object)package$.MODULE$.Nil());
        }
        if (bytesRead < this.chunkSize()) {
            Object object = Predef$.MODULE$.byteArrayOps(chunkBuffer$1);
            byte[] dst = (byte[])ArrayOps$.MODULE$.take$extension(object, bytesRead);
            ChunkAPI.Chunk chunk = this.buildChunk(dst);
            return this.insert(chunk).map((Function1 & Serializable)_$2 -> ChunkDB.loop$1$$anonfun$1(chunk, _$2 == null ? null : ((ChunkAPI.ChunkId)_$2).value()));
        }
        ChunkAPI.Chunk chunk = this.buildChunk(chunkBuffer$1);
        Task fs = this.insert(chunk).map((Function1 & Serializable)v1 -> new ChunkAPI.ChunkId(chunk.id()));
        return fs.flatMap((Function1 & Serializable)s -> this.loop$1$$anonfun$2(fis$1, chunkBuffer$1, s == null ? null : ((ChunkAPI.ChunkId)s).value()));
    }

    private final /* synthetic */ Task loop$2$$anonfun$1(InputStream is$3, byte[] chunkBuffer$5, String s) {
        return this.loop$2(is$3, chunkBuffer$5).map((Function1 & Serializable)s2 -> s2.$colon$colon((Object)new ChunkAPI.ChunkId(s)));
    }

    private final Task loop$2(InputStream is$1, byte[] chunkBuffer$2) {
        int len = is$1.read(chunkBuffer$2);
        if (len > 0) {
            ChunkAPI.Chunk chunk;
            if (len < this.chunkSize()) {
                Object object = Predef$.MODULE$.byteArrayOps(chunkBuffer$2);
                chunk = this.buildChunk((byte[])ArrayOps$.MODULE$.take$extension(object, len));
            } else {
                chunk = this.buildChunk(chunkBuffer$2);
            }
            ChunkAPI.Chunk chunk2 = chunk;
            Task fs = this.insert(chunk2).map((Function1 & Serializable)v1 -> new ChunkAPI.ChunkId(chunk2.id()));
            return fs.flatMap((Function1 & Serializable)s -> this.loop$2$$anonfun$1(is$1, chunkBuffer$2, s == null ? null : ((ChunkAPI.ChunkId)s).value()));
        }
        return Task$.MODULE$.now((Object)package$.MODULE$.Nil());
    }

    private final /* synthetic */ Observable read$$anonfun$1(String sha) {
        return Observable$.MODULE$.fromTask(this.get(sha).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                ChunkAPI.Chunk chunk = (ChunkAPI.Chunk)((Some)option).value();
                return Task$.MODULE$.now((Object)chunk);
            }
            if (None$.MODULE$.equals(option)) {
                return Task$.MODULE$.raiseError((Throwable)new ChunkNotFoundException(sha));
            }
            throw new MatchError((Object)option);
        }));
    }

    private static final String insert$$anonfun$2$$anonfun$2(ChunkAPI.Chunk c$3) {
        return c$3.id();
    }

    private static final /* synthetic */ String insert$$anonfun$2$$anonfun$3(ChunkAPI.Chunk c$4, Object x$1) {
        Object object = x$1;
        return c$4.id();
    }

    private final /* synthetic */ Task insert$$anonfun$2(ChunkAPI.Chunk c$1, boolean exists) {
        return (!exists ? this.chunks().insertOneT(this.toChunkDoc(c$1)).map((Function1 & Serializable)_$7 -> new ChunkAPI.ChunkId(c$1.id())).onErrorRecover(DuplicateKeyHandler$.MODULE$.apply((Function0 & Serializable)() -> new ChunkAPI.ChunkId(ChunkDB.insert$$anonfun$2$$anonfun$2(c$1)))) : Task$.MODULE$.unit()).map((Function1 & Serializable)x$1 -> new ChunkAPI.ChunkId(ChunkDB.insert$$anonfun$2$$anonfun$3(c$1, x$1)));
    }

    private static final Object validateAll$$anonfun$1$$anonfun$1(Set ids$1) {
        return "Validating " + ids$1.size() + " chunks";
    }

    private static final Object $anonfun$3$$anonfun$2$$anonfun$1(ChunkSHAException ex$1) {
        return "Validation error: " + ex$1;
    }

    private static final Object $anonfun$3$$anonfun$2$$anonfun$2(ChunkSHAException ex$2) {
        return new ChunkAPI.ChunkId(ex$2.was()) + " is a valid id";
    }

    private static final Object $anonfun$3$$anonfun$2$$anonfun$3() {
        return "which isn't a valid id";
    }

    private final /* synthetic */ Task $anonfun$3(List ids$2, String sha) {
        return this.get(sha).map((Function1)(JProcedure1 & Serializable)_$10 -> {}).onErrorHandle((Function1)(JProcedure1 & Serializable)x$1 -> {
            Throwable throwable = x$1;
            if (throwable instanceof ChunkSHAException) {
                ChunkSHAException ex = (ChunkSHAException)throwable;
                ((LoggingMixin)this).log().error(() -> ChunkDB.$anonfun$3$$anonfun$2$$anonfun$1(ex), Line$.MODULE$.apply(173), FullName$.MODULE$.apply("ambience.chunk.ChunkDB.fs"));
                if (ids$2.contains((Object)new ChunkAPI.ChunkId(ex.was()))) {
                    ((LoggingMixin)this).log().info(() -> ChunkDB.$anonfun$3$$anonfun$2$$anonfun$2(ex), Line$.MODULE$.apply(174), FullName$.MODULE$.apply("ambience.chunk.ChunkDB.fs"));
                } else {
                    ((LoggingMixin)this).log().info(ChunkDB::$anonfun$3$$anonfun$2$$anonfun$3, Line$.MODULE$.apply(174), FullName$.MODULE$.apply("ambience.chunk.ChunkDB.fs"));
                }
                return;
            }
            Throwable ex = throwable;
            throw ex;
        });
    }
}

