/*
 * Decompiled with CFR 0.152.
 */
package ambience.codex;

import ambience.codex.DocManager;
import ambience.codex.DocumentManager$;
import ambience.framework.ErrorExplanation$;
import ambience.module.UserDB;
import ambience.util.ONConverter$;
import com.elixirtech.api.AuditAPI;
import com.elixirtech.arch.Clock;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingMixin;
import com.elixirtech.codex.CodexCollection;
import com.elixirtech.codex.CodexFilter;
import com.elixirtech.codex.CodexFindOptions;
import com.elixirtech.codex.CodexFindOptions$;
import io.circe.Json;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonObjectId$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public abstract class AuditedDocumentManager
implements DocManager {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AuditedDocumentManager.class.getDeclaredField("clock$lzy1"));
    private volatile Object clock$lzy1;

    public abstract Task<CodexCollection> cltnT();

    public abstract String uniqueKey();

    public abstract AuditAPI.AuditAppender auditAppender();

    public abstract AuditAPI.Component auditComponent();

    public Clock clock() {
        Object object = this.clock$lzy1;
        if (object instanceof Clock) {
            return (Clock)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Clock)this.clock$lzyINIT1();
    }

    private Object clock$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.clock$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Clock clock = null;
                    try {
                        clock = (Clock)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Clock.class));
                        object2 = clock == null ? LazyVals.NullValue$.MODULE$ : clock;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.clock$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return clock;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<BoxedUnit> init() {
        return this.cltnT().flatMap((Function1 & Serializable)cltn -> DocumentManager$.MODULE$.setupUniqueColumn((CodexCollection)cltn, this.uniqueKey()));
    }

    @Override
    public Task<Json> get(UserDB.User user) {
        CodexFindOptions options = CodexFindOptions$.MODULE$.sorts((CodexFindOptions.Sort)CodexFindOptions.Ascending$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.uniqueKey()})));
        return this.cltnT().flatMap((Function1 & Serializable)cltn -> cltn.findO(DocumentManager$.MODULE$.exists(this.uniqueKey()), options).toListL().flatMap((Function1 & Serializable)docs -> Task$.MODULE$.apply(() -> AuditedDocumentManager.get$$anonfun$1$$anonfun$1$$anonfun$1(docs)).map((Function1 & Serializable)json -> json)));
    }

    @Override
    public Task<LogMessage> save(UserDB.User user, Json json) {
        Tuple2 tuple2;
        Document doc = org.mongodb.scala.bson.package$.MODULE$.Document().apply(json.noSpaces());
        Either unpacked = this.extractId(doc).flatMap((Function1 & Serializable)optId -> this.extractKey(doc).map((Function1 & Serializable)key -> Tuple2$.MODULE$.apply(optId, key)));
        Either either = unpacked;
        if (either instanceof Left) {
            LogMessage msg = (LogMessage)((Left)either).value();
            return Task$.MODULE$.now((Object)msg);
        }
        if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
            Option optId2 = (Option)tuple2._1();
            BsonValue key = (BsonValue)tuple2._2();
            Option option = optId2;
            if (option instanceof Some) {
                BsonObjectId id = (BsonObjectId)((Some)option).value();
                return this.update(user, id, key, doc);
            }
            if (None$.MODULE$.equals(option)) {
                return this.add(user, key, doc).map((Function1 & Serializable)x$1 -> {
                    Either either = x$1;
                    if (either instanceof Right) {
                        return LogMessage.None$.MODULE$;
                    }
                    if (either instanceof Left) {
                        LogMessage msg = (LogMessage)((Left)either).value();
                        return msg;
                    }
                    throw new MatchError((Object)either);
                });
            }
            throw new MatchError((Object)option);
        }
        throw new MatchError((Object)either);
    }

    @Override
    public Task<LogMessage> delete(UserDB.User user, String hexId) {
        Task task;
        ((LoggingMixin)this).log().info(() -> AuditedDocumentManager.delete$$anonfun$1(hexId), Line$.MODULE$.apply(61), FullName$.MODULE$.apply("ambience.codex.AuditedDocumentManager.delete"));
        Try try_ = Try$.MODULE$.apply(() -> AuditedDocumentManager.$anonfun$2(hexId));
        if (try_ instanceof Success) {
            BsonObjectId id = (BsonObjectId)((Success)try_).value();
            task = this.cltnT().flatMap((Function1 & Serializable)cltn -> cltn.updateOneT((CodexFilter)CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)id), DocumentManager$.MODULE$.deleteAction(this.uniqueKey())).map((Function1 & Serializable)_$1 -> LogMessage.None$.MODULE$).onErrorHandle((Function1 & Serializable)ex -> ErrorExplanation$.MODULE$.apply("Delete failed", (Throwable)ex)).map((Function1 & Serializable)msg -> msg));
        } else if (try_ instanceof Failure) {
            task = Task$.MODULE$.now((Object)LogMessage.Error$.MODULE$.apply("Invalid id"));
        } else {
            throw new MatchError((Object)try_);
        }
        Task treply = task;
        return treply.map((Function1 & Serializable)reply -> {
            LogMessage logMessage = reply;
            LogMessage.None$ none$ = LogMessage.None$.MODULE$;
            AuditAPI.Action action = AuditAPI.Action$.MODULE$.apply(!(logMessage != null ? !logMessage.equals(none$) : none$ != null), hexId, "Deleted", AuditAPI.Action$.MODULE$.$lessinit$greater$default$4(), AuditAPI.Action$.MODULE$.$lessinit$greater$default$5());
            AuditAPI.AuditMessage auditMsg = AuditAPI.AuditMessage$.MODULE$.apply(user.name(), this.auditComponent(), action);
            this.auditAppender().append(auditMsg);
            return reply;
        });
    }

    @Override
    public Task<LogMessage> undelete(UserDB.User user, String hexId) {
        Task task;
        ((LoggingMixin)this).log().info(() -> AuditedDocumentManager.undelete$$anonfun$1(hexId), Line$.MODULE$.apply(82), FullName$.MODULE$.apply("ambience.codex.AuditedDocumentManager.undelete"));
        Try try_ = Try$.MODULE$.apply(() -> AuditedDocumentManager.$anonfun$4(hexId));
        if (try_ instanceof Success) {
            BsonObjectId id = (BsonObjectId)((Success)try_).value();
            task = this.cltnT().flatMap((Function1 & Serializable)cltn -> cltn.updateOneT((CodexFilter)CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)id), DocumentManager$.MODULE$.undeleteAction(this.uniqueKey())).map((Function1 & Serializable)_$2 -> LogMessage.None$.MODULE$).onErrorHandle((Function1 & Serializable)ex -> ErrorExplanation$.MODULE$.apply("Undelete failed", (Throwable)ex)).map((Function1 & Serializable)msg -> msg));
        } else if (try_ instanceof Failure) {
            task = Task$.MODULE$.now((Object)LogMessage.Error$.MODULE$.apply("Invalid id"));
        } else {
            throw new MatchError((Object)try_);
        }
        Task treply = task;
        return treply.map((Function1 & Serializable)reply -> {
            LogMessage logMessage = reply;
            LogMessage.None$ none$ = LogMessage.None$.MODULE$;
            AuditAPI.Action action = AuditAPI.Action$.MODULE$.apply(!(logMessage != null ? !logMessage.equals(none$) : none$ != null), hexId, "Undeleted", AuditAPI.Action$.MODULE$.$lessinit$greater$default$4(), AuditAPI.Action$.MODULE$.$lessinit$greater$default$5());
            AuditAPI.AuditMessage auditMsg = AuditAPI.AuditMessage$.MODULE$.apply(user.name(), this.auditComponent(), action);
            this.auditAppender().append(auditMsg);
            return reply;
        });
    }

    public Task<Either<LogMessage, BsonObjectId>> add(UserDB.User user, BsonValue key, Document doc) {
        ((LoggingMixin)this).log().info(() -> AuditedDocumentManager.add$$anonfun$1(key), Line$.MODULE$.apply(103), FullName$.MODULE$.apply("ambience.codex.AuditedDocumentManager.add"));
        BsonObjectId id = BsonObjectId$.MODULE$.apply();
        Task treply = this.cltnT().flatMap((Function1 & Serializable)cltn -> {
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)id), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"lastModified");
            objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonDateTime$.MODULE$.apply(this.clock().now())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            return cltn.insertOneT((Document)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).map((Function1 & Serializable)_$3 -> package$.MODULE$.Right().apply((Object)id)).onErrorHandle((Function1 & Serializable)ex -> package$.MODULE$.Left().apply((Object)ErrorExplanation$.MODULE$.apply("Add failed", (Throwable)ex))).map((Function1 & Serializable)either -> either);
        });
        return treply.map((Function1 & Serializable)reply -> {
            Option optName = Try$.MODULE$.apply(() -> AuditedDocumentManager.$anonfun$7(key)).toOption().map((Function1 & Serializable)_$4 -> _$4.getValue());
            AuditAPI.Action action = AuditAPI.Action$.MODULE$.apply(reply.isRight(), id.getValue().toHexString(), "Added", optName, AuditAPI.Action$.MODULE$.$lessinit$greater$default$5());
            AuditAPI.AuditMessage auditMsg = AuditAPI.AuditMessage$.MODULE$.apply(user.name(), this.auditComponent(), action);
            this.auditAppender().append(auditMsg);
            return reply;
        });
    }

    public Task<LogMessage> update(UserDB.User user, BsonObjectId id, BsonValue key, Document doc) {
        ((LoggingMixin)this).log().info(() -> AuditedDocumentManager.update$$anonfun$1(key), Line$.MODULE$.apply(122), FullName$.MODULE$.apply("ambience.codex.AuditedDocumentManager.update"));
        Task treply = this.cltnT().flatMap((Function1 & Serializable)cltn -> {
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"lastModified");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonDateTime$.MODULE$.apply(this.clock().now())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            return cltn.replaceOneT((CodexFilter)CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)id), CodexFilter.Exists$.MODULE$.apply(this.uniqueKey())})), (Document)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).map((Function1 & Serializable)_$5 -> LogMessage.None$.MODULE$).onErrorHandle((Function1 & Serializable)ex -> ErrorExplanation$.MODULE$.apply("Update failed", (Throwable)ex)).map((Function1 & Serializable)msg -> msg);
        });
        return treply.map((Function1 & Serializable)reply -> {
            Option optName = Try$.MODULE$.apply(() -> AuditedDocumentManager.$anonfun$10(key)).toOption().map((Function1 & Serializable)_$6 -> _$6.getValue());
            LogMessage logMessage = reply;
            LogMessage.None$ none$ = LogMessage.None$.MODULE$;
            AuditAPI.Action action = AuditAPI.Action$.MODULE$.apply(!(logMessage != null ? !logMessage.equals(none$) : none$ != null), id.getValue().toHexString(), "Updated", optName, AuditAPI.Action$.MODULE$.$lessinit$greater$default$5());
            AuditAPI.AuditMessage auditMsg = AuditAPI.AuditMessage$.MODULE$.apply(user.name(), this.auditComponent(), action);
            this.auditAppender().append(auditMsg);
            return reply;
        });
    }

    public Either<LogMessage, Option<BsonObjectId>> extractId(Document doc) {
        Option option = doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonObjectId) {
                BsonObjectId id = (BsonObjectId)bsonValue;
                return package$.MODULE$.Right().apply((Object)Some$.MODULE$.apply((Object)id));
            }
            if (bsonValue instanceof BsonString) {
                BsonString s = (BsonString)bsonValue;
                return package$.MODULE$.Right().apply((Object)Some$.MODULE$.apply((Object)BsonObjectId$.MODULE$.apply(s.getValue())));
            }
            return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Invalid id"));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Right().apply((Object)None$.MODULE$);
        }
        throw new MatchError((Object)option);
    }

    public Either<LogMessage, BsonValue> extractKey(Document doc) {
        Option option = doc.get(this.uniqueKey(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonString) {
                BsonString bs = (BsonString)bsonValue;
                String s = bs.getValue().trim();
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s))) {
                    return package$.MODULE$.Right().apply((Object)BsonString$.MODULE$.apply(s));
                }
                return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Empty key field"));
            }
            BsonValue x = bsonValue;
            return package$.MODULE$.Right().apply((Object)x);
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Missing key field"));
        }
        throw new MatchError((Object)option);
    }

    private static final Json get$$anonfun$1$$anonfun$1$$anonfun$1(List docs$1) {
        return ONConverter$.MODULE$.bsonToRelaxedJson((List<Document>)docs$1);
    }

    private static final Object delete$$anonfun$1(String hexId$1) {
        return "deleting " + hexId$1;
    }

    private static final BsonObjectId $anonfun$2(String hexId$2) {
        return BsonObjectId$.MODULE$.apply(hexId$2);
    }

    private static final Object undelete$$anonfun$1(String hexId$4) {
        return "undeleting " + hexId$4;
    }

    private static final BsonObjectId $anonfun$4(String hexId$5) {
        return BsonObjectId$.MODULE$.apply(hexId$5);
    }

    private static final Object add$$anonfun$1(BsonValue key$1) {
        return "inserting " + key$1;
    }

    private static final BsonString $anonfun$7(BsonValue key$3) {
        return key$3.asString();
    }

    private static final Object update$$anonfun$1(BsonValue key$4) {
        return "updating " + key$4;
    }

    private static final BsonString $anonfun$10(BsonValue key$6) {
        return key$6.asString();
    }
}

