/*
 * Decompiled with CFR 0.152.
 */
package ambience.framework;

import ambience.api.BinaryStore;
import ambience.api.BinaryStore$Content$;
import ambience.api.BinaryStore$ContentId$;
import ambience.framework.BinaryStoreAPI;
import cats.Functor;
import cats.effect.Bracket;
import cats.effect.Resource;
import cats.effect.Resource$;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.FileDataBytes$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.ObservableDataBytes;
import com.elixirtech.arch.SyncDataBytes;
import io.circe.Json;
import io.circe.Json$;
import io.circe.parser.package$;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Try;
import scala.util.Try$;

public class DiskBinaryStoreLocation
implements BinaryStore.Location,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DiskBinaryStoreLocation.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final String MetadataSuffix;
    private final String id;
    private final String path;
    private final long maxSize;
    private final String description;
    private final File rootFile;

    public DiskBinaryStoreLocation(BinaryStoreAPI.BSConfig bsConfig) {
        this.MetadataSuffix = "_metadata.json";
        this.id = bsConfig.id();
        this.path = bsConfig.config().getString("path");
        this.maxSize = bsConfig.config().getMemorySize("maxSize").toBytes();
        this.description = "Disk BinaryStore using " + this.path();
        this.rootFile = new File(this.path());
        this.rootFile().mkdirs();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String MetadataSuffix() {
        return this.MetadataSuffix;
    }

    @Override
    public String id() {
        return this.id;
    }

    public String path() {
        return this.path;
    }

    @Override
    public long maxSize() {
        return this.maxSize;
    }

    @Override
    public String description() {
        return this.description;
    }

    public File rootFile() {
        return this.rootFile;
    }

    @Override
    public Task<String> add(BinaryStore.Content content) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> new BinaryStore.ContentId(DiskBinaryStoreLocation.add$$anonfun$1())).flatMap((Function1 & Serializable)contentId -> this.add$$anonfun$2(content, contentId == null ? null : ((BinaryStore.ContentId)contentId).value()));
    }

    @Override
    public Observable<String> all() {
        return Observable$.MODULE$.fromIterable((Iterable)Predef$.MODULE$.wrapRefArray((Object[])Option$.MODULE$.apply((Object)this.rootFile().listFiles()).getOrElse(DiskBinaryStoreLocation::all$$anonfun$1))).flatMap((Function1 & Serializable)f -> {
            if (f.isFile() && !f.getName().endsWith(this.MetadataSuffix())) {
                return Observable$.MODULE$.now((Object)new BinaryStore.ContentId(BinaryStore$ContentId$.MODULE$.apply(f.getName())));
            }
            return Observable$.MODULE$.empty();
        });
    }

    @Override
    public Task<Option<BinaryStore.Content>> get(String id) {
        return Task$.MODULE$.apply(() -> this.get$$anonfun$1(id));
    }

    public Option<BinaryStore.Content> loadContentSync(String id) {
        File file = this.toFile(id);
        None$ optDB = file.exists() ? Some$.MODULE$.apply((Object)FileDataBytes$.MODULE$.apply(file)) : None$.MODULE$;
        return optDB.map((Function1 & Serializable)db -> BinaryStore$Content$.MODULE$.apply((DataBytes)db, (Json)this.getMetadataSync(file).getOrElse(DiskBinaryStoreLocation::loadContentSync$$anonfun$1$$anonfun$1)));
    }

    @Override
    public Task<Option<Json>> getMetadata(String id) {
        return Task$.MODULE$.apply(() -> this.getMetadata$$anonfun$1(id));
    }

    public Option<Json> getMetadataSync(File file) {
        File md = this.metadata(file);
        if (md.exists()) {
            return package$.MODULE$.parse(com.elixirtech.arch.package$.MODULE$.enrichFile(md).text()).toOption();
        }
        return None$.MODULE$;
    }

    public Task<BoxedUnit> setMetadata(String id, Json json) {
        return Task$.MODULE$.apply(() -> this.setMetadata$$anonfun$1(id)).flatMap((Function1 & Serializable)md -> Task$.MODULE$.apply(() -> DiskBinaryStoreLocation.setMetadata$$anonfun$2$$anonfun$1(md, json)).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            Path path = x$1;
        }));
    }

    @Override
    public Task<BoxedUnit> remove(String id) {
        return Task$.MODULE$.apply(() -> this.remove$$anonfun$1(id)).void();
    }

    public File toFile(String id) {
        return new File(this.rootFile(), id);
    }

    public File metadata(File content) {
        return new File(content.getParentFile(), content.getName() + this.MetadataSuffix());
    }

    private static final String add$$anonfun$1() {
        return BinaryStore$ContentId$.MODULE$.apply(UUID.randomUUID().toString());
    }

    private final File add$$anonfun$2$$anonfun$1(String contentId$1) {
        return this.toFile(contentId$1);
    }

    private final Path add$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(SyncDataBytes sb$1, File file$2) {
        if (sb$1.length() > this.maxSize()) {
            throw new BinaryStore.MaxSizeException(sb$1.length(), this.maxSize());
        }
        return Files.write(file$2.toPath(), sb$1.bytes(), new OpenOption[0]);
    }

    private final WriteLimiter $anonfun$1(File file$3) {
        return new WriteLimiter(file$3, this.maxSize());
    }

    private static final void $anonfun$2$$anonfun$1(WriteLimiter fos$1) {
        fos$1.close();
    }

    private static final /* synthetic */ String add$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$3(String contentId$4, Object x$1) {
        Object object = x$1;
        return contentId$4;
    }

    private final /* synthetic */ Task add$$anonfun$2(BinaryStore.Content content$2, String contentId) {
        return Task$.MODULE$.apply(() -> this.add$$anonfun$2$$anonfun$1(contentId)).flatMap((Function1 & Serializable)file -> this.setMetadata(contentId, content$2.metadata()).flatMap((Function1 & Serializable)x$12 -> {
            Task task;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            DataBytes dataBytes = content$2.bytes();
            if (dataBytes instanceof SyncDataBytes) {
                SyncDataBytes sb = (SyncDataBytes)dataBytes;
                task = Task$.MODULE$.apply(() -> this.add$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(sb, file));
            } else if (dataBytes instanceof ObservableDataBytes) {
                ObservableDataBytes ob = (ObservableDataBytes)dataBytes;
                Resource fos2 = Resource$.MODULE$.make((Object)Task$.MODULE$.apply(() -> this.$anonfun$1(file)), (Function1 & Serializable)fos -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
                    DiskBinaryStoreLocation.$anonfun$2$$anonfun$1(fos);
                    return BoxedUnit.UNIT;
                }), (Functor)Task$.MODULE$.catsAsync());
                task = (Task)fos2.use((Function1 & Serializable)os -> ob.observable().foreachL((Function1)(JProcedure1 & Serializable)bytes -> os.write((byte[])bytes)), (Bracket)Task$.MODULE$.catsAsync());
            } else {
                throw new MatchError((Object)dataBytes);
            }
            return task.map((Function1 & Serializable)x$1 -> new BinaryStore.ContentId(DiskBinaryStoreLocation.add$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$3(contentId, x$1)));
        }));
    }

    private static final File[] all$$anonfun$1() {
        return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
    }

    private final Option get$$anonfun$1(String id$1) {
        return this.loadContentSync(id$1);
    }

    private static final Json loadContentSync$$anonfun$1$$anonfun$1() {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private final Option getMetadata$$anonfun$1(String id$2) {
        return this.getMetadataSync(this.toFile(id$2));
    }

    private final File setMetadata$$anonfun$1(String id$3) {
        return this.metadata(this.toFile(id$3));
    }

    private static final Path setMetadata$$anonfun$2$$anonfun$1(File md$1, Json json$1) {
        return Files.write(md$1.toPath(), json$1.spaces2().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private static final boolean remove$$anonfun$1$$anonfun$1(File content$4) {
        return content$4.delete();
    }

    private static final boolean remove$$anonfun$1$$anonfun$2(File md$2) {
        return md$2.delete();
    }

    private final Try remove$$anonfun$1(String id$4) {
        File content = this.toFile(id$4);
        File md = this.metadata(content);
        Try$.MODULE$.apply(() -> DiskBinaryStoreLocation.remove$$anonfun$1$$anonfun$1(content));
        return Try$.MODULE$.apply(() -> DiskBinaryStoreLocation.remove$$anonfun$1$$anonfun$2(md));
    }

    public static class WriteLimiter {
        private final File file;
        private final long maxSize;
        private long byteCount;
        private final FileOutputStream fos;

        public WriteLimiter(File file, long maxSize) {
            this.file = file;
            this.maxSize = maxSize;
            this.byteCount = 0L;
            this.fos = new FileOutputStream(file);
        }

        public FileOutputStream fos() {
            return this.fos;
        }

        public void write(byte[] bytes) {
            this.byteCount += (long)bytes.length;
            if (this.byteCount > this.maxSize) {
                throw new BinaryStore.MaxSizeException("Streamed", this.maxSize);
            }
            this.fos().write(bytes);
        }

        public void close() {
            this.fos().close();
            if (this.byteCount > this.maxSize) {
                this.file.delete();
                return;
            }
        }
    }
}

