/*
 * Decompiled with CFR 0.152.
 */
package ambience.framework;

import ambience.framework.DocumentManager2$;
import ambience.framework.DocumentManager2$Existence$;
import ambience.framework.ErrorExplanation$;
import ambience.module.UserDB;
import ambience.util.ONConverter$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingMixin;
import com.elixirtech.mongodb.FindOptions;
import com.elixirtech.mongodb.FindOptions$;
import com.elixirtech.mongodb.RichMongoCollection;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import io.circe.Json;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.MongoClient;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonObjectId$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Projections$;
import org.mongodb.scala.model.Sorts$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Either$;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public abstract class DocumentManager2 {
    public static String DeleteSuffix() {
        return DocumentManager2$.MODULE$.DeleteSuffix();
    }

    public static Bson deleteAction(String string) {
        return DocumentManager2$.MODULE$.deleteAction(string);
    }

    public static Bson exists(String string) {
        return DocumentManager2$.MODULE$.exists(string);
    }

    public static Task<BoxedUnit> setupUniqueColumn(RichMongoCollection richMongoCollection, String string) {
        return DocumentManager2$.MODULE$.setupUniqueColumn(richMongoCollection, string);
    }

    public static MongoClient testingMongoClient(String string) {
        return DocumentManager2$.MODULE$.testingMongoClient(string);
    }

    public static Bson undeleteAction(String string) {
        return DocumentManager2$.MODULE$.undeleteAction(string);
    }

    public static Bson withObjId(BsonObjectId bsonObjectId) {
        return DocumentManager2$.MODULE$.withObjId(bsonObjectId);
    }

    public abstract RichMongoCollection cltn();

    public abstract String uniqueKey();

    public Task<BoxedUnit> init() {
        return DocumentManager2$.MODULE$.setupUniqueColumn(this.cltn(), this.uniqueKey());
    }

    public Task<Json> get() {
        Some some = Some$.MODULE$.apply((Object)Sorts$.MODULE$.ascending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.uniqueKey()})));
        Option option = FindOptions$.MODULE$.$lessinit$greater$default$1();
        Option option2 = FindOptions$.MODULE$.$lessinit$greater$default$3();
        Option option3 = FindOptions$.MODULE$.$lessinit$greater$default$4();
        FindOptions options = FindOptions$.MODULE$.apply(option, (Option)some, option2, option3);
        return this.cltn().findO(DocumentManager2$.MODULE$.exists(this.uniqueKey()), options).toListL().map((Function1 & Serializable)docs -> ONConverter$.MODULE$.bsonToRelaxedJson((List<Document>)docs));
    }

    public Task<BoxedUnit> upload(UserDB.User user, Document doc) {
        return Task$.MODULE$.apply(() -> DocumentManager2.upload$$anonfun$1(doc)).flatMap((Function1 & Serializable)id -> this.idExists((BsonObjectId)id).flatMap((Function1 & Serializable)exists -> {
            Task task;
            if (exists.exists()) {
                if (exists.active()) {
                    Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
                    objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonObjectId$.MODULE$.apply()), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                    task = Task$.MODULE$.now(doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
                } else {
                    task = this.silentDelete((BsonObjectId)id).map((Function1 & Serializable)_$1 -> doc);
                }
            } else {
                task = Task$.MODULE$.now((Object)doc);
            }
            return task.flatMap((Function1 & Serializable)fullDoc -> this.cltn().insertOneT(fullDoc).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                InsertOneResult insertOneResult = x$1;
            }));
        }));
    }

    public Task<LogMessage> save(Json json) {
        Tuple2 tuple2;
        Document doc = Document$.MODULE$.apply(json.noSpaces());
        Either unpacked = this.extractId(doc).flatMap((Function1 & Serializable)optId -> this.extractKey(doc).map((Function1 & Serializable)key -> Tuple2$.MODULE$.apply(optId, key)));
        Either either = unpacked;
        if (either instanceof Left) {
            LogMessage msg = (LogMessage)((Left)either).value();
            return Task$.MODULE$.now((Object)msg);
        }
        if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
            Option optId2 = (Option)tuple2._1();
            BsonValue key = (BsonValue)tuple2._2();
            Option option = optId2;
            if (option instanceof Some) {
                BsonObjectId id = (BsonObjectId)((Some)option).value();
                return this.update(id, key, doc);
            }
            if (None$.MODULE$.equals(option)) {
                return this.add(key, doc).map((Function1 & Serializable)_$2 -> {
                    Either either = Either$.MODULE$.MergeableEither(_$2.map((Function1 & Serializable)_$3 -> LogMessage.None$.MODULE$));
                    return (LogMessage)Either.MergeableEither$.MODULE$.merge$extension(either);
                });
            }
            throw new MatchError((Object)option);
        }
        throw new MatchError((Object)either);
    }

    public Task<LogMessage> delete(String hexId) {
        Try try_ = Try$.MODULE$.apply(() -> DocumentManager2.delete$$anonfun$1(hexId));
        if (try_ instanceof Success) {
            BsonObjectId id = (BsonObjectId)((Success)try_).value();
            Task ret = this.logInfo((Function0<String>)((Function0 & Serializable)() -> DocumentManager2.$anonfun$2(hexId))).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.cltn().updateOneT(Filters$.MODULE$.eq("_id", (Object)id), DocumentManager2$.MODULE$.deleteAction(this.uniqueKey())).map((Function1 & Serializable)x$1 -> {
                    UpdateResult updateResult = x$1;
                    return LogMessage.None$.MODULE$;
                });
            });
            return ret.onErrorHandle((Function1 & Serializable)ex -> ErrorExplanation$.MODULE$.apply("Delete failed", (Throwable)ex));
        }
        if (try_ instanceof Failure) {
            return Task$.MODULE$.now((Object)LogMessage.Error$.MODULE$.apply("Invalid id"));
        }
        throw new MatchError((Object)try_);
    }

    public Task<LogMessage> undelete(String hexId) {
        Try try_ = Try$.MODULE$.apply(() -> DocumentManager2.undelete$$anonfun$1(hexId));
        if (try_ instanceof Success) {
            BsonObjectId id = (BsonObjectId)((Success)try_).value();
            Task ret = this.logInfo((Function0<String>)((Function0 & Serializable)() -> DocumentManager2.$anonfun$4(hexId))).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.cltn().updateOneT(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.eq("_id", (Object)id)})), DocumentManager2$.MODULE$.undeleteAction(this.uniqueKey())).map((Function1 & Serializable)x$1 -> {
                    UpdateResult updateResult = x$1;
                    return LogMessage.None$.MODULE$;
                });
            });
            return ret.onErrorHandle((Function1 & Serializable)ex -> ErrorExplanation$.MODULE$.apply("Undelete failed", (Throwable)ex));
        }
        if (try_ instanceof Failure) {
            return Task$.MODULE$.now((Object)LogMessage.Error$.MODULE$.apply("Invalid id"));
        }
        throw new MatchError((Object)try_);
    }

    public Task<Either<LogMessage, Document>> add(BsonValue key, Document doc) {
        Task ret = this.logInfo((Function0<String>)((Function0 & Serializable)() -> DocumentManager2.$anonfun$6(key))).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Task$.MODULE$.apply(() -> DocumentManager2.$anonfun$7$$anonfun$1(doc)).flatMap((Function1 & Serializable)finalDoc -> this.cltn().insertOneT(finalDoc).map((Function1 & Serializable)x$1 -> {
                InsertOneResult insertOneResult = x$1;
                return package$.MODULE$.Right().apply(finalDoc);
            }));
        });
        return ret.onErrorHandle((Function1 & Serializable)ex -> package$.MODULE$.Left().apply((Object)ErrorExplanation$.MODULE$.apply("Add failed", (Throwable)ex)));
    }

    public Task<LogMessage> update(BsonObjectId id, BsonValue key, Document doc) {
        Task ret = this.logInfo((Function0<String>)((Function0 & Serializable)() -> DocumentManager2.$anonfun$8(key))).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.cltn().replaceOneT(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.eq("_id", (Object)id), DocumentManager2$.MODULE$.exists(this.uniqueKey())})), doc).map((Function1 & Serializable)x$1 -> {
                UpdateResult updateResult = x$1;
                return LogMessage.None$.MODULE$;
            });
        });
        return ret.onErrorHandle((Function1 & Serializable)ex -> ErrorExplanation$.MODULE$.apply("Update failed", (Throwable)ex));
    }

    public Either<LogMessage, Option<BsonObjectId>> extractId(Document doc) {
        Option option = doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonObjectId) {
                BsonObjectId id = (BsonObjectId)bsonValue;
                return package$.MODULE$.Right().apply((Object)Some$.MODULE$.apply((Object)id));
            }
            if (bsonValue instanceof BsonString) {
                BsonString s = (BsonString)bsonValue;
                return package$.MODULE$.Right().apply((Object)Some$.MODULE$.apply((Object)BsonObjectId$.MODULE$.apply(s.getValue())));
            }
            return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Invalid id"));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Right().apply((Object)None$.MODULE$);
        }
        throw new MatchError((Object)option);
    }

    public Either<LogMessage, BsonValue> extractKey(Document doc) {
        Option option = doc.get(this.uniqueKey(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonString) {
                BsonString bs = (BsonString)bsonValue;
                String s = bs.getValue().trim();
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s))) {
                    return package$.MODULE$.Right().apply((Object)BsonString$.MODULE$.apply(s));
                }
                return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Empty key field"));
            }
            BsonValue x = bsonValue;
            return package$.MODULE$.Right().apply((Object)x);
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Missing key field"));
        }
        throw new MatchError((Object)option);
    }

    public Task<Existence> idExists(BsonObjectId id) {
        FindOptions options = FindOptions$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_id", "name"}))), FindOptions$.MODULE$.$lessinit$greater$default$2(), FindOptions$.MODULE$.$lessinit$greater$default$3(), FindOptions$.MODULE$.$lessinit$greater$default$4());
        return this.cltn().findO(DocumentManager2$.MODULE$.withObjId(id), options).firstOptionL().map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Document doc = (Document)((Some)option).value();
                return DocumentManager2$Existence$.MODULE$.apply(true, doc.contains("name"));
            }
            if (None$.MODULE$.equals(option)) {
                return DocumentManager2$Existence$.MODULE$.apply(false, false);
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<BoxedUnit> silentDelete(BsonObjectId id) {
        return this.cltn().deleteOneT(DocumentManager2$.MODULE$.withObjId(id)).map((Function1)(JProcedure1 & Serializable)_$4 -> {});
    }

    public Task<BoxedUnit> logInfo(Function0<String> msg) {
        ((LoggingMixin)this).log().info(msg, Line$.MODULE$.apply(175), FullName$.MODULE$.apply("ambience.framework.DocumentManager2.logInfo"));
        return Task$.MODULE$.now((Object)BoxedUnit.UNIT);
    }

    private static final BsonObjectId upload$$anonfun$1(Document doc$1) {
        return (BsonObjectId)doc$1.apply("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonObjectId.class));
    }

    private static final BsonObjectId delete$$anonfun$1(String hexId$1) {
        return BsonObjectId$.MODULE$.apply(hexId$1);
    }

    private static final String $anonfun$2(String hexId$2) {
        return "deleting " + hexId$2;
    }

    private static final BsonObjectId undelete$$anonfun$1(String hexId$3) {
        return BsonObjectId$.MODULE$.apply(hexId$3);
    }

    private static final String $anonfun$4(String hexId$4) {
        return "undeleting " + hexId$4;
    }

    private static final String $anonfun$6(BsonValue key$1) {
        return "inserting " + key$1;
    }

    private static final Document $anonfun$7$$anonfun$1(Document doc$7) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonObjectId$.MODULE$.apply()), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return (Document)doc$7.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private static final String $anonfun$8(BsonValue key$2) {
        return "updating " + key$2;
    }

    public static final class Existence
    implements Product,
    Serializable {
        private final boolean exists;
        private final boolean active;

        public static Existence apply(boolean bl, boolean bl2) {
            return DocumentManager2$Existence$.MODULE$.apply(bl, bl2);
        }

        public static Existence fromProduct(Product product) {
            return DocumentManager2$Existence$.MODULE$.fromProduct(product);
        }

        public static Existence unapply(Existence existence) {
            return DocumentManager2$Existence$.MODULE$.unapply(existence);
        }

        public Existence(boolean exists, boolean active) {
            this.exists = exists;
            this.active = active;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.exists() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.active() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Existence)) return false;
            Existence existence = (Existence)object;
            if (this.exists() != existence.exists()) return false;
            if (this.active() != existence.active()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Existence;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Existence";
        }

        public Object productElement(int n) {
            boolean bl;
            int n2 = n;
            if (0 == n2) {
                bl = this._1();
            } else if (1 == n2) {
                bl = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToBoolean((boolean)bl);
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "exists";
            }
            if (1 == n2) {
                return "active";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean exists() {
            return this.exists;
        }

        public boolean active() {
            return this.active;
        }

        public Existence copy(boolean exists, boolean active) {
            return new Existence(exists, active);
        }

        public boolean copy$default$1() {
            return this.exists();
        }

        public boolean copy$default$2() {
            return this.active();
        }

        public boolean _1() {
            return this.exists();
        }

        public boolean _2() {
            return this.active();
        }
    }
}

