/*
 * Decompiled with CFR 0.152.
 */
package ambience.framework;

import ambience.framework.DocumentManager2;
import ambience.gravity.GravityHelper$;
import ambience.module.UserDB;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.elixirtech.gravity.GravityRoute;
import com.elixirtech.gravity.GravityRoute$;
import com.elixirtech.gravity.GravitySystem$;
import io.circe.Json;
import java.io.Serializable;
import monix.eval.Task;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public class DocumentRoute2 {
    private final DocumentManager2 mgr;
    private final String writeGroup;
    private final Scheduler scheduler;

    public DocumentRoute2(DocumentManager2 mgr, String writeGroup) {
        this.mgr = mgr;
        this.writeGroup = writeGroup;
        this.scheduler = Scheduler$.MODULE$.global();
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Task<GravityResponse> canWrite(UserDB.User user, Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>> fn, GravityRequest request) {
        if (user.privileges().contains((Object)this.writeGroup)) {
            return (Task)((Function1)fn.apply((Object)user)).apply((Object)request);
        }
        return Gravity$.MODULE$.ForbiddenResponseT();
    }

    public GravityRoute route(UserDB.User user) {
        return GravityRoute$.MODULE$.all(GravitySystem$.MODULE$.fromRoutes(this.routes(user), GravitySystem$.MODULE$.fromRoutes$default$2()));
    }

    public List<GravityRoute> routes(UserDB.User user) {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GravityRoute[]{GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "data", (Function1 & Serializable)request -> this.getData(user, (GravityRequest)request)), GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "data", (Function1 & Serializable)request -> this.canWrite(user, (Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> (Function1 & Serializable)request -> this.postData((UserDB.User)user, (GravityRequest)request), (GravityRequest)request)), GravityRoute$.MODULE$.pathPrefixOnly(Gravity$.MODULE$.POST(), "data-delete", (Function1 & Serializable)request -> this.canWrite(user, (Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> (Function1 & Serializable)request -> this.postDataDelete((UserDB.User)user, (GravityRequest)request), (GravityRequest)request)), GravityRoute$.MODULE$.pathPrefixOnly(Gravity$.MODULE$.POST(), "data-undelete", (Function1 & Serializable)request -> this.canWrite(user, (Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> (Function1 & Serializable)request -> this.postDataUndelete((UserDB.User)user, (GravityRequest)request), (GravityRequest)request))}));
    }

    public Task<GravityResponse> getData(UserDB.User user, GravityRequest request) {
        return this.all();
    }

    public Task<GravityResponse> postData(UserDB.User user, GravityRequest request) {
        return GravityHelper$.MODULE$.jsonT(request).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Json json = (Json)((Some)option).value();
                return this.save(json);
            }
            if (None$.MODULE$.equals(option)) {
                return Gravity$.MODULE$.BadRequestResponseT("Invalid json");
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<GravityResponse> postDataDelete(UserDB.User user, GravityRequest request) {
        return GravityHelper$.MODULE$.seg1(request, (Function1<Gravity.Segment, Task<GravityResponse>>)(Function1 & Serializable)hexId -> this.delete(hexId.value()));
    }

    public Task<GravityResponse> postDataUndelete(UserDB.User user, GravityRequest request) {
        return GravityHelper$.MODULE$.seg1(request, (Function1<Gravity.Segment, Task<GravityResponse>>)(Function1 & Serializable)hexId -> this.undelete(hexId.value()));
    }

    public Task<GravityResponse> all() {
        return this.mgr.get().map((Function1 & Serializable)json -> GravityResponse$.MODULE$.json(json));
    }

    public Task<GravityResponse> save(Json json) {
        return this.mgr.save(json).map((Function1 & Serializable)msg -> GravityHelper$.MODULE$.toResponse((LogMessage)msg));
    }

    public Task<GravityResponse> delete(String hexId) {
        return this.mgr.delete(hexId).map((Function1 & Serializable)msg -> GravityHelper$.MODULE$.toResponse((LogMessage)msg));
    }

    public Task<GravityResponse> undelete(String hexId) {
        return this.mgr.undelete(hexId).map((Function1 & Serializable)msg -> GravityHelper$.MODULE$.toResponse((LogMessage)msg));
    }
}

