/*
 * Decompiled with CFR 0.152.
 */
package ambience.framework;

import ambience.api.BinaryStore;
import ambience.api.BinaryStore$Content$;
import ambience.api.BinaryStore$ContentId$;
import ambience.framework.BinaryStoreAPI;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.ObservableDataBytes;
import com.elixirtech.arch.ObservableDataBytes$;
import com.elixirtech.mongodb.FindOptions$;
import com.elixirtech.mongodb.MongoDB;
import com.elixirtech.mongodb.RichMongoCollection;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonBinary;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.MongoDatabase;
import org.mongodb.scala.bson.BsonBinary$;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonInt32$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.package$;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Projections$;
import scala.Function1;
import scala.Int$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class MongoDBBinaryStoreLocation
implements BinaryStore.Location,
LoggingHelper2 {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(MongoDBBinaryStoreLocation.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MongoDBBinaryStoreLocation.class.getDeclaredField("cltn$lzy1"));
    private volatile Object log$lzy1;
    private final String id;
    private final String dbName;
    private final String cltnName;
    private final long maxSize;
    private volatile Object cltn$lzy1;

    public MongoDBBinaryStoreLocation(BinaryStoreAPI.BSConfig bsConfig) {
        this.id = bsConfig.id();
        this.dbName = bsConfig.config().getString("database");
        this.cltnName = bsConfig.config().getString("collection");
        this.maxSize = bsConfig.config().getMemorySize("maxSize").toBytes();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public String id() {
        return this.id;
    }

    public String dbName() {
        return this.dbName;
    }

    public String cltnName() {
        return this.cltnName;
    }

    @Override
    public long maxSize() {
        return this.maxSize;
    }

    public RichMongoCollection cltn() {
        Object object = this.cltn$lzy1;
        if (object instanceof RichMongoCollection) {
            return (RichMongoCollection)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RichMongoCollection)this.cltn$lzyINIT1();
    }

    private Object cltn$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.cltn$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RichMongoCollection richMongoCollection = null;
                    try {
                        MongoDB mongoDB = (MongoDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(MongoDB.class));
                        MongoDatabase db = this.dbName().trim().isEmpty() ? mongoDB.database() : mongoDB.mongoClient().getDatabase(this.dbName());
                        richMongoCollection = new RichMongoCollection(db.getCollection(this.cltnName(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
                        object2 = richMongoCollection == null ? LazyVals.NullValue$.MODULE$ : richMongoCollection;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.cltn$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.cltn$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return richMongoCollection;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public String description() {
        return "MongoDB BinaryStore using " + this.dbName() + ":" + this.cltnName();
    }

    @Override
    public Task<String> add(BinaryStore.Content content) {
        return content.bytes().observable().toListL().flatMap((Function1 & Serializable)f -> {
            String uuid = UUID.randomUUID().toString();
            Object object = Predef$.MODULE$.refArrayOps((Object[])f.toArray(ClassTag$.MODULE$.apply(Byte.TYPE).wrap()));
            byte[] bytes = (byte[])ArrayOps$.MODULE$.flatten$extension(object, (Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs), ClassTag$.MODULE$.apply(Byte.TYPE));
            if ((long)bytes.length > this.maxSize()) {
                return Task$.MODULE$.raiseError((Throwable)new BinaryStore.MaxSizeException(Int$.MODULE$.int2long(bytes.length), this.maxSize()));
            }
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[5];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(uuid)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"bytes");
            objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonBinary$.MODULE$.apply(bytes)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"metadata");
            objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonString$.MODULE$.apply(content.metadata().noSpaces())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"size");
            objectArray[3] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)BsonInt32$.MODULE$.apply(bytes.length)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"created");
            objectArray[4] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)BsonDateTime$.MODULE$.apply(System.currentTimeMillis())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            Document doc = package$.MODULE$.Document().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            return this.cltn().insertOneT(doc).map((Function1 & Serializable)_$1 -> new BinaryStore.ContentId(BinaryStore$ContentId$.MODULE$.apply(uuid)));
        });
    }

    @Override
    public Observable<String> all() {
        return this.cltn().distinctO("_id").flatMap((Function1 & Serializable)x$1 -> {
            BsonValue bsonValue = x$1;
            if (bsonValue instanceof BsonString) {
                BsonString v = (BsonString)bsonValue;
                return Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new BinaryStore.ContentId[]{new BinaryStore.ContentId(BinaryStore$ContentId$.MODULE$.apply(v.getValue()))}));
            }
            return Observable$.MODULE$.empty();
        });
    }

    @Override
    public Task<Option<BinaryStore.Content>> get(String id) {
        return this.cltn().findO(Filters$.MODULE$.eq("_id", (Object)BsonString$.MODULE$.apply(id))).firstOptionL().map((Function1 & Serializable)optDoc -> optDoc.map((Function1 & Serializable)doc -> {
            ObservableDataBytes bytes = ObservableDataBytes$.MODULE$.apply(Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(this.getBytes((Document)doc))));
            Json metadata = (Json)this.getMetadata((Document)doc).getOrElse(MongoDBBinaryStoreLocation::$anonfun$2);
            return BinaryStore$Content$.MODULE$.apply((DataBytes)bytes, metadata);
        }));
    }

    @Override
    public Task<Option<Json>> getMetadata(String id) {
        return this.cltn().findO(Filters$.MODULE$.eq("_id", (Object)BsonString$.MODULE$.apply(id)), FindOptions$.MODULE$.projections(Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"metadata"})))).firstOptionL().map((Function1 & Serializable)_$2 -> _$2.flatMap((Function1 & Serializable)doc -> this.getMetadata((Document)doc)));
    }

    @Override
    public Task<BoxedUnit> remove(String id) {
        return this.cltn().deleteOneT(Filters$.MODULE$.eq("_id", (Object)BsonString$.MODULE$.apply(id))).map((Function1)(JProcedure1 & Serializable)_$3 -> {});
    }

    private Option<Json> parseJson(String s) {
        return io.circe.parser.package$.MODULE$.parse(s).toOption();
    }

    private Option<byte[]> getBytes(Document doc) {
        return doc.get("bytes", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBinary.class)).map((Function1 & Serializable)_$4 -> _$4.getData());
    }

    private Option<Json> getMetadata(Document doc) {
        return doc.get("metadata", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$5 -> _$5.getValue()).flatMap((Function1 & Serializable)s -> this.parseJson((String)s));
    }

    private static final Json $anonfun$2() {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }
}

