/*
 * Decompiled with CFR 0.152.
 */
package ambience.framework;

import ambience.framework.SafeUploadHandler$;
import ambience.framework.SafeUploadHandler$ConflictInfo$;
import ambience.framework.SafeUploadHandler$ExtractedInfo$;
import ambience.framework.SafeUploadHandler$IdNameOwner$;
import ambience.framework.SafeUploadHandler$Request$;
import ambience.framework.SafeUploadHandler$Result$;
import ambience.module.UserDB;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelperT;
import com.elixirtech.arch.LoggingInterfaceT;
import com.elixirtech.codex.CodexCollection;
import com.elixirtech.codex.CodexDB;
import com.elixirtech.codex.CodexFilter;
import com.elixirtech.codex.CodexFindOptions;
import io.circe.DecodingFailure;
import io.circe.Json;
import io.circe.Json$;
import io.circe.ParsingFailure;
import io.circe.parser.package$;
import java.io.Serializable;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public abstract class SafeUploadHandler
implements LoggingHelperT {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SafeUploadHandler.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final CodexCollection cltn;

    public static CodexFindOptions KeepIdNameAndOwner() {
        return SafeUploadHandler$.MODULE$.KeepIdNameAndOwner();
    }

    public SafeUploadHandler(CodexCollection cltn) {
        this.cltn = cltn;
    }

    public LoggingInterfaceT log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterfaceT) {
            return (LoggingInterfaceT)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterfaceT)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterfaceT loggingInterfaceT = null;
                    try {
                        loggingInterfaceT = LoggingHelperT.log$((LoggingHelperT)this);
                        object2 = loggingInterfaceT == null ? LazyVals.NullValue$.MODULE$ : loggingInterfaceT;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterfaceT;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public abstract Either<Task<Result>, ExtractedInfo> isValidContent(Json var1);

    public Task<Result> handleUpload(UserDB.User user, byte[] bytes, Option<String> optName, boolean overwrite) {
        Either either = package$.MODULE$.parse(new String(bytes, DataBytes$.MODULE$.UTF_8()));
        if (either instanceof Left) {
            ParsingFailure err = (ParsingFailure)((Left)either).value();
            return this.parsingFailed(err);
        }
        if (either instanceof Right) {
            Json incomingJson = (Json)((Right)either).value();
            return this.handleUpload(user, incomingJson, optName, overwrite);
        }
        throw new MatchError((Object)either);
    }

    public Task<Result> handleUpload(UserDB.User user, Json json, Option<String> optName, boolean overwrite) {
        Either<Task<Result>, ExtractedInfo> either = this.isValidContent(json);
        if (either instanceof Right) {
            ExtractedInfo incoming = (ExtractedInfo)((Right)either).value();
            return this.handleRequest(SafeUploadHandler$Request$.MODULE$.apply(user, json, incoming._id(), (String)optName.getOrElse(() -> SafeUploadHandler.handleUpload$$anonfun$1(incoming)), overwrite));
        }
        if (either instanceof Left) {
            Task result = (Task)((Left)either).value();
            return result;
        }
        throw new MatchError(either);
    }

    public Task<Result> parsingFailed(ParsingFailure err) {
        return this.log().errorT(() -> SafeUploadHandler.parsingFailed$$anonfun$1(err), Line$.MODULE$.apply(59), FullName$.MODULE$.apply("ambience.framework.SafeUploadHandler.parsingFailed")).map((Function1 & Serializable)_$3 -> SafeUploadHandler$Result$.MODULE$.apply("", (LogMessage)LogMessage.Error$.MODULE$.apply("Parsing json failed")));
    }

    public Task<Result> decodingFailed(String fileType, DecodingFailure err) {
        return this.log().errorT(() -> SafeUploadHandler.decodingFailed$$anonfun$1(fileType, err), Line$.MODULE$.apply(63), FullName$.MODULE$.apply("ambience.framework.SafeUploadHandler.decodingFailed")).map((Function1 & Serializable)_$4 -> SafeUploadHandler$Result$.MODULE$.apply("", (LogMessage)LogMessage.Error$.MODULE$.apply("Decoding " + fileType + " failed")));
    }

    public Task<Result> handleRequest(Request request) {
        return this.buildConflictInfo(request).flatMap((Function1 & Serializable)conflictInfo -> this.conflictResolution((ConflictInfo)conflictInfo).map((Function1 & Serializable)result -> result));
    }

    public Task<ConflictInfo> buildConflictInfo(Request request) {
        CodexFilter.Or filter = CodexFilter.Or$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(request.id())), CodexFilter.Eq$.MODULE$.apply("name", (BsonValue)BsonString$.MODULE$.apply(request.name()))}));
        return this.cltn.findO((CodexFilter)filter, SafeUploadHandler$.MODULE$.KeepIdNameAndOwner()).toListL().map((Function1 & Serializable)docs -> {
            List conflicts = docs.map((Function1 & Serializable)doc -> {
                Option name = doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$5 -> _$5.getValue());
                String owner = (String)doc.get("owner", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$6 -> _$6.getValue()).getOrElse(SafeUploadHandler::$anonfun$4);
                return SafeUploadHandler$IdNameOwner$.MODULE$.apply(doc.apply("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).asString().getValue(), (Option<String>)name, owner);
            });
            return SafeUploadHandler$ConflictInfo$.MODULE$.apply(request, (List<IdNameOwner>)conflicts);
        });
    }

    public Task<Result> conflictResolution(ConflictInfo conflictInfo) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(conflictInfo.optMatchingId(), conflictInfo.optMatchingName());
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                return this.newAddition(conflictInfo.request());
            }
            if (option instanceof Some) {
                IdNameOwner idNameOwner;
                IdNameOwner a = idNameOwner = (IdNameOwner)((Some)option).value();
                if (None$.MODULE$.equals(option2)) {
                    if (a.name().isEmpty()) {
                        return this.replaceDeleted(conflictInfo.request());
                    }
                    return this.idExistsWithDifferentName(conflictInfo.request());
                }
                IdNameOwner a2 = idNameOwner;
                if (option2 instanceof Some) {
                    IdNameOwner idNameOwner2;
                    IdNameOwner b = idNameOwner2 = (IdNameOwner)((Some)option2).value();
                    IdNameOwner idNameOwner3 = a2;
                    IdNameOwner idNameOwner4 = b;
                    if (!(idNameOwner3 != null ? !((Object)idNameOwner3).equals(idNameOwner4) : idNameOwner4 != null)) {
                        return this.replace(b, conflictInfo.request());
                    }
                    IdNameOwner b2 = idNameOwner2;
                    return this.idAndNameExistIndependently(b2, conflictInfo.request());
                }
            }
            if (None$.MODULE$.equals(option) && option2 instanceof Some) {
                IdNameOwner b = (IdNameOwner)((Some)option2).value();
                return this.nameExistsWithDifferentId(b, conflictInfo.request());
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public Task<Result> newAddition(Request request) {
        return this.log().infoT(SafeUploadHandler::newAddition$$anonfun$1, Line$.MODULE$.apply(98), FullName$.MODULE$.apply("ambience.framework.SafeUploadHandler.newAddition")).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.insert(request.newDocument()).map((Function1 & Serializable)_$7 -> SafeUploadHandler$Result$.MODULE$.apply(request.name(), (LogMessage)LogMessage.Info$.MODULE$.apply("Upload added successfully"))).map((Function1 & Serializable)result -> result);
        });
    }

    public Task<Result> replace(IdNameOwner nameMatch, Request request) {
        return this.checkConstraints(nameMatch, request, (Function0<Task<Result>>)((Function0 & Serializable)() -> this.replace$$anonfun$1(request)));
    }

    public Task<Result> replaceDeleted(Request request) {
        CodexFilter.Eq filter = CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(request.id()));
        return this.log().infoT(SafeUploadHandler::replaceDeleted$$anonfun$1, Line$.MODULE$.apply(116), FullName$.MODULE$.apply("ambience.framework.SafeUploadHandler.replaceDeleted")).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.cltn.replaceOneT((CodexFilter)filter, request.newDocument()).map((Function1 & Serializable)x$1 -> {
                CodexDB.UpdateResult updateResult = x$1;
                return SafeUploadHandler$Result$.MODULE$.apply(request.name(), (LogMessage)LogMessage.Info$.MODULE$.apply("Upload added " + request.name() + " successfully"));
            });
        });
    }

    public Task<Result> idAndNameExistIndependently(IdNameOwner nameMatch, Request request) {
        return this.checkConstraints(nameMatch, request, (Function0<Task<Result>>)((Function0 & Serializable)() -> this.idAndNameExistIndependently$$anonfun$1(request)));
    }

    public Task<Result> idExistsWithDifferentName(Request request) {
        String newId = UUID.randomUUID().toString();
        return this.log().infoT(() -> SafeUploadHandler.idExistsWithDifferentName$$anonfun$1(newId), Line$.MODULE$.apply(137), FullName$.MODULE$.apply("ambience.framework.SafeUploadHandler.idExistsWithDifferentName")).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(newId)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            return this.insert((Document)request.newDocument().updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return SafeUploadHandler$Result$.MODULE$.apply(request.name(), (LogMessage)LogMessage.Info$.MODULE$.apply("Upload added " + request.name() + " with new id"));
            });
        });
    }

    public Task<Result> nameExistsWithDifferentId(IdNameOwner nameMatch, Request request) {
        return this.checkConstraints(nameMatch, request, (Function0<Task<Result>>)((Function0 & Serializable)() -> this.nameExistsWithDifferentId$$anonfun$1(request)));
    }

    public Task<Result> checkConstraints(IdNameOwner nameMatch, Request request, Function0<Task<Result>> fn) {
        boolean canOverwrite = request.overwrite();
        String string = nameMatch.owner();
        String string2 = request.user().id();
        boolean isOwner = !(string != null ? !string.equals(string2) : string2 != null);
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(canOverwrite, isOwner);
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (!bl) {
                if (bl2) {
                    return Task$.MODULE$.now((Object)SafeUploadHandler$Result$.MODULE$.apply("", (LogMessage)LogMessage.Error$.MODULE$.apply("Name " + request.name() + " already used (tick Overwrite to replace)")));
                }
                if (!bl2) {
                    return Task$.MODULE$.now((Object)SafeUploadHandler$Result$.MODULE$.apply("", (LogMessage)LogMessage.Error$.MODULE$.apply("Name " + request.name() + " owned by someone else")));
                }
            }
            if (bl) {
                if (!bl2) {
                    return Task$.MODULE$.now((Object)SafeUploadHandler$Result$.MODULE$.apply("", (LogMessage)LogMessage.Error$.MODULE$.apply("Name " + request.name() + " owned by someone else")));
                }
                if (bl2) {
                    return (Task)fn.apply();
                }
            }
        }
        throw new MatchError((Object)sp2);
    }

    public Task<BoxedUnit> insert(Document doc) {
        return this.cltn.insertOneT(doc).map((Function1)(JProcedure1 & Serializable)_$8 -> {});
    }

    public Task<BoxedUnit> deleteName(String name) {
        return this.cltn.deleteOneT((CodexFilter)CodexFilter.Eq$.MODULE$.apply("name", (BsonValue)BsonString$.MODULE$.apply(name))).map((Function1)(JProcedure1 & Serializable)_$9 -> {});
    }

    private static final String handleUpload$$anonfun$1(ExtractedInfo incoming$1) {
        return incoming$1.name();
    }

    private static final Object parsingFailed$$anonfun$1(ParsingFailure err$1) {
        return "Cannot parse uploaded file as json: " + err$1;
    }

    private static final Object decodingFailed$$anonfun$1(String fileType$1, DecodingFailure err$2) {
        return "Cannot decode json as " + fileType$1 + ": " + err$2;
    }

    private static final String $anonfun$4() {
        return "";
    }

    private static final Object newAddition$$anonfun$1() {
        return "action = newAddition";
    }

    private static final Object replace$$anonfun$1$$anonfun$1() {
        return "action = replace";
    }

    private final Task replace$$anonfun$1(Request request$4) {
        CodexFilter.Eq filter = CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(request$4.id()));
        return this.log().infoT(SafeUploadHandler::replace$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(107), FullName$.MODULE$.apply("ambience.framework.SafeUploadHandler.replace")).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.cltn.replaceOneT((CodexFilter)filter, request$4.newDocument()).map((Function1 & Serializable)x$1 -> {
                CodexDB.UpdateResult updateResult = x$1;
                return SafeUploadHandler$Result$.MODULE$.apply(request$4.name(), (LogMessage)LogMessage.Info$.MODULE$.apply("Upload replaced " + request$4.name() + " successfully"));
            });
        });
    }

    private static final Object replaceDeleted$$anonfun$1() {
        return "action = replaceDeleted";
    }

    private static final Object idAndNameExistIndependently$$anonfun$1$$anonfun$1(String newId$1) {
        return "action = idAndNameExistIndependently changing to id " + newId$1;
    }

    private final Task idAndNameExistIndependently$$anonfun$1(Request request$9) {
        String newId = UUID.randomUUID().toString();
        return this.log().infoT(() -> SafeUploadHandler.idAndNameExistIndependently$$anonfun$1$$anonfun$1(newId), Line$.MODULE$.apply(126), FullName$.MODULE$.apply("ambience.framework.SafeUploadHandler.idAndNameExistIndependently")).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.deleteName(request$9.name()).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
                objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(newId)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                return this.insert((Document)request$9.newDocument().updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return SafeUploadHandler$Result$.MODULE$.apply(request$9.name(), (LogMessage)LogMessage.Info$.MODULE$.apply("Upload replaced " + request$9.name() + " with new id"));
                });
            });
        });
    }

    private static final Object idExistsWithDifferentName$$anonfun$1(String newId$4) {
        return "action = idExistsWithDifferentName changing to id " + newId$4;
    }

    private static final Object nameExistsWithDifferentId$$anonfun$1$$anonfun$1() {
        return "action = nameExistsWithDifferentId";
    }

    private final Task nameExistsWithDifferentId$$anonfun$1(Request request$15) {
        return this.log().infoT(SafeUploadHandler::nameExistsWithDifferentId$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(146), FullName$.MODULE$.apply("ambience.framework.SafeUploadHandler.nameExistsWithDifferentId")).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.deleteName(request$15.name()).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.insert(request$15.newDocument()).map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return SafeUploadHandler$Result$.MODULE$.apply(request$15.name(), (LogMessage)LogMessage.Info$.MODULE$.apply("Upload replaced " + request$15.name() + " successfully"));
                });
            });
        });
    }

    public static final class ConflictInfo
    implements Product,
    Serializable {
        public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(ConflictInfo.class.getDeclaredField("optMatchingName$lzy1"));
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ConflictInfo.class.getDeclaredField("optMatchingId$lzy1"));
        private final Request request;
        private final List conflicts;
        private volatile Object optMatchingId$lzy1;
        private volatile Object optMatchingName$lzy1;

        public static ConflictInfo apply(Request request, List<IdNameOwner> list) {
            return SafeUploadHandler$ConflictInfo$.MODULE$.apply(request, list);
        }

        public static ConflictInfo fromProduct(Product product) {
            return SafeUploadHandler$ConflictInfo$.MODULE$.fromProduct(product);
        }

        public static ConflictInfo unapply(ConflictInfo conflictInfo) {
            return SafeUploadHandler$ConflictInfo$.MODULE$.unapply(conflictInfo);
        }

        public ConflictInfo(Request request, List<IdNameOwner> conflicts) {
            this.request = request;
            this.conflicts = conflicts;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ConflictInfo)) return false;
            ConflictInfo conflictInfo = (ConflictInfo)object;
            Request request = this.request();
            Request request2 = conflictInfo.request();
            if (request == null) {
                if (request2 != null) {
                    return false;
                }
            } else if (!((Object)request).equals(request2)) return false;
            List<IdNameOwner> list = this.conflicts();
            List<IdNameOwner> list2 = conflictInfo.conflicts();
            if (list == null) {
                if (list2 == null) return true;
                return false;
            } else {
                if (!list.equals(list2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ConflictInfo;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ConflictInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "request";
            }
            if (1 == n2) {
                return "conflicts";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Request request() {
            return this.request;
        }

        public List<IdNameOwner> conflicts() {
            return this.conflicts;
        }

        public Option<IdNameOwner> optMatchingId() {
            Object object = this.optMatchingId$lzy1;
            if (object instanceof Option) {
                return (Option)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Option)this.optMatchingId$lzyINIT1();
        }

        private Object optMatchingId$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.optMatchingId$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Option option = null;
                        try {
                            option = this.conflicts().find((Function1 & Serializable)_$1 -> {
                                String string = _$1.id();
                                String string2 = this.request().id();
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            });
                            object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.optMatchingId$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return option;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public Option<IdNameOwner> optMatchingName() {
            Object object = this.optMatchingName$lzy1;
            if (object instanceof Option) {
                return (Option)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Option)this.optMatchingName$lzyINIT1();
        }

        private Object optMatchingName$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.optMatchingName$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Option option = null;
                        try {
                            option = this.conflicts().find((Function1 & Serializable)_$2 -> _$2.name().contains((Object)this.request().name()));
                            object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.optMatchingName$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return option;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public ConflictInfo copy(Request request, List<IdNameOwner> conflicts) {
            return new ConflictInfo(request, conflicts);
        }

        public Request copy$default$1() {
            return this.request();
        }

        public List<IdNameOwner> copy$default$2() {
            return this.conflicts();
        }

        public Request _1() {
            return this.request();
        }

        public List<IdNameOwner> _2() {
            return this.conflicts();
        }
    }

    public static final class ExtractedInfo
    implements Product,
    Serializable {
        private final String _id;
        private final String name;

        public static ExtractedInfo apply(String string, String string2) {
            return SafeUploadHandler$ExtractedInfo$.MODULE$.apply(string, string2);
        }

        public static ExtractedInfo fromProduct(Product product) {
            return SafeUploadHandler$ExtractedInfo$.MODULE$.fromProduct(product);
        }

        public static ExtractedInfo unapply(ExtractedInfo extractedInfo) {
            return SafeUploadHandler$ExtractedInfo$.MODULE$.unapply(extractedInfo);
        }

        public ExtractedInfo(String _id, String name) {
            this._id = _id;
            this.name = name;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ExtractedInfo)) return false;
            ExtractedInfo extractedInfo = (ExtractedInfo)object;
            String string = this._id();
            String string2 = extractedInfo._id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.name();
            String string4 = extractedInfo.name();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ExtractedInfo;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ExtractedInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "_id";
            }
            if (1 == n2) {
                return "name";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String _id() {
            return this._id;
        }

        public String name() {
            return this.name;
        }

        public ExtractedInfo copy(String _id, String name) {
            return new ExtractedInfo(_id, name);
        }

        public String copy$default$1() {
            return this._id();
        }

        public String copy$default$2() {
            return this.name();
        }

        public String _1() {
            return this._id();
        }

        public String _2() {
            return this.name();
        }
    }

    public static final class IdNameOwner
    implements Product,
    Serializable {
        private final String id;
        private final Option name;
        private final String owner;

        public static IdNameOwner apply(String string, Option<String> option, String string2) {
            return SafeUploadHandler$IdNameOwner$.MODULE$.apply(string, option, string2);
        }

        public static IdNameOwner fromProduct(Product product) {
            return SafeUploadHandler$IdNameOwner$.MODULE$.fromProduct(product);
        }

        public static IdNameOwner unapply(IdNameOwner idNameOwner) {
            return SafeUploadHandler$IdNameOwner$.MODULE$.unapply(idNameOwner);
        }

        public IdNameOwner(String id, Option<String> name, String owner) {
            this.id = id;
            this.name = name;
            this.owner = owner;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof IdNameOwner)) return false;
            IdNameOwner idNameOwner = (IdNameOwner)object;
            String string = this.id();
            String string2 = idNameOwner.id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<String> option = this.name();
            Option<String> option2 = idNameOwner.name();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            String string3 = this.owner();
            String string4 = idNameOwner.owner();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof IdNameOwner;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "IdNameOwner";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "id";
                }
                case 1: {
                    return "name";
                }
                case 2: {
                    return "owner";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String id() {
            return this.id;
        }

        public Option<String> name() {
            return this.name;
        }

        public String owner() {
            return this.owner;
        }

        public IdNameOwner copy(String id, Option<String> name, String owner) {
            return new IdNameOwner(id, name, owner);
        }

        public String copy$default$1() {
            return this.id();
        }

        public Option<String> copy$default$2() {
            return this.name();
        }

        public String copy$default$3() {
            return this.owner();
        }

        public String _1() {
            return this.id();
        }

        public Option<String> _2() {
            return this.name();
        }

        public String _3() {
            return this.owner();
        }
    }

    public static final class Request
    implements Product,
    Serializable {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Request.class.getDeclaredField("newDocument$lzy1"));
        private final UserDB.User user;
        private final Json incomingJson;
        private final String id;
        private final String name;
        private final boolean overwrite;
        private volatile Object newDocument$lzy1;

        public static Request apply(UserDB.User user, Json json, String string, String string2, boolean bl) {
            return SafeUploadHandler$Request$.MODULE$.apply(user, json, string, string2, bl);
        }

        public static Request fromProduct(Product product) {
            return SafeUploadHandler$Request$.MODULE$.fromProduct(product);
        }

        public static Request unapply(Request request) {
            return SafeUploadHandler$Request$.MODULE$.unapply(request);
        }

        public Request(UserDB.User user, Json incomingJson, String id, String name, boolean overwrite) {
            this.user = user;
            this.incomingJson = incomingJson;
            this.id = id;
            this.name = name;
            this.overwrite = overwrite;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.user()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.incomingJson()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.id()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)(this.overwrite() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Request)) return false;
            Request request = (Request)object;
            if (this.overwrite() != request.overwrite()) return false;
            UserDB.User user = this.user();
            UserDB.User user2 = request.user();
            if (user == null) {
                if (user2 != null) {
                    return false;
                }
            } else if (!((Object)user).equals(user2)) return false;
            Json json = this.incomingJson();
            Json json2 = request.incomingJson();
            if (json == null) {
                if (json2 != null) {
                    return false;
                }
            } else if (!json.equals(json2)) return false;
            String string = this.id();
            String string2 = request.id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.name();
            String string4 = request.name();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Request;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "Request";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return BoxesRunTime.boxToBoolean((boolean)this._5());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "user";
                }
                case 1: {
                    return "incomingJson";
                }
                case 2: {
                    return "id";
                }
                case 3: {
                    return "name";
                }
                case 4: {
                    return "overwrite";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public UserDB.User user() {
            return this.user;
        }

        public Json incomingJson() {
            return this.incomingJson;
        }

        public String id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public boolean overwrite() {
            return this.overwrite;
        }

        public Document newDocument() {
            Object object = this.newDocument$lzy1;
            if (object instanceof Document) {
                return (Document)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Document)this.newDocument$lzyINIT1();
        }

        private Object newDocument$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.newDocument$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Document document = null;
                        try {
                            Json recordJson = this.incomingJson().mapObject((Function1 & Serializable)obj -> obj.add("owner", Json$.MODULE$.fromString(this.user().id())).add("name", Json$.MODULE$.fromString(this.name())));
                            document = org.mongodb.scala.bson.package$.MODULE$.Document().apply(recordJson.noSpaces());
                            object2 = document == null ? LazyVals.NullValue$.MODULE$ : document;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.newDocument$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return document;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public Request copy(UserDB.User user, Json incomingJson, String id, String name, boolean overwrite) {
            return new Request(user, incomingJson, id, name, overwrite);
        }

        public UserDB.User copy$default$1() {
            return this.user();
        }

        public Json copy$default$2() {
            return this.incomingJson();
        }

        public String copy$default$3() {
            return this.id();
        }

        public String copy$default$4() {
            return this.name();
        }

        public boolean copy$default$5() {
            return this.overwrite();
        }

        public UserDB.User _1() {
            return this.user();
        }

        public Json _2() {
            return this.incomingJson();
        }

        public String _3() {
            return this.id();
        }

        public String _4() {
            return this.name();
        }

        public boolean _5() {
            return this.overwrite();
        }
    }

    public static final class Result
    implements Product,
    Serializable {
        private final String name;
        private final LogMessage msg;

        public static Result apply(String string, LogMessage logMessage) {
            return SafeUploadHandler$Result$.MODULE$.apply(string, logMessage);
        }

        public static Result fromProduct(Product product) {
            return SafeUploadHandler$Result$.MODULE$.fromProduct(product);
        }

        public static Result unapply(Result result) {
            return SafeUploadHandler$Result$.MODULE$.unapply(result);
        }

        public Result(String name, LogMessage msg) {
            this.name = name;
            this.msg = msg;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Result)) return false;
            Result result = (Result)object;
            String string = this.name();
            String string2 = result.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            LogMessage logMessage = this.msg();
            LogMessage logMessage2 = result.msg();
            if (logMessage == null) {
                if (logMessage2 == null) return true;
                return false;
            } else {
                if (!logMessage.equals(logMessage2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Result;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Result";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "name";
            }
            if (1 == n2) {
                return "msg";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public LogMessage msg() {
            return this.msg;
        }

        public Result copy(String name, LogMessage msg) {
            return new Result(name, msg);
        }

        public String copy$default$1() {
            return this.name();
        }

        public LogMessage copy$default$2() {
            return this.msg();
        }

        public String _1() {
            return this.name();
        }

        public LogMessage _2() {
            return this.msg();
        }
    }
}

