/*
 * Decompiled with CFR 0.152.
 */
package ambience.housekeeping;

import ambience.agenda.Agenda;
import ambience.agenda.Agenda$EpochMinute$;
import ambience.agenda.Agenda$Listener$;
import ambience.agenda.Agenda$ListenerId$;
import ambience.agenda.Agenda$Result$;
import ambience.agenda.AmbienceAgenda;
import com.elixirtech.arch.Clock;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.MongoDB;
import io.circe.Json$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonObjectId;
import org.mongodb.scala.MongoCollection;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Sorts$;
import org.reactivestreams.Publisher;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class CollectionCleaner
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CollectionCleaner.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final MongoDB mongoDB;
    private final Clock clock;
    private final AmbienceAgenda agenda;
    private final Scheduler scheduler;
    private final String listenerId;
    private final List cltns;
    private long lastRun;
    private Map<String, BsonObjectId> state;

    public CollectionCleaner(MongoDB mongoDB, Clock clock, AmbienceAgenda agenda) {
        this.mongoDB = mongoDB;
        this.clock = clock;
        this.agenda = agenda;
        this.scheduler = Scheduler$.MODULE$.global();
        this.listenerId = Agenda$ListenerId$.MODULE$.apply("CollectionCleaner");
        this.cltns = CollectionConverters$.MODULE$.ListHasAsScala(mongoDB.sysConfig().config().getStringList("ambience.collection-cleaner.collections")).asScala().toList();
        this.lastRun = 0L;
        this.state = Predef$.MODULE$.Map().empty();
        if (this.cltns().nonEmpty()) {
            Task steps = Task$.MODULE$.sleep(FiniteDuration$.MODULE$.apply(5L, scala.concurrent.duration.package$.MODULE$.MINUTES())).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.taskInfo((Function0<String>)((Function0 & Serializable)this::$anonfun$1$$anonfun$1)).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                        this.$anonfun$1$$anonfun$2$$anonfun$1(agenda);
                        return BoxedUnit.UNIT;
                    }).flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return this.schedule().map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        });
                    });
                });
            });
            v0 = steps.runToFuture(this.scheduler()).recover((PartialFunction)new Serializable(this){
                private final /* synthetic */ CollectionCleaner $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    if (throwable instanceof Exception) {
                        Exception ex = (Exception)throwable;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    if (throwable instanceof Exception) {
                        Exception ex = (Exception)throwable;
                        this.$outer.log().error(() -> CollectionCleaner.ambience$housekeeping$CollectionCleaner$$anon$1$$_$applyOrElse$$anonfun$1(ex), (Throwable)ex, Line$.MODULE$.apply(37), FullName$.MODULE$.apply("ambience.housekeeping.CollectionCleaner"));
                        return BoxedUnit.UNIT;
                    }
                    return function1.apply((Object)x);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{ambience$housekeeping$CollectionCleaner$$anon$1$$_$applyOrElse$$anonfun$1(java.lang.Exception )}, serializedLambda);
                }
            }, (ExecutionContext)this.scheduler());
        } else {
            this.log().info(CollectionCleaner::$init$$$anonfun$1, Line$.MODULE$.apply(40), FullName$.MODULE$.apply("ambience.housekeeping.CollectionCleaner"));
            v0 = BoxedUnit.UNIT;
        }
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public String listenerId() {
        return this.listenerId;
    }

    public List<String> cltns() {
        return this.cltns;
    }

    public Try<Agenda.Result> onRun(Agenda.Item item) {
        return Try$.MODULE$.apply(this::onRun$$anonfun$1);
    }

    private Task<BoxedUnit> schedule() {
        return this.taskInfo((Function0<String>)((Function0 & Serializable)CollectionCleaner::schedule$$anonfun$1)).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.agenda.isActive(this.listenerId()).flatMap((Function1 & Serializable)active -> this.schedule$$anonfun$2$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)active)));
        });
    }

    private Task<String> addSchedule() {
        this.log().info(CollectionCleaner::addSchedule$$anonfun$1, Line$.MODULE$.apply(55), FullName$.MODULE$.apply("ambience.housekeeping.CollectionCleaner.addSchedule"));
        return this.agenda.notify(Agenda$EpochMinute$.MODULE$.now().addHours(1), this.listenerId(), Json$.MODULE$.fromFields((Iterable)package$.MODULE$.Nil()));
    }

    public Agenda.Result run() {
        this.log().info(CollectionCleaner::run$$anonfun$1, Line$.MODULE$.apply(60), FullName$.MODULE$.apply("ambience.housekeeping.CollectionCleaner.run"));
        long now = this.clock.now();
        this.log().info(() -> this.run$$anonfun$2(now), Line$.MODULE$.apply(62), FullName$.MODULE$.apply("ambience.housekeeping.CollectionCleaner.run"));
        this.lastRun = now;
        Observable pairs = Observable$.MODULE$.fromTask(this.cleanup(this.state)).flatMap((Function1 & Serializable)delCount -> this.$anonfun$2(BoxesRunTime.unboxToLong((Object)delCount)));
        Task tresult = pairs.toListL().map((Function1 & Serializable)_$1 -> _$1.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).flatMap((Function1 & Serializable)newState -> {
            this.setState((Map<String, BsonObjectId>)newState);
            return Task$.MODULE$.now((Object)BoxedUnit.UNIT).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.schedule().flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    Object[] objectArray = new Tuple2[1];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"counted");
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromInt(this.state.size()));
                    return Task$.MODULE$.now((Object)Agenda$Result$.MODULE$.apply(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).map((Function1 & Serializable)result -> result);
                });
            });
        });
        return (Agenda.Result)Await$.MODULE$.result((Awaitable)tresult.runToFuture(Scheduler$.MODULE$.global()), (Duration)Duration$.MODULE$.Inf());
    }

    public void setState(Map<String, BsonObjectId> newState) {
        this.log().info(() -> CollectionCleaner.setState$$anonfun$1(newState), Line$.MODULE$.apply(80), FullName$.MODULE$.apply("ambience.housekeeping.CollectionCleaner.setState"));
        this.state = newState;
    }

    public Task<Object> cleanup(Map<String, BsonObjectId> currentState) {
        Observable all = Observable$.MODULE$.fromIterable((Iterable)currentState.toList()).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String cltnName = (String)tuple2._1();
                BsonObjectId id = (BsonObjectId)tuple2._2();
                return true;
            }
            return false;
        }).flatMap((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                String cltnName = (String)tuple2._1();
                BsonObjectId id = (BsonObjectId)tuple2._2();
                this.log().info(() -> CollectionCleaner.$anonfun$6$$anonfun$1(cltnName, id), Line$.MODULE$.apply(87), FullName$.MODULE$.apply("ambience.housekeeping.CollectionCleaner.all"));
                return Observable$.MODULE$.now((Object)BoxedUnit.UNIT).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return Observable$.MODULE$.now((Object)this.mongoDB.database().getCollection(cltnName, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class))).flatMap((Function1 & Serializable)cltn -> Observable$.MODULE$.fromReactivePublisher((Publisher)cltn.deleteMany(Filters$.MODULE$.lte("_id", (Object)id)).map((Function1 & Serializable)_$2 -> _$2.getDeletedCount())).flatMap((Function1 & Serializable)delCount -> CollectionCleaner.$anonfun$6$$anonfun$2$$anonfun$1$$anonfun$2(cltnName, BoxesRunTime.unboxToLong((Object)delCount))));
                });
            }
            throw new MatchError((Object)tuple2);
        });
        return all.toListL().map((Function1 & Serializable)_$3 -> BoxesRunTime.unboxToLong((Object)_$3.sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
    }

    public Observable<Tuple2<String, BsonObjectId>> getLatest(String cltnName) {
        MongoCollection cltn = this.mongoDB.database().getCollection(cltnName, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
        return Observable$.MODULE$.fromReactivePublisher((Publisher)cltn.find(DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)).sort(Sorts$.MODULE$.descending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_id"}))).limit(1)).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonObjectId.class)))).map((Function1 & Serializable)objId -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)cltnName);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, objId);
        }));
    }

    public Task<BoxedUnit> taskInfo(Function0<String> msg) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.taskInfo$$anonfun$1(msg);
            return BoxedUnit.UNIT;
        });
    }

    private final String $anonfun$1$$anonfun$1() {
        return "Setting up cleaner for " + ((IterableOnceOps)this.cltns().sorted((Ordering)Ordering.String$.MODULE$)).mkString(",");
    }

    private final void $anonfun$1$$anonfun$2$$anonfun$1(AmbienceAgenda agenda$3) {
        agenda$3.add(Agenda$Listener$.MODULE$.apply(this.listenerId(), (Function1<Agenda.Item, Try<Agenda.Result>>)(Function1 & Serializable)item -> this.onRun((Agenda.Item)item)));
    }

    public static final Object ambience$housekeeping$CollectionCleaner$$anon$1$$_$applyOrElse$$anonfun$1(Exception ex$1) {
        return "Error caught in init: " + ex$1;
    }

    private static final Object $init$$$anonfun$1() {
        return "No collections defined for cleaning";
    }

    private final Agenda.Result onRun$$anonfun$1() {
        return this.run();
    }

    private static final String schedule$$anonfun$1() {
        return "Scheduling...";
    }

    private static final String schedule$$anonfun$2$$anonfun$1$$anonfun$1() {
        return "There is already a scheduled activity recorded";
    }

    private final /* synthetic */ Task schedule$$anonfun$2$$anonfun$1(boolean active) {
        return (!active ? this.addSchedule() : this.taskInfo((Function0<String>)((Function0 & Serializable)CollectionCleaner::schedule$$anonfun$2$$anonfun$1$$anonfun$1))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            Object object = x$1;
        });
    }

    private static final Object addSchedule$$anonfun$1() {
        return "Adding scheduled activity to run in 60 minutes";
    }

    private static final Object run$$anonfun$1() {
        return "Running";
    }

    private final Object run$$anonfun$2(long now$1) {
        return "Bumped lastRun from " + this.lastRun + " to " + now$1;
    }

    private static final Object $anonfun$2$$anonfun$1(long delCount$1) {
        return "Deleted " + delCount$1 + " records in total";
    }

    private final /* synthetic */ Observable $anonfun$2(long delCount) {
        this.log().info(() -> CollectionCleaner.$anonfun$2$$anonfun$1(delCount), Line$.MODULE$.apply(66), FullName$.MODULE$.apply("ambience.housekeeping.CollectionCleaner.pairs"));
        return Observable$.MODULE$.now((Object)BoxedUnit.UNIT).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Observable$.MODULE$.fromIterable(this.cltns()).flatMap((Function1 & Serializable)cltn -> this.getLatest((String)cltn).map((Function1 & Serializable)pair -> pair));
        });
    }

    private static final Object setState$$anonfun$1(Map newState$1) {
        return "newState: " + newState$1;
    }

    private static final Object $anonfun$6$$anonfun$1(String cltnName$1, BsonObjectId id$1) {
        return "Cleaning up " + cltnName$1 + " " + id$1;
    }

    private static final /* synthetic */ Observable $anonfun$6$$anonfun$2$$anonfun$1$$anonfun$2(String cltnName$4, long delCount) {
        return Observable$.MODULE$.now((Object)("Deleted " + delCount + " from " + cltnName$4)).map((Function1 & Serializable)x$1 -> {
            String string = x$1;
            return delCount;
        });
    }

    private final void taskInfo$$anonfun$1(Function0 msg$1) {
        this.log().info(msg$1, Line$.MODULE$.apply(104), FullName$.MODULE$.apply("ambience.housekeeping.CollectionCleaner.taskInfo"));
    }
}

