/*
 * Decompiled with CFR 0.152.
 */
package ambience.module;

import ambience.module.APITokenDB;
import ambience.module.AccessLogging$;
import ambience.module.BumpActivityLogic;
import ambience.module.CorePrivileges$;
import ambience.module.CustomOAuth2Client;
import ambience.module.CustomOAuth2Client$SessionData$;
import ambience.module.ProjectConfig;
import ambience.module.SessionDataDecoder$;
import ambience.module.UserDB;
import ambience.module.UserDB$;
import ambience.module.UserDB$RoleIdName$;
import ambience.module.UserDB$User$;
import ambience.module.impl.ExtraGroupsBuilder$;
import ambience.session.SessionManager;
import ambience.session.SessionManager$SessionId$;
import ambience.sso.client.ClientModel;
import ambience.sso.client.ClientModel$OriginalUri$;
import ambience.sso.client.ClientModel$RequestInfo$;
import ambience.sso.client.ClientModel$UserInfo$;
import ambience.sso.client.OAuth2CookieClient;
import ambience.sso.client.OAuth2CookieClient$;
import ambience.sso.client.SSOClientState;
import cats.Functor;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import cats.implicits$;
import cats.kernel.Order;
import cats.syntax.EitherIdOps$;
import com.elixirtech.api.AuditAPI;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityCookie;
import com.elixirtech.gravity.GravityCookie$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.typesafe.config.Config;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Base64;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple3$;
import scala.Tuple6$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Left$;
import scala.util.Right;
import scala.util.Right$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class CustomOAuth2ClientImpl
extends OAuth2CookieClient
implements CustomOAuth2Client,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CustomOAuth2ClientImpl.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final ProjectConfig projectConfig;
    private final UserDB userDB;
    private final APITokenDB apiTokenDB;
    private final SessionManager sessionManager;
    private final Config config;
    private final String CookieSameSite;
    private final boolean CookieSecure;
    private final String CookieExtensions;
    private final String OpenIdCase;
    private final boolean OpenIdFieldStripDomain;
    private final boolean AddAuthenticatedUsers;
    private final List AddRoles;
    private final Base64.Encoder encoder;
    private final BumpActivityLogic bumpActivityLogic;

    public CustomOAuth2ClientImpl(ProjectConfig projectConfig, UserDB userDB, APITokenDB apiTokenDB, SessionManager sessionManager, SSOClientState ssoClientState) {
        this.projectConfig = projectConfig;
        this.userDB = userDB;
        this.apiTokenDB = apiTokenDB;
        this.sessionManager = sessionManager;
        super("elxsso", ssoClientState, CustomOAuth2ClientImpl.CustomOAuth2ClientImpl$superArg$1(projectConfig, userDB, apiTokenDB, sessionManager, ssoClientState));
        this.config = OAuth2CookieClient$.MODULE$.config();
        this.CookieSameSite = this.config().getString("cookie-same-site");
        this.CookieSecure = this.config().getBoolean("cookie-secure");
        this.CookieExtensions = this.config().getString("cookie-extensions");
        this.OpenIdCase = this.config().getString("openid-case");
        this.OpenIdFieldStripDomain = this.config().getBoolean("openid-field-strip-domain");
        this.AddAuthenticatedUsers = this.config().getBoolean("add-authenticated-users.enabled");
        this.AddRoles = CollectionConverters$.MODULE$.ListHasAsScala(this.config().getStringList("add-authenticated-users.roles")).asScala().toList();
        this.encoder = Base64.getEncoder();
        this.bumpActivityLogic = new BumpActivityLogic(sessionManager, OAuth2CookieClient$.MODULE$.CookieName());
        Elixir$.MODULE$.registerInstance((Object)this.service(), ClassTag$.MODULE$.apply(ClientModel.ServiceDefinition.class));
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Config config() {
        return this.config;
    }

    public String CookieSameSite() {
        return this.CookieSameSite;
    }

    public boolean CookieSecure() {
        return this.CookieSecure;
    }

    public String CookieExtensions() {
        return this.CookieExtensions;
    }

    public String OpenIdCase() {
        return this.OpenIdCase;
    }

    public boolean OpenIdFieldStripDomain() {
        return this.OpenIdFieldStripDomain;
    }

    public boolean AddAuthenticatedUsers() {
        return this.AddAuthenticatedUsers;
    }

    public List<String> AddRoles() {
        return this.AddRoles;
    }

    public Base64.Encoder encoder() {
        return this.encoder;
    }

    public BumpActivityLogic bumpActivityLogic() {
        return this.bumpActivityLogic;
    }

    public Function1<Option<UserDB.User>, Function1<GravityRequest, Task<GravityResponse>>> opt(Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>> uh) {
        return (Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                UserDB.User user = (UserDB.User)((Some)option).value();
                return this.logAccess(user, uh);
            }
            if (None$.MODULE$.equals(option)) {
                return Gravity$.MODULE$.ForbiddenHandler();
            }
            throw new MatchError((Object)option);
        };
    }

    @Override
    public Function1<GravityRequest, Task<GravityResponse>> approveWithUser(Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>> innerRoute) {
        return this.approveWithOptUser(this.opt(innerRoute));
    }

    public Function1<GravityRequest, Task<GravityResponse>> approveWithOptUser(Function1<Option<UserDB.User>, Function1<GravityRequest, Task<GravityResponse>>> innerRoute) {
        return (Function1 & Serializable)request -> {
            Option<String> option = this.extractElxToken((GravityRequest)request);
            if (option instanceof Some) {
                String token = (String)((Some)option).value();
                return (Task)this.approvedElxToken(token, innerRoute).apply(request);
            }
            if (None$.MODULE$.equals(option)) {
                return (Task)this.approve(OAuth2CookieClient$.MODULE$.OpenIdScope(), (Function1<ClientModel.UserInfo, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)userInfo -> (Function1)innerRoute.apply(this.buildUser((ClientModel.UserInfo)userInfo))).apply(request);
            }
            throw new MatchError(option);
        };
    }

    @Override
    public Function1<GravityRequest, Task<GravityResponse>> ifAuthenticated(Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>> innerRoute) {
        return (Function1 & Serializable)request -> {
            Option<String> option = this.extractElxToken((GravityRequest)request);
            if (option instanceof Some) {
                String token = (String)((Some)option).value();
                return (Task)this.approvedElxToken(token, this.opt(innerRoute)).apply(request);
            }
            if (None$.MODULE$.equals(option)) {
                return (Task)this.ifCookieApproved((Function1<ClientModel.UserInfo, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)userInfo -> {
                    Option<UserDB.User> option = this.buildUser((ClientModel.UserInfo)userInfo);
                    if (option instanceof Some) {
                        UserDB.User user = (UserDB.User)((Some)option).value();
                        return (Function1)innerRoute.apply((Object)user);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return Gravity$.MODULE$.BadRequestHandler();
                    }
                    throw new MatchError(option);
                }, this.ifCookieApproved$default$2()).apply(request);
            }
            throw new MatchError(option);
        };
    }

    @Override
    public Function1<GravityRequest, Task<GravityResponse>> optAuthenticated(Function1<Option<UserDB.User>, Function1<GravityRequest, Task<GravityResponse>>> innerRoute) {
        return (Function1 & Serializable)request -> {
            Option<String> option = this.extractElxToken((GravityRequest)request);
            if (option instanceof Some) {
                String token = (String)((Some)option).value();
                return (Task)this.approvedElxToken(token, innerRoute).apply(request);
            }
            if (None$.MODULE$.equals(option)) {
                return (Task)this.ifCookieApproved((Function1<ClientModel.UserInfo, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)userInfo -> this.logAccess(this.buildUser((ClientModel.UserInfo)userInfo), innerRoute), (Function1<GravityRequest, Task<GravityResponse>>)((Function1)innerRoute.apply((Object)None$.MODULE$))).apply(request);
            }
            throw new MatchError(option);
        };
    }

    public Option<String> extractElxToken(GravityRequest request) {
        return request.parameters().get("elx.token").orElse(() -> this.extractElxToken$$anonfun$1(request));
    }

    public Option<String> extractElxTokenFromAuthentication(GravityRequest request) {
        String value;
        Option option = request.headers().get("Authentication");
        if (option instanceof Some && (value = (String)((Some)option).value()).startsWith("elx.token ")) {
            return Some$.MODULE$.apply((Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(value), "elx.token ").trim());
        }
        return None$.MODULE$;
    }

    public Function1<GravityRequest, Task<GravityResponse>> approvedElxToken(String token, Function1<Option<UserDB.User>, Function1<GravityRequest, Task<GravityResponse>>> innerRoute) {
        return (Function1 & Serializable)request -> this.apiTokenDB.lookupUserForToken(token, request.path()).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                APITokenDB.APIInfo apiInfo = (APITokenDB.APIInfo)((Some)option).value();
                return (Task)this.handleTokenRoute(token, apiInfo, request.host(), innerRoute).apply(request);
            }
            if (None$.MODULE$.equals(option)) {
                return (Task)((Function1)innerRoute.apply((Object)None$.MODULE$)).apply(request);
            }
            throw new MatchError((Object)option);
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> logAccess(UserDB.User user, Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>> inner) {
        return (Function1 & Serializable)request -> AccessLogging$.MODULE$.logUser((GravityRequest)request, user.name()).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return ((Task)((Function1)inner.apply((Object)user)).apply(request)).map((Function1 & Serializable)ret -> ret);
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> logAccess(Option<UserDB.User> optUser, Function1<Option<UserDB.User>, Function1<GravityRequest, Task<GravityResponse>>> inner) {
        return (Function1 & Serializable)request -> ((Task)optUser.map((Function1 & Serializable)user -> AccessLogging$.MODULE$.logUser((GravityRequest)request, user.name())).getOrElse(CustomOAuth2ClientImpl::logAccess$$anonfun$2$$anonfun$2)).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return ((Task)((Function1)inner.apply((Object)optUser)).apply(request)).map((Function1 & Serializable)ret -> ret);
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> handleTokenRoute(String token, APITokenDB.APIInfo apiInfo, String clientIP, Function1<Option<UserDB.User>, Function1<GravityRequest, Task<GravityResponse>>> innerRoute) {
        return (Function1 & Serializable)request -> {
            UserDB.User user = apiInfo.user();
            ClientModel.RequestInfo requestInfo = ClientModel$RequestInfo$.MODULE$.apply(request.host());
            if (apiInfo.addCookie()) {
                return this.buildSession(requestInfo, user).flatMap((Function1 & Serializable)x$1 -> {
                    Either either = x$1;
                    if (either instanceof Right) {
                        GravityCookie cookie = (GravityCookie)((Right)either).value();
                        return ((Task)this.logAccess((Option<UserDB.User>)Some$.MODULE$.apply((Object)user), innerRoute).apply(request)).map((Function1 & Serializable)response -> {
                            this.log().info(() -> CustomOAuth2ClientImpl.handleTokenRoute$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(token), Line$.MODULE$.apply(145), FullName$.MODULE$.apply("ambience.module.CustomOAuth2ClientImpl.handleTokenRoute"));
                            Gravity.Headers headers = response.headers().$plus(cookie.asSetCookieHeader());
                            int n = response.copy$default$1();
                            DataBytes dataBytes = response.copy$default$3();
                            return response.copy(n, headers, dataBytes);
                        });
                    }
                    if (either instanceof Left) {
                        String err = (String)((Left)either).value();
                        return (Task)((Function1)innerRoute.apply((Object)None$.MODULE$)).apply(request);
                    }
                    throw new MatchError((Object)either);
                });
            }
            return (Task)this.logAccess((Option<UserDB.User>)Some$.MODULE$.apply((Object)user), innerRoute).apply(request);
        };
    }

    public Option<UserDB.User> buildUser(ClientModel.UserInfo userInfo) {
        String string = "id";
        String string2 = "name";
        String string3 = "email";
        String string4 = "roles";
        String string5 = "privileges";
        String string6 = "enabled";
        int size = 6;
        Either either = userInfo.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("User", CustomOAuth2ClientImpl::buildUser$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), CustomOAuth2ClientImpl::buildUser$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(CustomOAuth2ClientImpl::buildUser$$anonfun$3)))));
        if (either instanceof Right) {
            UserDB.User user = (UserDB.User)((Right)either).value();
            return Some$.MODULE$.apply((Object)user);
        }
        if (either instanceof Left) {
            DecodingFailure err = (DecodingFailure)((Left)either).value();
            this.log().error(() -> CustomOAuth2ClientImpl.buildUser$$anonfun$4(err, userInfo), Line$.MODULE$.apply(158), FullName$.MODULE$.apply("ambience.module.CustomOAuth2ClientImpl.buildUser"));
            return None$.MODULE$;
        }
        throw new MatchError((Object)either);
    }

    @Override
    public Function1<GravityRequest, Task<GravityResponse>> bumpActivity() {
        return (Function1 & Serializable)_$1 -> this.bumpActivityLogic().apply((GravityRequest)_$1);
    }

    @Override
    public Task<Either<String, GravityCookie>> buildCookie(ClientModel.RequestInfo requestInfo, ClientModel.AuthUserInfo ui) {
        String sub = this.fixOpenIdField((String)ui.json().hcursor().downField(OAuth2CookieClient$.MODULE$.OpenIdField()).as(Decoder$.MODULE$.decodeString()).toOption().getOrElse(CustomOAuth2ClientImpl::$anonfun$4));
        String email = (String)ui.json().hcursor().downField("email").as(Decoder$.MODULE$.decodeString()).toOption().getOrElse(CustomOAuth2ClientImpl::$anonfun$5);
        boolean changePassword = BoxesRunTime.unboxToBoolean((Object)ui.json().hcursor().downField("elxsso_changePassword").as(Decoder$.MODULE$.decodeBoolean()).toOption().getOrElse(CustomOAuth2ClientImpl::$anonfun$6));
        return this.userDB.setUserEmail(sub, email).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return UserDB$.MODULE$.filterEnabled(this.userDB.getUserByName(sub)).flatMap((Function1 & Serializable)optUser -> ExtraGroupsBuilder$.MODULE$.run((Option<UserDB.User>)optUser, ui).flatMap((Function1 & Serializable)optUserExtra -> {
                Task<Either<String, GravityCookie>> task;
                Option option = optUserExtra;
                if (option instanceof Some) {
                    UserDB.User realUser = (UserDB.User)((Some)option).value();
                    UserDB.User user = changePassword ? this.changePasswordUser(realUser) : realUser;
                    task = this.buildSession(requestInfo, user);
                } else if (None$.MODULE$.equals(option)) {
                    task = this.handleNoUser(requestInfo, sub, email, ui);
                } else {
                    throw new MatchError((Object)option);
                }
                return task.map((Function1 & Serializable)reply -> reply);
            }));
        });
    }

    public String fixOpenIdField(String s) {
        return this.adjustCase(this.stripDomain(s));
    }

    public String stripDomain(String s) {
        if (this.OpenIdFieldStripDomain()) {
            return StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)_$2 -> CustomOAuth2ClientImpl.stripDomain$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$2)));
        }
        return s;
    }

    public String adjustCase(String s) {
        String string = this.OpenIdCase().toUpperCase();
        if ("UPPER".equals(string)) {
            return s.toUpperCase();
        }
        if ("LOWER".equals(string)) {
            return s.toLowerCase();
        }
        return s;
    }

    public Task<Either<String, GravityCookie>> handleNoUser(ClientModel.RequestInfo requestInfo, String sub, String email, ClientModel.AuthUserInfo ui) {
        if (this.AddAuthenticatedUsers()) {
            EitherT ret = EitherT$.MODULE$.apply(this.addUser(sub)).flatMap((Function1 & Serializable)user -> EitherT$.MODULE$.apply((Object)this.userDB.setUserEmail(sub, email).map((Function1 & Serializable)_$3 -> {
                BoxedUnit boxedUnit = (BoxedUnit)implicits$.MODULE$.catsSyntaxEitherId(_$3);
                return EitherIdOps$.MODULE$.asRight$extension((Object)boxedUnit);
            })).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return EitherT$.MODULE$.apply((Object)ExtraGroupsBuilder$.MODULE$.run((UserDB.User)user, ui).map((Function1 & Serializable)_$4 -> {
                    UserDB.User user = (UserDB.User)implicits$.MODULE$.catsSyntaxEitherId(_$4);
                    return EitherIdOps$.MODULE$.asRight$extension((Object)user);
                })).flatMap((Function1 & Serializable)augUser -> EitherT$.MODULE$.apply(this.buildSession(requestInfo, (UserDB.User)augUser)).map((Function1 & Serializable)cookie -> cookie, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
            }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
            return (Task)ret.value();
        }
        return Task$.MODULE$.now((Object)Left$.MODULE$.apply((Object)("User with sub " + sub + " email " + email + " not found")));
    }

    public Task<Either<String, GravityCookie>> buildSession(ClientModel.RequestInfo requestInfo, UserDB.User user) {
        return this.sessionManager.createSession(requestInfo, user).flatMap((Function1 & Serializable)sessionId -> this.buildSession$$anonfun$1(user, sessionId == null ? null : ((SessionManager.SessionId)sessionId).value()));
    }

    public Task<BoxedUnit> auditNewSession(UserDB.User user, String sessionId) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.auditNewSession$$anonfun$1(user, sessionId);
            return BoxedUnit.UNIT;
        });
    }

    public Task<BoxedUnit> auditDeleteSession(UserDB.User user, String sessionId) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.auditDeleteSession$$anonfun$1(user, sessionId);
            return BoxedUnit.UNIT;
        });
    }

    public Task<Either<String, GravityCookie>> buildCookie(String sessionId, String sub) {
        CustomOAuth2Client.SessionData sessionData = (CustomOAuth2Client.SessionData)package$.MODULE$.EncoderOps((Object)CustomOAuth2Client$SessionData$.MODULE$.apply(sessionId, sub));
        String string = "uuid";
        String string2 = "name";
        String cookieValue = package.EncoderOps$.MODULE$.asJson$extension((Object)sessionData, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(CustomOAuth2ClientImpl::$anonfun$12, scala.package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default())))).noSpaces();
        this.log().info(() -> CustomOAuth2ClientImpl.buildCookie$$anonfun$2(cookieValue), Line$.MODULE$.apply(239), FullName$.MODULE$.apply("ambience.module.CustomOAuth2ClientImpl.buildCookie"));
        return Task$.MODULE$.now((Object)Right$.MODULE$.apply((Object)this.buildCookie(OAuth2CookieClient$.MODULE$.CookieName(), this.encodeB64(cookieValue), (Option<Object>)None$.MODULE$)));
    }

    public Task<Either<String, UserDB.User>> addUser(String name) {
        this.log().info(() -> CustomOAuth2ClientImpl.addUser$$anonfun$1(name), Line$.MODULE$.apply(244), FullName$.MODULE$.apply("ambience.module.CustomOAuth2ClientImpl.addUser"));
        return this.userDB.addAuthenticatedUser(name, this.AddRoles());
    }

    public UserDB.User changePasswordUser(UserDB.User user) {
        if (user.privileges().contains((Object)CorePrivileges$.MODULE$.NoForcePasswordChange().name())) {
            return user;
        }
        this.log().info(() -> CustomOAuth2ClientImpl.changePasswordUser$$anonfun$1(user), Line$.MODULE$.apply(251), FullName$.MODULE$.apply("ambience.module.CustomOAuth2ClientImpl.changePasswordUser"));
        Set set = Predef$.MODULE$.Set().empty();
        Set set2 = (Set)((SetOps)user.privileges().filter((Function1 & Serializable)_$7 -> {
            String string = _$7;
            String string2 = "mod-user-settings";
            return !(string != null ? !string.equals(string2) : string2 != null);
        })).$plus((Object)"force-change-password");
        String string = user.copy$default$1();
        String string2 = user.copy$default$2();
        String string3 = user.copy$default$3();
        boolean bl = user.copy$default$6();
        return user.copy(string, string2, string3, (Set<UserDB.RoleIdName>)set, (Set<String>)set2, bl);
    }

    @Override
    public GravityCookie buildCookie(String name, String value, Option<Object> optMaxAge) {
        this.log().info(() -> CustomOAuth2ClientImpl.buildCookie$$anonfun$3(name, value, optMaxAge), Line$.MODULE$.apply(258), FullName$.MODULE$.apply("ambience.module.CustomOAuth2ClientImpl.buildCookie"));
        ListBuffer buffer = new ListBuffer();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.CookieSameSite()))) {
            buffer.append((Object)("SameSite=" + this.CookieSameSite()));
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.CookieExtensions()))) {
            buffer.append((Object)this.CookieExtensions());
        }
        None$ extension = buffer.isEmpty() ? None$.MODULE$ : Some$.MODULE$.apply((Object)buffer.mkString("; "));
        return GravityCookie$.MODULE$.apply(name, value, optMaxAge, (Option)Some$.MODULE$.apply((Object)"/"), this.CookieSecure(), true, (Option)extension);
    }

    @Override
    public Option<Object> buildCookie$default$3() {
        return None$.MODULE$;
    }

    @Override
    public Function1<GravityRequest, Task<GravityResponse>> decodeCookie(String cookie, Function1<Option<ClientModel.UserInfo>, Function1<GravityRequest, Task<GravityResponse>>> fn) {
        return (Function1 & Serializable)request -> {
            Either<Exception, CustomOAuth2Client.SessionData> either = SessionDataDecoder$.MODULE$.apply(cookie);
            if (either instanceof Right) {
                CustomOAuth2Client.SessionData sd = (CustomOAuth2Client.SessionData)((Right)either).value();
                return this.sessionManager.getSession(SessionManager$SessionId$.MODULE$.apply(sd.uuid())).map((Function1 & Serializable)optUser -> optUser.map((Function1 & Serializable)user -> {
                    UserDB.User user2 = (UserDB.User)package$.MODULE$.EncoderOps(user);
                    String string = "id";
                    String string2 = "name";
                    String string3 = "email";
                    String string4 = "roles";
                    String string5 = "privileges";
                    String string6 = "enabled";
                    return ClientModel$UserInfo$.MODULE$.apply(package.EncoderOps$.MODULE$.asJson$extension((Object)user2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(CustomOAuth2ClientImpl::decodeCookie$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default())))));
                })).flatMap((Function1 & Serializable)optUserInfo -> ((Task)((Function1)fn.apply(optUserInfo)).apply(request)).map((Function1 & Serializable)response -> response));
            }
            if (either instanceof Left) {
                Exception ex = (Exception)((Left)either).value();
                this.log().error(() -> CustomOAuth2ClientImpl.decodeCookie$$anonfun$1$$anonfun$3(cookie, ex), Line$.MODULE$.apply(286), FullName$.MODULE$.apply("ambience.module.CustomOAuth2ClientImpl.decodeCookie"));
                return Gravity$.MODULE$.BadRequestResponseT();
            }
            throw new MatchError(either);
        };
    }

    public Task<ClientModel.UserInfo> decodeCookie(String cookie) {
        Either<Exception, CustomOAuth2Client.SessionData> either = SessionDataDecoder$.MODULE$.apply(cookie);
        if (either instanceof Right) {
            CustomOAuth2Client.SessionData sd = (CustomOAuth2Client.SessionData)((Right)either).value();
            return this.sessionManager.getSession(SessionManager$SessionId$.MODULE$.apply(sd.uuid())).map((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    UserDB.User user = (UserDB.User)((Some)option).value();
                    UserDB.User user2 = (UserDB.User)package$.MODULE$.EncoderOps((Object)user);
                    String string = "id";
                    String string2 = "name";
                    String string3 = "email";
                    String string4 = "roles";
                    String string5 = "privileges";
                    String string6 = "enabled";
                    return ClientModel$UserInfo$.MODULE$.apply(package.EncoderOps$.MODULE$.asJson$extension((Object)user2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(CustomOAuth2ClientImpl::decodeCookie$$anonfun$2$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default())))));
                }
                if (None$.MODULE$.equals(option)) {
                    throw new RuntimeException("No session " + sd.uuid());
                }
                throw new MatchError((Object)option);
            });
        }
        if (either instanceof Left) {
            Exception ex = (Exception)((Left)either).value();
            return Task$.MODULE$.raiseError((Throwable)ex);
        }
        throw new MatchError(either);
    }

    @Override
    public Task<BoxedUnit> logoutSession(String cookieValue) {
        Either<Exception, CustomOAuth2Client.SessionData> either = SessionDataDecoder$.MODULE$.apply(cookieValue);
        if (either instanceof Right) {
            CustomOAuth2Client.SessionData sd = (CustomOAuth2Client.SessionData)((Right)either).value();
            return this.doLogoutSession(sd);
        }
        if (either instanceof Left) {
            Exception ex = (Exception)((Left)either).value();
            this.log().warn(() -> CustomOAuth2ClientImpl.logoutSession$$anonfun$1(ex), Line$.MODULE$.apply(306), FullName$.MODULE$.apply("ambience.module.CustomOAuth2ClientImpl.logoutSession"));
            return Task$.MODULE$.unit();
        }
        throw new MatchError(either);
    }

    public Task<BoxedUnit> doLogoutSession(CustomOAuth2Client.SessionData sd) {
        String id = SessionManager$SessionId$.MODULE$.apply(sd.uuid());
        return this.sessionManager.getSession(id).flatMap((Function1 & Serializable)optUser -> ((Task)optUser.map((Function1 & Serializable)_$8 -> this.auditDeleteSession((UserDB.User)_$8, id)).getOrElse(CustomOAuth2ClientImpl::doLogoutSession$$anonfun$1$$anonfun$2)).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return ((Task)optUser.map((Function1 & Serializable)user -> this.auditLogout((UserDB.User)user)).getOrElse(CustomOAuth2ClientImpl::doLogoutSession$$anonfun$1$$anonfun$3$$anonfun$2)).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.sessionManager.logout(id).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            });
        }));
    }

    public Task<BoxedUnit> auditLogout(UserDB.User user) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.auditLogout$$anonfun$1(user);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Function1<GravityRequest, Task<GravityResponse>> getAuth(String scope, String reason) {
        return (Function1 & Serializable)request -> {
            this.log().info(() -> CustomOAuth2ClientImpl.getAuth$$anonfun$1$$anonfun$1(scope, reason), Line$.MODULE$.apply(328), FullName$.MODULE$.apply("ambience.module.CustomOAuth2ClientImpl.getAuth"));
            Gravity.Path originalUri = request.path();
            if (originalUri.toString().toUpperCase().endsWith(".HTML")) {
                String proxyFixed = this.combineQuery(this.combineUrl(this.projectConfig.WebURL(), originalUri.toString()), request.queryString());
                this.log().info(() -> CustomOAuth2ClientImpl.getAuth$$anonfun$1$$anonfun$2(proxyFixed), Line$.MODULE$.apply(332), FullName$.MODULE$.apply("ambience.module.CustomOAuth2ClientImpl.getAuth"));
                Task tResponse = this.clientHandler().getRedirectURIT(this.service(), "code", scope, ClientModel$OriginalUri$.MODULE$.apply(proxyFixed)).map((Function1 & Serializable)uri -> {
                    this.log().info(() -> CustomOAuth2ClientImpl.$anonfun$18$$anonfun$1(uri), Line$.MODULE$.apply(336), FullName$.MODULE$.apply("ambience.module.CustomOAuth2ClientImpl.tResponse"));
                    return GravityResponse$.MODULE$.apply(Gravity.Status$.MODULE$.TemporaryRedirect(), Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{Gravity.Header$.MODULE$.Location(uri)})), GravityResponse$.MODULE$.$lessinit$greater$default$3());
                }).onErrorRecover((PartialFunction)new Serializable(this){
                    private final /* synthetic */ CustomOAuth2ClientImpl $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable = x;
                        return true;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable = x;
                        this.$outer.log().error(() -> CustomOAuth2ClientImpl.ambience$module$CustomOAuth2ClientImpl$$anon$1$$_$applyOrElse$$anonfun$1(x), x, Line$.MODULE$.apply(340), FullName$.MODULE$.apply("ambience.module.CustomOAuth2ClientImpl.tResponse"));
                        GravityResponse gravityResponse = GravityResponse$.MODULE$.text("Internal error in getAuth");
                        return gravityResponse.copy(Gravity.Status$.MODULE$.apply(500), gravityResponse.copy$default$2(), gravityResponse.copy$default$3());
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{ambience$module$CustomOAuth2ClientImpl$$anon$1$$_$applyOrElse$$anonfun$1(java.lang.Throwable )}, serializedLambda);
                    }
                });
                return tResponse;
            }
            this.log().debug(() -> CustomOAuth2ClientImpl.getAuth$$anonfun$1$$anonfun$3(originalUri), Line$.MODULE$.apply(346), FullName$.MODULE$.apply("ambience.module.CustomOAuth2ClientImpl.getAuth"));
            return Task$.MODULE$.apply(CustomOAuth2ClientImpl::getAuth$$anonfun$1$$anonfun$4);
        };
    }

    private String encodeB64(String s) {
        return this.encoder().encodeToString(s.getBytes("UTF-8"));
    }

    private String combineUrl(String a, String b) {
        return StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(a), "/") + "/" + StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(b), "/");
    }

    private String combineQuery(String a, String q) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(q.trim()))) {
            return a + "?" + q;
        }
        return a;
    }

    private static Function1<Gravity.Path, Gravity.Path> CustomOAuth2ClientImpl$superArg$1(ProjectConfig projectConfig, UserDB userDB, APITokenDB apiTokenDB, SessionManager sessionManager, SSOClientState ssoClientState) {
        return (Function1 & Serializable)x -> (Gravity.Path)Predef$.MODULE$.identity(x);
    }

    private final Option extractElxToken$$anonfun$1(GravityRequest request$1) {
        return this.extractElxTokenFromAuthentication(request$1);
    }

    private static final Task logAccess$$anonfun$2$$anonfun$2() {
        return Task$.MODULE$.unit();
    }

    private static final Object handleTokenRoute$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(String token$6) {
        return "Setting cookie for APIToken " + token$6;
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$1() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeBoolean();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 $anonfun$2() {
        UserDB$RoleIdName$ userDB$RoleIdName$ = UserDB$RoleIdName$.MODULE$;
        return (Function1 & Serializable)p -> (UserDB.RoleIdName)userDB$RoleIdName$.fromProduct((Product)p);
    }

    private static final Product $anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private static final List buildUser$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        void var3_2;
        void var1;
        Decoder decodeA5 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA6 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA4 = Decoder$.MODULE$.decodeString();
        String string = "id";
        String string2 = "name";
        String string3 = "enabled";
        int size = 3;
        Decoder decoder2 = decodeA3 = Decoder$.MODULE$.decodeSet(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("RoleIdName", CustomOAuth2ClientImpl::$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), CustomOAuth2ClientImpl::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(CustomOAuth2ClientImpl::$anonfun$3)))));
        Decoder decoder3 = decodeA2 = Decoder$.MODULE$.decodeSet(Decoder$.MODULE$.decodeString());
        Decoder decoder4 = decodeA = Decoder$.MODULE$.decodeBoolean();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 buildUser$$anonfun$2() {
        UserDB$User$ userDB$User$ = UserDB$User$.MODULE$;
        return (Function1 & Serializable)p -> (UserDB.User)userDB$User$.fromProduct((Product)p);
    }

    private static final Product buildUser$$anonfun$3() {
        return Tuple6$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private static final Object buildUser$$anonfun$4(DecodingFailure err$1, ClientModel.UserInfo userInfo$1) {
        return err$1 + " Invalid user json: " + userInfo$1.json().noSpaces();
    }

    private static final String $anonfun$4() {
        return "";
    }

    private static final String $anonfun$5() {
        return "";
    }

    private static final boolean $anonfun$6() {
        return false;
    }

    private static final /* synthetic */ boolean stripDomain$$anonfun$1(char _$2) {
        return _$2 != '@';
    }

    private final /* synthetic */ Task buildSession$$anonfun$1(UserDB.User user$5, String sessionId) {
        return this.auditNewSession(user$5, sessionId).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.buildCookie(sessionId, user$5.name()).map((Function1 & Serializable)cookie -> cookie);
        });
    }

    private final void auditNewSession$$anonfun$1(UserDB.User user$7, String sessionId$2) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"roles");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromValues((Iterable)((List)user$7.roles().toList().map((Function1 & Serializable)_$5 -> _$5.name()).sorted(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForString()))).map((Function1 & Serializable)value -> Json$.MODULE$.fromString(value))));
        Json info = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        AuditAPI.Action action = AuditAPI.Success$.MODULE$.apply(sessionId$2, "Created", (Option)Some$.MODULE$.apply((Object)info.noSpaces()), AuditAPI.Success$.MODULE$.apply$default$4());
        this.auditAppender().append(AuditAPI.AuditMessage$.MODULE$.apply(user$7.name(), this.auditSessionComponent(), action));
    }

    private final void auditDeleteSession$$anonfun$1(UserDB.User user$8, String sessionId$3) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"roles");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromValues((Iterable)((List)user$8.roles().toList().map((Function1 & Serializable)_$6 -> _$6.name()).sorted(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForString()))).map((Function1 & Serializable)value -> Json$.MODULE$.fromString(value))));
        Json info = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        AuditAPI.Action action = AuditAPI.Success$.MODULE$.apply(sessionId$3, "Deleted", (Option)Some$.MODULE$.apply((Object)info.noSpaces()), AuditAPI.Success$.MODULE$.apply$default$4());
        this.auditAppender().append(AuditAPI.AuditMessage$.MODULE$.apply(user$8.name(), this.auditSessionComponent(), action));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$12() {
        void var3_2;
        void var1;
        Encoder encodeA = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Object buildCookie$$anonfun$2(String cookieValue$1) {
        return "Cookie: " + cookieValue$1;
    }

    private static final Object addUser$$anonfun$1(String name$2) {
        return "Adding authenticated user: " + name$2;
    }

    private static final Object changePasswordUser$$anonfun$1(UserDB.User user$9) {
        return "Restricting user " + user$9.name() + " privileges until they change password";
    }

    private static final Object buildCookie$$anonfun$3(String name$3, String value$1, Option optMaxAge$1) {
        return "buildCookie " + name$3 + " " + value$1 + " " + optMaxAge$1;
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$14() {
        Encoder encodeA;
        void var3_2;
        void var1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA = Encoder$.MODULE$.encodeBoolean();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List decodeCookie$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        Encoder encodeA;
        Encoder.AsArray encodeA2;
        Encoder.AsArray encodeA3;
        Encoder encodeA4;
        void var3_2;
        void var1;
        Encoder encodeA5 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA6 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA4 = Encoder$.MODULE$.encodeString();
        String string = "id";
        String string2 = "name";
        String string3 = "enabled";
        Encoder.AsArray asArray = encodeA3 = Encoder$.MODULE$.encodeSet(Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(CustomOAuth2ClientImpl::$anonfun$14, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
        Encoder.AsArray asArray2 = encodeA2 = Encoder$.MODULE$.encodeSet(Encoder$.MODULE$.encodeString());
        Encoder encoder2 = encodeA = Encoder$.MODULE$.encodeBoolean();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder2).$colon$colon((Object)asArray2).$colon$colon((Object)asArray).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Object decodeCookie$$anonfun$1$$anonfun$3(String cookie$3, Exception ex$1) {
        return "Cannot decodeCookie " + cookie$3 + ": " + ex$1;
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$15() {
        Encoder encodeA;
        void var3_2;
        void var1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA = Encoder$.MODULE$.encodeBoolean();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List decodeCookie$$anonfun$2$$anonfun$1() {
        Encoder encodeA;
        Encoder.AsArray encodeA2;
        Encoder.AsArray encodeA3;
        Encoder encodeA4;
        void var3_2;
        void var1;
        Encoder encodeA5 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA6 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA4 = Encoder$.MODULE$.encodeString();
        String string = "id";
        String string2 = "name";
        String string3 = "enabled";
        Encoder.AsArray asArray = encodeA3 = Encoder$.MODULE$.encodeSet(Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(CustomOAuth2ClientImpl::$anonfun$15, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
        Encoder.AsArray asArray2 = encodeA2 = Encoder$.MODULE$.encodeSet(Encoder$.MODULE$.encodeString());
        Encoder encoder2 = encodeA = Encoder$.MODULE$.encodeBoolean();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder2).$colon$colon((Object)asArray2).$colon$colon((Object)asArray).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Object logoutSession$$anonfun$1(Exception ex$2) {
        return "Can't update session expireAt on logout: " + ex$2;
    }

    private static final Task doLogoutSession$$anonfun$1$$anonfun$2() {
        return Task$.MODULE$.unit();
    }

    private static final Task doLogoutSession$$anonfun$1$$anonfun$3$$anonfun$2() {
        return Task$.MODULE$.unit();
    }

    private final void auditLogout$$anonfun$1(UserDB.User user$10) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"roles");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromValues((Iterable)((List)user$10.roles().toList().map((Function1 & Serializable)_$9 -> _$9.name()).sorted(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForString()))).map((Function1 & Serializable)value -> Json$.MODULE$.fromString(value))));
        Json info = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        AuditAPI.Action action = AuditAPI.Success$.MODULE$.apply("sso-client", "Logout", (Option)Some$.MODULE$.apply((Object)info.noSpaces()), AuditAPI.Success$.MODULE$.apply$default$4());
        this.auditAppender().append(AuditAPI.AuditMessage$.MODULE$.apply(user$10.name(), this.auditComponent(), action));
    }

    private static final Object getAuth$$anonfun$1$$anonfun$1(String scope$2, String reason$2) {
        return "getAuth(" + new ClientModel.Scope(scope$2) + "," + reason$2 + ")";
    }

    private static final Object getAuth$$anonfun$1$$anonfun$2(String proxyFixed$1) {
        return "Storing original URI: " + proxyFixed$1;
    }

    private static final Object $anonfun$18$$anonfun$1(String uri$1) {
        return "getAuth redirecting to " + uri$1;
    }

    public static final Object ambience$module$CustomOAuth2ClientImpl$$anon$1$$_$applyOrElse$$anonfun$1(Throwable x$1) {
        return "Error in getAuth: " + x$1;
    }

    private static final Object getAuth$$anonfun$1$$anonfun$3(Gravity.Path originalUri$1) {
        return "Refusing call to " + originalUri$1;
    }

    private static final GravityResponse getAuth$$anonfun$1$$anonfun$4() {
        return GravityResponse$.MODULE$.apply(Gravity.Status$.MODULE$.Unauthorized(), GravityResponse$.MODULE$.$lessinit$greater$default$2(), GravityResponse$.MODULE$.$lessinit$greater$default$3());
    }
}

