/*
 * Decompiled with CFR 0.152.
 */
package ambience.module;

import com.elixirtech.arch.package$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.runtime.ModuleSerializationProxy;

public final class ModuleControl$
implements Serializable {
    private static final Base64.Encoder base64Encoder;
    private static final Base64.Decoder base64Decoder;
    public static final ModuleControl$ MODULE$;

    private ModuleControl$() {
    }

    static {
        MODULE$ = new ModuleControl$();
        base64Encoder = Base64.getEncoder();
        base64Decoder = Base64.getDecoder();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ModuleControl$.class);
    }

    public Base64.Encoder base64Encoder() {
        return base64Encoder;
    }

    public Base64.Decoder base64Decoder() {
        return base64Decoder;
    }

    public void sign(File in, File out) {
        Config licConfig = ConfigFactory.parseFile((File)in);
        Config remainder = licConfig.withoutPath("licence-key");
        String text = ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(remainder.entrySet()).asScala().toList().map((Function1 & Serializable)kv -> kv.getKey() + ":" + this.getValues((ConfigValue)kv.getValue())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n");
        String licKey = this.sign(text);
        out.delete();
        Files.copy(in.toPath(), out.toPath(), new CopyOption[0]);
        String extraLine = "licence-key: \"" + licKey + "\"\n";
        Files.writeString(out.toPath(), (CharSequence)extraLine, StandardOpenOption.APPEND);
        Predef$.MODULE$.println((Object)extraLine);
        Predef$.MODULE$.println((Object)"Completed");
    }

    private String getValues(ConfigValue value) {
        return value.render(ConfigRenderOptions.concise());
    }

    public String sign(String txt) {
        File homeDir = new File(System.getProperty("user.home"));
        File buildDir = new File(homeDir, "build");
        File privateKeyFile = new File(buildDir, "ambience-2020.private-key.txt");
        if (!privateKeyFile.exists()) {
            throw new RuntimeException("Missing private key: " + privateKeyFile.getAbsolutePath());
        }
        String privateKeyString = package$.MODULE$.enrichFile(privateKeyFile).text();
        return this.sign(privateKeyString, txt);
    }

    public String sign(String privateKeyString, String txt) {
        byte[] privateBytes = this.base64Decoder().decode(privateKeyString);
        KeyFactory keyFactory = KeyFactory.getInstance("DSA");
        PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateBytes));
        Signature rsa = Signature.getInstance("SHA256withDSA");
        rsa.initSign(privateKey);
        rsa.update(txt.getBytes("UTF-8"));
        return this.base64Encoder().encodeToString(rsa.sign());
    }
}

