/*
 * Decompiled with CFR 0.152.
 */
package ambience.module;

import ambience.module.CodexHelper$;
import ambience.module.UserDB;
import ambience.module.UserDB$Privilege$;
import ambience.module.UserDB$Role$;
import ambience.module.UserDB$RoleIdName$;
import ambience.module.UserDB$User$;
import ambience.module.UserDB$UserIdName$;
import cats.Functor;
import cats.Monad;
import cats.data.OptionT;
import cats.data.OptionT$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.codex.CodexCollection;
import com.elixirtech.codex.CodexDB;
import com.elixirtech.codex.CodexFilter;
import com.elixirtech.codex.CodexFindOptions;
import com.elixirtech.codex.CodexFindOptions$;
import com.elixirtech.codex.CodexUpdate;
import com.elixirtech.mongodb.BsonETL$;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.types.ObjectId;
import org.mongodb.scala.bson.BsonArray$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonObjectId$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class UserCodexDB
implements UserDB,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(UserCodexDB.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final Task usersT;
    private final Task rolesT;
    private final Task privilegesT;

    public UserCodexDB(CodexDB codexDB) {
        this.usersT = codexDB.getCodexCollection("Users").memoize();
        this.rolesT = codexDB.getCodexCollection("Roles").memoize();
        this.privilegesT = codexDB.getCodexCollection("Privileges").memoize();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<CodexCollection> usersT() {
        return this.usersT;
    }

    public Task<CodexCollection> rolesT() {
        return this.rolesT;
    }

    public Task<CodexCollection> privilegesT() {
        return this.privilegesT;
    }

    @Override
    public Task<Object> getUserCount() {
        return this.usersT().flatMap((Function1 & Serializable)_$1 -> _$1.countDocumentsT((CodexFilter)CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexHelper$.MODULE$.IsEnabled(), CodexHelper$.MODULE$.NotDeleted()}))));
    }

    @Override
    public Task<Object> hasUserId(String id) {
        Try try_ = Try$.MODULE$.apply(() -> UserCodexDB.hasUserId$$anonfun$1(id));
        if (try_ instanceof Success) {
            BsonObjectId oid = (BsonObjectId)((Success)try_).value();
            return this.usersT().flatMap((Function1 & Serializable)_$2 -> _$2.findO((CodexFilter)CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexHelper$.MODULE$.NotDeleted(), CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)oid)}))).firstOptionL().map((Function1 & Serializable)_$3 -> _$3.isDefined()));
        }
        if (try_ instanceof Failure) {
            return Task$.MODULE$.now((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public Task<Option<UserDB.User>> getUserByName(String name) {
        return this.privilegesT().flatMap((Function1 & Serializable)privileges -> this.rolesT().flatMap((Function1 & Serializable)roles -> this.usersT().flatMap((Function1 & Serializable)users -> privileges.findO((CodexFilter)CodexHelper$.MODULE$.NotDeleted()).toListL().flatMap((Function1 & Serializable)ps -> roles.findO((CodexFilter)CodexHelper$.MODULE$.NotDeleted()).toListL().flatMap((Function1 & Serializable)rs -> users.findO((CodexFilter)CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.Eq$.MODULE$.apply("name", (BsonValue)BsonString$.MODULE$.apply(name)), CodexHelper$.MODULE$.NotDeleted()}))).toListL().map((Function1 & Serializable)us -> this.assembleUser((Seq<Document>)us, (Seq<Document>)rs, (Seq<Document>)ps)))))));
    }

    @Override
    public Task<Option<UserDB.User>> getUserById(String id) {
        Try try_ = Try$.MODULE$.apply(() -> UserCodexDB.getUserById$$anonfun$1(id));
        if (try_ instanceof Success) {
            BsonObjectId uId = (BsonObjectId)((Success)try_).value();
            return this.privilegesT().flatMap((Function1 & Serializable)privileges -> this.rolesT().flatMap((Function1 & Serializable)roles -> this.usersT().flatMap((Function1 & Serializable)users -> privileges.findO((CodexFilter)CodexHelper$.MODULE$.NotDeleted()).toListL().flatMap((Function1 & Serializable)ps -> roles.findO((CodexFilter)CodexHelper$.MODULE$.NotDeleted()).toListL().flatMap((Function1 & Serializable)rs -> users.findO((CodexFilter)CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)uId), CodexHelper$.MODULE$.NotDeleted()}))).toListL().map((Function1 & Serializable)us -> this.assembleUser((Seq<Document>)us, (Seq<Document>)rs, (Seq<Document>)ps)))))));
        }
        if (try_ instanceof Failure) {
            return Task$.MODULE$.now((Object)None$.MODULE$);
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public Task<String> addUser(String name, Set<UserDB.Privilege> privileges, String password) {
        ObjectId objectId = new ObjectId();
        BsonArray bsonPrivileges = BsonArray$.MODULE$.fromIterable((Iterable)((IterableOnceOps)privileges.flatMap((Function1 & Serializable)g -> Try$.MODULE$.apply(() -> UserCodexDB.$anonfun$1$$anonfun$1(g)).toOption())).toSeq());
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[5];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)objectId), (BsonTransformer)BsonTransformer$.MODULE$.TransformObjectId());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)name), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"enabled");
        objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBoolean());
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"roles");
        objectArray[3] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)new BsonArray()), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"privileges");
        objectArray[4] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)bsonPrivileges), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        Document userDoc = Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return this.usersT().flatMap((Function1 & Serializable)_$4 -> _$4.insertOneT(userDoc).map((Function1 & Serializable)_$5 -> objectId.toHexString()));
    }

    @Override
    public Task<Either<String, UserDB.User>> addAuthenticatedUser(String name, List<String> roles) {
        Task ret = Task$.MODULE$.apply(UserCodexDB::$anonfun$2).flatMap((Function1 & Serializable)objectId -> this.getRoleIdNames().toListL().map((Function1 & Serializable)list -> list.map((Function1 & Serializable)r -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)r.name());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)r.id());
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).flatMap((Function1 & Serializable)allRoles -> Task$.MODULE$.apply(() -> UserCodexDB.$anonfun$3$$anonfun$2$$anonfun$1(roles, allRoles)).flatMap((Function1 & Serializable)roleIds -> Task$.MODULE$.apply(() -> UserCodexDB.$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$1(objectId, name, roleIds)).flatMap((Function1 & Serializable)userDoc -> this.usersT().flatMap((Function1 & Serializable)_$6 -> _$6.insertOneT(userDoc)).flatMap((Function1 & Serializable)x$1 -> {
            CodexDB.InsertOneResult insertOneResult = x$1;
            return this.getUserByName(name).map((Function1 & Serializable)user -> user);
        })))));
        return ret.map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                UserDB.User user = (UserDB.User)((Some)option).value();
                return package$.MODULE$.Right().apply((Object)user);
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)"Cannot add authenticated user");
            }
            throw new MatchError((Object)option);
        });
    }

    @Override
    public Task<BoxedUnit> setUserEmail(String name, String email) {
        CodexFilter.And filter = CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.Eq$.MODULE$.apply("name", (BsonValue)BsonString$.MODULE$.apply(name)), CodexFilter.Not$.MODULE$.apply((CodexFilter)CodexFilter.Eq$.MODULE$.apply("email", (BsonValue)BsonString$.MODULE$.apply(email))), CodexHelper$.MODULE$.IsEnabled(), CodexHelper$.MODULE$.NotDeleted()}));
        CodexUpdate.Set update = CodexUpdate.Set$.MODULE$.apply("email", (BsonValue)BsonString$.MODULE$.apply(email));
        return this.usersT().flatMap((Function1 & Serializable)_$7 -> _$7.updateOneT((CodexFilter)filter, (CodexUpdate)update).map((Function1)(JProcedure1 & Serializable)_$8 -> {}));
    }

    @Override
    public Task<BoxedUnit> setUserPrivileges(String userId, Set<UserDB.Privilege> privileges) {
        Set ps = (Set)privileges.flatMap((Function1 & Serializable)p -> Try$.MODULE$.apply(() -> UserCodexDB.$anonfun$4$$anonfun$1(p)).toOption());
        CodexFilter.Eq filter = CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonObjectId$.MODULE$.apply(userId));
        CodexUpdate.Set update = CodexUpdate.Set$.MODULE$.apply("privileges", (BsonValue)BsonArray$.MODULE$.fromIterable((Iterable)ps));
        return this.usersT().flatMap((Function1 & Serializable)_$9 -> _$9.updateOneT((CodexFilter)filter, (CodexUpdate)update).map((Function1)(JProcedure1 & Serializable)_$10 -> {}));
    }

    public Option<UserDB.User> assembleUser(Seq<Document> us, Seq<Document> rs, Seq<Document> ps) {
        Map privilegeMap = ((IterableOnceOps)((IterableOps)ps.flatMap((Function1 & Serializable)doc -> this.buildPrivilege((Document)doc))).map((Function1 & Serializable)g -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)g.id());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, g);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Map roleMap = ((IterableOnceOps)((IterableOps)rs.flatMap((Function1 & Serializable)doc -> this.buildRole((Document)doc))).map((Function1 & Serializable)r -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)r.id());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, r);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return us.headOption().flatMap((Function1 & Serializable)doc -> doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)bson -> this.oidString((BsonValue)bson)).flatMap((Function1 & Serializable)id -> doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$11 -> _$11.getValue()).flatMap((Function1 & Serializable)name -> Some$.MODULE$.apply(doc.get("email", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$12 -> _$12.getValue()).getOrElse(UserCodexDB::assembleUser$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2)).flatMap((Function1 & Serializable)email -> Some$.MODULE$.apply(doc.get("privileges", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)_$13 -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(_$13.asArray().getValues()).asScala().map((Function1 & Serializable)bson -> this.oidString((BsonValue)bson))).map((Function1 & Serializable)_$14 -> _$14.toSet()).getOrElse(UserCodexDB::assembleUser$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$3)).flatMap((Function1 & Serializable)privilegeIds -> doc.get("enabled", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBoolean.class)).map((Function1 & Serializable)_$15 -> _$15.getValue()).flatMap((Function1 & Serializable)enabled -> this.assembleUser$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$4$$anonfun$2((Set)privilegeIds, privilegeMap, (Document)doc, roleMap, (String)id, (String)name, (String)email, BoxesRunTime.unboxToBoolean((Object)enabled))))))));
    }

    @Override
    public Observable<UserDB.Privilege> getPrivileges() {
        return Observable$.MODULE$.fromTask(this.privilegesT()).flatMap((Function1 & Serializable)privileges -> privileges.findO((CodexFilter)CodexHelper$.MODULE$.NotDeleted()).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(this.buildPrivilege((Document)doc))).map((Function1 & Serializable)reply -> reply)));
    }

    @Override
    public Task<UserDB.Privilege> addPrivilege(String name, String desc) {
        return Task$.MODULE$.apply(UserCodexDB::addPrivilege$$anonfun$1).flatMap((Function1 & Serializable)objectId -> this.privilegesT().flatMap((Function1 & Serializable)privileges -> {
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, objectId), (BsonTransformer)BsonTransformer$.MODULE$.TransformObjectId());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
            objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)name), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"description");
            objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)desc), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
            return privileges.insertOneT(Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).flatMap((Function1 & Serializable)x$1 -> {
                CodexDB.InsertOneResult insertOneResult = x$1;
                return privileges.countDocumentsT().flatMap((Function1 & Serializable)count -> this.addPrivilege$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(name, (ObjectId)objectId, desc, BoxesRunTime.unboxToLong((Object)count)));
            });
        }));
    }

    public Option<UserDB.Privilege> buildPrivilege(Document doc) {
        return doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonObjectId.class)).map((Function1 & Serializable)_$23 -> _$23.getValue().toHexString()).flatMap((Function1 & Serializable)id -> doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$24 -> _$24.getValue()).flatMap((Function1 & Serializable)name -> doc.get("description", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$25 -> _$25.getValue()).map((Function1 & Serializable)desc -> UserDB$Privilege$.MODULE$.apply((String)id, (String)name, (String)desc))));
    }

    @Override
    public Observable<UserDB.UserIdName> getUserIdNames() {
        return Observable$.MODULE$.fromTask(this.usersT()).flatMap((Function1 & Serializable)users -> users.findO((CodexFilter)CodexHelper$.MODULE$.NotDeleted(), CodexFindOptions$.MODULE$.projections((CodexFindOptions.Projection)CodexFindOptions.Retain$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_id", "name", "enabled"})))).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(this.buildUserIdName((Document)doc))).map((Function1 & Serializable)reply -> reply)));
    }

    @Override
    public Observable<UserDB.Role> getRoles() {
        return Observable$.MODULE$.fromTask(this.rolesT()).flatMap((Function1 & Serializable)roles -> roles.findO((CodexFilter)CodexHelper$.MODULE$.NotDeleted()).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(this.buildRole((Document)doc))).map((Function1 & Serializable)reply -> reply)));
    }

    @Override
    public Observable<UserDB.RoleIdName> getRoleIdNames() {
        return Observable$.MODULE$.fromTask(this.rolesT()).flatMap((Function1 & Serializable)roles -> roles.findO((CodexFilter)CodexHelper$.MODULE$.NotDeleted(), CodexFindOptions$.MODULE$.projections((CodexFindOptions.Projection)CodexFindOptions.Retain$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_id", "name", "enabled"})))).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(this.buildRoleIdName((Document)doc))).map((Function1 & Serializable)reply -> reply)));
    }

    @Override
    public Task<Option<UserDB.Privilege>> getPrivilege(String name) {
        CodexFilter.And filter = CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.Eq$.MODULE$.apply("name", (BsonValue)BsonString$.MODULE$.apply(name)), CodexHelper$.MODULE$.NotDeleted()}));
        return this.privilegesT().flatMap((Function1 & Serializable)_$26 -> _$26.findO((CodexFilter)filter).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(this.buildPrivilege((Document)doc)))).firstOptionL());
    }

    @Override
    public Task<Option<UserDB.Role>> getRoleByName(String name) {
        CodexFilter.And filter = CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.Eq$.MODULE$.apply("name", (BsonValue)BsonString$.MODULE$.apply(name)), CodexHelper$.MODULE$.NotDeleted()}));
        return this.rolesT().flatMap((Function1 & Serializable)_$27 -> _$27.findO((CodexFilter)filter).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(this.buildRole((Document)doc)))).firstOptionL());
    }

    @Override
    public Task<Option<UserDB.Role>> getRoleById(String id) {
        Try try_ = Try$.MODULE$.apply(() -> UserCodexDB.getRoleById$$anonfun$1(id));
        if (try_ instanceof Success) {
            BsonObjectId oid = (BsonObjectId)((Success)try_).value();
            CodexFilter.And filter = CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)oid), CodexHelper$.MODULE$.NotDeleted()}));
            return this.rolesT().flatMap((Function1 & Serializable)_$28 -> _$28.findO((CodexFilter)filter).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(this.buildRole((Document)doc)))).firstOptionL());
        }
        if (try_ instanceof Failure) {
            return Task$.MODULE$.now((Object)None$.MODULE$);
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public Observable<UserDB.UserIdName> getUsersWithPrivilege(UserDB.Privilege p) {
        Try try_ = Try$.MODULE$.apply(() -> UserCodexDB.getUsersWithPrivilege$$anonfun$1(p));
        if (try_ instanceof Success) {
            BsonObjectId pId = (BsonObjectId)((Success)try_).value();
            Task all = this.usersWithRolePrivilege(pId).$plus$plus(() -> this.$anonfun$9(pId)).toListL().map((Function1 & Serializable)_$29 -> (List)_$29.distinct());
            return Observable$.MODULE$.fromTask(all).flatMap((Function1 & Serializable)iterable -> Observable$.MODULE$.fromIterable((Iterable)iterable));
        }
        if (try_ instanceof Failure) {
            return Observable$.MODULE$.empty();
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public Observable<UserDB.UserIdName> getUsersWithRole(UserDB.Role r) {
        Try try_ = Try$.MODULE$.apply(() -> UserCodexDB.getUsersWithRole$$anonfun$1(r));
        if (try_ instanceof Success) {
            BsonObjectId rId = (BsonObjectId)((Success)try_).value();
            return this.usersWithRole(rId);
        }
        if (try_ instanceof Failure) {
            return Observable$.MODULE$.empty();
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public Task<Option<String>> getUserSetting(String id, String key) {
        Try try_ = Try$.MODULE$.apply(() -> UserCodexDB.getUserSetting$$anonfun$1(id));
        if (try_ instanceof Success) {
            BsonObjectId uId = (BsonObjectId)((Success)try_).value();
            OptionT optT = OptionT$.MODULE$.apply((Object)this.usersT().map((Function1 & Serializable)_$30 -> Some$.MODULE$.apply(_$30))).flatMap((Function1 & Serializable)users -> OptionT$.MODULE$.apply((Object)users.findO((CodexFilter)CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)uId)).firstOptionL()).flatMap((Function1 & Serializable)doc -> OptionT$.MODULE$.apply((Object)Task$.MODULE$.apply(() -> UserCodexDB.$anonfun$12$$anonfun$1$$anonfun$1(doc, key))).map((Function1 & Serializable)value -> value, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
            return (Task)optT.value();
        }
        if (try_ instanceof Failure) {
            return Task$.MODULE$.now((Object)None$.MODULE$);
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public Task<BoxedUnit> putUserSetting(String id, String key, String value) {
        Try try_ = Try$.MODULE$.apply(() -> UserCodexDB.putUserSetting$$anonfun$1(id));
        if (try_ instanceof Success) {
            BsonObjectId uId = (BsonObjectId)((Success)try_).value();
            CodexUpdate.Set update = CodexUpdate.Set$.MODULE$.apply("settings." + key, (BsonValue)BsonString$.MODULE$.apply(value));
            return this.usersT().flatMap((Function1 & Serializable)_$31 -> _$31.updateOneT((CodexFilter)CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)uId), (CodexUpdate)update).map((Function1)(JProcedure1 & Serializable)_$32 -> {}));
        }
        if (try_ instanceof Failure) {
            return Task$.MODULE$.unit();
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public Task<BoxedUnit> removeUserSetting(String id, String key) {
        Try try_ = Try$.MODULE$.apply(() -> UserCodexDB.removeUserSetting$$anonfun$1(id));
        if (try_ instanceof Success) {
            BsonObjectId uId = (BsonObjectId)((Success)try_).value();
            CodexUpdate.Unset update = CodexUpdate.Unset$.MODULE$.apply("settings." + key);
            return this.usersT().flatMap((Function1 & Serializable)_$33 -> _$33.updateOneT((CodexFilter)CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)uId), (CodexUpdate)update).map((Function1)(JProcedure1 & Serializable)_$34 -> {}));
        }
        if (try_ instanceof Failure) {
            return Task$.MODULE$.unit();
        }
        throw new MatchError((Object)try_);
    }

    private String oidString(BsonValue bson) {
        return bson.asObjectId().getValue().toHexString();
    }

    public Option<UserDB.UserIdName> buildUserIdName(Document doc) {
        return doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonObjectId.class)).map((Function1 & Serializable)_$35 -> _$35.getValue().toHexString()).flatMap((Function1 & Serializable)id -> doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$36 -> _$36.getValue()).flatMap((Function1 & Serializable)name -> doc.get("enabled", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBoolean.class)).map((Function1 & Serializable)_$37 -> _$37.getValue()).map((Function1 & Serializable)enabled -> UserDB$UserIdName$.MODULE$.apply(id, name, BoxesRunTime.unboxToBoolean((Object)enabled)))));
    }

    public Option<UserDB.Role> buildRole(Document doc) {
        return doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)_$38 -> _$38.asObjectId().getValue().toHexString()).flatMap((Function1 & Serializable)id -> doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)_$39 -> _$39.asString().getValue()).flatMap((Function1 & Serializable)name -> doc.get("description", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)_$40 -> _$40.asString().getValue()).flatMap((Function1 & Serializable)desc -> doc.get("privileges", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonArray.class)).map((Function1 & Serializable)_$41 -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(_$41.getValues()).asScala().map((Function1 & Serializable)bson -> this.oidString((BsonValue)bson))).flatMap((Function1 & Serializable)privileges -> Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)doc.get("enabled", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBoolean.class)).forall((Function1 & Serializable)_$42 -> _$42.getValue()))).map((Function1 & Serializable)enabled -> UserDB$Role$.MODULE$.apply(id, name, desc, (Set<String>)privileges.toSet(), BoxesRunTime.unboxToBoolean((Object)enabled)))))));
    }

    public Option<UserDB.RoleIdName> buildRoleIdName(Document doc) {
        return doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonObjectId.class)).map((Function1 & Serializable)_$43 -> _$43.getValue().toHexString()).flatMap((Function1 & Serializable)id -> doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$44 -> _$44.getValue()).flatMap((Function1 & Serializable)name -> Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)doc.get("enabled", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBoolean.class)).forall((Function1 & Serializable)_$45 -> _$45.getValue()))).map((Function1 & Serializable)enabled -> UserDB$RoleIdName$.MODULE$.apply(id, name, BoxesRunTime.unboxToBoolean((Object)enabled)))));
    }

    public Observable<BsonObjectId> privilegeId(String p) {
        return Observable$.MODULE$.fromTask(this.privilegesT()).flatMap((Function1 & Serializable)privileges -> privileges.findO((CodexFilter)CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.Eq$.MODULE$.apply("name", (BsonValue)BsonString$.MODULE$.apply(p)), CodexHelper$.MODULE$.NotDeleted()}))).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonObjectId.class)))).map((Function1 & Serializable)reply -> reply)));
    }

    public Observable<UserDB.UserIdName> usersWithRolePrivilege(BsonObjectId pId) {
        return this.rolesWithPrivilege(pId).flatMap((Function1 & Serializable)role -> this.usersWithRole((BsonObjectId)role).map((Function1 & Serializable)result -> result));
    }

    public Observable<BsonObjectId> rolesWithPrivilege(BsonObjectId p) {
        return Observable$.MODULE$.fromTask(this.rolesT()).flatMap((Function1 & Serializable)roles -> roles.findO((CodexFilter)CodexFilter.Eq$.MODULE$.apply("privileges", (BsonValue)p)).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonObjectId.class)))).map((Function1 & Serializable)reply -> reply)));
    }

    public Observable<UserDB.UserIdName> usersWithDirectPrivilege(BsonObjectId pid) {
        return Observable$.MODULE$.fromTask(this.usersT()).flatMap((Function1 & Serializable)users -> users.findO((CodexFilter)CodexFilter.Eq$.MODULE$.apply("privileges", (BsonValue)pid)).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(this.buildUserIdName((Document)doc))).map((Function1 & Serializable)reply -> reply)));
    }

    public Observable<UserDB.UserIdName> usersWithRole(BsonObjectId rid) {
        return Observable$.MODULE$.fromTask(this.usersT()).flatMap((Function1 & Serializable)users -> users.findO((CodexFilter)CodexFilter.Eq$.MODULE$.apply("roles", (BsonValue)rid)).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(this.buildUserIdName((Document)doc))).map((Function1 & Serializable)reply -> reply)));
    }

    @Override
    public boolean allowExtendedRoles() {
        return true;
    }

    private static final BsonObjectId hasUserId$$anonfun$1(String id$1) {
        return BsonObjectId$.MODULE$.apply(id$1);
    }

    private static final BsonObjectId getUserById$$anonfun$1(String id$2) {
        return BsonObjectId$.MODULE$.apply(id$2);
    }

    private static final BsonObjectId $anonfun$1$$anonfun$1(UserDB.Privilege g$1) {
        return BsonObjectId$.MODULE$.apply(g$1.id());
    }

    private static final ObjectId $anonfun$2() {
        return new ObjectId();
    }

    private static final BsonObjectId $anonfun$3$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(String s$1) {
        return BsonObjectId$.MODULE$.apply(s$1);
    }

    private static final List $anonfun$3$$anonfun$2$$anonfun$1(List roles$7, Map allRoles$1) {
        return roles$7.flatMap((Function1 & Serializable)key -> allRoles$1.get(key)).flatMap((Function1 & Serializable)s -> Try$.MODULE$.apply(() -> UserCodexDB.$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(s)).toOption());
    }

    private static final Document $anonfun$3$$anonfun$2$$anonfun$2$$anonfun$1(ObjectId objectId$5, String name$9, List roleIds$1) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[5];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)objectId$5), (BsonTransformer)BsonTransformer$.MODULE$.TransformObjectId());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)name$9), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"enabled");
        objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBoolean());
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"roles");
        objectArray[3] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)BsonArray$.MODULE$.fromIterable((Iterable)roleIds$1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"privileges");
        objectArray[4] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)new BsonArray()), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private static final BsonObjectId $anonfun$4$$anonfun$1(UserDB.Privilege p$1) {
        return BsonObjectId$.MODULE$.apply(p$1.id());
    }

    private static final String assembleUser$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2() {
        return "";
    }

    private static final Set assembleUser$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$3() {
        return Predef$.MODULE$.Set().empty();
    }

    private static final Set assembleUser$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$4$$anonfun$2$$anonfun$3$$anonfun$3() {
        return Predef$.MODULE$.Set().empty();
    }

    private final /* synthetic */ Option assembleUser$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$4$$anonfun$2(Set privilegeIds$1, Map privilegeMap$5, Document doc$5, Map roleMap$5, String id$6, String name$14, String email$2, boolean enabled) {
        return Some$.MODULE$.apply(((IterableOps)privilegeIds$1.flatMap((Function1 & Serializable)key -> privilegeMap$5.get(key))).map((Function1 & Serializable)_$16 -> _$16.name())).flatMap((Function1 & Serializable)privileges -> Some$.MODULE$.apply(doc$5.get("roles", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)_$17 -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(_$17.asArray().getValues()).asScala().map((Function1 & Serializable)bson -> this.oidString((BsonValue)bson))).map((Function1 & Serializable)_$18 -> _$18.toSet()).getOrElse(UserCodexDB::assembleUser$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$4$$anonfun$2$$anonfun$3$$anonfun$3)).flatMap((Function1 & Serializable)roleIds -> Some$.MODULE$.apply(roleIds.flatMap((Function1 & Serializable)key -> roleMap$5.get(key))).flatMap((Function1 & Serializable)fullRoles -> Some$.MODULE$.apply(fullRoles.map((Function1 & Serializable)_$19 -> _$19.toIdName())).flatMap((Function1 & Serializable)roles -> Some$.MODULE$.apply(((IterableOps)((IterableOps)((IterableOps)fullRoles.filter((Function1 & Serializable)_$20 -> _$20.enabled())).flatMap((Function1 & Serializable)_$21 -> _$21.privilegeIds())).flatMap((Function1 & Serializable)key -> privilegeMap$5.get(key))).map((Function1 & Serializable)_$22 -> _$22.name())).map((Function1 & Serializable)rolePrivileges -> UserDB$User$.MODULE$.apply(id$6, name$14, email$2, (Set<UserDB.RoleIdName>)roles, (Set<String>)((Set)rolePrivileges.$plus$plus((IterableOnce)privileges)), enabled))))));
    }

    private static final ObjectId addPrivilege$$anonfun$1() {
        return new ObjectId();
    }

    private static final Object addPrivilege$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(String name$25, long count$2) {
        return "Added privilege " + name$25 + " count=" + count$2;
    }

    private final void addPrivilege$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(String name$24, long count$1) {
        this.log().info(() -> UserCodexDB.addPrivilege$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(name$24, count$1), Line$.MODULE$.apply(141), FullName$.MODULE$.apply("ambience.module.UserCodexDB.addPrivilege"));
    }

    private static final UserDB.Privilege addPrivilege$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(ObjectId objectId$10, String name$27, String desc$6) {
        return UserDB$Privilege$.MODULE$.apply(objectId$10.toHexString(), name$27, desc$6);
    }

    private final /* synthetic */ Task addPrivilege$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(String name$23, ObjectId objectId$8, String desc$4, long count) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.addPrivilege$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(name$23, count);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Task$.MODULE$.apply(() -> UserCodexDB.addPrivilege$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(objectId$8, name$23, desc$4)).map((Function1 & Serializable)ret -> ret);
        });
    }

    private static final BsonObjectId getRoleById$$anonfun$1(String id$14) {
        return BsonObjectId$.MODULE$.apply(id$14);
    }

    private static final BsonObjectId getUsersWithPrivilege$$anonfun$1(UserDB.Privilege p$2) {
        return BsonObjectId$.MODULE$.apply(p$2.id());
    }

    private final Observable $anonfun$9(BsonObjectId pId$1) {
        return this.usersWithDirectPrivilege(pId$1);
    }

    private static final BsonObjectId getUsersWithRole$$anonfun$1(UserDB.Role r$1) {
        return BsonObjectId$.MODULE$.apply(r$1.id());
    }

    private static final BsonObjectId getUserSetting$$anonfun$1(String id$15) {
        return BsonObjectId$.MODULE$.apply(id$15);
    }

    private static final Option $anonfun$12$$anonfun$1$$anonfun$1(Document doc$9, String key$2) {
        return BsonETL$.MODULE$.get(doc$9, "settings." + key$2).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(BsonValue x) {
                BsonValue bsonValue = x;
                if (bsonValue instanceof BsonString) {
                    BsonString s = (BsonString)bsonValue;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(BsonValue x, Function1 function1) {
                BsonValue bsonValue = x;
                if (bsonValue instanceof BsonString) {
                    BsonString s = (BsonString)bsonValue;
                    return s.getValue();
                }
                return function1.apply((Object)x);
            }
        });
    }

    private static final BsonObjectId putUserSetting$$anonfun$1(String id$16) {
        return BsonObjectId$.MODULE$.apply(id$16);
    }

    private static final BsonObjectId removeUserSetting$$anonfun$1(String id$17) {
        return BsonObjectId$.MODULE$.apply(id$17);
    }
}

