/*
 * Decompiled with CFR 0.152.
 */
package ambience.module;

import ambience.module.AmbienceDB$;
import ambience.module.UserDB;
import ambience.module.UserDB$Privilege$;
import ambience.module.UserDB$Role$;
import ambience.module.UserDB$RoleIdName$;
import ambience.module.UserDB$User$;
import ambience.module.UserDB$UserIdName$;
import cats.Functor;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import cats.data.OptionT;
import cats.data.OptionT$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.BsonETL$;
import com.elixirtech.mongodb.FindOptions;
import com.elixirtech.mongodb.FindOptions$;
import com.elixirtech.mongodb.MongoDB;
import com.elixirtech.mongodb.RichMongoCollection;
import com.mongodb.client.result.InsertOneResult;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.mongodb.scala.bson.BsonArray$;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonObjectId$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Projections$;
import org.mongodb.scala.model.Updates$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class UserMongoDB
implements UserDB,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(UserMongoDB.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final RichMongoCollection usersCltn;
    private final RichMongoCollection rolesCltn;
    private final RichMongoCollection privilegesCltn;

    public UserMongoDB(MongoDB mongoDB) {
        this.usersCltn = com.elixirtech.mongodb.package$.MODULE$.enrichDatabase(mongoDB.database()).getRichCollection("Users");
        this.rolesCltn = com.elixirtech.mongodb.package$.MODULE$.enrichDatabase(mongoDB.database()).getRichCollection("Roles");
        this.privilegesCltn = com.elixirtech.mongodb.package$.MODULE$.enrichDatabase(mongoDB.database()).getRichCollection("Privileges");
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public RichMongoCollection usersCltn() {
        return this.usersCltn;
    }

    public RichMongoCollection rolesCltn() {
        return this.rolesCltn;
    }

    public RichMongoCollection privilegesCltn() {
        return this.privilegesCltn;
    }

    @Override
    public Task<Object> getUserCount() {
        return this.usersCltn().countDocumentsT(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{AmbienceDB$.MODULE$.IsEnabled(), AmbienceDB$.MODULE$.NotDeleted()})));
    }

    @Override
    public Task<Object> hasUserId(String id) {
        Try try_ = Try$.MODULE$.apply(() -> UserMongoDB.hasUserId$$anonfun$1(id));
        if (try_ instanceof Success) {
            BsonObjectId oid = (BsonObjectId)((Success)try_).value();
            return this.usersCltn().findO(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{AmbienceDB$.MODULE$.NotDeleted(), Filters$.MODULE$.eq("_id", (Object)oid)}))).firstOptionL().map((Function1 & Serializable)_$1 -> _$1.isDefined());
        }
        if (try_ instanceof Failure) {
            return Task$.MODULE$.now((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public Task<Option<UserDB.User>> getUserByName(String name) {
        return this.privilegesCltn().findO(AmbienceDB$.MODULE$.NotDeleted()).toListL().flatMap((Function1 & Serializable)ps -> this.rolesCltn().findO(AmbienceDB$.MODULE$.NotDeleted()).toListL().flatMap((Function1 & Serializable)rs -> this.usersCltn().findO(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.eq("name", (Object)name), AmbienceDB$.MODULE$.NotDeleted()}))).toListL().map((Function1 & Serializable)us -> this.assembleUser((Seq<Document>)us, (Seq<Document>)rs, (Seq<Document>)ps))));
    }

    @Override
    public Task<Option<UserDB.User>> getUserById(String id) {
        Try try_ = Try$.MODULE$.apply(() -> UserMongoDB.getUserById$$anonfun$1(id));
        if (try_ instanceof Success) {
            BsonObjectId uId = (BsonObjectId)((Success)try_).value();
            return this.privilegesCltn().findO(AmbienceDB$.MODULE$.NotDeleted()).toListL().flatMap((Function1 & Serializable)ps -> this.rolesCltn().findO(AmbienceDB$.MODULE$.NotDeleted()).toListL().flatMap((Function1 & Serializable)rs -> this.usersCltn().findO(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.eq("_id", (Object)uId), AmbienceDB$.MODULE$.NotDeleted()}))).toListL().map((Function1 & Serializable)us -> this.assembleUser((Seq<Document>)us, (Seq<Document>)rs, (Seq<Document>)ps))));
        }
        if (try_ instanceof Failure) {
            return Task$.MODULE$.now((Object)None$.MODULE$);
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public Task<String> addUser(String name, Set<UserDB.Privilege> privileges, String password) {
        ObjectId objectId = new ObjectId();
        BsonArray bsonPrivileges = BsonArray$.MODULE$.fromIterable((Iterable)((IterableOnceOps)privileges.flatMap((Function1 & Serializable)g -> Try$.MODULE$.apply(() -> UserMongoDB.$anonfun$1$$anonfun$1(g)).toOption())).toSeq());
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[5];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)objectId), (BsonTransformer)BsonTransformer$.MODULE$.TransformObjectId());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)name), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"enabled");
        objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBoolean());
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"roles");
        objectArray[3] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)new BsonArray()), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"privileges");
        objectArray[4] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)bsonPrivileges), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        Document userDoc = Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return this.usersCltn().insertOneT(userDoc).map((Function1 & Serializable)_$2 -> objectId.toHexString());
    }

    @Override
    public Task<Either<String, UserDB.User>> addAuthenticatedUser(String name, List<String> roles) {
        EitherT ret = EitherT$.MODULE$.apply((Object)UserMongoDB.et$1(() -> this.$anonfun$2(name))).flatMap((Function1 & Serializable)alreadyUser -> EitherT$.MODULE$.apply(this.checkAlreadyExists((Option<UserDB.User>)alreadyUser)).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return EitherT$.MODULE$.apply((Object)Task$.MODULE$.apply(UserMongoDB::$anonfun$3$$anonfun$1$$anonfun$1)).flatMap((Function1 & Serializable)objectId -> EitherT$.MODULE$.apply((Object)UserMongoDB.et$1(this::$anonfun$3$$anonfun$1$$anonfun$2$$anonfun$1)).flatMap((Function1 & Serializable)allRoles -> EitherT$.MODULE$.apply(this.buildRoleIds((Map<String, String>)allRoles, roles)).flatMap((Function1 & Serializable)roleIds -> EitherT$.MODULE$.apply(this.newUser((ObjectId)objectId, name, (List<BsonObjectId>)roleIds)).flatMap((Function1 & Serializable)userDoc -> EitherT$.MODULE$.apply((Object)UserMongoDB.et$1(() -> this.$anonfun$3$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(userDoc))).flatMap((Function1 & Serializable)x$1 -> {
                InsertOneResult insertOneResult = x$1;
                return EitherT$.MODULE$.apply((Object)UserMongoDB.et$1(() -> this.$anonfun$3$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(name))).flatMap((Function1 & Serializable)optUser -> EitherT$.MODULE$.apply((Object)Task$.MODULE$.apply(() -> UserMongoDB.$anonfun$3$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(optUser))).map((Function1 & Serializable)ret -> ret, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
            }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
        }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
        return (Task)ret.value();
    }

    public Task<Either<String, BoxedUnit>> checkAlreadyExists(Option<UserDB.User> maybeUser) {
        return Task$.MODULE$.apply(() -> UserMongoDB.checkAlreadyExists$$anonfun$1(maybeUser));
    }

    public Task<Either<String, List<BsonObjectId>>> buildRoleIds(Map<String, String> allRoles, List<String> roles) {
        return Task$.MODULE$.apply(() -> UserMongoDB.buildRoleIds$$anonfun$1(roles, allRoles));
    }

    public Task<Either<String, Document>> newUser(ObjectId objectId, String name, List<BsonObjectId> roleIds) {
        return Task$.MODULE$.apply(() -> UserMongoDB.newUser$$anonfun$1(objectId, name, roleIds));
    }

    @Override
    public Task<BoxedUnit> setUserEmail(String name, String email) {
        Bson filter = Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.eq("name", (Object)BsonString$.MODULE$.apply(name)), Filters$.MODULE$.ne("email", (Object)BsonString$.MODULE$.apply(email)), AmbienceDB$.MODULE$.IsEnabled(), AmbienceDB$.MODULE$.NotDeleted()}));
        Bson update = Updates$.MODULE$.set("email", (Object)BsonString$.MODULE$.apply(email));
        return this.usersCltn().updateOneT(filter, update).map((Function1)(JProcedure1 & Serializable)_$3 -> {});
    }

    @Override
    public Task<BoxedUnit> setUserPrivileges(String userId, Set<UserDB.Privilege> privileges) {
        Set ps = (Set)privileges.flatMap((Function1 & Serializable)p -> Try$.MODULE$.apply(() -> UserMongoDB.$anonfun$4$$anonfun$1(p)).toOption());
        return (Task)Try$.MODULE$.apply(() -> UserMongoDB.setUserPrivileges$$anonfun$1(userId)).map((Function1 & Serializable)objectId -> {
            Bson filter = Filters$.MODULE$.eq("_id", objectId);
            Bson update = Updates$.MODULE$.set("privileges", (Object)BsonArray$.MODULE$.fromIterable((Iterable)ps));
            return this.usersCltn().updateOneT(filter, update).map((Function1)(JProcedure1 & Serializable)_$4 -> {});
        }).getOrElse(() -> this.setUserPrivileges$$anonfun$3(userId));
    }

    public Option<UserDB.User> assembleUser(Seq<Document> us, Seq<Document> rs, Seq<Document> ps) {
        Map privilegeMap = ((IterableOnceOps)((IterableOps)ps.flatMap((Function1 & Serializable)doc -> this.buildPrivilege((Document)doc))).map((Function1 & Serializable)g -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)g.id());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, g);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Map roleMap = ((IterableOnceOps)((IterableOps)rs.flatMap((Function1 & Serializable)doc -> this.buildRole((Document)doc))).map((Function1 & Serializable)r -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)r.id());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, r);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return us.headOption().flatMap((Function1 & Serializable)doc -> doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)bson -> this.oidString((BsonValue)bson)).flatMap((Function1 & Serializable)id -> doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$5 -> _$5.getValue()).flatMap((Function1 & Serializable)name -> Some$.MODULE$.apply(doc.get("email", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$6 -> _$6.getValue()).getOrElse(UserMongoDB::assembleUser$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2)).flatMap((Function1 & Serializable)email -> Some$.MODULE$.apply(doc.get("privileges", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)_$7 -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(_$7.asArray().getValues()).asScala().map((Function1 & Serializable)bson -> this.oidString((BsonValue)bson))).map((Function1 & Serializable)_$8 -> _$8.toSet()).getOrElse(UserMongoDB::assembleUser$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$3)).flatMap((Function1 & Serializable)privilegeIds -> doc.get("enabled", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBoolean.class)).map((Function1 & Serializable)_$9 -> _$9.getValue()).flatMap((Function1 & Serializable)enabled -> this.assembleUser$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$4$$anonfun$2((Set)privilegeIds, privilegeMap, (Document)doc, roleMap, (String)id, (String)name, (String)email, BoxesRunTime.unboxToBoolean((Object)enabled))))))));
    }

    @Override
    public Observable<UserDB.Privilege> getPrivileges() {
        return this.privilegesCltn().findO(AmbienceDB$.MODULE$.NotDeleted()).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(this.buildPrivilege((Document)doc))));
    }

    @Override
    public Task<UserDB.Privilege> addPrivilege(String name, String desc) {
        ObjectId objectId = new ObjectId();
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)objectId), (BsonTransformer)BsonTransformer$.MODULE$.TransformObjectId());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)name), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"description");
        objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)desc), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        return this.privilegesCltn().insertOneT(Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).map((Function1 & Serializable)_$17 -> UserDB$Privilege$.MODULE$.apply(objectId.toHexString(), name, desc));
    }

    public Option<UserDB.Privilege> buildPrivilege(Document doc) {
        return doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonObjectId.class)).map((Function1 & Serializable)_$18 -> _$18.getValue().toHexString()).flatMap((Function1 & Serializable)id -> doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$19 -> _$19.getValue()).flatMap((Function1 & Serializable)name -> doc.get("description", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$20 -> _$20.getValue()).map((Function1 & Serializable)desc -> UserDB$Privilege$.MODULE$.apply((String)id, (String)name, (String)desc))));
    }

    @Override
    public Observable<UserDB.UserIdName> getUserIdNames() {
        FindOptions options = FindOptions$.MODULE$.projections(Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_id", "name", "enabled"})));
        return this.usersCltn().findO(AmbienceDB$.MODULE$.NotDeleted(), options).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(this.buildUserIdName((Document)doc))));
    }

    @Override
    public Observable<UserDB.Role> getRoles() {
        return this.rolesCltn().findO(AmbienceDB$.MODULE$.NotDeleted()).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(this.buildRole((Document)doc))));
    }

    @Override
    public Observable<UserDB.RoleIdName> getRoleIdNames() {
        FindOptions options = FindOptions$.MODULE$.projections(Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_id", "name", "enabled"})));
        return this.rolesCltn().findO(AmbienceDB$.MODULE$.NotDeleted(), options).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(this.buildRoleIdName((Document)doc))));
    }

    @Override
    public Task<Option<UserDB.Privilege>> getPrivilege(String name) {
        Bson filter = Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.eq("name", (Object)BsonString$.MODULE$.apply(name)), AmbienceDB$.MODULE$.NotDeleted()}));
        return this.privilegesCltn().findO(filter).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(this.buildPrivilege((Document)doc)))).firstOptionL();
    }

    @Override
    public Task<Option<UserDB.Role>> getRoleByName(String name) {
        Bson filter = Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.eq("name", (Object)BsonString$.MODULE$.apply(name)), AmbienceDB$.MODULE$.NotDeleted()}));
        return this.rolesCltn().findO(filter).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(this.buildRole((Document)doc)))).firstOptionL();
    }

    @Override
    public Task<Option<UserDB.Role>> getRoleById(String id) {
        Try try_ = Try$.MODULE$.apply(() -> UserMongoDB.getRoleById$$anonfun$1(id));
        if (try_ instanceof Success) {
            BsonObjectId oid = (BsonObjectId)((Success)try_).value();
            Bson filter = Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.eq("_id", (Object)oid), AmbienceDB$.MODULE$.NotDeleted()}));
            return this.rolesCltn().findO(filter).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(this.buildRole((Document)doc)))).firstOptionL();
        }
        if (try_ instanceof Failure) {
            return Task$.MODULE$.now((Object)None$.MODULE$);
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public Observable<UserDB.UserIdName> getUsersWithPrivilege(UserDB.Privilege p) {
        Try try_ = Try$.MODULE$.apply(() -> UserMongoDB.getUsersWithPrivilege$$anonfun$1(p));
        if (try_ instanceof Success) {
            BsonObjectId pId = (BsonObjectId)((Success)try_).value();
            Task all = this.usersWithRolePrivilege(pId).$plus$plus(() -> this.$anonfun$9(pId)).toListL().map((Function1 & Serializable)_$21 -> (List)_$21.distinct());
            return Observable$.MODULE$.fromTask(all).flatMap((Function1 & Serializable)iterable -> Observable$.MODULE$.fromIterable((Iterable)iterable));
        }
        if (try_ instanceof Failure) {
            return Observable$.MODULE$.empty();
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public Observable<UserDB.UserIdName> getUsersWithRole(UserDB.Role r) {
        Try try_ = Try$.MODULE$.apply(() -> UserMongoDB.getUsersWithRole$$anonfun$1(r));
        if (try_ instanceof Success) {
            BsonObjectId rId = (BsonObjectId)((Success)try_).value();
            return this.usersWithRole(rId);
        }
        if (try_ instanceof Failure) {
            return Observable$.MODULE$.empty();
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public Task<Option<String>> getUserSetting(String id, String key) {
        Try try_ = Try$.MODULE$.apply(() -> UserMongoDB.getUserSetting$$anonfun$1(id));
        if (try_ instanceof Success) {
            BsonObjectId uId = (BsonObjectId)((Success)try_).value();
            OptionT optT = OptionT$.MODULE$.apply((Object)this.usersCltn().findO(Filters$.MODULE$.eq("_id", (Object)uId)).firstOptionL()).flatMap((Function1 & Serializable)doc -> OptionT$.MODULE$.apply((Object)Task$.MODULE$.apply(() -> UserMongoDB.$anonfun$11$$anonfun$1(doc, key))).map((Function1 & Serializable)value -> value, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
            return (Task)optT.value();
        }
        if (try_ instanceof Failure) {
            return Task$.MODULE$.now((Object)None$.MODULE$);
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public Task<BoxedUnit> putUserSetting(String id, String key, String value) {
        Try try_ = Try$.MODULE$.apply(() -> UserMongoDB.putUserSetting$$anonfun$1(id));
        if (try_ instanceof Success) {
            BsonObjectId uId = (BsonObjectId)((Success)try_).value();
            Bson update = Updates$.MODULE$.set("settings." + key, (Object)BsonString$.MODULE$.apply(value));
            return this.usersCltn().updateOneT(Filters$.MODULE$.eq("_id", (Object)uId), update).map((Function1)(JProcedure1 & Serializable)_$22 -> {});
        }
        if (try_ instanceof Failure) {
            return Task$.MODULE$.unit();
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public Task<BoxedUnit> removeUserSetting(String id, String key) {
        Try try_ = Try$.MODULE$.apply(() -> UserMongoDB.removeUserSetting$$anonfun$1(id));
        if (try_ instanceof Success) {
            BsonObjectId uId = (BsonObjectId)((Success)try_).value();
            Bson update = Updates$.MODULE$.unset("settings." + key);
            return this.usersCltn().updateOneT(Filters$.MODULE$.eq("_id", (Object)uId), update).map((Function1)(JProcedure1 & Serializable)_$23 -> {});
        }
        if (try_ instanceof Failure) {
            return Task$.MODULE$.unit();
        }
        throw new MatchError((Object)try_);
    }

    private String oidString(BsonValue bson) {
        return bson.asObjectId().getValue().toHexString();
    }

    public Option<UserDB.UserIdName> buildUserIdName(Document doc) {
        return doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonObjectId.class)).map((Function1 & Serializable)_$24 -> _$24.getValue().toHexString()).flatMap((Function1 & Serializable)id -> doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$25 -> _$25.getValue()).flatMap((Function1 & Serializable)name -> doc.get("enabled", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBoolean.class)).map((Function1 & Serializable)_$26 -> _$26.getValue()).map((Function1 & Serializable)enabled -> UserDB$UserIdName$.MODULE$.apply(id, name, BoxesRunTime.unboxToBoolean((Object)enabled)))));
    }

    public Option<UserDB.Role> buildRole(Document doc) {
        return doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)_$27 -> _$27.asObjectId().getValue().toHexString()).flatMap((Function1 & Serializable)id -> doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)_$28 -> _$28.asString().getValue()).flatMap((Function1 & Serializable)name -> doc.get("description", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)_$29 -> _$29.asString().getValue()).flatMap((Function1 & Serializable)desc -> doc.get("privileges", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonArray.class)).map((Function1 & Serializable)_$30 -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(_$30.getValues()).asScala().map((Function1 & Serializable)bson -> this.oidString((BsonValue)bson))).flatMap((Function1 & Serializable)privileges -> Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)doc.get("enabled", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBoolean.class)).forall((Function1 & Serializable)_$31 -> _$31.getValue()))).map((Function1 & Serializable)enabled -> UserDB$Role$.MODULE$.apply(id, name, desc, (Set<String>)privileges.toSet(), BoxesRunTime.unboxToBoolean((Object)enabled)))))));
    }

    public Option<UserDB.RoleIdName> buildRoleIdName(Document doc) {
        return doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonObjectId.class)).map((Function1 & Serializable)_$32 -> _$32.getValue().toHexString()).flatMap((Function1 & Serializable)id -> doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$33 -> _$33.getValue()).flatMap((Function1 & Serializable)name -> Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)doc.get("enabled", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBoolean.class)).forall((Function1 & Serializable)_$34 -> _$34.getValue()))).map((Function1 & Serializable)enabled -> UserDB$RoleIdName$.MODULE$.apply(id, name, BoxesRunTime.unboxToBoolean((Object)enabled)))));
    }

    public Observable<BsonObjectId> privilegeId(String p) {
        Bson filter = Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.eq("name", (Object)BsonString$.MODULE$.apply(p)), AmbienceDB$.MODULE$.NotDeleted()}));
        return this.privilegesCltn().findO(filter).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonObjectId.class)))));
    }

    public Observable<UserDB.UserIdName> usersWithRolePrivilege(BsonObjectId pId) {
        return this.rolesWithPrivilege(pId).flatMap((Function1 & Serializable)role -> this.usersWithRole((BsonObjectId)role).map((Function1 & Serializable)result -> result));
    }

    public Observable<BsonObjectId> rolesWithPrivilege(BsonObjectId p) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"privileges");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)p), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return this.rolesCltn().findO((Bson)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonObjectId.class)))));
    }

    public Observable<UserDB.UserIdName> usersWithDirectPrivilege(BsonObjectId pid) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"privileges");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)pid), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return this.usersCltn().findO((Bson)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(this.buildUserIdName((Document)doc))));
    }

    public Observable<UserDB.UserIdName> usersWithRole(BsonObjectId rid) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"roles");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)rid), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return this.usersCltn().findO((Bson)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(this.buildUserIdName((Document)doc))));
    }

    @Override
    public boolean allowExtendedRoles() {
        return true;
    }

    private static final BsonObjectId hasUserId$$anonfun$1(String id$1) {
        return BsonObjectId$.MODULE$.apply(id$1);
    }

    private static final BsonObjectId getUserById$$anonfun$1(String id$2) {
        return BsonObjectId$.MODULE$.apply(id$2);
    }

    private static final BsonObjectId $anonfun$1$$anonfun$1(UserDB.Privilege g$1) {
        return BsonObjectId$.MODULE$.apply(g$1.id());
    }

    private static final Task et$1(Function0 fn) {
        return ((Task)fn.apply()).map((Function1 & Serializable)ret -> package$.MODULE$.Right().apply(ret));
    }

    private final Task $anonfun$2(String name$3) {
        return this.getUserByName(name$3);
    }

    private static final Right $anonfun$3$$anonfun$1$$anonfun$1() {
        return package$.MODULE$.Right().apply((Object)new ObjectId());
    }

    private final Task $anonfun$3$$anonfun$1$$anonfun$2$$anonfun$1() {
        return this.getRoleIdNames().toListL().map((Function1 & Serializable)list -> list.map((Function1 & Serializable)r -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)r.name());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)r.id());
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private final Task $anonfun$3$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(Document userDoc$1) {
        return this.usersCltn().insertOneT(userDoc$1);
    }

    private final Task $anonfun$3$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(String name$11) {
        return this.getUserByName(name$11);
    }

    private static final String $anonfun$3$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1() {
        return "Cannot add authenticated user";
    }

    private static final Either $anonfun$3$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(Option optUser$1) {
        return optUser$1.toRight(UserMongoDB::$anonfun$3$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1);
    }

    private static final Either checkAlreadyExists$$anonfun$1(Option maybeUser$1) {
        Option option = maybeUser$1;
        if (option instanceof Some) {
            UserDB.User user = (UserDB.User)((Some)option).value();
            return package$.MODULE$.Left().apply((Object)("User is already defined, but not available (enabled=" + user.enabled() + ")"));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        }
        throw new MatchError((Object)option);
    }

    private static final BsonObjectId buildRoleIds$$anonfun$1$$anonfun$2$$anonfun$1(String s$1) {
        return BsonObjectId$.MODULE$.apply(s$1);
    }

    private static final Right buildRoleIds$$anonfun$1(List roles$5, Map allRoles$1) {
        return package$.MODULE$.Right().apply((Object)roles$5.flatMap((Function1 & Serializable)key -> allRoles$1.get(key)).flatMap((Function1 & Serializable)s -> Try$.MODULE$.apply(() -> UserMongoDB.buildRoleIds$$anonfun$1$$anonfun$2$$anonfun$1(s)).toOption()));
    }

    private static final Right newUser$$anonfun$1(ObjectId objectId$4, String name$12, List roleIds$1) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[5];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)objectId$4), (BsonTransformer)BsonTransformer$.MODULE$.TransformObjectId());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)name$12), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"enabled");
        objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBoolean());
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"roles");
        objectArray[3] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)BsonArray$.MODULE$.fromIterable((Iterable)roleIds$1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"privileges");
        objectArray[4] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)new BsonArray()), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return package$.MODULE$.Right().apply((Object)Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
    }

    private static final BsonObjectId $anonfun$4$$anonfun$1(UserDB.Privilege p$1) {
        return BsonObjectId$.MODULE$.apply(p$1.id());
    }

    private static final BsonObjectId setUserPrivileges$$anonfun$1(String userId$1) {
        return BsonObjectId$.MODULE$.apply(userId$1);
    }

    private static final Object setUserPrivileges$$anonfun$3$$anonfun$1(String userId$3) {
        return "setUserPrivileges invalid userId: " + userId$3;
    }

    private final Task setUserPrivileges$$anonfun$3(String userId$2) {
        this.log().error(() -> UserMongoDB.setUserPrivileges$$anonfun$3$$anonfun$1(userId$2), Line$.MODULE$.apply(119), FullName$.MODULE$.apply("ambience.module.UserMongoDB.setUserPrivileges"));
        return Task$.MODULE$.unit();
    }

    private static final String assembleUser$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2() {
        return "";
    }

    private static final Set assembleUser$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$3() {
        return Predef$.MODULE$.Set().empty();
    }

    private static final Set assembleUser$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$4$$anonfun$2$$anonfun$3$$anonfun$3() {
        return Predef$.MODULE$.Set().empty();
    }

    private final /* synthetic */ Option assembleUser$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$4$$anonfun$2(Set privilegeIds$1, Map privilegeMap$5, Document doc$5, Map roleMap$5, String id$6, String name$15, String email$2, boolean enabled) {
        return Some$.MODULE$.apply(((IterableOps)privilegeIds$1.flatMap((Function1 & Serializable)key -> privilegeMap$5.get(key))).map((Function1 & Serializable)_$10 -> _$10.name())).flatMap((Function1 & Serializable)privileges -> Some$.MODULE$.apply(doc$5.get("roles", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)_$11 -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(_$11.asArray().getValues()).asScala().map((Function1 & Serializable)bson -> this.oidString((BsonValue)bson))).map((Function1 & Serializable)_$12 -> _$12.toSet()).getOrElse(UserMongoDB::assembleUser$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$4$$anonfun$2$$anonfun$3$$anonfun$3)).flatMap((Function1 & Serializable)roleIds -> Some$.MODULE$.apply(roleIds.flatMap((Function1 & Serializable)key -> roleMap$5.get(key))).flatMap((Function1 & Serializable)fullRoles -> Some$.MODULE$.apply(fullRoles.map((Function1 & Serializable)_$13 -> _$13.toIdName())).flatMap((Function1 & Serializable)roles -> Some$.MODULE$.apply(((IterableOps)((IterableOps)((IterableOps)fullRoles.filter((Function1 & Serializable)_$14 -> _$14.enabled())).flatMap((Function1 & Serializable)_$15 -> _$15.privilegeIds())).flatMap((Function1 & Serializable)key -> privilegeMap$5.get(key))).map((Function1 & Serializable)_$16 -> _$16.name())).map((Function1 & Serializable)rolePrivileges -> UserDB$User$.MODULE$.apply(id$6, name$15, email$2, (Set<UserDB.RoleIdName>)roles, (Set<String>)((Set)rolePrivileges.$plus$plus((IterableOnce)privileges)), enabled))))));
    }

    private static final BsonObjectId getRoleById$$anonfun$1(String id$14) {
        return BsonObjectId$.MODULE$.apply(id$14);
    }

    private static final BsonObjectId getUsersWithPrivilege$$anonfun$1(UserDB.Privilege p$2) {
        return BsonObjectId$.MODULE$.apply(p$2.id());
    }

    private final Observable $anonfun$9(BsonObjectId pId$1) {
        return this.usersWithDirectPrivilege(pId$1);
    }

    private static final BsonObjectId getUsersWithRole$$anonfun$1(UserDB.Role r$1) {
        return BsonObjectId$.MODULE$.apply(r$1.id());
    }

    private static final BsonObjectId getUserSetting$$anonfun$1(String id$15) {
        return BsonObjectId$.MODULE$.apply(id$15);
    }

    private static final Option $anonfun$11$$anonfun$1(Document doc$9, String key$1) {
        return BsonETL$.MODULE$.get(doc$9, "settings." + key$1).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(BsonValue x) {
                BsonValue bsonValue = x;
                if (bsonValue instanceof BsonString) {
                    BsonString s = (BsonString)bsonValue;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(BsonValue x, Function1 function1) {
                BsonValue bsonValue = x;
                if (bsonValue instanceof BsonString) {
                    BsonString s = (BsonString)bsonValue;
                    return s.getValue();
                }
                return function1.apply((Object)x);
            }
        });
    }

    private static final BsonObjectId putUserSetting$$anonfun$1(String id$16) {
        return BsonObjectId$.MODULE$.apply(id$16);
    }

    private static final BsonObjectId removeUserSetting$$anonfun$1(String id$17) {
        return BsonObjectId$.MODULE$.apply(id$17);
    }
}

