/*
 * Decompiled with CFR 0.152.
 */
package ambience.queue;

import ambience.framework.EventBus;
import ambience.framework.EventBus$;
import ambience.queue.JobRunner;
import ambience.queue.JobType;
import ambience.queue.JobType$;
import ambience.queue.Payload;
import ambience.queue.QId;
import ambience.queue.QId$;
import ambience.queue.Queue;
import ambience.queue.QueueEngine$Busy$;
import ambience.queue.QueueEngine$Idle$;
import ambience.queue.QueueEngine$Message$;
import ambience.queue.QueueEngine$Waiting$;
import ambience.queue.QueueEvent;
import ambience.queue.QueueEvent$;
import ambience.queue.QueueEvent$Added$;
import ambience.queue.QueueEvent$Cancelled$;
import ambience.queue.QueueEvent$Completed$;
import ambience.queue.QueueEvent$Deleted$;
import ambience.queue.QueueEvent$Failed$;
import ambience.queue.QueueEvent$JobTimeout$;
import ambience.queue.QueueEvent$Poll$;
import ambience.queue.QueueEvent$Processing$;
import ambience.queue.QueueManager;
import ambience.queue.RepliedResultHelper;
import ambience.queue.RepliedResultHelper$;
import ambience.queue.RepliedResultHelper$Failed$;
import ambience.queue.RepliedResultHelper$JobTimeout$;
import ambience.queue.RepliedResultHelper$Success$;
import ambience.queue.SystemQueueManager;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import java.io.Serializable;
import monix.eval.Fiber;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler$;
import monix.execution.atomic.Atomic;
import monix.execution.atomic.AtomicAny$;
import monix.reactive.Observable;
import org.bson.BsonString;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class QueueEngine
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(QueueEngine.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final SystemQueueManager manager;
    private final String engineId;
    private final Queue queue;
    private final Atomic status;
    private final List AllowedJobTypes;
    private final Set AllowedJobTypesSet;

    public QueueEngine(SystemQueueManager manager, String engineId, Queue queue) {
        this.manager = manager;
        this.engineId = engineId;
        this.queue = queue;
        this.status = AtomicAny$.MODULE$.apply((Object)QueueEngine$Idle$.MODULE$);
        this.AllowedJobTypes = manager.jobTypes().toList().map((Function1 & Serializable)jt -> BsonString$.MODULE$.apply(jt == null ? null : ((JobType)jt).value()));
        this.AllowedJobTypesSet = this.AllowedJobTypes().toSet();
        this.RichOb(this.RichOb(this.RichOb(this.RichOb(EventBus$.MODULE$.events((Function1<EventBus.Message, Object>)(Function1 & Serializable)msg -> this.isQueueEvent((EventBus.Message)msg), 100).map((Function1 & Serializable)msg -> QueueEngine$Message$.MODULE$.apply(msg.eventType(), QueueEngine$Message$.MODULE$.$lessinit$greater$default$2()))).tap((Function1)(JProcedure1 & Serializable)x -> this.log().debug(() -> QueueEngine.$init$$$anonfun$4$$anonfun$1(engineId, x), Line$.MODULE$.apply(45), FullName$.MODULE$.apply("ambience.queue.QueueEngine")))).tap((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.$init$$$anonfun$5();
            return BoxedUnit.UNIT;
        }).mapEval((Function1 & Serializable)msg -> this.queueUpdate((Message)msg))).tap((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.$init$$$anonfun$7();
            return BoxedUnit.UNIT;
        })).tap((Function1)(JProcedure1 & Serializable)x -> x.optQId().foreach((Function1 & Serializable)v1 -> {
            this.$init$$$anonfun$8$$anonfun$1(engineId, v1 == null ? null : ((QId)v1).value());
            return BoxedUnit.UNIT;
        })).completedL().onErrorHandleWith((Function1 & Serializable)ex -> this.error((Function0<String>)((Function0 & Serializable)() -> QueueEngine.$init$$$anonfun$9$$anonfun$1(ex)))).runToFuture(Scheduler$.MODULE$.global());
        this.RichOb(this.RichOb(EventBus$.MODULE$.events((Function1<EventBus.Message, Object>)(Function1 & Serializable)msg -> this.isControlEvent((EventBus.Message)msg), 100).map((Function1 & Serializable)msg -> QueueEngine$Message$.MODULE$.apply(msg.eventType(), QueueEvent$.MODULE$.qId(msg.doc()))).filter((Function1 & Serializable)msg -> this.isRelevant((Message)msg))).tap((Function1)(JProcedure1 & Serializable)x -> this.log().debug(() -> QueueEngine.$init$$$anonfun$13$$anonfun$1(engineId, x), Line$.MODULE$.apply(58), FullName$.MODULE$.apply("ambience.queue.QueueEngine"))).mapEval((Function1 & Serializable)msg -> this.controlUpdate((Message)msg))).tap((Function1)(JProcedure1 & Serializable)x -> this.log().debug(() -> QueueEngine.$init$$$anonfun$15$$anonfun$1(engineId, x), Line$.MODULE$.apply(60), FullName$.MODULE$.apply("ambience.queue.QueueEngine"))).completedL().onErrorHandleWith((Function1 & Serializable)ex -> this.error((Function0<String>)((Function0 & Serializable)() -> QueueEngine.$init$$$anonfun$16$$anonfun$1(ex)))).runToFuture(Scheduler$.MODULE$.global());
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Atomic<Status> status() {
        return this.status;
    }

    public List<BsonString> AllowedJobTypes() {
        return this.AllowedJobTypes;
    }

    public Set<BsonString> AllowedJobTypesSet() {
        return this.AllowedJobTypesSet;
    }

    public final <T> RichOb<T> RichOb(Observable<T> ob) {
        return new RichOb<T>(this, ob);
    }

    public boolean isQueueEvent(EventBus.Message msg) {
        String string = msg.eventType();
        String string2 = QueueEvent$Added$.MODULE$.id();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return true;
        }
        String string4 = QueueEvent$Poll$.MODULE$.id();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            String string6 = msg.systemId();
            String string7 = EventBus$.MODULE$.systemId();
            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                return true;
            }
        }
        return false;
    }

    public boolean isControlEvent(EventBus.Message msg) {
        String string = msg.eventType();
        String string2 = QueueEvent$Cancelled$.MODULE$.id();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return true;
        }
        String string4 = QueueEvent$Deleted$.MODULE$.id();
        String string5 = string;
        return !(string4 != null ? !string4.equals(string5) : string5 != null);
    }

    public boolean isRelevant(Message msg) {
        Status status = (Status)this.status().get();
        if (status instanceof Busy) {
            Busy busy = QueueEngine$Busy$.MODULE$.unapply((Busy)status);
            String string = busy._1();
            Fiber<BoxedUnit> fiber = busy._2();
            String qId = string;
            return msg.optQId().contains((Object)new QId(qId));
        }
        return false;
    }

    public Task<Message> queueUpdate(Message msg) {
        Task<Message> task;
        String string = msg.eventType();
        String string2 = QueueEvent$Added$.MODULE$.id();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            task = this.processQueue("add", msg);
        } else {
            String string4 = QueueEvent$Poll$.MODULE$.id();
            String string5 = string;
            task = !(string4 != null ? !string4.equals(string5) : string5 != null) ? this.processQueue("polling", msg) : Task$.MODULE$.now((Object)msg);
        }
        Task<Message> task2 = task;
        return task2.onErrorHandleWith((Function1 & Serializable)ex -> this.doFailEx(msg, (Throwable)ex));
    }

    public Task<Message> controlUpdate(Message msg) {
        Task task;
        String string = msg.eventType();
        String string2 = QueueEvent$Cancelled$.MODULE$.id();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            task = (Task)msg.optQId().map((Function1 & Serializable)qId -> this.$anonfun$1(qId == null ? null : ((QId)qId).value())).getOrElse(QueueEngine::$anonfun$2);
        } else {
            String string4 = QueueEvent$Deleted$.MODULE$.id();
            String string5 = string;
            task = !(string4 != null ? !string4.equals(string5) : string5 != null) ? (Task)msg.optQId().map((Function1 & Serializable)qId -> this.$anonfun$3(qId == null ? null : ((QId)qId).value())).getOrElse(QueueEngine::$anonfun$4) : Task$.MODULE$.unit();
        }
        Task task2 = task;
        return task2.as((Object)msg).onErrorHandleWith((Function1 & Serializable)ex -> this.doFailEx(msg, (Throwable)ex));
    }

    public Task<Message> processQueue(String mode, Message msg) {
        return this.debug((Function0<String>)((Function0 & Serializable)() -> QueueEngine.processQueue$$anonfun$1(mode))).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.queue.readRequest(this.engineId, this.AllowedJobTypesSet()).flatMap((Function1 & Serializable)optQreq -> {
                Task task;
                Option option = optQreq;
                if (option instanceof Some) {
                    Payload req = (Payload)((Some)option).value();
                    task = this.runQueueRequest(req).as((Object)msg.withQId(req.qId()));
                } else if (None$.MODULE$.equals(option)) {
                    task = this.debug((Function0<String>)((Function0 & Serializable)() -> QueueEngine.processQueue$$anonfun$2$$anonfun$1$$anonfun$1(mode))).as((Object)msg);
                } else {
                    throw new MatchError((Object)option);
                }
                return task.map((Function1 & Serializable)msgOut -> msgOut);
            });
        });
    }

    public Task<BoxedUnit> runQueueRequest(Payload req) {
        Task task = Task$.MODULE$.apply((Function0 & Serializable)() -> {
            QueueEngine.$anonfun$5(req);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.doRun(req.doc()).flatMap((Function1 & Serializable)result -> this.handleResult(req.copy(req.copy$default$1(), (Document)result)).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }));
        });
        return task.onCancelRaiseError((Throwable)new QueueManager.JobCancelledException(QId$.MODULE$.shortId(req.qId()))).executeAsync().start().flatMap((Function1 & Serializable)fiber -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.runQueueRequest$$anonfun$1$$anonfun$1(req, (Fiber)fiber);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return fiber.join().map((Function1)(JProcedure1 & Serializable)result -> {});
        }));
    }

    public Task<Document> doRun(Document req) {
        Option option = req.get("jobType", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$1 -> _$1.getValue());
        if (option instanceof Some) {
            String jobType = (String)((Some)option).value();
            Option<JobRunner> option2 = this.manager.getRunner(JobType$.MODULE$.apply(jobType));
            if (option2 instanceof Some) {
                JobRunner runner = (JobRunner)((Some)option2).value();
                return runner.run(req);
            }
            if (None$.MODULE$.equals(option2)) {
                this.log().error(() -> QueueEngine.doRun$$anonfun$2(jobType), Line$.MODULE$.apply(139), FullName$.MODULE$.apply("ambience.queue.QueueEngine.doRun"));
                Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"error");
                objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply("Unsupported jobType " + jobType)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                return Task$.MODULE$.now((Object)Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            this.log().error(QueueEngine::doRun$$anonfun$3, Line$.MODULE$.apply(143), FullName$.MODULE$.apply("ambience.queue.QueueEngine.doRun"));
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"error");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply("Missing jobType")), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            return Task$.MODULE$.now((Object)Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        }
        throw new MatchError((Object)option);
    }

    public Task<BoxedUnit> handleResult(Payload req) {
        RepliedResultHelper.Result result = RepliedResultHelper$.MODULE$.getError(req.doc());
        if (RepliedResultHelper$JobTimeout$.MODULE$.equals(result)) {
            return this.doJobTimeout(req);
        }
        if (result instanceof RepliedResultHelper.Failed) {
            String string;
            RepliedResultHelper.Failed failed = RepliedResultHelper$Failed$.MODULE$.unapply((RepliedResultHelper.Failed)result);
            String msg = string = failed._1();
            return this.doFail(req, msg);
        }
        if (RepliedResultHelper$Success$.MODULE$.equals(result)) {
            return this.doComplete(req);
        }
        throw new MatchError((Object)result);
    }

    private Task<BoxedUnit> doJobTimeout(Payload req) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"engineId");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.engineId), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"qId");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)req.qId()), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        Document doc = Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return this.info((Function0<String>)((Function0 & Serializable)QueueEngine::doJobTimeout$$anonfun$1)).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.manager.queue().jobTimeout(req.qId()).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                    QueueEngine.doJobTimeout$$anonfun$2$$anonfun$1$$anonfun$1(doc);
                    return BoxedUnit.UNIT;
                }).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            });
        });
    }

    public Task<BoxedUnit> doCancel(String qId) {
        return Task$.MODULE$.apply(this::doCancel$$anonfun$1).flatMap((Function1 & Serializable)s -> {
            Task task;
            Status status = s;
            if (status instanceof Busy) {
                Busy s2 = (Busy)status;
                String string = qId;
                String string2 = s2.qId();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    task = s2.cancelableF().cancel().map((Function1)(JProcedure1 & Serializable)_$2 -> this.log().info(() -> this.doCancel$$anonfun$2$$anonfun$1$$anonfun$1(qId), Line$.MODULE$.apply(169), FullName$.MODULE$.apply("ambience.queue.QueueEngine.doCancel")));
                    return task.map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    });
                }
            }
            task = Task$.MODULE$.unit();
            return task.map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        });
    }

    private Task<BoxedUnit> doComplete(Payload req) {
        return this.queue.writeResult(req).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                QueueEngine.doComplete$$anonfun$1$$anonfun$1(req);
                return BoxedUnit.UNIT;
            }).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        });
    }

    private Task<BoxedUnit> doFail(Payload req, String msg) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"engineId");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.engineId), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"msg");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)msg), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"qId");
        objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)req.qId()), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        Document doc = Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return this.error((Function0<String>)((Function0 & Serializable)() -> this.doFail$$anonfun$1(msg))).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.manager.queue().failed(req.qId(), msg).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                    QueueEngine.doFail$$anonfun$2$$anonfun$1$$anonfun$1(doc);
                    return BoxedUnit.UNIT;
                }).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            });
        });
    }

    private Task<Message> doFailEx(Message msg, Throwable ex) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"engineId");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.engineId), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"msg");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)ex.getMessage()), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        Document doc1 = Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return Task$.MODULE$.apply(this::doFailEx$$anonfun$1).flatMap((Function1 & Serializable)optQId -> Task$.MODULE$.apply(() -> QueueEngine.doFailEx$$anonfun$2$$anonfun$1(optQId, doc1)).flatMap((Function1 & Serializable)doc2 -> this.error((Function0<String>)((Function0 & Serializable)() -> this.doFailEx$$anonfun$2$$anonfun$2$$anonfun$1(ex))).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return ((Task)optQId.map((Function1 & Serializable)qId -> this.doFailEx$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(ex, qId == null ? null : ((QId)qId).value())).getOrElse(QueueEngine::doFailEx$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2)).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                    QueueEngine.doFailEx$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$1(doc2);
                    return BoxedUnit.UNIT;
                }).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return Task$.MODULE$.apply(() -> QueueEngine.doFailEx$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$1(optQId, msg)).map((Function1 & Serializable)msgOut -> msgOut);
                });
            });
        })));
    }

    public Option<String> getCurrentQId() {
        Status status = (Status)this.status().get();
        if (status instanceof Busy) {
            Busy busy = QueueEngine$Busy$.MODULE$.unapply((Busy)status);
            String string = busy._1();
            Fiber<BoxedUnit> fiber = busy._2();
            String qId = string;
            return Some$.MODULE$.apply((Object)new QId(qId));
        }
        return None$.MODULE$;
    }

    public Task<BoxedUnit> info(Function0<String> msg) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.info$$anonfun$1(msg);
            return BoxedUnit.UNIT;
        });
    }

    public Task<BoxedUnit> debug(Function0<String> msg) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.debug$$anonfun$1(msg);
            return BoxedUnit.UNIT;
        });
    }

    public Task<BoxedUnit> error(Function0<String> msg) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.error$$anonfun$1(msg);
            return BoxedUnit.UNIT;
        });
    }

    private static final Object $init$$$anonfun$4$$anonfun$1(String engineId$2, Message x$1) {
        return "---- " + engineId$2 + " received " + x$1.eventType() + " ----";
    }

    private final void $init$$$anonfun$5() {
        this.status().set((Object)QueueEngine$Waiting$.MODULE$);
    }

    private final void $init$$$anonfun$7() {
        this.status().set((Object)QueueEngine$Idle$.MODULE$);
    }

    private static final Object $init$$$anonfun$8$$anonfun$1$$anonfun$1(String engineId$5, String qId$1) {
        return "---- " + engineId$5 + " " + QId$.MODULE$.shortId(qId$1) + " completed ----";
    }

    private final /* synthetic */ void $init$$$anonfun$8$$anonfun$1(String engineId$4, String qId) {
        this.log().debug(() -> QueueEngine.$init$$$anonfun$8$$anonfun$1$$anonfun$1(engineId$4, qId), Line$.MODULE$.apply(49), FullName$.MODULE$.apply("ambience.queue.QueueEngine"));
    }

    private static final String $init$$$anonfun$9$$anonfun$1(Throwable ex$1) {
        return "Queue exception: " + ex$1;
    }

    private static final Object $init$$$anonfun$13$$anonfun$1(String engineId$7, Message x$2) {
        return "---- " + engineId$7 + " control event received " + x$2 + " ----";
    }

    private static final Object $init$$$anonfun$15$$anonfun$1(String engineId$9, Message x$3) {
        return "---- " + engineId$9 + " control event completed " + x$3 + " ----";
    }

    private static final String $init$$$anonfun$16$$anonfun$1(Throwable ex$2) {
        return "Control exception: " + ex$2;
    }

    private static final void tap$$anonfun$1$$anonfun$1(Function1 fn$2, Object t$1) {
        fn$2.apply(t$1);
    }

    public static final /* synthetic */ Task ambience$queue$QueueEngine$RichOb$$_$tap$$anonfun$1(Function1 fn$1, Object t) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            QueueEngine.tap$$anonfun$1$$anonfun$1(fn$1, t);
            return BoxedUnit.UNIT;
        }).as(t);
    }

    public static final /* synthetic */ Task ambience$queue$QueueEngine$RichOb$$_$tap$$anonfun$2(Function0 fn$3, Object t) {
        return Task$.MODULE$.apply(fn$3).as(t);
    }

    private final /* synthetic */ Task $anonfun$1(String qId) {
        return this.doCancel(qId);
    }

    private static final Task $anonfun$2() {
        return Task$.MODULE$.unit();
    }

    private final /* synthetic */ Task $anonfun$3(String qId) {
        return this.doCancel(qId);
    }

    private static final Task $anonfun$4() {
        return Task$.MODULE$.unit();
    }

    private static final String processQueue$$anonfun$1(String mode$1) {
        return "processQueue " + mode$1;
    }

    private static final String processQueue$$anonfun$2$$anonfun$1$$anonfun$1(String mode$4) {
        return mode$4 + " already handled";
    }

    private static final void $anonfun$5(Payload req$1) {
        QueueEvent$.MODULE$.addEvent((QueueEvent.QueueEvent)QueueEvent$Processing$.MODULE$, req$1.qId());
    }

    private final void runQueueRequest$$anonfun$1$$anonfun$1(Payload req$5, Fiber fiber$1) {
        this.status().set((Object)QueueEngine$Busy$.MODULE$.apply(req$5.qId(), (Fiber<BoxedUnit>)fiber$1));
    }

    private static final Object doRun$$anonfun$2(String jobType$1) {
        return "Unsupported jobType: " + jobType$1;
    }

    private static final Object doRun$$anonfun$3() {
        return "Missing jobType";
    }

    private static final String doJobTimeout$$anonfun$1() {
        return "job timeout";
    }

    private static final void doJobTimeout$$anonfun$2$$anonfun$1$$anonfun$1(Document doc$3) {
        QueueEvent$.MODULE$.addEvent((QueueEvent.QueueEvent)QueueEvent$JobTimeout$.MODULE$, doc$3);
    }

    private final Status doCancel$$anonfun$1() {
        return (Status)this.status().get();
    }

    private final Object doCancel$$anonfun$2$$anonfun$1$$anonfun$1(String qId$4) {
        return this.engineId + " Cancelled " + qId$4;
    }

    private static final void doComplete$$anonfun$1$$anonfun$1(Payload req$8) {
        QueueEvent$.MODULE$.addEvent(QueueEvent$Completed$.MODULE$, req$8.qId(), req$8.doc());
    }

    private final String doFail$$anonfun$1(String msg$5) {
        return "Job failed, status=" + this.status().get() + ". " + msg$5;
    }

    private static final void doFail$$anonfun$2$$anonfun$1$$anonfun$1(Document doc$6) {
        QueueEvent$.MODULE$.addEvent((QueueEvent.QueueEvent)QueueEvent$Failed$.MODULE$, doc$6);
    }

    private final Option doFailEx$$anonfun$1() {
        return this.getCurrentQId();
    }

    private static final /* synthetic */ Document doFailEx$$anonfun$2$$anonfun$1$$anonfun$1(Document doc1$3, String qId) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"qId");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)qId), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        return (Document)doc1$3.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private static final Document doFailEx$$anonfun$2$$anonfun$1$$anonfun$2(Document doc1$4) {
        return doc1$4;
    }

    private static final Document doFailEx$$anonfun$2$$anonfun$1(Option optQId$2, Document doc1$1) {
        return (Document)optQId$2.map((Function1 & Serializable)qId -> QueueEngine.doFailEx$$anonfun$2$$anonfun$1$$anonfun$1(doc1$1, qId == null ? null : ((QId)qId).value())).getOrElse(() -> QueueEngine.doFailEx$$anonfun$2$$anonfun$1$$anonfun$2(doc1$1));
    }

    private final String doFailEx$$anonfun$2$$anonfun$2$$anonfun$1(Throwable ex$5) {
        return "Engine failed, status=" + this.status().get() + ". " + ex$5;
    }

    private final /* synthetic */ Task doFailEx$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(Throwable ex$7, String qId) {
        return this.manager.queue().failed(qId, "Engine failure, " + ex$7.getMessage());
    }

    private static final Task doFailEx$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2() {
        return Task$.MODULE$.unit();
    }

    private static final void doFailEx$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$1(Document doc2$3) {
        QueueEvent$.MODULE$.addEvent((QueueEvent.QueueEvent)QueueEvent$Failed$.MODULE$, doc2$3);
    }

    private static final Message doFailEx$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$2(Message msg$14) {
        return msg$14;
    }

    private static final Message doFailEx$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$1(Option optQId$7, Message msg$12) {
        return (Message)optQId$7.map((Function1 & Serializable)qId -> msg$12.withQId(qId == null ? null : ((QId)qId).value())).getOrElse(() -> QueueEngine.doFailEx$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$2(msg$12));
    }

    private final Object info$$anonfun$1$$anonfun$1(Function0 msg$16) {
        return this.engineId + " " + msg$16.apply();
    }

    private final void info$$anonfun$1(Function0 msg$15) {
        this.log().info(() -> this.info$$anonfun$1$$anonfun$1(msg$15), Line$.MODULE$.apply(211), FullName$.MODULE$.apply("ambience.queue.QueueEngine.info"));
    }

    private final Object debug$$anonfun$1$$anonfun$1(Function0 msg$18) {
        return this.engineId + " " + msg$18.apply();
    }

    private final void debug$$anonfun$1(Function0 msg$17) {
        this.log().debug(() -> this.debug$$anonfun$1$$anonfun$1(msg$17), Line$.MODULE$.apply(215), FullName$.MODULE$.apply("ambience.queue.QueueEngine.debug"));
    }

    private final Object error$$anonfun$1$$anonfun$1(Function0 msg$20) {
        return this.engineId + " " + msg$20.apply();
    }

    private final void error$$anonfun$1(Function0 msg$19) {
        this.log().error(() -> this.error$$anonfun$1$$anonfun$1(msg$19), Line$.MODULE$.apply(219), FullName$.MODULE$.apply("ambience.queue.QueueEngine.error"));
    }

    public static class Busy
    implements Status,
    Product,
    Serializable {
        private final String qId;
        private final Fiber cancelableF;

        public static Busy apply(String string, Fiber<BoxedUnit> fiber) {
            return QueueEngine$Busy$.MODULE$.apply(string, fiber);
        }

        public static Busy fromProduct(Product product) {
            return QueueEngine$Busy$.MODULE$.fromProduct(product);
        }

        public static Busy unapply(Busy busy) {
            return QueueEngine$Busy$.MODULE$.unapply(busy);
        }

        public Busy(String qId, Fiber<BoxedUnit> cancelableF) {
            this.qId = qId;
            this.cancelableF = cancelableF;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Busy)) return false;
            Busy busy = (Busy)object;
            String string = this.qId();
            String string2 = busy.qId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Fiber<BoxedUnit> fiber = this.cancelableF();
            Fiber<BoxedUnit> fiber2 = busy.cancelableF();
            if (fiber == null) {
                if (fiber2 != null) {
                    return false;
                }
            } else if (!fiber.equals(fiber2)) return false;
            if (!busy.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Busy;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Busy";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return new QId(this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "qId";
            }
            if (1 == n2) {
                return "cancelableF";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String qId() {
            return this.qId;
        }

        public Fiber<BoxedUnit> cancelableF() {
            return this.cancelableF;
        }

        public Busy copy(String qId, Fiber<BoxedUnit> cancelableF) {
            return new Busy(qId, cancelableF);
        }

        public String copy$default$1() {
            return this.qId();
        }

        public Fiber<BoxedUnit> copy$default$2() {
            return this.cancelableF();
        }

        public String _1() {
            return this.qId();
        }

        public Fiber<BoxedUnit> _2() {
            return this.cancelableF();
        }
    }

    public static final class Message
    implements Product,
    Serializable {
        private final String eventType;
        private final Option optQId;

        public static Message apply(String string, Option<String> option) {
            return QueueEngine$Message$.MODULE$.apply(string, option);
        }

        public static Message fromProduct(Product product) {
            return QueueEngine$Message$.MODULE$.fromProduct(product);
        }

        public static Message unapply(Message message) {
            return QueueEngine$Message$.MODULE$.unapply(message);
        }

        public static Option<String> $lessinit$greater$default$2() {
            return QueueEngine$Message$.MODULE$.$lessinit$greater$default$2();
        }

        public Message(String eventType, Option<String> optQId) {
            this.eventType = eventType;
            this.optQId = optQId;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Message)) return false;
            Message message = (Message)object;
            String string = this.eventType();
            String string2 = message.eventType();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<String> option = this.optQId();
            Option<String> option2 = message.optQId();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof Message;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Message";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "eventType";
            }
            if (1 == n2) {
                return "optQId";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String eventType() {
            return this.eventType;
        }

        public Option<String> optQId() {
            return this.optQId;
        }

        public String toString() {
            return this.eventType() + " " + this.optQId();
        }

        public Message withQId(String qId) {
            Some some = Some$.MODULE$.apply((Object)new QId(qId));
            String string = this.copy$default$1();
            return this.copy(string, (Option<String>)some);
        }

        public Message copy(String eventType, Option<String> optQId) {
            return new Message(eventType, optQId);
        }

        public String copy$default$1() {
            return this.eventType();
        }

        public Option<String> copy$default$2() {
            return this.optQId();
        }

        public String _1() {
            return this.eventType();
        }

        public Option<String> _2() {
            return this.optQId();
        }
    }

    public class RichOb<T> {
        private final Observable<T> ob;
        private final /* synthetic */ QueueEngine $outer;

        public RichOb(QueueEngine $outer, Observable<T> ob) {
            this.ob = ob;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public Observable<T> tap(Function1<T, BoxedUnit> fn) {
            return this.ob.mapEval(arg_0 -> QueueEngine.ambience$queue$QueueEngine$RichOb$$_$tap$$anonfun$1(fn, arg_0));
        }

        public Observable<T> tap(Function0<BoxedUnit> fn) {
            return this.ob.mapEval(arg_0 -> QueueEngine.ambience$queue$QueueEngine$RichOb$$_$tap$$anonfun$2(fn, arg_0));
        }

        public final /* synthetic */ QueueEngine ambience$queue$QueueEngine$RichOb$$$outer() {
            return this.$outer;
        }
    }

    public static interface Status {
    }
}

