/*
 * Decompiled with CFR 0.152.
 */
package ambience.queue;

import ambience.framework.EventBus$;
import ambience.queue.QId;
import ambience.queue.QueueEvent$;
import ambience.queue.QueueEvent$Cancelled$;
import ambience.queue.QueueEvent$Completed$;
import ambience.queue.QueueEvent$Deleted$;
import ambience.queue.QueueEvent$Failed$;
import ambience.queue.QueueEvent$JobTimeout$;
import ambience.queue.QueueEvent$Processing$;
import ambience.queue.QueueManager;
import ambience.queue.SystemQueueManager;
import ambience.queue.WaitTimeout;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.CancelableFuture;
import monix.execution.Scheduler$;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBoolean$;
import org.bson.BsonString;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class QueueJobHandler
implements LoggingHelper2 {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(QueueJobHandler.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(QueueJobHandler.class.getDeclaredField("cancelable$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(QueueJobHandler.class.getDeclaredField("promise$lzy1"));
    private volatile Object log$lzy1;
    private final SystemQueueManager manager;
    private final String qId;
    private final CancelableFuture watcher;
    private volatile Object promise$lzy1;
    private volatile Object cancelable$lzy1;
    private final AtomicBoolean isAdded;
    private final WaitTimeout wt;

    public QueueJobHandler(SystemQueueManager manager, String qId, long waitTimeoutAtMs) {
        this.manager = manager;
        this.qId = qId;
        this.log().info(() -> QueueJobHandler.$init$$$anonfun$1(qId), Line$.MODULE$.apply(17), FullName$.MODULE$.apply("ambience.queue.QueueJobHandler"));
        this.watcher = EventBus$.MODULE$.events().filter((Function1 & Serializable)msg -> QueueEvent$.MODULE$.qId(msg.doc()).contains((Object)new QId(qId))).mapEval((Function1 & Serializable)msg -> this.eventBusUpdate(msg.eventType(), msg.doc())).completedL().runToFuture(Scheduler$.MODULE$.global());
        this.isAdded = AtomicBoolean$.MODULE$.apply(true);
        this.wt = new WaitTimeout(this, waitTimeoutAtMs);
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String qId() {
        return this.qId;
    }

    public CancelableFuture<BoxedUnit> watcher() {
        return this.watcher;
    }

    public Promise<Document> promise() {
        Object object = this.promise$lzy1;
        if (object instanceof Promise) {
            return (Promise)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Promise)this.promise$lzyINIT1();
    }

    private Object promise$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.promise$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Promise promise = null;
                    try {
                        promise = Promise$.MODULE$.apply();
                        object2 = promise == null ? LazyVals.NullValue$.MODULE$ : promise;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.promise$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return promise;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Cancelable cancelable() {
        Object object = this.cancelable$lzy1;
        if (object instanceof Cancelable) {
            return (Cancelable)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Cancelable)this.cancelable$lzyINIT1();
    }

    private Object cancelable$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.cancelable$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Cancelable cancelable = null;
                    try {
                        cancelable = Cancelable$.MODULE$.fromPromise(this.promise(), (Throwable)new QueueManager.JobCancelledException("Job QId=" + this.qId() + " Cancelled"));
                        object2 = cancelable == null ? LazyVals.NullValue$.MODULE$ : cancelable;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.cancelable$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return cancelable;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public AtomicBoolean isAdded() {
        return this.isAdded;
    }

    public WaitTimeout wt() {
        return this.wt;
    }

    public Task<Document> run() {
        return Task$.MODULE$.deferFuture(this::run$$anonfun$1).onErrorRecoverWith((PartialFunction)new Serializable(this){
            private final /* synthetic */ QueueJobHandler $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof QueueManager.JobException) {
                    QueueManager.JobException ex = (QueueManager.JobException)throwable;
                    return true;
                }
                Throwable ex = throwable;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof QueueManager.JobException) {
                    QueueManager.JobException ex = (QueueManager.JobException)throwable;
                    return Task$.MODULE$.raiseError((Throwable)ex);
                }
                Throwable ex = throwable;
                Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"msg");
                objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)ex.getMessage()), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
                return this.$outer.doFail(Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).map(QueueJobHandler::ambience$queue$QueueJobHandler$$anon$1$$_$applyOrElse$$anonfun$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{ambience$queue$QueueJobHandler$$anon$1$$_$applyOrElse$$anonfun$1(scala.runtime.BoxedUnit )}, serializedLambda);
            }
        });
    }

    public Task<BoxedUnit> eventBusUpdate(String eventType, Document doc) {
        String string = eventType;
        String string2 = QueueEvent$Cancelled$.MODULE$.id();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return this.doCancel();
        }
        String string4 = QueueEvent$Completed$.MODULE$.id();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return this.doComplete(doc);
        }
        String string6 = QueueEvent$Deleted$.MODULE$.id();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return this.doDelete();
        }
        String string8 = QueueEvent$Processing$.MODULE$.id();
        String string9 = string;
        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
            return this.doProcessing();
        }
        String string10 = QueueEvent$JobTimeout$.MODULE$.id();
        String string11 = string;
        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
            return this.doJobTimeout();
        }
        String string12 = QueueEvent$Failed$.MODULE$.id();
        String string13 = string;
        if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
            return this.doJobFail(doc);
        }
        return Task$.MODULE$.unit();
    }

    public Task<BoxedUnit> doProcessing() {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.doProcessing$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    public Task<BoxedUnit> doCancel() {
        return this.info((Function0<String>)((Function0 & Serializable)QueueJobHandler::doCancel$$anonfun$1)).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                this.doCancel$$anonfun$2$$anonfun$1();
                return BoxedUnit.UNIT;
            }).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.removeWatcher().map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            });
        });
    }

    public Task<BoxedUnit> doComplete(Document doc) {
        return this.info((Function0<String>)((Function0 & Serializable)QueueJobHandler::doComplete$$anonfun$1)).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.removeWatcher().flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Task$.MODULE$.apply(() -> this.doComplete$$anonfun$2$$anonfun$1$$anonfun$1(doc)).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Promise promise = x$1;
                });
            });
        });
    }

    public Task<BoxedUnit> doDelete() {
        return this.info((Function0<String>)((Function0 & Serializable)QueueJobHandler::doDelete$$anonfun$1)).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.removeWatcher().flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Task$.MODULE$.apply(this::doDelete$$anonfun$2$$anonfun$1$$anonfun$1).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Promise promise = x$1;
                });
            });
        });
    }

    public Task<BoxedUnit> doFail(Document doc) {
        return this.info((Function0<String>)((Function0 & Serializable)QueueJobHandler::doFail$$anonfun$1)).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.removeWatcher().flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.manager.queue().failed(this.qId(), "QueueJobHandler failure").flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return Task$.MODULE$.apply(() -> QueueJobHandler.doFail$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(doc)).flatMap((Function1 & Serializable)msg -> Task$.MODULE$.raiseError((Throwable)new QueueManager.JobFailedException("Job Failed qId=" + this.qId() + ", msg=" + msg)).void().map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }));
                });
            });
        });
    }

    public Task<BoxedUnit> doJobTimeout() {
        return this.info((Function0<String>)((Function0 & Serializable)QueueJobHandler::doJobTimeout$$anonfun$1)).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.removeWatcher().flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Task$.MODULE$.apply(this::doJobTimeout$$anonfun$2$$anonfun$1$$anonfun$1).flatMap((Function1 & Serializable)success -> this.doJobTimeout$$anonfun$2$$anonfun$1$$anonfun$2(BoxesRunTime.unboxToBoolean((Object)success)));
            });
        });
    }

    public Task<BoxedUnit> doWaitTimeout() {
        return this.info((Function0<String>)((Function0 & Serializable)QueueJobHandler::doWaitTimeout$$anonfun$1)).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.manager.queue().waitTimeout(this.qId()).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Task$.MODULE$.apply(this::doWaitTimeout$$anonfun$2$$anonfun$1$$anonfun$1).flatMap((Function1 & Serializable)success -> this.doWaitTimeout$$anonfun$2$$anonfun$1$$anonfun$2(BoxesRunTime.unboxToBoolean((Object)success)));
            });
        });
    }

    public Task<BoxedUnit> doJobFail(Document doc) {
        return this.info((Function0<String>)((Function0 & Serializable)QueueJobHandler::doJobFail$$anonfun$1)).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.removeWatcher().flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Task$.MODULE$.apply(() -> QueueJobHandler.doJobFail$$anonfun$2$$anonfun$1$$anonfun$1(doc)).flatMap((Function1 & Serializable)msg -> Task$.MODULE$.apply(() -> this.doJobFail$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(msg)).flatMap((Function1 & Serializable)success -> this.doJobFail$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2(BoxesRunTime.unboxToBoolean((Object)success))));
            });
        });
    }

    public Task<BoxedUnit> error(Function0<String> msg, Throwable ex) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.error$$anonfun$1(msg, ex);
            return BoxedUnit.UNIT;
        });
    }

    public Task<BoxedUnit> info(Function0<String> msg) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.info$$anonfun$1(msg);
            return BoxedUnit.UNIT;
        });
    }

    public Task<BoxedUnit> debug(Function0<String> msg) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.debug$$anonfun$1(msg);
            return BoxedUnit.UNIT;
        });
    }

    public Task<BoxedUnit> removeWatcher() {
        return this.wt().cancelT().map((Function1)(JProcedure1 & Serializable)_$4 -> this.watcher().cancel());
    }

    private static final Object $init$$$anonfun$1(String qId$1) {
        return "QueueJobHandler created " + new QId(qId$1);
    }

    private final Future run$$anonfun$1() {
        return this.promise().future();
    }

    public static final /* synthetic */ Document ambience$queue$QueueJobHandler$$anon$1$$_$applyOrElse$$anonfun$1(BoxedUnit _$1) {
        return Document$.MODULE$.apply();
    }

    private final void doProcessing$$anonfun$1() {
        this.isAdded().set(false);
    }

    private static final String doCancel$$anonfun$1() {
        return "Job Cancel received";
    }

    private final void doCancel$$anonfun$2$$anonfun$1() {
        this.cancelable().cancel();
    }

    private static final String doComplete$$anonfun$1() {
        return "Completed received";
    }

    private final Promise doComplete$$anonfun$2$$anonfun$1$$anonfun$1(Document doc$3) {
        return this.promise().success((Object)doc$3);
    }

    private static final String doDelete$$anonfun$1() {
        return "Deleted received";
    }

    private final Promise doDelete$$anonfun$2$$anonfun$1$$anonfun$1() {
        return this.promise().failure((Throwable)new QueueManager.JobDeletedException("Job qId=" + this.qId() + " Deleted "));
    }

    private static final String doFail$$anonfun$1() {
        return "Failed received";
    }

    private static final String doFail$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2() {
        return "";
    }

    private static final String doFail$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(Document doc$7) {
        return (String)doc$7.get("msg", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$2 -> _$2.getValue()).getOrElse(QueueJobHandler::doFail$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2);
    }

    private static final String doJobTimeout$$anonfun$1() {
        return "JobTimeout received";
    }

    private final boolean doJobTimeout$$anonfun$2$$anonfun$1$$anonfun$1() {
        return this.promise().tryFailure((Throwable)new QueueManager.JobTimeoutException("Job Timeout qId=" + this.qId()));
    }

    private static final String doJobTimeout$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(boolean success$1) {
        return "JobTimeout fail promise=" + success$1;
    }

    private final /* synthetic */ Task doJobTimeout$$anonfun$2$$anonfun$1$$anonfun$2(boolean success) {
        return this.debug((Function0<String>)((Function0 & Serializable)() -> QueueJobHandler.doJobTimeout$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(success))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
    }

    private static final String doWaitTimeout$$anonfun$1() {
        return "WaitTimeout received";
    }

    private final boolean doWaitTimeout$$anonfun$2$$anonfun$1$$anonfun$1() {
        return this.promise().tryFailure((Throwable)new QueueManager.WaitTimeoutException("WaitTimeout qId=" + this.qId()));
    }

    private static final String doWaitTimeout$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(boolean success$2) {
        return "WaitTimeout fail promise=" + success$2;
    }

    private final /* synthetic */ Task doWaitTimeout$$anonfun$2$$anonfun$1$$anonfun$2(boolean success) {
        return this.debug((Function0<String>)((Function0 & Serializable)() -> QueueJobHandler.doWaitTimeout$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(success))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
    }

    private static final String doJobFail$$anonfun$1() {
        return "Job Failed received";
    }

    private static final String doJobFail$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2() {
        return "";
    }

    private static final String doJobFail$$anonfun$2$$anonfun$1$$anonfun$1(Document doc$10) {
        return (String)doc$10.get("msg", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$3 -> _$3.getValue()).getOrElse(QueueJobHandler::doJobFail$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2);
    }

    private final boolean doJobFail$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(String msg$1) {
        return this.promise().tryFailure((Throwable)new QueueManager.JobFailedException("Job Failed qId=" + this.qId() + ", msg=" + msg$1));
    }

    private static final String doJobFail$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(boolean success$3) {
        return "Job Failed fail promise=" + success$3;
    }

    private final /* synthetic */ Task doJobFail$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2(boolean success) {
        return this.debug((Function0<String>)((Function0 & Serializable)() -> QueueJobHandler.doJobFail$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(success))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
    }

    private final Object error$$anonfun$1$$anonfun$1(Function0 msg$3) {
        return new QId(this.qId()) + " " + msg$3.apply();
    }

    private final void error$$anonfun$1(Function0 msg$2, Throwable ex$1) {
        this.log().error(() -> this.error$$anonfun$1$$anonfun$1(msg$2), ex$1, Line$.MODULE$.apply(122), FullName$.MODULE$.apply("ambience.queue.QueueJobHandler.error"));
    }

    private final Object info$$anonfun$1$$anonfun$1(Function0 msg$5) {
        return new QId(this.qId()) + " " + msg$5.apply();
    }

    private final void info$$anonfun$1(Function0 msg$4) {
        this.log().info(() -> this.info$$anonfun$1$$anonfun$1(msg$4), Line$.MODULE$.apply(126), FullName$.MODULE$.apply("ambience.queue.QueueJobHandler.info"));
    }

    private final Object debug$$anonfun$1$$anonfun$1(Function0 msg$7) {
        return new QId(this.qId()) + " " + msg$7.apply();
    }

    private final void debug$$anonfun$1(Function0 msg$6) {
        this.log().debug(() -> this.debug$$anonfun$1$$anonfun$1(msg$6), Line$.MODULE$.apply(130), FullName$.MODULE$.apply("ambience.queue.QueueJobHandler.debug"));
    }
}

