/*
 * Decompiled with CFR 0.152.
 */
package ambience.session;

import ambience.agenda.AmbienceAgenda;
import ambience.module.ProjectConfig;
import ambience.module.UserDB;
import ambience.module.UserDB$RoleIdName$;
import ambience.module.UserDB$User$;
import ambience.session.HourlyClean;
import ambience.session.SessionManager;
import ambience.session.SessionManager$SessionId$;
import ambience.sso.client.ClientModel;
import ambience.util.DBHelper$;
import ambience.util.ONConverter$;
import com.elixirtech.arch.Clock;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.MongoDB;
import com.elixirtech.mongodb.RichMongoCollection;
import com.mongodb.client.result.InsertOneResult;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonDateTime;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonObjectId$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Updates$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple3$;
import scala.Tuple6$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class SessionManagerImpl
implements SessionManager,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SessionManagerImpl.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final Clock clock;
    private final ProjectConfig projectConfig;
    private final AmbienceAgenda agenda;
    private final ExecutionContext exeCxt;
    private final RichMongoCollection sessions;
    private final RichMongoCollection users;
    private final boolean enforceSingleSession;
    private final HourlyClean hourlyClean;

    public SessionManagerImpl(Clock clock, ProjectConfig projectConfig, MongoDB mongoDB, AmbienceAgenda agenda) {
        this.clock = clock;
        this.projectConfig = projectConfig;
        this.agenda = agenda;
        this.exeCxt = mongoDB.sysConfig().exeCxt();
        this.sessions = com.elixirtech.mongodb.package$.MODULE$.enrichDatabase(mongoDB.database()).getRichCollection("Sessions");
        this.users = com.elixirtech.mongodb.package$.MODULE$.enrichDatabase(mongoDB.database()).getRichCollection("Users");
        this.enforceSingleSession = projectConfig.WebEnforceSingleSession();
        this.hourlyClean = new HourlyClean(this);
        DBHelper$.MODULE$.setExpireAtIndex(this.sessions(), "expiresAt", projectConfig.SessionCleanerExpiry());
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Clock clock() {
        return this.clock;
    }

    public AmbienceAgenda agenda() {
        return this.agenda;
    }

    public ExecutionContext exeCxt() {
        return this.exeCxt;
    }

    public RichMongoCollection sessions() {
        return this.sessions;
    }

    public RichMongoCollection users() {
        return this.users;
    }

    public boolean enforceSingleSession() {
        return this.enforceSingleSession;
    }

    public HourlyClean hourlyClean() {
        return this.hourlyClean;
    }

    @Override
    public Task<String> createSession(ClientModel.RequestInfo requestInfo, UserDB.User user) {
        Task task;
        String uuid = UUID.randomUUID().toString();
        if (this.enforceSingleSession()) {
            Bson thisUser = Filters$.MODULE$.eq("id", (Object)BsonString$.MODULE$.apply(user.id()));
            Bson expireNow = Updates$.MODULE$.set("expiresAt", (Object)BsonDateTime$.MODULE$.apply(this.clock().now()));
            Bson forcedClose = Updates$.MODULE$.set("forcedExpiryBy", (Object)BsonString$.MODULE$.apply(uuid));
            Bson updates = Updates$.MODULE$.combine((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{expireNow, forcedClose}));
            task = this.sessions().updateManyT(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{thisUser, this.laterThanNow()})), updates).map((Function1)(JProcedure1 & Serializable)reply -> {
                if (reply.getModifiedCount() > 0L) {
                    this.log().info(() -> SessionManagerImpl.$anonfun$1$$anonfun$1(user), Line$.MODULE$.apply(58), FullName$.MODULE$.apply("ambience.session.SessionManagerImpl.fr"));
                    return;
                }
            });
        } else {
            task = Task$.MODULE$.unit();
        }
        Task fr = task;
        BsonDateTime now = BsonDateTime$.MODULE$.apply(this.clock().now());
        UserDB.User user2 = (UserDB.User)io.circe.syntax.package$.MODULE$.EncoderOps((Object)user);
        String string = "id";
        String string2 = "name";
        String string3 = "email";
        String string4 = "roles";
        String string5 = "privileges";
        String string6 = "enabled";
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[4];
        String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)BsonString$.MODULE$.apply(uuid)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)"requestIP");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (Object)BsonString$.MODULE$.apply(requestInfo.requestIP())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string9 = (String)Predef$.MODULE$.ArrowAssoc((Object)"createdAt");
        objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string9, (Object)now), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string10 = (String)Predef$.MODULE$.ArrowAssoc((Object)"expiresAt");
        objectArray[3] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string10, (Object)BsonDateTime$.MODULE$.apply(this.expiresAt())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        Document sessionDoc = (Document)Document$.MODULE$.apply(package.EncoderOps$.MODULE$.asJson$extension((Object)user2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(SessionManagerImpl::$anonfun$2, package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default())))).noSpaces()).updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return fr.flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.sessions().insertOneT(sessionDoc).flatMap((Function1 & Serializable)x$12 -> {
                InsertOneResult insertOneResult = x$12;
                return this.updateLastLogin(user, now).map((Function1 & Serializable)x$1 -> new SessionManager.SessionId(SessionManagerImpl.createSession$$anonfun$1$$anonfun$1$$anonfun$1(uuid, x$1)));
            });
        });
    }

    public Task<BoxedUnit> updateLastLogin(UserDB.User user, BsonDateTime now) {
        return this.users().updateOneT(Filters$.MODULE$.eq("_id", (Object)BsonObjectId$.MODULE$.apply(user.id())), Updates$.MODULE$.set("lastLogin", (Object)now)).map((Function1)(JProcedure1 & Serializable)_$1 -> {});
    }

    @Override
    public Task<Option<UserDB.User>> getSession(String sid) {
        return this.sessions().findO(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{this.withId(sid), this.laterThanNow()}))).firstOptionL().map((Function1 & Serializable)optDoc -> optDoc.flatMap((Function1 & Serializable)doc -> {
            Json json = ONConverter$.MODULE$.bsonToRelaxedJson((Document)doc);
            String string = "id";
            String string2 = "name";
            String string3 = "email";
            String string4 = "roles";
            String string5 = "privileges";
            String string6 = "enabled";
            int size = 6;
            Either either = json.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("User", SessionManagerImpl::getSession$$anonfun$1$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), SessionManagerImpl::getSession$$anonfun$1$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(SessionManagerImpl::getSession$$anonfun$1$$anonfun$1$$anonfun$3)))));
            if (either instanceof Right) {
                UserDB.User user = (UserDB.User)((Right)either).value();
                return Some$.MODULE$.apply((Object)user);
            }
            if (either instanceof Left) {
                DecodingFailure err = (DecodingFailure)((Left)either).value();
                this.log().warn(() -> SessionManagerImpl.getSession$$anonfun$1$$anonfun$1$$anonfun$4(json, err), Line$.MODULE$.apply(88), FullName$.MODULE$.apply("ambience.session.SessionManagerImpl.getSession"));
                return None$.MODULE$;
            }
            throw new MatchError((Object)either);
        }));
    }

    @Override
    public Task<Object> bumpSession(String sid) {
        long newTime = this.expiresAt();
        Bson bump = Updates$.MODULE$.set("expiresAt", (Object)BsonDateTime$.MODULE$.apply(newTime));
        Task ret = this.sessions().updateOneT(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{this.withId(sid), this.laterThanNow()})), bump).map((Function1 & Serializable)_$2 -> _$2.getModifiedCount() == 1L);
        return ret.map((Function1 & Serializable)b -> SessionManagerImpl.bumpSession$$anonfun$1(newTime, BoxesRunTime.unboxToBoolean((Object)b)));
    }

    @Override
    public Task<BoxedUnit> logout(String sid) {
        Bson reset = Updates$.MODULE$.currentDate("expiresAt");
        return this.sessions().updateOneT(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{this.withId(sid), this.laterThanNow()})), reset).map((Function1)(JProcedure1 & Serializable)_$3 -> {});
    }

    @Override
    public Task<BoxedUnit> deleteSession(String sid) {
        return this.sessions().deleteOneT(this.withId(sid)).map((Function1)(JProcedure1 & Serializable)_$4 -> {});
    }

    @Override
    public Task<Object> getActiveSessionCount() {
        return this.sessions().countDocumentsT(this.laterThanNow()).map((Function1)(JFunction1.mcIJ.sp & Serializable)_$5 -> (int)_$5);
    }

    private Bson withId(String sid) {
        return Filters$.MODULE$.eq("_id", (Object)BsonString$.MODULE$.apply(sid));
    }

    private long expiresAt() {
        return this.clock().now() + this.projectConfig.WebSessionTimeout();
    }

    private Bson laterThanNow() {
        return Filters$.MODULE$.gt("expiresAt", (Object)BsonDateTime$.MODULE$.apply(this.clock().now()));
    }

    private static final Object $anonfun$1$$anonfun$1(UserDB.User user$2) {
        return "Enforcing single session for " + user$2.name() + " by terminating existing sessions";
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$3() {
        Encoder encodeA;
        void var3_2;
        void var1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA = Encoder$.MODULE$.encodeBoolean();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$2() {
        Encoder encodeA;
        Encoder.AsArray encodeA2;
        Encoder.AsArray encodeA3;
        Encoder encodeA4;
        void var3_2;
        void var1;
        Encoder encodeA5 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA6 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA4 = Encoder$.MODULE$.encodeString();
        String string = "id";
        String string2 = "name";
        String string3 = "enabled";
        Encoder.AsArray asArray = encodeA3 = Encoder$.MODULE$.encodeSet(Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(SessionManagerImpl::$anonfun$3, package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
        Encoder.AsArray asArray2 = encodeA2 = Encoder$.MODULE$.encodeSet(Encoder$.MODULE$.encodeString());
        Encoder encoder2 = encodeA = Encoder$.MODULE$.encodeBoolean();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder2).$colon$colon((Object)asArray2).$colon$colon((Object)asArray).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final /* synthetic */ String createSession$$anonfun$1$$anonfun$1$$anonfun$1(String uuid$3, BoxedUnit x$1) {
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return SessionManager$SessionId$.MODULE$.apply(uuid$3);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$4() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeBoolean();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 $anonfun$5() {
        UserDB$RoleIdName$ userDB$RoleIdName$ = UserDB$RoleIdName$.MODULE$;
        return (Function1 & Serializable)p -> (UserDB.RoleIdName)userDB$RoleIdName$.fromProduct((Product)p);
    }

    private static final Product $anonfun$6() {
        return Tuple3$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private static final List getSession$$anonfun$1$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        void var3_2;
        void var1;
        Decoder decodeA5 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA6 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA4 = Decoder$.MODULE$.decodeString();
        String string = "id";
        String string2 = "name";
        String string3 = "enabled";
        int size = 3;
        Decoder decoder2 = decodeA3 = Decoder$.MODULE$.decodeSet(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("RoleIdName", SessionManagerImpl::$anonfun$4, package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), SessionManagerImpl::$anonfun$5, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(SessionManagerImpl::$anonfun$6)))));
        Decoder decoder3 = decodeA2 = Decoder$.MODULE$.decodeSet(Decoder$.MODULE$.decodeString());
        Decoder decoder4 = decodeA = Decoder$.MODULE$.decodeBoolean();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 getSession$$anonfun$1$$anonfun$1$$anonfun$2() {
        UserDB$User$ userDB$User$ = UserDB$User$.MODULE$;
        return (Function1 & Serializable)p -> (UserDB.User)userDB$User$.fromProduct((Product)p);
    }

    private static final Product getSession$$anonfun$1$$anonfun$1$$anonfun$3() {
        return Tuple6$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private static final Object getSession$$anonfun$1$$anonfun$1$$anonfun$4(Json json$1, DecodingFailure err$1) {
        return "Cant parse session data " + json$1.noSpaces() + ": " + err$1;
    }

    private static final /* synthetic */ long bumpSession$$anonfun$1(long newTime$1, boolean b) {
        if (b) {
            return newTime$1;
        }
        return 0L;
    }
}

