/*
 * Decompiled with CFR 0.152.
 */
package better.files;

import better.files.Dispose;
import better.files.File;
import better.files.File$Attributes$;
import better.files.File$CopyOptions$;
import better.files.File$Events$;
import better.files.File$LinkOptions$;
import better.files.File$OpenOptions$;
import better.files.File$Order$;
import better.files.File$PathMatcherSyntax$;
import better.files.File$RandomAccessMode$;
import better.files.File$VisitOptions$;
import better.files.package$;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.management.ObjectName;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Properties$;

public final class File$
implements Serializable {
    public static final File$Attributes$ Attributes;
    public static final File$CopyOptions$ CopyOptions;
    public static final File$Events$ Events;
    public static final File$OpenOptions$ OpenOptions;
    public static final File$LinkOptions$ LinkOptions;
    public static final File$VisitOptions$ VisitOptions;
    public static final File$Order$ Order;
    public static final File$PathMatcherSyntax$ PathMatcherSyntax;
    public static final File$RandomAccessMode$ RandomAccessMode;
    public static final File$ MODULE$;

    private File$() {
    }

    static {
        MODULE$ = new File$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(File$.class);
    }

    private FileSystem $lessinit$greater$default$2(Path path) {
        return path.getFileSystem();
    }

    public File newTemporaryDirectory(String prefix, Option<File> parent, Seq<FileAttribute<?>> attributes) {
        Option<File> option = parent;
        if (option instanceof Some) {
            File dir = (File)((Some)option).value();
            return this.apply(Files.createTempDirectory(dir.path(), prefix, (FileAttribute[])Arrays$.MODULE$.seqToArray(attributes, FileAttribute.class)));
        }
        return this.apply(Files.createTempDirectory(prefix, (FileAttribute[])Arrays$.MODULE$.seqToArray(attributes, FileAttribute.class)));
    }

    public String newTemporaryDirectory$default$1() {
        return "";
    }

    public Option<File> newTemporaryDirectory$default$2() {
        return None$.MODULE$;
    }

    public Seq<FileAttribute<?>> newTemporaryDirectory$default$3(String prefix, Option<File> parent) {
        return File$Attributes$.MODULE$.default();
    }

    public Dispose<File> temporaryDirectory(String prefix, Option<File> parent, Seq<FileAttribute<?>> attributes) {
        return this.newTemporaryDirectory(prefix, parent, attributes).toTemporary();
    }

    public String temporaryDirectory$default$1() {
        return "";
    }

    public Option<File> temporaryDirectory$default$2() {
        return None$.MODULE$;
    }

    public Seq<FileAttribute<?>> temporaryDirectory$default$3() {
        return File$Attributes$.MODULE$.default();
    }

    public <U> void usingTemporaryDirectory(String prefix, Option<File> parent, Seq<FileAttribute<?>> attributes, Function1<File, U> f) {
        this.temporaryDirectory(prefix, parent, attributes).foreach(f);
    }

    public <U> String usingTemporaryDirectory$default$1() {
        return "";
    }

    public <U> Option<File> usingTemporaryDirectory$default$2() {
        return None$.MODULE$;
    }

    public <U> Seq<FileAttribute<?>> usingTemporaryDirectory$default$3() {
        return File$Attributes$.MODULE$.default();
    }

    public File newTemporaryFile(String prefix, String suffix, Option<File> parent, Seq<FileAttribute<?>> attributes) {
        Option<File> option = parent;
        if (option instanceof Some) {
            File dir = (File)((Some)option).value();
            return this.apply(Files.createTempFile(dir.path(), prefix, suffix, (FileAttribute[])Arrays$.MODULE$.seqToArray(attributes, FileAttribute.class)));
        }
        return this.apply(Files.createTempFile(prefix, suffix, (FileAttribute[])Arrays$.MODULE$.seqToArray(attributes, FileAttribute.class)));
    }

    public String newTemporaryFile$default$1() {
        return "";
    }

    public String newTemporaryFile$default$2() {
        return "";
    }

    public Option<File> newTemporaryFile$default$3() {
        return None$.MODULE$;
    }

    public Seq<FileAttribute<?>> newTemporaryFile$default$4(String prefix, String suffix, Option<File> parent) {
        return File$Attributes$.MODULE$.default();
    }

    public <U> Dispose<File> temporaryFile(String prefix, String suffix, Option<File> parent, Seq<FileAttribute<?>> attributes) {
        return this.newTemporaryFile(prefix, suffix, parent, attributes).toTemporary();
    }

    public <U> String temporaryFile$default$1() {
        return "";
    }

    public <U> String temporaryFile$default$2() {
        return "";
    }

    public <U> Option<File> temporaryFile$default$3() {
        return None$.MODULE$;
    }

    public <U> Seq<FileAttribute<?>> temporaryFile$default$4() {
        return File$Attributes$.MODULE$.default();
    }

    public <U> void usingTemporaryFile(String prefix, String suffix, Option<File> parent, Seq<FileAttribute<?>> attributes, Function1<File, U> f) {
        this.temporaryFile(prefix, suffix, parent, attributes).foreach(f);
    }

    public <U> String usingTemporaryFile$default$1() {
        return "";
    }

    public <U> String usingTemporaryFile$default$2() {
        return "";
    }

    public <U> Option<File> usingTemporaryFile$default$3() {
        return None$.MODULE$;
    }

    public <U> Seq<FileAttribute<?>> usingTemporaryFile$default$4() {
        return File$Attributes$.MODULE$.default();
    }

    public File apply(Path path) {
        Path path2 = path.toAbsolutePath().normalize();
        return new File(path2, this.$lessinit$greater$default$2(path2));
    }

    public File apply(String path, Seq<String> fragments) {
        return this.apply(Paths.get(path, (String[])Arrays$.MODULE$.seqToArray(fragments, String.class)));
    }

    public File apply(File anchor, String path, Seq<String> fragments) {
        Path p = Paths.get(path, (String[])Arrays$.MODULE$.seqToArray(fragments, String.class));
        if (p.isAbsolute()) {
            return this.apply(p);
        }
        if (anchor.isDirectory(anchor.isDirectory$default$1())) {
            return anchor.$div(p.toString());
        }
        return anchor.parent().$div(p.toString());
    }

    public File apply(URL url) {
        return this.apply(url.toURI());
    }

    public File apply(URI uri) {
        Predef$.MODULE$.require(package$.MODULE$.URIExtensions(uri).isFile(), () -> this.apply$$anonfun$1(uri));
        return this.apply(Paths.get(uri));
    }

    public Iterable<File> roots() {
        return (Iterable)((IterableOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(FileSystems.getDefault().getRootDirectories()).asScala()).map((Function1 & Serializable)path -> this.apply((Path)path));
    }

    public File root() {
        return (File)this.roots().head();
    }

    public File home() {
        return package$.MODULE$.StringExtensions(Properties$.MODULE$.userHome()).toFile();
    }

    public File temp() {
        return package$.MODULE$.StringExtensions(Properties$.MODULE$.tmpDir()).toFile();
    }

    public File currentWorkingDirectory() {
        return this.apply("", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
    }

    public long numberOfOpenFileDescriptors() {
        return BoxesRunTime.unboxToLong((Object)ManagementFactory.getPlatformMBeanServer().getAttribute(new ObjectName("java.lang:type=OperatingSystem"), "OpenFileDescriptorCount"));
    }

    private final Object apply$$anonfun$1(URI uri$1) {
        return new StringBuilder(12).append("Not a file: ").append(uri$1).toString();
    }
}

