/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.webserver;

import com.elixirtech.arch.DataBytes;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$Header$;
import com.elixirtech.gravity.Gravity$Headers$;
import com.elixirtech.gravity.Gravity$Status$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public class ETagHandler
implements Function1<GravityRequest, Task<GravityResponse>> {
    private final Function1<GravityRequest, Task<GravityResponse>> inner;
    private final String quotedEtag;
    private final Gravity.Header etagHeader;
    private final GravityResponse NotModified;

    public ETagHandler(String etag, Function1<GravityRequest, Task<GravityResponse>> inner) {
        this.inner = inner;
        this.quotedEtag = "\"" + etag + "\"";
        this.etagHeader = Gravity$Header$.MODULE$.apply("Etag", this.quotedEtag());
        this.NotModified = GravityResponse$.MODULE$.apply(Gravity$Status$.MODULE$.NotModified(), Gravity$Headers$.MODULE$.apply((Seq<Gravity.Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{this.etagHeader()})), GravityResponse$.MODULE$.$lessinit$greater$default$3());
    }

    public String quotedEtag() {
        return this.quotedEtag;
    }

    public Gravity.Header etagHeader() {
        return this.etagHeader;
    }

    public GravityResponse NotModified() {
        return this.NotModified;
    }

    public Task<GravityResponse> apply(GravityRequest request) {
        String header;
        Option<String> option = request.headers().get("If-None-Match");
        if (option instanceof Some && (header = (String)((Some)option).value()).contains(this.quotedEtag())) {
            return Task$.MODULE$.now((Object)this.NotModified());
        }
        return ((Task)this.inner.apply((Object)request)).map((Function1 & Serializable)response -> {
            Gravity.Headers headers = response.headers().$plus(this.etagHeader());
            int n = response.copy$default$1();
            DataBytes dataBytes = response.copy$default$3();
            return response.copy(n, headers, dataBytes);
        });
    }
}

