/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.webserver;

import com.elixirtech.arch.package$;
import com.elixirtech.webserver.FileWebTree$CacheKey$;
import com.elixirtech.webserver.I18N;
import com.elixirtech.webserver.I18N$;
import com.elixirtech.webserver.I18NFile$;
import com.elixirtech.webserver.WebTree;
import com.elixirtech.webserver.WebTree$FileInfo$;
import java.io.File;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOps;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class FileWebTree
implements WebTree {
    private final File webRootDir;
    private final String basePath;
    private final HashMap<CacheKey, WebTree.FileInfo> cache;

    public FileWebTree(File webRootDir) {
        this.webRootDir = webRootDir;
        this.basePath = webRootDir.getAbsolutePath();
        this.cache = new HashMap();
    }

    public String basePath() {
        return this.basePath;
    }

    @Override
    public boolean exists(String name) {
        return this.file(name, I18N$.MODULE$.EmptyLanguage()).isDefined();
    }

    @Override
    public Option<String> content(String name, String language) {
        CacheKey cacheKey = FileWebTree$CacheKey$.MODULE$.apply(name, language);
        return this.file(name, language).map((Function1 & Serializable)f -> {
            Option option = this.cache.get((Object)cacheKey);
            if (option instanceof Some) {
                WebTree.FileInfo fileInfo = (WebTree.FileInfo)((Some)option).value();
                if (f.lastModified() > fileInfo.ts()) {
                    WebTree.FileInfo fInfo = WebTree$FileInfo$.MODULE$.apply(f.lastModified(), package$.MODULE$.enrichFile(f).text());
                    this.cache.put((Object)cacheKey, (Object)fInfo);
                    return fInfo.content();
                }
                return fileInfo.content();
            }
            if (None$.MODULE$.equals(option)) {
                WebTree.FileInfo fInfo = WebTree$FileInfo$.MODULE$.apply(f.lastModified(), package$.MODULE$.enrichFile(f).text());
                this.cache.put((Object)cacheKey, (Object)fInfo);
                return fInfo.content();
            }
            throw new MatchError((Object)option);
        });
    }

    private Option<File> file(String name, String language) {
        return ((IterableOps)I18NFile$.MODULE$.apply(name, language).view().flatMap((Function1 & Serializable)path -> this.asFile((String)path))).headOption();
    }

    private Option<File> asFile(String path) {
        File src = new File(this.webRootDir, path);
        if (src.isFile() && src.getAbsolutePath().startsWith(this.basePath())) {
            return Some$.MODULE$.apply((Object)src);
        }
        return None$.MODULE$;
    }

    public static final class CacheKey
    implements Product,
    Serializable {
        private final String name;
        private final String language;

        public static CacheKey apply(String string, String string2) {
            return FileWebTree$CacheKey$.MODULE$.apply(string, string2);
        }

        public static CacheKey fromProduct(Product product) {
            return FileWebTree$CacheKey$.MODULE$.fromProduct(product);
        }

        public static CacheKey unapply(CacheKey cacheKey) {
            return FileWebTree$CacheKey$.MODULE$.unapply(cacheKey);
        }

        public CacheKey(String name, String language) {
            this.name = name;
            this.language = language;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CacheKey)) return false;
            CacheKey cacheKey = (CacheKey)object;
            String string = this.name();
            String string2 = cacheKey.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.language();
            String string4 = cacheKey.language();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CacheKey;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "CacheKey";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return new I18N.Language(this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "name";
            }
            if (1 == n2) {
                return "language";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public String language() {
            return this.language;
        }

        public CacheKey copy(String name, String language) {
            return new CacheKey(name, language);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.language();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.language();
        }
    }
}

