/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.webserver;

import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.webserver.I18N;
import com.elixirtech.webserver.I18N$Language$;
import com.elixirtech.webserver.I18N$Preference$;
import com.elixirtech.webserver.RTL$;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.concurrent.Map;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;

public final class I18N$
implements LoggingHelper2,
Serializable {
    private volatile Object log$lzy1;
    public static final I18N$Language$ Language;
    public static final I18N$Preference$ Preference;
    private static final String EmptyLanguage;
    private static final I18N.Preference Default;
    private static final Map<Option<String>, String> alCache;
    private volatile Object EmptyResourceBundle$lzy1;
    private static final Map<String, I18N> i18nCache;
    public static final I18N$ MODULE$;

    private I18N$() {
    }

    static {
        MODULE$ = new I18N$();
        EmptyLanguage = I18N$Language$.MODULE$.apply("");
        Default = I18N$Preference$.MODULE$.apply(MODULE$.EmptyLanguage(), 0.0f);
        alCache = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        i18nCache = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, I18N.OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, I18N.OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, I18N.OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, I18N.OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(I18N$.class);
    }

    public String EmptyLanguage() {
        return EmptyLanguage;
    }

    public ResourceBundle EmptyResourceBundle() {
        Object object = this.EmptyResourceBundle$lzy1;
        if (object instanceof ResourceBundle) {
            return (ResourceBundle)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ResourceBundle)this.EmptyResourceBundle$lzyINIT1();
    }

    private Object EmptyResourceBundle$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.EmptyResourceBundle$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, I18N.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ResourceBundle resourceBundle = null;
                    try {
                        resourceBundle = new ResourceBundle(this){
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                            }

                            public Object handleGetObject(String key) {
                                return null;
                            }

                            public Enumeration getKeys() {
                                return new Enumeration<String>(){

                                    public boolean hasMoreElements() {
                                        return false;
                                    }

                                    public String nextElement() {
                                        throw new IllegalStateException("No elements!");
                                    }
                                };
                            }
                        };
                        object2 = resourceBundle == null ? LazyVals.NullValue$.MODULE$ : resourceBundle;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, I18N.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.EmptyResourceBundle$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, I18N.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return resourceBundle;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, I18N.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String getAcceptLanguage(GravityRequest request) {
        Object object = this.getValidElxI18N(request).getOrElse((Function0 & Serializable)() -> new I18N.Language(this.getAcceptLanguage$$anonfun$1(request)));
        if (object == null) {
            return null;
        }
        return ((I18N.Language)object).value();
    }

    public Option<String> getValidElxI18N(GravityRequest request) {
        return request.cookies().get((Object)"elx-i18n").flatMap((Function1 & Serializable)s -> this.buildLanguage(s.value()));
    }

    public Option<String> buildLanguage(String s) {
        if (StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)ch -> this.buildLanguage$$anonfun$1(BoxesRunTime.unboxToChar((Object)ch)))) {
            return Some$.MODULE$.apply((Object)new I18N.Language(I18N$Language$.MODULE$.apply(s)));
        }
        return None$.MODULE$;
    }

    public boolean isValidLangChar(char ch) {
        return Character.isDigit(ch) || Character.isLetter(ch) || ch == '-';
    }

    public PartialFunction<String, String> lookup(String lang) {
        return new PartialFunction<String, String>(lang, this){
            private final String lang$4;
            {
                this.lang$4 = lang$5;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                PartialFunction.$init$((PartialFunction)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isDefinedAt(String name) {
                String string = name;
                String string2 = "i18n-dir";
                if (string == null) {
                    if (string2 == null) return true;
                } else if (string.equals(string2)) return true;
                String string3 = name;
                String string4 = "i18n-lang";
                if (string3 == null) {
                    if (string4 == null) return true;
                } else if (string3.equals(string4)) return true;
                if (!name.startsWith("i18n:")) return false;
                return true;
            }

            public String apply(String name) {
                String string = name;
                String string2 = "i18n-dir";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return I18N$.MODULE$.getDir(this.lang$4);
                }
                String string3 = name;
                String string4 = "i18n-lang";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    return this.lang$4;
                }
                return I18N$.MODULE$.com$elixirtech$webserver$I18N$$$getCache(name).getLookupMap(this.lang$4);
            }
        };
    }

    public String getDir(String lang) {
        if (RTL$.MODULE$.isRTL(lang)) {
            return "rtl";
        }
        return "ltr";
    }

    public String parseAcceptLanguage(Option<String> acceptLanguage) {
        I18N.Preference preference;
        package$.MODULE$.Ordering();
        Ordering.Float$.TotalOrdering$ ordering = Ordering.Float$.TotalOrdering$.MODULE$;
        Option<String> option = acceptLanguage;
        if (option instanceof Some) {
            String s2 = (String)((Some)option).value();
            Object object = Predef$.MODULE$.refArrayOps((Object[])s2.split(","));
            preference = (I18N.Preference)((IterableOps)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)s -> this.buildPreference((String)s), ClassTag$.MODULE$.apply(I18N.Preference.class))).toVector().sortBy((Function1 & Serializable)_$1 -> _$1.quality(), (Ordering)ordering)).lastOption().getOrElse(this::$anonfun$4);
        } else if (None$.MODULE$.equals(option)) {
            preference = Default;
        } else {
            throw new MatchError(option);
        }
        I18N.Preference pref = preference;
        return pref.language();
    }

    public Locale getLocale(String lang) {
        String string = lang;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return Locale.getDefault();
        }
        return Locale.forLanguageTag(lang);
    }

    private Option<I18N.Preference> buildPreference(String s) {
        int idx = s.indexOf(";");
        if (idx < 0) {
            return Some$.MODULE$.apply((Object)I18N$Preference$.MODULE$.apply(I18N$Language$.MODULE$.apply(s.trim()), 1.0f));
        }
        Option optQuality = com.elixirtech.arch.package$.MODULE$.richWrapper(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(s.substring(idx + 1)), "q=")).toOptFloat();
        return optQuality.map((Function1 & Serializable)quality -> this.buildPreference$$anonfun$1(s, idx, BoxesRunTime.unboxToFloat((Object)quality)));
    }

    public I18N com$elixirtech$webserver$I18N$$$getCache(String name) {
        return (I18N)i18nCache.getOrElseUpdate((Object)name, () -> this.getCache$$anonfun$1(name));
    }

    private final String getAcceptLanguage$$anonfun$1$$anonfun$1(Option acceptLanguage$1) {
        return this.parseAcceptLanguage((Option<String>)acceptLanguage$1);
    }

    private final String getAcceptLanguage$$anonfun$1(GravityRequest request$1) {
        Option<String> acceptLanguage = request$1.headers().get("Accept-Language");
        Object object = alCache.getOrElseUpdate(acceptLanguage, (Function0 & Serializable)() -> new I18N.Language(this.getAcceptLanguage$$anonfun$1$$anonfun$1(acceptLanguage)));
        if (object == null) {
            return null;
        }
        return ((I18N.Language)object).value();
    }

    private final /* synthetic */ boolean buildLanguage$$anonfun$1(char ch) {
        return this.isValidLangChar(ch);
    }

    private final I18N.Preference $anonfun$4() {
        return Default;
    }

    private final /* synthetic */ I18N.Preference buildPreference$$anonfun$1(String s$1, int idx$1, float quality) {
        return I18N$Preference$.MODULE$.apply(I18N$Language$.MODULE$.apply(s$1.substring(0, idx$1).trim()), quality);
    }

    private final I18N getCache$$anonfun$1(String name$2) {
        return new I18N(name$2);
    }
}

