/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.webserver;

import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.webserver.I18N$;
import com.elixirtech.webserver.I18N$Language$;
import com.elixirtech.webserver.I18N$Preference$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.KeyEncoder$;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class I18N {
    private final String name;
    private final List bundles;
    private final scala.collection.concurrent.Map<String, String> rbCache;
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(I18N$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(I18N$.class.getDeclaredField("EmptyResourceBundle$lzy1"));

    public static String EmptyLanguage() {
        return I18N$.MODULE$.EmptyLanguage();
    }

    public static ResourceBundle EmptyResourceBundle() {
        return I18N$.MODULE$.EmptyResourceBundle();
    }

    public static Option<String> buildLanguage(String string) {
        return I18N$.MODULE$.buildLanguage(string);
    }

    public static String getAcceptLanguage(GravityRequest gravityRequest) {
        return I18N$.MODULE$.getAcceptLanguage(gravityRequest);
    }

    public static String getDir(String string) {
        return I18N$.MODULE$.getDir(string);
    }

    public static Locale getLocale(String string) {
        return I18N$.MODULE$.getLocale(string);
    }

    public static Option<String> getValidElxI18N(GravityRequest gravityRequest) {
        return I18N$.MODULE$.getValidElxI18N(gravityRequest);
    }

    public static boolean isValidLangChar(char c) {
        return I18N$.MODULE$.isValidLangChar(c);
    }

    public static LoggingInterface log() {
        return I18N$.MODULE$.log();
    }

    public static PartialFunction<String, String> lookup(String string) {
        return I18N$.MODULE$.lookup(string);
    }

    public static String parseAcceptLanguage(Option<String> option) {
        return I18N$.MODULE$.parseAcceptLanguage(option);
    }

    public I18N(String name) {
        this.name = name;
        Predef$.MODULE$.require(name.startsWith("i18n:"), () -> I18N.$init$$$anonfun$1(name));
        Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(name), "i18n:").split(","));
        this.bundles = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)s -> "i18n/" + s, ClassTag$.MODULE$.apply(String.class))).toList();
        this.rbCache = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
    }

    public List<String> bundles() {
        return this.bundles;
    }

    public String getLookupMap(String lang) {
        return (String)this.rbCache.getOrElseUpdate((Object)new Language(lang), () -> this.getLookupMap$$anonfun$1(lang));
    }

    private String buildRBString(String lang) {
        Map fullMap = this.bundles().flatMap((Function1 & Serializable)bundle -> {
            ResourceBundle rb = this.lookupMap((String)bundle, lang);
            return (IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala(rb.keySet()).asScala().map((Function1 & Serializable)key -> {
                String string = (String)Predef$.MODULE$.ArrowAssoc(key);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)rb.getString((String)key));
            });
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Map map = (Map)package$.MODULE$.EncoderOps((Object)fullMap);
        return package.EncoderOps$.MODULE$.asJson$extension((Object)map, (Encoder)Encoder$.MODULE$.encodeMap(KeyEncoder$.MODULE$.encodeKeyString(), Encoder$.MODULE$.encodeString())).noSpaces().intern();
    }

    private ResourceBundle lookupMap(String bundleName, String lang) {
        Locale locale = I18N$.MODULE$.getLocale(lang);
        Try try_ = Try$.MODULE$.apply(() -> I18N.lookupMap$$anonfun$1(bundleName, locale));
        if (try_ instanceof Success) {
            ResourceBundle rb = (ResourceBundle)((Success)try_).value();
            return rb;
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            I18N$.MODULE$.log().error(() -> I18N.lookupMap$$anonfun$2(bundleName, lang, ex), Line$.MODULE$.apply(125), FullName$.MODULE$.apply("com.elixirtech.webserver.I18N.lookupMap"));
            return I18N$.MODULE$.EmptyResourceBundle();
        }
        throw new MatchError((Object)try_);
    }

    private static final Object $init$$$anonfun$1(String name$1) {
        return "Name " + name$1 + " must start with i18n:";
    }

    private final String getLookupMap$$anonfun$1(String lang$1) {
        return this.buildRBString(lang$1);
    }

    private static final ResourceBundle lookupMap$$anonfun$1(String bundleName$1, Locale locale$1) {
        return ResourceBundle.getBundle(bundleName$1, locale$1);
    }

    private static final Object lookupMap$$anonfun$2(String bundleName$2, String lang$3, Throwable ex$1) {
        return "Bundle error in lookupMap(" + bundleName$2 + "," + lang$3 + "): " + ex$1;
    }

    public static final class Language
    implements Product,
    Serializable {
        private final String value;

        public static String apply(String string) {
            return I18N$Language$.MODULE$.apply(string);
        }

        public static String unapply(String string) {
            return I18N$Language$.MODULE$.unapply(string);
        }

        public static String _1$extension(String string) {
            return I18N$Language$.MODULE$._1$extension(string);
        }

        public static boolean canEqual$extension(String string, Object object) {
            return I18N$Language$.MODULE$.canEqual$extension(string, object);
        }

        public static String copy$extension(String string, String string2) {
            return I18N$Language$.MODULE$.copy$extension(string, string2);
        }

        public static boolean equals$extension(String string, Object object) {
            return I18N$Language$.MODULE$.equals$extension(string, object);
        }

        public static int hashCode$extension(String string) {
            return I18N$Language$.MODULE$.hashCode$extension(string);
        }

        public static int productArity$extension(String string) {
            return I18N$Language$.MODULE$.productArity$extension(string);
        }

        public static Object productElement$extension(String string, int n) {
            return I18N$Language$.MODULE$.productElement$extension(string, n);
        }

        public static String productElementName$extension(String string, int n) {
            return I18N$Language$.MODULE$.productElementName$extension(string, n);
        }

        public static String productPrefix$extension(String string) {
            return I18N$Language$.MODULE$.productPrefix$extension(string);
        }

        public static String toString$extension(String string) {
            return I18N$Language$.MODULE$.toString$extension(string);
        }

        public static String copy$default$1$extension(String string) {
            return I18N$Language$.MODULE$.copy$default$1$extension(string);
        }

        public Language(String value) {
            this.value = value;
        }

        public int hashCode() {
            return I18N$Language$.MODULE$.hashCode$extension(this.value());
        }

        public boolean equals(Object x$0) {
            return I18N$Language$.MODULE$.equals$extension(this.value(), x$0);
        }

        public String toString() {
            return I18N$Language$.MODULE$.toString$extension(this.value());
        }

        public boolean canEqual(Object that) {
            return I18N$Language$.MODULE$.canEqual$extension(this.value(), that);
        }

        public int productArity() {
            return I18N$Language$.MODULE$.productArity$extension(this.value());
        }

        public String productPrefix() {
            return I18N$Language$.MODULE$.productPrefix$extension(this.value());
        }

        public Object productElement(int n) {
            return I18N$Language$.MODULE$.productElement$extension(this.value(), n);
        }

        public String productElementName(int n) {
            return I18N$Language$.MODULE$.productElementName$extension(this.value(), n);
        }

        public String value() {
            return this.value;
        }

        public String copy(String value) {
            return I18N$Language$.MODULE$.copy$extension(this.value(), value);
        }

        public String copy$default$1() {
            return I18N$Language$.MODULE$.copy$default$1$extension(this.value());
        }

        public String _1() {
            return I18N$Language$.MODULE$._1$extension(this.value());
        }
    }

    public static final class Preference
    implements Product,
    Serializable {
        private final String language;
        private final float quality;

        public static Preference apply(String string, float f) {
            return I18N$Preference$.MODULE$.apply(string, f);
        }

        public static Preference fromProduct(Product product) {
            return I18N$Preference$.MODULE$.fromProduct(product);
        }

        public static Preference unapply(Preference preference) {
            return I18N$Preference$.MODULE$.unapply(preference);
        }

        public Preference(String language, float quality) {
            this.language = language;
            this.quality = quality;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)new Language(this.language())));
            n = Statics.mix((int)n, (int)Statics.floatHash((float)this.quality()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Preference)) return false;
            Preference preference = (Preference)object;
            if (this.quality() != preference.quality()) return false;
            String string = this.language();
            String string2 = preference.language();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Preference;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Preference";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return new Language(this._1());
            }
            if (1 == n2) {
                return BoxesRunTime.boxToFloat((float)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "language";
            }
            if (1 == n2) {
                return "quality";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String language() {
            return this.language;
        }

        public float quality() {
            return this.quality;
        }

        public Preference copy(String language, float quality) {
            return new Preference(language, quality);
        }

        public String copy$default$1() {
            return this.language();
        }

        public float copy$default$2() {
            return this.quality();
        }

        public String _1() {
            return this.language();
        }

        public float _2() {
            return this.quality();
        }
    }
}

