/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.job;

import com.elixirtech.api.SchedulerAPI;
import com.elixirtech.api.SchedulerAPI$TriggerStatus$;
import com.elixirtech.arch.LoggingHelper;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.NamedLogger;
import com.elixirtech.arch.job.IJobLog;
import com.elixirtech.arch.job.IJobLogging;
import com.elixirtech.arch.job.JobAuthentication;
import com.elixirtech.arch.job.JobCancelled;
import com.elixirtech.arch.job.JobCancelled$;
import com.elixirtech.arch.job.JobDescription;
import com.elixirtech.arch.job.JobEnded;
import com.elixirtech.arch.job.JobEntry;
import com.elixirtech.arch.job.JobException;
import com.elixirtech.arch.job.JobException$;
import com.elixirtech.arch.job.JobLogEntry;
import com.elixirtech.arch.job.JobLogging;
import com.elixirtech.arch.job.JobRecordCount;
import com.elixirtech.arch.job.JobReference;
import com.elixirtech.arch.job.JobResult;
import com.elixirtech.arch.job.JobResultEntry;
import com.elixirtech.arch.job.JobResultUnzipped;
import com.elixirtech.arch.job.JobTimeout;
import com.elixirtech.arch.job.JobUnableToComplete;
import com.elixirtech.arch.job.JobUnableToComplete$;
import com.elixirtech.arch.job.NestedJobLogging;
import com.elixirtech.arch.job.NullJobLogging$;
import com.elixirtech.arch.util.ThrowableInfo$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;
import scala.util.DynamicVariable;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class JobLogging$
implements LoggingHelper2,
Serializable {
    private volatile Object log$lzy1;
    private static final DynamicVariable<IJobLogging> jobLogging;
    public static final JobLogging$ MODULE$;

    private JobLogging$() {
    }

    static {
        MODULE$ = new JobLogging$();
        jobLogging = new DynamicVariable((Object)NullJobLogging$.MODULE$);
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, JobLogging.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, JobLogging.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, JobLogging.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, JobLogging.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JobLogging$.class);
    }

    public IJobLogging getInstance() {
        return (IJobLogging)jobLogging.value();
    }

    public <T> Tuple2<IJobLog, Option<T>> run(String jobType, Function0<T> fn) {
        return this.runNested(new NestedJobLogging((IJobLogging)jobLogging.value(), jobType), fn);
    }

    public IJobLog run(String jobType, Runnable r) {
        return (IJobLog)this.runNested(new NestedJobLogging((IJobLogging)jobLogging.value(), jobType), (Function0 & Serializable)() -> {
            this.run$$anonfun$1(r);
            return BoxedUnit.UNIT;
        })._1();
    }

    public <JOBLOG, T> Tuple2<IJobLog, Option<T>> run(IJobLogging jl, Function0<T> fn) {
        ObjectRef t = ObjectRef.create((Object)None$.MODULE$);
        jobLogging.withValue((Object)jl, (Function0 & Serializable)() -> {
            this.run$$anonfun$2(jl, fn, t);
            return BoxedUnit.UNIT;
        });
        return Tuple2$.MODULE$.apply((Object)jl.getJobLog(), (Object)((Option)t.elem));
    }

    public <JOBLOG, T> Tuple2<IJobLog, Option<T>> runNested(IJobLogging jl, Function0<T> fn) {
        Some t = Some$.MODULE$.apply(jobLogging.withValue((Object)jl, () -> this.$anonfun$1(jl, fn)));
        return Tuple2$.MODULE$.apply((Object)jl.getJobLog(), (Object)t);
    }

    public LoggingHelper.Level getLogLevel(String jobType) {
        return new NamedLogger(jobType).getLevel();
    }

    public void add(JobEntry entry) {
        ((IJobLogging)jobLogging.value()).add(entry);
    }

    public void debug(String category, Function0<String> msg) {
        ((IJobLogging)jobLogging.value()).debug(category, msg);
    }

    public void info(String category, Function0<String> msg) {
        ((IJobLogging)jobLogging.value()).info(category, msg);
    }

    public void warn(String category, Function0<String> msg) {
        ((IJobLogging)jobLogging.value()).warn(category, msg);
    }

    public void error(String category, Function0<String> msg) {
        ((IJobLogging)jobLogging.value()).error(category, msg);
    }

    public void error(String category, Function0<String> msg, Exception ex) {
        ((IJobLogging)jobLogging.value()).error(category, msg, ex);
    }

    public Nothing$ cancel() {
        throw new JobLogging.JobCancelledException();
    }

    public Nothing$ unableToComplete(String msg) {
        throw new JobLogging.JobUnableToCompleteException(msg);
    }

    public void exception(Throwable ex) {
        this.add(JobException$.MODULE$.apply(ThrowableInfo$.MODULE$.apply(ex), JobException$.MODULE$.$lessinit$greater$default$2()));
    }

    public Option<JobResult> lastJobResult() {
        return ((IJobLogging)jobLogging.value()).lastJobResult();
    }

    public void logDebug(String category, String msg) {
        ((IJobLogging)jobLogging.value()).debug(category, (Function0<String>)((Function0 & Serializable)() -> this.logDebug$$anonfun$1(msg)));
    }

    public void logInfo(String category, String msg) {
        ((IJobLogging)jobLogging.value()).info(category, (Function0<String>)((Function0 & Serializable)() -> this.logInfo$$anonfun$1(msg)));
    }

    public void logWarn(String category, String msg) {
        ((IJobLogging)jobLogging.value()).warn(category, (Function0<String>)((Function0 & Serializable)() -> this.logWarn$$anonfun$1(msg)));
    }

    public void logError(String category, String msg) {
        ((IJobLogging)jobLogging.value()).error(category, (Function0<String>)((Function0 & Serializable)() -> this.logError$$anonfun$1(msg)));
    }

    public void logError(String category, String msg, Exception ex) {
        ((IJobLogging)jobLogging.value()).error(category, (Function0<String>)((Function0 & Serializable)() -> this.logError$$anonfun$2(msg)), ex);
    }

    public SchedulerAPI.TriggerStatus statusCode(List<JobEntry> entries) {
        return (SchedulerAPI.TriggerStatus)entries.foldLeft((Object)SchedulerAPI$TriggerStatus$.MODULE$.Unknown(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                SchedulerAPI.TriggerStatus s = (SchedulerAPI.TriggerStatus)tuple2._1();
                JobEntry e = (JobEntry)tuple2._2();
                return s.$plus(this.status(e));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Option<Object> elapsed(List<JobEntry> entries) {
        return entries.headOption().map((Function1 & Serializable)_$4 -> _$4.timestamp()).flatMap((Function1 & Serializable)start -> this.elapsed$$anonfun$2(entries, BoxesRunTime.unboxToLong((Object)start)));
    }

    public String summary(List<JobEntry> entries) {
        StringBuilder sb = new StringBuilder();
        List useful = entries.filterNot((Function1 & Serializable)_$6 -> _$6 instanceof JobLogEntry);
        sb.append(useful.collect((PartialFunction)new Serializable(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final boolean isDefinedAt(JobEntry x) {
                JobEntry jobEntry = x;
                if (jobEntry instanceof JobReference) {
                    JobReference e = (JobReference)jobEntry;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(JobEntry x, Function1 function1) {
                JobEntry jobEntry = x;
                if (jobEntry instanceof JobReference) {
                    JobReference e = (JobReference)jobEntry;
                    return e;
                }
                return function1.apply((Object)x);
            }
        }).map((Function1 & Serializable)_$7 -> _$7.text()).mkString("\n"));
        sb.append(useful.collect((PartialFunction)new Serializable(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final boolean isDefinedAt(JobEntry x) {
                JobEntry jobEntry = x;
                if (jobEntry instanceof JobAuthentication) {
                    JobAuthentication e = (JobAuthentication)jobEntry;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(JobEntry x, Function1 function1) {
                JobEntry jobEntry = x;
                if (jobEntry instanceof JobAuthentication) {
                    JobAuthentication e = (JobAuthentication)jobEntry;
                    return e;
                }
                return function1.apply((Object)x);
            }
        }).map((Function1 & Serializable)_$8 -> _$8.text()).mkString("\n"));
        sb.append(useful.collect((PartialFunction)new Serializable(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final boolean isDefinedAt(JobEntry x) {
                JobEntry jobEntry = x;
                if (jobEntry instanceof JobDescription) {
                    JobDescription e = (JobDescription)jobEntry;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(JobEntry x, Function1 function1) {
                JobEntry jobEntry = x;
                if (jobEntry instanceof JobDescription) {
                    JobDescription e = (JobDescription)jobEntry;
                    return e;
                }
                return function1.apply((Object)x);
            }
        }).map((Function1 & Serializable)_$9 -> _$9.text()).mkString("\n"));
        sb.append(useful.collect((PartialFunction)new Serializable(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final boolean isDefinedAt(JobEntry x) {
                JobEntry jobEntry = x;
                if (jobEntry instanceof JobResultEntry) {
                    JobResultEntry e = (JobResultEntry)((Object)jobEntry);
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(JobEntry x, Function1 function1) {
                JobEntry jobEntry = x;
                if (jobEntry instanceof JobResultEntry) {
                    JobResultEntry e = (JobResultEntry)((Object)jobEntry);
                    return e;
                }
                return function1.apply((Object)x);
            }
        }).map((Function1 & Serializable)_$10 -> _$10.text()).mkString("\n"));
        this.elapsed(entries).foreach((Function1 & Serializable)time -> this.summary$$anonfun$5(sb, BoxesRunTime.unboxToLong((Object)time)));
        return sb.toString();
    }

    public SchedulerAPI.TriggerStatus status(JobEntry entry) {
        JobEntry jobEntry = entry;
        if (jobEntry instanceof JobCancelled) {
            JobCancelled e = (JobCancelled)jobEntry;
            return SchedulerAPI$TriggerStatus$.MODULE$.Cancelled();
        }
        if (jobEntry instanceof JobException) {
            JobException e = (JobException)jobEntry;
            return SchedulerAPI$TriggerStatus$.MODULE$.LoggedException();
        }
        if (jobEntry instanceof JobTimeout) {
            JobTimeout e = (JobTimeout)jobEntry;
            return SchedulerAPI$TriggerStatus$.MODULE$.StartedButNotFinished();
        }
        if (jobEntry instanceof JobUnableToComplete) {
            JobUnableToComplete e = (JobUnableToComplete)jobEntry;
            return SchedulerAPI$TriggerStatus$.MODULE$.UnableToComplete();
        }
        if (jobEntry instanceof JobRecordCount) {
            JobRecordCount e = (JobRecordCount)jobEntry;
            return SchedulerAPI$TriggerStatus$.MODULE$.Completed();
        }
        if (jobEntry instanceof JobResult) {
            JobResult e = (JobResult)jobEntry;
            return SchedulerAPI$TriggerStatus$.MODULE$.Completed();
        }
        if (jobEntry instanceof JobResultUnzipped) {
            JobResultUnzipped e = (JobResultUnzipped)jobEntry;
            return SchedulerAPI$TriggerStatus$.MODULE$.Completed();
        }
        if (jobEntry instanceof JobEnded) {
            JobEnded e = (JobEnded)jobEntry;
            return SchedulerAPI$TriggerStatus$.MODULE$.Completed();
        }
        return SchedulerAPI$TriggerStatus$.MODULE$.Unknown();
    }

    public Option<JobResult> lastResult() {
        return ((IJobLogging)jobLogging.value()).getJobLog().result();
    }

    private final void run$$anonfun$1(Runnable r$1) {
        r$1.run();
    }

    private final Object run$$anonfun$2$$anonfun$1(Exception ex$2) {
        return "Unexpected error while running job: " + ex$2;
    }

    private final Object run$$anonfun$2$$anonfun$2(Exception ex$3) {
        return "Unable to record job exception in job log: " + ex$3;
    }

    private final void run$$anonfun$2(IJobLogging jl$1, Function0 fn$1, ObjectRef t$1) {
        jl$1.begin();
        try {
            Some some = Some$.MODULE$.apply(fn$1.apply());
            t$1.elem = some;
            some = null;
        }
        catch (JobLogging.JobCancelledException ex) {
            jl$1.add(JobCancelled$.MODULE$.apply(JobCancelled$.MODULE$.$lessinit$greater$default$1()));
        }
        catch (JobLogging.JobUnableToCompleteException ex) {
            jl$1.add(JobUnableToComplete$.MODULE$.apply(ex.getMessage(), JobUnableToComplete$.MODULE$.$lessinit$greater$default$2()));
        }
        catch (Exception ex) {
            this.log().error(() -> this.run$$anonfun$2$$anonfun$1(ex), (Throwable)ex, Line$.MODULE$.apply(234), FullName$.MODULE$.apply("com.elixirtech.arch.job.JobLogging.run"));
            try {
                jl$1.add(JobException$.MODULE$.apply(ThrowableInfo$.MODULE$.apply(ex), JobException$.MODULE$.$lessinit$greater$default$2()));
            }
            catch (Exception ex2) {
                this.log().warn(() -> this.run$$anonfun$2$$anonfun$2(ex2), Line$.MODULE$.apply(236), FullName$.MODULE$.apply("com.elixirtech.arch.job.JobLogging.run"));
            }
        }
        jl$1.end();
    }

    private final Object $anonfun$1(IJobLogging jl$2, Function0 fn$2) {
        jl$2.begin();
        Object ret = fn$2.apply();
        jl$2.end();
        return ret;
    }

    private final String logDebug$$anonfun$1(String msg$1) {
        return msg$1;
    }

    private final String logInfo$$anonfun$1(String msg$2) {
        return msg$2;
    }

    private final String logWarn$$anonfun$1(String msg$3) {
        return msg$3;
    }

    private final String logError$$anonfun$1(String msg$4) {
        return msg$4;
    }

    private final String logError$$anonfun$2(String msg$5) {
        return msg$5;
    }

    private final /* synthetic */ Option elapsed$$anonfun$2(List entries$1, long start) {
        return entries$1.lastOption().map((Function1 & Serializable)_$5 -> _$5.timestamp()).map((Function1)(JFunction1.mcJJ.sp & Serializable)end -> end - start);
    }

    private final /* synthetic */ StringBuilder summary$$anonfun$5(StringBuilder sb$1, long time) {
        return sb$1.append("Elapsed time = " + time);
    }
}

