/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.security;

import com.elixirtech.arch.Domain;
import com.elixirtech.arch.Domain$;
import com.elixirtech.arch.Token;
import com.elixirtech.arch.Token$;
import com.elixirtech.arch.security.AdminPrincipal;
import com.elixirtech.arch.security.AnonymousPrincipal;
import com.elixirtech.arch.security.ChangePasswordPrincipal;
import com.elixirtech.arch.security.DomainPrincipal;
import com.elixirtech.arch.security.GroupPrincipal;
import com.elixirtech.arch.security.TokenPrincipal;
import com.elixirtech.arch.security.UserPrincipal;
import java.io.Serializable;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class SecurityHelper$
implements Serializable {
    public static final SecurityHelper$ MODULE$ = new SecurityHelper$();

    private SecurityHelper$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SecurityHelper$.class);
    }

    public <T extends Principal> Option<T> getPrincipal(Subject subject, Class<T> t) {
        return CollectionConverters$.MODULE$.SetHasAsScala(subject.getPrincipals(t)).asScala().headOption();
    }

    public Option<Token> getToken(Subject subject) {
        Set<TokenPrincipal> ts = subject.getPrincipals(TokenPrincipal.class);
        if (ts.size() == 1) {
            return Some$.MODULE$.apply((Object)Token$.MODULE$.apply(ts.iterator().next().getName()));
        }
        return None$.MODULE$;
    }

    public Option<Domain> getDomain(Subject subject) {
        Set<DomainPrincipal> dp = subject.getPrincipals(DomainPrincipal.class);
        if (dp.size() == 1) {
            return Some$.MODULE$.apply((Object)Domain$.MODULE$.apply(dp.iterator().next().getName()));
        }
        return None$.MODULE$;
    }

    public Option<String> getUserName(Subject subject) {
        Set<UserPrincipal> us = subject.getPrincipals(UserPrincipal.class);
        if (us.size() == 1) {
            return Some$.MODULE$.apply((Object)us.iterator().next().getName());
        }
        return None$.MODULE$;
    }

    public List<String> getGroupNames(Subject subject) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(subject.getPrincipals(GroupPrincipal.class)).asScala().map((Function1 & Serializable)_$1 -> _$1.getName())).toList();
    }

    public scala.collection.immutable.Set<String> getCredentials(Subject subject) {
        List list;
        Option<String> user = this.getUserName(subject);
        Nil$ any = this.isAnon(subject) ? package$.MODULE$.Nil() : (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"*"}));
        List<String> groups = this.getGroupNames(subject);
        Option<String> option = user;
        if (option instanceof Some) {
            String u = (String)((Some)option).value();
            list = groups.$colon$colon$colon((List)any).$colon$colon((Object)u);
        } else if (None$.MODULE$.equals(option)) {
            list = groups.$colon$colon$colon((List)any);
        } else {
            throw new MatchError(option);
        }
        return list.toSet();
    }

    public boolean isAdmin(Subject subject) {
        return subject.getPrincipals(AdminPrincipal.class).size() > 0;
    }

    public boolean isAnon(Subject subject) {
        return subject.getPrincipals(AnonymousPrincipal.class).size() > 0;
    }

    public boolean isChangePassword(Subject subject) {
        return subject.getPrincipals(ChangePasswordPrincipal.class).size() > 0;
    }
}

