/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.barcode;

import com.elixirtech.barcode.IBarcodeBean;
import com.elixirtech.barcode.fourstate.CodeElement;
import com.elixirtech.barcode.fourstate.RM4SCC;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;
import javax.swing.JComponent;

public class BarcodeBean
extends JComponent
implements IBarcodeBean {
    private String m_Code;
    private double m_AngleRadians;

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void setCode(String string) {
        this.m_Code = string;
    }

    @Override
    public void setAngleDegrees(double d) {
        while (d < 0.0) {
            d += 360.0;
        }
        while (d >= 360.0) {
            d -= 360.0;
        }
        this.m_AngleRadians = d < 90.0 ? 0.0 : (d < 180.0 ? 1.5707963267948966 : (d < 270.0 ? Math.PI : 4.71238898038469));
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        Color color = this.getBackground();
        if (color == null) {
            color = Color.WHITE;
        }
        graphics2D.setColor(color);
        graphics2D.fill(this.getVisibleRect());
        graphics2D.translate((double)dimension.width / 2.0, (double)dimension.height / 2.0);
        graphics2D.rotate(this.m_AngleRadians);
        graphics2D.setColor(Color.BLACK);
        List<CodeElement> list = RM4SCC.getCode(this.m_Code);
        Dimension dimension2 = new Dimension(list.size() * 3, 16);
        graphics2D.translate(-dimension2.width / 2, -dimension2.height / 2);
        int n = 1;
        for (CodeElement codeElement : list) {
            int n2 = this.getTop(codeElement);
            int n3 = this.getBottom(codeElement);
            graphics2D.drawLine(n, n2, n, n3);
            n += 3;
        }
    }

    private int getTop(CodeElement codeElement) {
        if (codeElement == CodeElement.ASC || codeElement == CodeElement.BAR) {
            return 0;
        }
        return 6;
    }

    private int getBottom(CodeElement codeElement) {
        if (codeElement == CodeElement.DESC || codeElement == CodeElement.BAR) {
            return 15;
        }
        return 10;
    }
}

