/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.barcode;

import com.dragontechnology.barcode.BarcodeException;
import com.dragontechnology.barcode.BarcodeStrategy;
import com.dragontechnology.barcode.Code128;
import com.dragontechnology.barcode.Code39;
import com.dragontechnology.barcode.Code39_2to1;
import com.dragontechnology.barcode.Codebar;
import com.dragontechnology.barcode.ExtendedCode39;
import com.dragontechnology.barcode.ExtendedCode39_2to1;
import com.dragontechnology.barcode.Interleaved25;
import com.dragontechnology.barcode.Interleaved25_2to1;
import com.dragontechnology.barcode.JBarcodeBean;
import com.dragontechnology.barcode.MSI;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.barcode.AztecBean;
import com.elixirtech.barcode.BarcodeBean;
import com.elixirtech.barcode.DataBarBarCode;
import com.elixirtech.barcode.DataMatrixBean;
import com.elixirtech.barcode.IBarcodeBean;
import com.elixirtech.barcode.PDF417Bean;
import com.elixirtech.barcode.QRCodeBean;
import com.elixirtech.barcode.strategy.EAN13;
import com.elixirtech.barcode.strategy.EAN8;
import com.elixirtech.barcode.strategy.UPCA;
import com.elixirtech.barcode.strategy.UPCE;
import com.elixirtech.report2.raw.model.AztecCode;
import com.elixirtech.report2.raw.model.Barcode;
import com.elixirtech.report2.raw.model.BarcodeBasic;
import com.elixirtech.report2.raw.model.DataMatrixCode;
import com.elixirtech.report2.raw.model.PDF417Code;
import com.elixirtech.report2.raw.model.QRCode;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class BasicBarcodeRenderer {
    static ElxLoggerJ m_Logger = ElxLoggerJ.getLogger(BasicBarcodeRenderer.class);
    public static Map<String, Class<? extends BarcodeStrategy>> BARCODE_STRATEGIES = new HashMap<String, Class<? extends BarcodeStrategy>>();
    private static String DEFAULTTEXT;
    private static String EAN8TEXT;
    private static String EAN13TEXT;
    private static String UPCA;
    private static String UPCE;
    private static String RM4SCC;
    private static String RSS;
    private static String RSS_Limited;
    private static String RSS_Expanded;
    public static ElxLoggerJ m_Log;

    public static BarcodeStrategy getStrategy(String string) {
        Class<? extends BarcodeStrategy> clazz = BARCODE_STRATEGIES.get(string);
        BarcodeStrategy barcodeStrategy = null;
        try {
            barcodeStrategy = clazz.newInstance();
        }
        catch (Exception exception) {
            m_Logger.error((Object)"Get Barcode Strategy exception, return code 39 as default ", (Throwable)exception);
            return new Code39();
        }
        return barcodeStrategy;
    }

    public IBarcodeBean getBarcode(Barcode barcode) {
        if ("RM4SCC".equals(barcode.getType())) {
            return this.getElixirBarcode(barcode);
        }
        if ("QRCode".equals(barcode.getType())) {
            return this.getQRCode(barcode);
        }
        if ("PDF417".equals(barcode.getType())) {
            return this.getPDF417Code(barcode);
        }
        if ("DataMatrix".equals(barcode.getType())) {
            return this.getDataMatrix(barcode);
        }
        if ("Aztec".equals(barcode.getType())) {
            return this.getAztech(barcode);
        }
        if (barcode.getType() != null && barcode.getType().startsWith("RSS-")) {
            return this.getDataBar(barcode);
        }
        return this.getDragonBarcode(barcode);
    }

    private IBarcodeBean getAztech(Barcode barcode) {
        BarcodeBasic barcodeBasic = barcode.getBarcodeBasic();
        assert (barcodeBasic instanceof AztecCode);
        AztecCode aztecCode = (AztecCode)barcodeBasic;
        AztecBean aztecBean = new AztecBean();
        if (aztecCode != null) {
            aztecBean.setLayers(aztecCode.getLayers());
        } else {
            m_Logger.warn((Object)"Unable able to get DataMatrix data.");
        }
        return aztecBean;
    }

    private IBarcodeBean getDataMatrix(Barcode barcode) {
        BarcodeBasic barcodeBasic = barcode.getBarcodeBasic();
        assert (barcodeBasic instanceof DataMatrixCode);
        DataMatrixCode dataMatrixCode = (DataMatrixCode)barcodeBasic;
        DataMatrixBean dataMatrixBean = new DataMatrixBean();
        if (dataMatrixCode != null) {
            dataMatrixBean.setSymbolShape(dataMatrixCode.getShape());
        } else {
            m_Logger.warn((Object)"Unable able to get DataMatrix data.");
        }
        return dataMatrixBean;
    }

    private IBarcodeBean getPDF417Code(Barcode barcode) {
        BarcodeBasic barcodeBasic = barcode.getBarcodeBasic();
        assert (barcodeBasic instanceof PDF417Code);
        PDF417Code pDF417Code = (PDF417Code)barcodeBasic;
        PDF417Bean pDF417Bean = new PDF417Bean();
        if (pDF417Code != null) {
            pDF417Bean.setCompaction(pDF417Code.isCompaction());
            pDF417Bean.setCompactMode(pDF417Code.getCompactMode());
        } else {
            m_Logger.warn((Object)"Unable able to get PDF417Code data.");
        }
        return pDF417Bean;
    }

    private IBarcodeBean getQRCode(Barcode barcode) {
        BarcodeBasic barcodeBasic = barcode.getBarcodeBasic();
        assert (barcodeBasic instanceof QRCode);
        QRCode qRCode = (QRCode)barcodeBasic;
        QRCodeBean qRCodeBean = new QRCodeBean();
        qRCodeBean.setErrorCorrectionLevelValue(qRCode.getErrorCorrectionLevel());
        qRCodeBean.setCharacterSet(qRCode.getCharacterSet());
        return qRCodeBean;
    }

    private IBarcodeBean getDataBar(Barcode barcode) {
        Integer n;
        Integer n2;
        BarcodeBasic barcodeBasic = barcode.getBarcodeBasic();
        assert (barcodeBasic != null);
        DataBarBarCode dataBarBarCode = new DataBarBarCode();
        dataBarBarCode.setType(barcode.getType());
        Double d = barcodeBasic.getBarcodeAngle();
        if (d != null) {
            dataBarBarCode.setAngleDegrees(d);
        }
        if ((n2 = barcodeBasic.getHeight()) != null && n2 != 0) {
            dataBarBarCode.setBarHeight(Math.max(2, n2 / 20));
        }
        if ((n = barcodeBasic.getBarWidth()) != null && n != 0) {
            dataBarBarCode.setBarWidth(Math.max(1, n / 20));
        }
        dataBarBarCode.setPaintText(barcodeBasic.isShowText() != null && barcodeBasic.isShowText() != false);
        Color color = null;
        String string = barcode.getBackgroundColor();
        color = StringUtil.notEmpty(string) ? StandardColor.lookup(string) : Color.WHITE;
        dataBarBarCode.setBackground(color);
        return dataBarBarCode;
    }

    private IBarcodeBean getElixirBarcode(Barcode barcode) {
        BarcodeBean barcodeBean = new BarcodeBean();
        BarcodeBasic barcodeBasic = barcode.getBarcodeBasic();
        assert (barcodeBasic != null);
        Color color = null;
        String string = barcode.getBackgroundColor();
        color = StringUtil.notEmpty(string) ? StandardColor.lookup(string) : Color.WHITE;
        barcodeBean.setBackground(color);
        if (barcodeBasic.getBarcodeAngle() != null) {
            barcodeBean.setAngleDegrees(barcodeBasic.getBarcodeAngle());
        }
        return barcodeBean;
    }

    private IBarcodeBean getDragonBarcode(Barcode barcode) {
        JBarcodeBean jBarcodeBean = new JBarcodeBean();
        BarcodeStrategy barcodeStrategy = BasicBarcodeRenderer.getStrategy(barcode.getType());
        Color color = null;
        String string = barcode.getBackgroundColor();
        color = StringUtil.notEmpty(string) ? StandardColor.lookup(string) : Color.WHITE;
        jBarcodeBean.setBarcodeBackground(color);
        jBarcodeBean.setBackground(color);
        jBarcodeBean.setCodeType(barcodeStrategy);
        BarcodeBasic barcodeBasic = barcode.getBarcodeBasic();
        assert (barcodeBasic != null);
        jBarcodeBean.setBarcodeHeight(barcodeBasic.getHeight() / 20);
        jBarcodeBean.setNarrowestBarWidth(barcodeBasic.getBarWidth() / 20);
        if (barcodeBasic.getBarcodeAngle() != null) {
            jBarcodeBean.setAngleDegrees(barcodeBasic.getBarcodeAngle());
        }
        try {
            int n = barcodeStrategy.requiresChecksum();
            if (n == 1) {
                jBarcodeBean.setCheckDigit(true);
            } else if (n == 0) {
                jBarcodeBean.setCheckDigit(false);
            } else {
                jBarcodeBean.setCheckDigit(barcodeBasic.isCheckDigit());
            }
        }
        catch (BarcodeException barcodeException) {
            m_Log.error((Object)("setCheckDigit Barcode exception, check digit is set to true." + barcodeException));
            try {
                jBarcodeBean.setCheckDigit(true);
            }
            catch (BarcodeException barcodeException2) {
                // empty catch block
            }
        }
        jBarcodeBean.setShowText(barcodeBasic.isShowText());
        return jBarcodeBean;
    }

    public void render(Barcode barcode, String string) {
        IBarcodeBean iBarcodeBean = this.getBarcode(barcode);
        iBarcodeBean.setCode(string);
        int n = barcode.getHeight();
        int n2 = barcode.getWidth();
        int n3 = barcode.getBorderWidth();
        if ("None".equals(barcode.getBorderStyle())) {
            n3 = 0;
        }
        if (barcode.isBorderTop()) {
            n -= n3;
        }
        if (barcode.isBorderBottom()) {
            n -= n3;
        }
        if (barcode.isBorderLeft()) {
            n2 -= n3;
        }
        if (barcode.isBorderRight()) {
            n2 -= n3;
        }
        n2 -= barcode.getPaddingLeft() + barcode.getPaddingRight();
        n -= barcode.getPaddingTop() + barcode.getPaddingBottom();
        if ((n2 /= 20) > 0 && (n /= 20) > 0) {
            double d = barcode.getImageResolution();
            if (d > 72.0) {
                m_Logger.debug((Object)("Scale Barcode image resolution " + d));
                double d2 = d / 72.0;
                int n4 = (int)((double)n2 * d2);
                int n5 = (int)((double)n * d2);
                BufferedImage bufferedImage = new BufferedImage(n4, n5, 2);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.scale(d2, d2);
                iBarcodeBean.setSize(new Dimension(n2, n));
                iBarcodeBean.paint(graphics2D);
                graphics2D.dispose();
                bufferedImage.flush();
                barcode.setImage(bufferedImage);
            } else {
                m_Logger.debug((Object)("Use default behaviour " + d));
                iBarcodeBean.setSize(new Dimension(n2, n));
                BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.clipRect(0, 0, n2, n);
                iBarcodeBean.paint(graphics2D);
                graphics2D.dispose();
                barcode.setImage(bufferedImage);
            }
        } else {
            barcode.setImage(null);
        }
    }

    public static String getSampleData(Barcode barcode) {
        if (barcode.getType() == null) {
            return DEFAULTTEXT;
        }
        if (barcode.getType().equals("EAN8")) {
            return EAN8TEXT;
        }
        if (barcode.getType().equals("EAN13")) {
            return EAN13TEXT;
        }
        if (barcode.getType().equals("UPC-A")) {
            return UPCA;
        }
        if (barcode.getType().equals("UPC-E")) {
            return UPCE;
        }
        if (barcode.getType().equals("RM4SCC")) {
            return RM4SCC;
        }
        if (barcode.getType().equals("RSS-Limited")) {
            return RSS_Limited;
        }
        if (barcode.getType().startsWith("RSS-Expanded")) {
            return RSS_Expanded;
        }
        if (barcode.getType().startsWith("RSS-")) {
            return RSS;
        }
        return DEFAULTTEXT;
    }

    static {
        BARCODE_STRATEGIES.put("Code39", Code39.class);
        BARCODE_STRATEGIES.put("Code39_2to1", Code39_2to1.class);
        BARCODE_STRATEGIES.put("EAN8", EAN8.class);
        BARCODE_STRATEGIES.put("EAN13", EAN13.class);
        BARCODE_STRATEGIES.put("ExtendedCode39", ExtendedCode39.class);
        BARCODE_STRATEGIES.put("ExtendedCode39_2to1", ExtendedCode39_2to1.class);
        BARCODE_STRATEGIES.put("Code128", Code128.class);
        BARCODE_STRATEGIES.put("Codebar", Codebar.class);
        BARCODE_STRATEGIES.put("InterleavedCode25", Interleaved25.class);
        BARCODE_STRATEGIES.put("InterleavedCode25_2to1", Interleaved25_2to1.class);
        BARCODE_STRATEGIES.put("MSI", MSI.class);
        BARCODE_STRATEGIES.put("UPC-A", UPCA.class);
        BARCODE_STRATEGIES.put("UPC-E", UPCE.class);
        DEFAULTTEXT = "1234";
        EAN8TEXT = "5512345";
        EAN13TEXT = "007567816412";
        UPCA = "05100003137";
        UPCE = "025300000208";
        RM4SCC = "SO316XY1A";
        RSS = "0950110153000";
        RSS_Limited = "1501234567890";
        RSS_Expanded = "(01)90614141000015(3202)000150";
        m_Log = ElxLoggerJ.getLogger(BasicBarcodeRenderer.class);
    }
}

