/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.corego;

import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.geometry.Geometry;
import com.elixirtech.canvas.geometry.RectangleEx;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Map;

public abstract class RectGO
extends GO {
    protected RectangleEx m_Rect = new RectangleEx(0, 0, this.m_MinWidth, this.m_MinHeight);
    protected int m_MinWidth = 40;
    protected int m_MinHeight = 40;
    protected static final int MARGIN = -5;
    protected static final String RECT = "rect";
    protected static final String MINWIDTH = "minwidth";
    protected static final String MINHEIGHT = "minheight";

    @Override
    public Point snapToEdge(Point point) {
        return Geometry.closestPointOnRectangle(this.getRect(), point);
    }

    public RectangleEx getRect() {
        return (RectangleEx)this.m_Rect.clone();
    }

    public RectangleEx getUnsafeRect() {
        return this.m_Rect;
    }

    @Override
    public boolean contains(Point point) {
        return this.m_Rect.contains(point);
    }

    public void setRect(RectangleEx rectangleEx) {
        this.m_Rect = (RectangleEx)rectangleEx.clone();
        if (this.m_Rect.width() < this.m_MinWidth) {
            this.m_Rect.right = this.m_Rect.left + this.m_MinWidth;
        }
        if (this.m_Rect.height() < this.m_MinHeight) {
            this.m_Rect.bottom = this.m_Rect.top + this.m_MinHeight;
        }
    }

    @Override
    public RectangleEx getSnapRect() {
        return this.getRect();
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> map = super.getProperties();
        map.put(RECT, this.m_Rect.toString());
        map.put(MINWIDTH, Integer.toString(this.m_MinWidth));
        map.put(MINHEIGHT, Integer.toString(this.m_MinHeight));
        return map;
    }

    @Override
    public void setProperty(String string, String string2) {
        if (string.equals(RECT)) {
            this.m_Rect = new RectangleEx(string2);
        } else if (string.equals(MINWIDTH)) {
            this.m_MinWidth = Integer.parseInt(string2);
        } else if (string.equals(MINHEIGHT)) {
            this.m_MinHeight = Integer.parseInt(string2);
        } else {
            super.setProperty(string, string2);
        }
    }

    public Dimension getMinSize() {
        return new Dimension(this.m_MinWidth, this.m_MinHeight);
    }
}

