/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.geometry;

import com.elixirtech.canvas.geometry.Ellipse;
import com.elixirtech.canvas.geometry.Line;
import com.elixirtech.canvas.geometry.RectangleEx;
import java.awt.Dimension;
import java.awt.Point;

public class Geometry {
    public static Point offsetStart(Point point, Point point2, int n) {
        Dimension dimension = new Dimension(point2.x - point.x, point2.y - point.y);
        double d = Math.sqrt(dimension.width * dimension.width + dimension.height * dimension.height);
        Point point3 = new Point((int)((double)point.x + (double)(dimension.width * n) / d), (int)((double)point.y + (double)(dimension.height * n) / d));
        return point3;
    }

    public static Point offsetStop(Point point, Point point2, int n) {
        Dimension dimension = new Dimension(point2.x - point.x, point2.y - point.y);
        double d = Math.sqrt(dimension.width * dimension.width + dimension.height * dimension.height);
        Point point3 = new Point((int)((double)point2.x - (double)(dimension.width * n) / d), (int)((double)point2.y - (double)(dimension.height * n) / d));
        return point3;
    }

    public static Point closestPointOnLineInclusive(Point point, Point point2, Point point3) {
        int n;
        Point point4 = Geometry.closestPointOnLine(point, point2, point3);
        int n2 = point.x <= point2.x ? point.x : point2.x;
        int n3 = point.x >= point2.x ? point.x : point2.x;
        int n4 = point.y <= point2.y ? point.y : point2.y;
        int n5 = n = point.y >= point2.y ? point.y : point2.y;
        if (point4.x >= n2 && point4.x <= n3 && point4.y >= n4 && point4.y <= n) {
            return point4;
        }
        return Geometry.distanceBetweenPoints(point, point3) <= Geometry.distanceBetweenPoints(point2, point3) ? point : point2;
    }

    public static Point closestPointOnLine(Point point, Point point2, Point point3) {
        Line line = new Line(point, point2);
        return line.closestPointTo(point3);
    }

    public static Point closestPointOnEllipse(RectangleEx rectangleEx, Point point) {
        Ellipse ellipse = new Ellipse(rectangleEx);
        return ellipse.closestPointTo(point);
    }

    public static Point closestPointOnRectangle(RectangleEx rectangleEx, Point point) {
        Point point2 = new Point(0, 0);
        if (rectangleEx.center() == point) {
            return new Point(rectangleEx.center().x, rectangleEx.top);
        }
        if (rectangleEx.contains(point)) {
            point2 = point;
            if (point.x - rectangleEx.left >= rectangleEx.right - point.x) {
                int n = rectangleEx.right - point.x;
                if (point.y - rectangleEx.top >= rectangleEx.bottom - point.y) {
                    int n2 = rectangleEx.bottom - point.y;
                    if (n >= n2) {
                        point2.y = rectangleEx.bottom;
                    } else {
                        point2.x = rectangleEx.right;
                    }
                } else {
                    int n3 = point.y - rectangleEx.top;
                    if (n >= n3) {
                        point2.y = rectangleEx.top;
                    } else {
                        point2.x = rectangleEx.right;
                    }
                }
            } else {
                int n = point.x - rectangleEx.left;
                if (point.y - rectangleEx.top >= rectangleEx.bottom - point.y) {
                    int n4 = rectangleEx.bottom - point.y;
                    if (n >= n4) {
                        point2.y = rectangleEx.bottom;
                    } else {
                        point2.x = rectangleEx.left;
                    }
                } else {
                    int n5 = point.y - rectangleEx.top;
                    if (n >= n5) {
                        point2.y = rectangleEx.top;
                    } else {
                        point2.x = rectangleEx.left;
                    }
                }
            }
        } else if (point.x > rectangleEx.left && point.x < rectangleEx.right) {
            point2.x = point.x;
            point2.y = point.y <= rectangleEx.center().y ? rectangleEx.top : rectangleEx.bottom;
        } else {
            point2.x = point.x <= rectangleEx.left ? rectangleEx.left : rectangleEx.right;
            point2.y = point.y <= rectangleEx.top ? rectangleEx.top : (point.y >= rectangleEx.bottom ? rectangleEx.bottom : point.y);
        }
        return point2;
    }

    public static double distanceToLine(Point point, Point point2, Point point3) {
        Line line = new Line(point, point2);
        return line.distanceToPoint(point3);
    }

    public static double distanceToLineInclusive(Point point, Point point2, Point point3) {
        Line line = new Line(point, point2);
        return line.distanceToPointInclusive(point3);
    }

    public static double distanceBetweenPoints(Point point, Point point2) {
        int n = point.x - point2.x;
        int n2 = point.y - point2.y;
        return Math.sqrt(n * n + n2 * n2);
    }
}

