/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.xml;

import com.elixirtech.canvas.graph.Node;
import com.elixirtech.canvas.graph.RelType;
import com.elixirtech.canvas.graph.Relationship;
import com.elixirtech.jdom.Element;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class JDOMReader {
    protected Map<String, String> m_Aliases;
    protected Element m_Root;
    protected Node m_CurrentNode;
    protected List<Node> m_Nodes = new ArrayList<Node>();

    public JDOMReader(Element element, Map<String, String> map) throws IOException {
        this.m_Root = element;
        this.m_Aliases = map;
        if (!"graph".equals(this.m_Root.getName())) {
            throw new IOException("<graph> expected, found <" + element.getName() + ">");
        }
        String string = this.m_Root.getAttributeValue("version");
        if (!string.startsWith("1.")) {
            throw new IOException("graph version 1 expected : " + string);
        }
        Iterator<Element> iterator = this.m_Root.getChildren().iterator();
        while (iterator.hasNext()) {
            this.load(iterator.next());
        }
        this.assertRels();
    }

    public Node[] readNodes() {
        Node[] nodeArray = new Node[this.m_Nodes.size()];
        this.m_Nodes.toArray(nodeArray);
        return nodeArray;
    }

    protected void load(Element element) throws IOException {
        String string = element.getName();
        if ("node".equals(string)) {
            this.loadNode(element);
        } else if ("relationship".equals(string)) {
            this.loadRelationship(element);
        } else if ("property".equals(string)) {
            this.loadProperty(element);
        } else if ("user-property".equals(string)) {
            this.loadUserProperty(element);
        }
    }

    protected void loadNode(Element element) throws IOException {
        String string = element.getAttributeValue("class");
        if (this.m_Aliases.containsKey(string)) {
            string = this.m_Aliases.get(string);
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName(string, true, classLoader);
            Node node = (Node)clazz.newInstance();
            this.m_Nodes.add(node);
            this.m_CurrentNode = node;
            Iterator<Element> iterator = element.getChildren().iterator();
            while (iterator.hasNext()) {
                this.load(iterator.next());
            }
            this.m_CurrentNode.readXMLAnnotations(element);
        }
        catch (Throwable throwable) {
            throw new IOException("Can't resolve class " + string + " : " + throwable);
        }
    }

    protected void loadRelationship(Element element) throws IOException {
        String string = element.getAttributeValue("type");
        RelType relType = RelType.lookup(string);
        int n = Integer.parseInt(element.getAttributeValue("from"));
        int n2 = Integer.parseInt(element.getAttributeValue("to"));
        Node node = this.m_Nodes.get(n);
        Node node2 = this.m_Nodes.get(n2);
        Relationship relationship = new Relationship(relType, node, node2);
        this.m_Nodes.add(relationship);
        this.m_CurrentNode = relationship;
        Iterator<Element> iterator = element.getChildren().iterator();
        while (iterator.hasNext()) {
            this.load(iterator.next());
        }
    }

    protected void loadProperty(Element element) {
        String string = element.getAttributeValue("name");
        String string2 = element.getText();
        this.m_CurrentNode.setProperty(string, string2);
    }

    protected void loadUserProperty(Element element) {
        String string = element.getAttributeValue("name");
        String string2 = element.getText();
        this.m_CurrentNode.setUserProperty(string, string2);
    }

    protected void assertRels() {
        int n = this.m_Nodes.size();
        for (int i = 0; i < n; ++i) {
            Node node = this.m_Nodes.get(i);
            if (!(node instanceof Relationship)) continue;
            ((Relationship)node).assertRel();
        }
    }
}

