/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2;

import com.elixirtech.chart2.LimnPlot;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.limn.Angle3d;
import com.elixirtech.limn.ArrayOf3dPoints;
import com.elixirtech.limn.IndexingPolygon;
import com.elixirtech.limn.Object3d;
import com.elixirtech.limn.Point3d;
import com.elixirtech.limn.Polyhedron;
import com.elixirtech.limn.RenderedPolygon;
import com.elixirtech.limn.ShadedColor;
import com.elixirtech.limn.World;
import com.elixirtech.limn.chart.ChartWorld;
import com.elixirtech.limn.chart.IAxisValues;
import java.util.List;
import org.jfree.data.UnknownKeyException;
import org.jfree.data.category.CategoryDataset;

public class LimnLineValues {
    private LimnPlot m_Plot;
    private ChartWorld m_World;
    private DatasetHolder m_DatasetHolder;
    private CategoryDataset m_Dataset;
    private ShadedColor[] m_Paints;

    public LimnLineValues(LimnPlot limnPlot, ChartWorld chartWorld, DatasetHolder datasetHolder) {
        this.m_Plot = limnPlot;
        this.m_World = chartWorld;
        this.m_DatasetHolder = datasetHolder;
        this.m_Dataset = (CategoryDataset)this.m_DatasetHolder.getDataset();
        int n = this.m_Dataset.getRowCount();
        this.m_Paints = this.m_Plot.getPaints(n);
        for (int i = 0; i < n; ++i) {
            this.buildRow(i);
        }
    }

    private void buildRow(int n) {
        Comparable comparable = this.m_Dataset.getRowKey(n);
        List list = this.m_Dataset.getColumnKeys();
        int n2 = 0;
        IAxisValues iAxisValues = this.m_World.getBottomLeftAxisValues();
        IAxisValues iAxisValues2 = this.m_World.getLeftAxisValues();
        IAxisValues iAxisValues3 = this.m_World.getBottomRightAxisValues();
        double d = iAxisValues3.getLocation(comparable);
        int n3 = (int)(d * 200.0);
        int n4 = (int)(iAxisValues3.getStepSize() * 200.0);
        String string = "v." + n + ".";
        double d2 = 5.0;
        double[] dArray = new double[list.size()];
        double[] dArray2 = new double[list.size()];
        for (int i = 0; i < dArray.length; ++i) {
            Comparable comparable2 = (Comparable)list.get(i);
            if (comparable2 == null) continue;
            dArray2[i] = (int)(iAxisValues.getLocation(comparable2) * 200.0);
            try {
                Number number = this.m_Dataset.getValue(comparable, comparable2);
                if (number == null) continue;
                dArray[i] = iAxisValues2.getLocation(number) * 200.0;
                continue;
            }
            catch (UnknownKeyException unknownKeyException) {
                // empty catch block
            }
        }
        this.buildColumnValues(string + n2, dArray, dArray2, d2, n3, n4, this.m_Paints[n]);
    }

    public void buildColumnValues(String string, double[] dArray, double[] dArray2, double d, double d2, double d3, ShadedColor shadedColor) {
        Polyhedron polyhedron = LimnLineValues.renderedValue(dArray, d3, d, d3 / 5.0, dArray2, shadedColor);
        Value value = new Value(this.m_World, new Point3d(0.0, 0.0, d2), new Angle3d(), polyhedron);
        value.setId(string);
    }

    public static Polyhedron renderedValue(double[] dArray, double d, double d2, double d3, double[] dArray2, ShadedColor shadedColor) {
        int n;
        int n2 = dArray.length * 4;
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        double[] dArray5 = new double[n2];
        double d4 = d2 / 2.0;
        double d5 = d / 2.0;
        double d6 = d5 - d3;
        double d7 = -d5 + d3;
        for (int i = 0; i < dArray.length; ++i) {
            n = i * 4;
            double d8 = Math.max(0.0, dArray[i] - d4);
            double d9 = Math.max(0.0, dArray[i] + d4);
            dArray3[n] = dArray2[i];
            dArray3[n + 1] = dArray2[i];
            dArray3[n + 2] = dArray2[i];
            dArray3[n + 3] = dArray2[i];
            dArray4[n] = d8;
            dArray4[n + 1] = d9;
            dArray4[n + 2] = d9;
            dArray4[n + 3] = d8;
            dArray5[n] = d6;
            dArray5[n + 1] = d6;
            dArray5[n + 2] = d7;
            dArray5[n + 3] = d7;
        }
        ArrayOf3dPoints arrayOf3dPoints = new ArrayOf3dPoints(dArray3, dArray4, dArray5, n2);
        n = n2 - 2;
        IndexingPolygon[] indexingPolygonArray = new IndexingPolygon[n];
        for (int i = 0; i < dArray.length - 1; ++i) {
            int n3 = i * 4;
            indexingPolygonArray[n3] = new RenderedPolygon(n3 + "-0", new int[]{n3, n3 + 1, n3 + 5, n3 + 4}, shadedColor);
            indexingPolygonArray[n3 + 1] = new RenderedPolygon(n3 + "-1", new int[]{n3 + 1, n3 + 2, n3 + 6, n3 + 5}, shadedColor);
            indexingPolygonArray[n3 + 2] = new RenderedPolygon(n3 + "-2", new int[]{n3 + 2, n3 + 3, n3 + 7, n3 + 6}, shadedColor);
            indexingPolygonArray[n3 + 3] = new RenderedPolygon(n3 + "-3", new int[]{n3 + 3, n3, n3 + 4, n3 + 7}, shadedColor);
        }
        indexingPolygonArray[n - 2] = new RenderedPolygon("start", new int[]{0, 3, 2, 1}, shadedColor);
        indexingPolygonArray[n - 1] = new RenderedPolygon("end", new int[]{n2 - 1, n2 - 4, n2 - 3, n2 - 2}, shadedColor);
        Polyhedron polyhedron = new Polyhedron(arrayOf3dPoints, indexingPolygonArray);
        return polyhedron;
    }

    private static class Value
    extends Object3d {
        public Value(World world, Point3d point3d, Angle3d angle3d, Polyhedron polyhedron) {
            super(world, point3d, angle3d);
            this.setPolyhedron(polyhedron, new Point3d(1.0, 1.0, 1.0));
        }
    }
}

