/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.data;

import com.elixirtech.data2.Data;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.GroupNode;

public class ChartData
implements Data {
    private DataTable m_Table;
    private int m_Index;

    public ChartData(DataTable dataTable) {
        this.m_Table = dataTable;
    }

    public void setRecordIndex(int n) {
        this.m_Index = n;
    }

    @Override
    public String getDataSourceName() {
        return this.m_Table.getName();
    }

    @Override
    public Object getObject(String string) {
        int n = this.m_Table.getColumnIndex(string);
        DataRecord dataRecord = this.m_Table.getRecord(this.m_Index);
        if (n >= 0) {
            return dataRecord.getData(n);
        }
        return null;
    }

    @Override
    public String getString(String string) {
        Object object;
        int n = this.m_Table.getColumnIndex(string);
        DataRecord dataRecord = this.m_Table.getRecord(this.m_Index);
        if (n >= 0 && (object = dataRecord.getData(n)) != null) {
            return object.toString();
        }
        return "";
    }

    @Override
    public DataRecord getDataRecord() {
        return this.m_Table.getRecord(this.m_Index);
    }

    @Override
    public DataTable getDataTable() {
        return this.m_Table;
    }

    @Override
    public GroupNode getGroup() {
        return this.m_Table.getGroups();
    }

    @Override
    public int getRecordIndex() {
        return this.m_Index;
    }

    @Override
    public int getRecordCount() {
        return this.m_Table.getRecordCount();
    }
}

