/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.data;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chart2.data.Category3dDatasetAdapter;
import com.elixirtech.chart2.data.CategoryDatasetAdapter;
import com.elixirtech.chart2.data.GanttTaskDatasetAdaptor;
import com.elixirtech.chart2.data.HighLowDatasetAdapter;
import com.elixirtech.chart2.data.MeterDatasetAdapter;
import com.elixirtech.chart2.data.PieDatasetAdapter;
import com.elixirtech.chart2.data.Scatter3dDatasetAdapter;
import com.elixirtech.chart2.data.WaterfallDatasetAdapter;
import com.elixirtech.chart2.data.WindDatasetAdapter;
import com.elixirtech.chart2.data.WindRoseDatasetAdapter;
import com.elixirtech.chart2.data.XYDatasetAdapter;
import com.elixirtech.chart2.data.XYZDatasetAdaptor;
import com.elixirtech.chart2.model.Category3dType;
import com.elixirtech.chart2.model.CategoryType;
import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.GanttTaskType;
import com.elixirtech.chart2.model.HighLowType;
import com.elixirtech.chart2.model.ICategory3dBaseType;
import com.elixirtech.chart2.model.ICategory3dGroupOnValueType;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.MeterType;
import com.elixirtech.chart2.model.PieType;
import com.elixirtech.chart2.model.PolarType;
import com.elixirtech.chart2.model.Scatter3dType;
import com.elixirtech.chart2.model.WindRoseType;
import com.elixirtech.chart2.model.WindType;
import com.elixirtech.chart2.model.XYType;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.IDataSource;
import java.text.NumberFormat;

public class ChartDataFactory {
    public static final NumberFormat FORMAT = NumberFormat.getInstance();
    public static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ChartDataFactory.class);

    public static DatasetHolder getDatasetHolder(String string, IChart iChart) {
        DataTable dataTable = ChartDataFactory.getTable(string);
        if (dataTable != null) {
            return ChartDataFactory.getDatasetHolder(dataTable, iChart);
        }
        return null;
    }

    public static DatasetHolder getDatasetHolder(DataTable dataTable, IChart iChart) {
        assert (dataTable != null);
        assert (iChart != null);
        assert (iChart.getChartType() != null);
        String string = iChart.getType();
        ChartType chartType = iChart.getChartType();
        return ChartDataFactory.getDatasetHolder(dataTable, string, chartType);
    }

    public static DatasetHolder getDatasetHolder(DataTable dataTable, String string, ChartType chartType) {
        if (string.startsWith("Pie")) {
            return PieDatasetAdapter.getPieData(dataTable, (PieType)chartType, string);
        }
        if (string.startsWith("Column")) {
            return CategoryDatasetAdapter.getCategoryData(dataTable, (CategoryType)chartType);
        }
        if (string.startsWith("Bar")) {
            return CategoryDatasetAdapter.getCategoryData(dataTable, (CategoryType)chartType);
        }
        if (string.startsWith("Bubble")) {
            return XYZDatasetAdaptor.getXYZData(dataTable, (ICategory3dGroupOnValueType)((Object)chartType));
        }
        if (string.startsWith("Area")) {
            return CategoryDatasetAdapter.getCategoryData(dataTable, (CategoryType)chartType);
        }
        if (string.startsWith("Line")) {
            return CategoryDatasetAdapter.getCategoryData(dataTable, (CategoryType)chartType);
        }
        if (string.startsWith("Waterfall")) {
            return WaterfallDatasetAdapter.getCategoryData(dataTable, (CategoryType)chartType);
        }
        if (string.startsWith("XY")) {
            return XYDatasetAdapter.getXYData(dataTable, (XYType)chartType);
        }
        if (string.startsWith("WindRose")) {
            return WindRoseDatasetAdapter.getWindData(dataTable, (WindRoseType)chartType);
        }
        if (string.startsWith("Wind")) {
            return WindDatasetAdapter.getWindData(dataTable, (WindType)chartType);
        }
        if (string.startsWith("HeatMap")) {
            return XYZDatasetAdaptor.getXYZData(dataTable, (ICategory3dBaseType)((Object)chartType));
        }
        if (string.startsWith("Stocks")) {
            return HighLowDatasetAdapter.getHighLowData(dataTable, (HighLowType)chartType);
        }
        if (string.startsWith("Meter")) {
            return MeterDatasetAdapter.getMeterData(dataTable, (MeterType)chartType);
        }
        if (string.startsWith("Polar")) {
            return XYDatasetAdapter.getXYData(dataTable, (PolarType)chartType);
        }
        if (string.startsWith("3D-Scatter")) {
            return Scatter3dDatasetAdapter.getScatterData(dataTable, (Scatter3dType)chartType);
        }
        if (string.startsWith("3D-")) {
            return Category3dDatasetAdapter.getCategoryData(dataTable, (Category3dType)chartType);
        }
        if (string.startsWith("Gantt")) {
            return GanttTaskDatasetAdaptor.getTaskData(dataTable, (GanttTaskType)chartType);
        }
        m_Log.error((Object)("Unable to locate chart type: " + string));
        return null;
    }

    protected static DataTable getTable(String string) {
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        try {
            IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, string);
            return DataTable.build(iDataSource);
        }
        catch (Throwable throwable) {
            m_Log.error((Object)("getFieldData: " + throwable), throwable);
            return null;
        }
    }
}

