/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.data;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chart2.data.ChartData;
import com.elixirtech.chart2.data.DataUtil;
import com.elixirtech.chart2.model.WindType;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.RecordScope;
import com.elixirtech.data2.function.First;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.function.IFunctionFactory;
import com.elixirtech.data2.function.RangedFunction;
import com.elixirtech.js.CompiledScript;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.js.ScriptException;
import com.elixirtech.report2.raw.model.ControlSource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.DefaultWindDataset;
import org.mozilla.javascript.Scriptable;

public class WindDatasetAdapter {
    private static final ElxLoggerJ m_JSLog = ElxLoggerJ.getLogger((String)"JavaScript");

    public static DatasetHolder getWindData(DataTable dataTable, WindType windType) {
        Object object;
        Object object2;
        Object[] objectArray;
        JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
        DataRecord[] dataRecordArray = dataTable.getRecords();
        Value value = WindDatasetAdapter.buildValue(javaScriptEngine, dataTable, windType.getKeySource());
        Value value2 = WindDatasetAdapter.buildValue(javaScriptEngine, dataTable, windType.getDateSource());
        Value value3 = WindDatasetAdapter.buildValue(javaScriptEngine, dataTable, windType.getDirectionSource());
        Value value4 = WindDatasetAdapter.buildValue(javaScriptEngine, dataTable, windType.getForceSource());
        ChartData chartData = new ChartData(dataTable);
        RecordScope recordScope = DataUtil.createRecordScope(chartData);
        TreeMap<String, ArrayList<Wind>> treeMap = new TreeMap<String, ArrayList<Wind>>();
        for (int i = 0; i < dataRecordArray.length; ++i) {
            ArrayList<Wind> arrayList;
            chartData.setRecordIndex(i);
            objectArray = dataRecordArray[i].getData();
            recordScope.setData(objectArray);
            String string = String.valueOf(value.getValue(recordScope));
            object2 = value2.getValue(recordScope);
            Object object3 = value3.getValue(recordScope);
            object = value4.getValue(recordScope);
            Wind wind = new Wind();
            if (object2 instanceof Number) {
                wind.timestamp = ((Number)object2).longValue();
            } else if (object2 instanceof Date) {
                wind.timestamp = ((Date)object2).getTime();
            }
            if (object3 instanceof Number) {
                wind.direction = ((Number)object3).intValue() % 360;
            }
            if (object instanceof Number) {
                wind.force = ((Number)object).intValue();
            }
            if ((arrayList = (ArrayList<Wind>)treeMap.get(string)) == null) {
                arrayList = new ArrayList<Wind>();
                treeMap.put(string, arrayList);
            }
            arrayList.add(wind);
        }
        String[] stringArray = new String[treeMap.size()];
        treeMap.keySet().toArray(stringArray);
        objectArray = new Object[stringArray.length][][];
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = (List)treeMap.get(stringArray[i]);
            objectArray[i] = new Object[object2.size()][];
            for (int j = 0; j < ((Object)objectArray[i]).length; ++j) {
                object = (Wind)object2.get(j);
                objectArray[i][j] = new Object[3];
                objectArray[i][j][0] = ((Wind)object).timestamp;
                objectArray[i][j][1] = ((Wind)object).direction;
                objectArray[i][j][2] = ((Wind)object).force;
            }
        }
        DefaultWindDataset defaultWindDataset = new DefaultWindDataset(stringArray, (Object[][][])objectArray);
        object2 = new DatasetHolder((Dataset)defaultWindDataset);
        ((DatasetHolder)object2).setTitle(DataUtil.buildChartText(javaScriptEngine, dataTable, windType.getTitle()));
        ((DatasetHolder)object2).setLegend(DataUtil.buildChartText(javaScriptEngine, dataTable, windType.getLegend()));
        ((DatasetHolder)object2).setSchema(dataTable.getSchema());
        ((DatasetHolder)object2).setKeyIndex(value.valueIdx);
        return object2;
    }

    private static Value buildValue(JavaScriptEngine javaScriptEngine, DataTable dataTable, ControlSource controlSource) {
        Value value = new Value();
        DataSchema dataSchema = dataTable.getSchema();
        if ("Field".equals(controlSource.getType())) {
            value.valueIdx = dataSchema.getColumnIndex(controlSource.getField());
        } else if ("Operation".equals(controlSource.getType())) {
            IFunctionFactory iFunctionFactory = (IFunctionFactory)Elixir.get(IFunctionFactory.class);
            value.valueIdx = dataSchema.getColumnIndex(controlSource.getField());
            DataType dataType = dataSchema.getColumnType(value.valueIdx);
            value.valueFn = iFunctionFactory.getFunction(dataType, controlSource.getOperation());
            if (value.valueFn instanceof RangedFunction) {
                RangedFunction rangedFunction = (RangedFunction)value.valueFn;
                dataTable.setRange(rangedFunction, dataTable.getGroups(), value.valueIdx);
            }
        } else if ("Script".equals(controlSource.getType())) {
            String string = controlSource.getText();
            if (string.startsWith("=")) {
                string = string.substring(1);
            }
            value.valueScript = javaScriptEngine.compile("value script", string);
        }
        return value;
    }

    private static class Value {
        public int valueIdx = -1;
        public String displayName;
        public Function valueFn = new First();
        public CompiledScript valueScript;
        private boolean m_WarnedOfScriptError = false;

        private Value() {
        }

        public Object getValue(RecordScope recordScope) {
            block4: {
                if (this.valueIdx >= 0) {
                    return recordScope.getData(this.valueIdx);
                }
                if (this.valueScript != null) {
                    try {
                        return this.valueScript.eval((Scriptable)recordScope);
                    }
                    catch (ScriptException scriptException) {
                        if (this.m_WarnedOfScriptError) break block4;
                        m_JSLog.warn((Object)("Script error: " + scriptException));
                        this.m_WarnedOfScriptError = true;
                    }
                }
            }
            return null;
        }
    }

    private static class Wind {
        public long timestamp;
        public int direction;
        public int force;

        private Wind() {
        }
    }
}

