/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.model;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.Group;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.SubPlot;
import com.elixirtech.jdom.Element;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.repository.RMLFileObject;
import com.elixirtech.sax.IBean;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class CompositeChart
implements IBean,
IChart {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(CompositeChart.class);
    protected boolean m_IsLoaded;
    public static final String CATEGORY_MULTIAXIS = "MultiAxis";
    public static final String CATEGORY_COMBO = "Combo";
    public static final String PLOT_CATEGORY = "CategoryPlot";
    public static final String PLOT_XY = "XYPlot";
    public static final String TYPE_AXIS_RANGE = "Range";
    public static final String TYPE_AXIS_DOMAIN = "Domain";
    protected ChartType m_ChartType;
    protected Script m_OnConfigure;
    protected List<SubPlot> m_SubPlot = new ArrayList<SubPlot>();
    protected transient RMLFileObject m_FileObject;
    protected String m_Category;
    protected String m_Type;
    protected Locale m_Locale;
    protected Color m_BackgroundColor;
    protected Double m_SubPlotGap;
    protected String m_DomainRangeType = "Range";

    protected static void logError(String string) {
        m_Log.error((Object)string);
    }

    protected static void logError(String string, Throwable throwable) {
        m_Log.error((Object)string, throwable);
    }

    protected static void logInfo(String string) {
        m_Log.info((Object)string);
    }

    public static boolean isHidden(String string) {
        return false;
    }

    @Override
    public String getTagName() {
        return "composite-chart";
    }

    @Override
    public void loaded() {
        this.m_IsLoaded = true;
        if (this.m_ChartType != null) {
            this.m_ChartType.loaded();
        }
        if (this.m_OnConfigure != null) {
            this.m_OnConfigure.loaded();
        }
        Iterator<SubPlot> iterator = this.m_SubPlot.iterator();
        while (iterator.hasNext()) {
            ((IBean)iterator.next()).loaded();
        }
    }

    @Override
    public void dispose() {
        if (this.m_ChartType != null) {
            if (this.m_ChartType != null) {
                this.m_ChartType.dispose();
            }
            this.m_ChartType = null;
        }
        if (this.m_OnConfigure != null) {
            if (this.m_OnConfigure != null) {
                this.m_OnConfigure.dispose();
            }
            this.m_OnConfigure = null;
        }
        if (this.m_SubPlot != null) {
            Iterator<SubPlot> iterator = this.m_SubPlot.iterator();
            while (iterator.hasNext()) {
                ((IBean)iterator.next()).dispose();
            }
        }
        this.m_SubPlot = null;
    }

    public void copyAttrs(Element element) {
        if (this.m_Category != null) {
            element.setAttribute("category", this.m_Category);
        }
        if (this.m_Type != null) {
            element.setAttribute("type", this.m_Type);
        }
        if (this.m_Locale != null) {
            element.setAttribute("locale", this.m_Locale.toString());
        }
        element.setAttribute("background-color", StandardColor.getColorName(this.m_BackgroundColor));
        if (this.m_DomainRangeType != null) {
            element.setAttribute("domain-range-type", this.m_DomainRangeType);
        }
    }

    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        CompositeChart compositeChart = (CompositeChart)this.getClass().newInstance();
        compositeChart.m_FileObject = this.m_FileObject;
        compositeChart.m_Category = this.m_Category;
        compositeChart.m_Type = this.m_Type;
        compositeChart.m_Locale = this.m_Locale;
        compositeChart.m_BackgroundColor = this.m_BackgroundColor;
        compositeChart.m_SubPlotGap = this.m_SubPlotGap;
        compositeChart.m_DomainRangeType = this.m_DomainRangeType;
        return compositeChart;
    }

    @Override
    public Group getGroup() {
        return null;
    }

    @Override
    public ChartType getChartType() {
        return this.m_ChartType;
    }

    @Override
    public void setChartType(ChartType chartType) {
        this.m_ChartType = chartType;
    }

    @Override
    public Script getOnConfigure() {
        return this.m_OnConfigure;
    }

    @Override
    public void setOnConfigure(Script script) {
        this.m_OnConfigure = script;
    }

    public void addSubPlot(SubPlot subPlot) {
        this.m_SubPlot.add(subPlot);
    }

    public void addSubPlot(int n, SubPlot subPlot) {
        this.m_SubPlot.add(n, subPlot);
    }

    public void addAllSubPlots(Collection<SubPlot> collection) {
        this.m_SubPlot.addAll(collection);
    }

    public int indexOfSubPlot(SubPlot subPlot) {
        return this.m_SubPlot.indexOf(subPlot);
    }

    public void removeSubPlot(SubPlot subPlot) {
        this.m_SubPlot.remove(subPlot);
    }

    public void removeAllSubPlots(Collection collection) {
        this.m_SubPlot.removeAll(collection);
    }

    public void removeAllSubPlots() {
        this.m_SubPlot.clear();
    }

    public SubPlot getSubPlot(int n) {
        return this.m_SubPlot.get(n);
    }

    public int getSubPlotCount() {
        return this.m_SubPlot.size();
    }

    public Iterator<SubPlot> getSubPlotIterator() {
        return this.m_SubPlot.iterator();
    }

    public List<SubPlot> getSubPlotList() {
        return this.m_SubPlot;
    }

    public void setSubPlotList(List<SubPlot> list) {
        this.m_SubPlot = list;
    }

    @Override
    public RMLFileObject getFileObject() {
        return this.m_FileObject;
    }

    @Override
    public void setFileObject(RMLFileObject rMLFileObject) {
        this.m_FileObject = rMLFileObject;
    }

    @Override
    public String getCategory() {
        return this.m_Category;
    }

    @Override
    public void setCategory(String string) {
        this.m_Category = string;
    }

    @Override
    public String getType() {
        return this.m_Type;
    }

    @Override
    public void setType(String string) {
        this.m_Type = string;
    }

    @Override
    public Locale getLocale() {
        return this.m_Locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.m_Locale = locale;
    }

    @Override
    public Color getBackgroundColor() {
        return this.m_BackgroundColor;
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.m_BackgroundColor = color;
    }

    public Double getSubPlotGap() {
        return this.m_SubPlotGap;
    }

    public void setSubPlotGap(Double d) {
        this.m_SubPlotGap = d;
    }

    public String getDomainRangeType() {
        return this.m_DomainRangeType;
    }

    public void setDomainRangeType(String string) {
        this.m_DomainRangeType = string;
    }

    public CompositeChart deepCopy() {
        CompositeChart compositeChart = new CompositeChart();
        this.copyInto(compositeChart);
        return compositeChart;
    }

    protected void copyInto(CompositeChart compositeChart) {
        compositeChart.m_FileObject = this.m_FileObject;
        compositeChart.m_Category = this.m_Category;
        compositeChart.m_Type = this.m_Type;
        compositeChart.m_Locale = this.m_Locale;
        compositeChart.m_BackgroundColor = this.m_BackgroundColor;
        compositeChart.m_SubPlotGap = this.m_SubPlotGap;
        compositeChart.m_DomainRangeType = this.m_DomainRangeType;
        if (this.m_ChartType != null) {
            compositeChart.m_ChartType = this.m_ChartType.deepCopy();
        }
        if (this.m_OnConfigure != null) {
            compositeChart.m_OnConfigure = this.m_OnConfigure.deepCopy();
        }
        compositeChart.m_SubPlot = new ArrayList<SubPlot>();
        for (SubPlot subPlot : this.m_SubPlot) {
            compositeChart.addSubPlot(subPlot.deepCopy());
        }
    }
}

