/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.model;

import com.elixirtech.chart2.model.CompositeChart;
import com.elixirtech.sax.IBean;
import com.elixirtech.sax.IBeanSAXOut;
import com.elixirtech.sax.ISAXOut;
import com.elixirtech.ui.StandardColor;
import java.util.Locale;
import org.xml.sax.helpers.AttributesImpl;

public class CompositeChartSAXOut
implements IBeanSAXOut {
    @Override
    public String getTagName() {
        return "composite-chart";
    }

    @Override
    public void output(ISAXOut iSAXOut, IBean iBean) {
        CompositeChart compositeChart = (CompositeChart)iBean;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.buildAttributes(compositeChart, attributesImpl);
        iSAXOut.startElement(iBean.getTagName(), attributesImpl);
        this.outputChild(iSAXOut, compositeChart);
        this.outputChildren(iSAXOut, compositeChart);
        iSAXOut.endElement(iBean.getTagName());
    }

    @Override
    public void output(ISAXOut iSAXOut, IBean iBean, String string) {
        CompositeChart compositeChart = (CompositeChart)iBean;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.buildAttributes(compositeChart, attributesImpl);
        iSAXOut.startElement(string, attributesImpl);
        this.outputChild(iSAXOut, compositeChart);
        this.outputChildren(iSAXOut, compositeChart);
        iSAXOut.endElement(string);
    }

    public void buildAttributes(CompositeChart compositeChart, AttributesImpl attributesImpl) {
        Object object;
        String string = compositeChart.getCategory();
        if (string != null) {
            object = "category";
            attributesImpl.addAttribute("", (String)object, (String)object, "CDATA", string);
        }
        if ((string = compositeChart.getType()) != null) {
            object = "type";
            attributesImpl.addAttribute("", (String)object, (String)object, "CDATA", string);
        }
        string = "locale";
        object = compositeChart.getLocale();
        if (object != null) {
            attributesImpl.addAttribute("", string, string, "CDATA", ((Locale)object).toString());
        }
        string = "background-color";
        object = StandardColor.getColorName(compositeChart.getBackgroundColor());
        if (object != null) {
            attributesImpl.addAttribute("", string, string, "CDATA", (String)object);
        }
        string = "subplot-gap";
        object = compositeChart.getSubPlotGap();
        if (object != null) {
            attributesImpl.addAttribute("", string, string, "CDATA", ((Double)object).toString());
        }
        if ((string = compositeChart.getDomainRangeType()) != null) {
            object = "domain-range-type";
            attributesImpl.addAttribute("", (String)object, (String)object, "CDATA", string);
        }
    }

    public void outputChild(ISAXOut iSAXOut, CompositeChart compositeChart) {
        iSAXOut.output(compositeChart.getChartType());
        iSAXOut.output(compositeChart.getOnConfigure(), "on-configure");
    }

    public void outputChildren(ISAXOut iSAXOut, CompositeChart compositeChart) {
        iSAXOut.output(compositeChart.getSubPlotIterator());
    }
}

