/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.model;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chart2.model.Font;
import com.elixirtech.chart2.model.Painter;
import com.elixirtech.jdom.Element;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.IControlSourceHolder;
import com.elixirtech.sax.IBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Legend
implements IBean,
IControlSourceHolder {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(Legend.class);
    protected boolean m_IsLoaded;
    protected Font m_Font;
    protected ControlSource m_ControlSource;
    protected List<Painter> m_Painter = new ArrayList<Painter>();
    protected String m_Anchor;
    protected Boolean m_CustomPaint;

    protected static void logError(String string) {
        m_Log.error((Object)string);
    }

    protected static void logError(String string, Throwable throwable) {
        m_Log.error((Object)string, throwable);
    }

    protected static void logInfo(String string) {
        m_Log.info((Object)string);
    }

    public static boolean isHidden(String string) {
        return false;
    }

    public Legend() {
        this.m_Anchor = "None";
        this.m_Font = new Font(Font.LEGEND_FONT);
        this.m_ControlSource = new ControlSource();
        this.m_ControlSource.setType("Literal");
        this.m_CustomPaint = Boolean.FALSE;
    }

    @Override
    public String getTagName() {
        return "legend";
    }

    @Override
    public void loaded() {
        this.m_IsLoaded = true;
        if (this.m_Font != null) {
            this.m_Font.loaded();
        }
        if (this.m_ControlSource != null) {
            this.m_ControlSource.loaded();
        }
        Iterator<Painter> iterator = this.m_Painter.iterator();
        while (iterator.hasNext()) {
            ((IBean)iterator.next()).loaded();
        }
    }

    @Override
    public void dispose() {
        if (this.m_Font != null) {
            if (this.m_Font != null) {
                this.m_Font.dispose();
            }
            this.m_Font = null;
        }
        if (this.m_ControlSource != null) {
            if (this.m_ControlSource != null) {
                this.m_ControlSource.dispose();
            }
            this.m_ControlSource = null;
        }
        if (this.m_Painter != null) {
            Iterator<Painter> iterator = this.m_Painter.iterator();
            while (iterator.hasNext()) {
                ((IBean)iterator.next()).dispose();
            }
        }
        this.m_Painter = null;
    }

    public void copyAttrs(Element element) {
        if (this.m_Anchor != null) {
            element.setAttribute("anchor", this.m_Anchor);
        }
        if (this.m_CustomPaint != null) {
            element.setAttribute("custom-paint", this.m_CustomPaint != false ? "Yes" : "No");
        }
    }

    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        Legend legend = (Legend)this.getClass().newInstance();
        legend.m_Anchor = this.m_Anchor;
        legend.m_CustomPaint = this.m_CustomPaint;
        return legend;
    }

    public Legend(String string) {
        this.m_ControlSource = new ControlSource();
        this.m_ControlSource.setType("Literal");
        this.m_ControlSource.setText(string);
    }

    public Legend(String string, String string2) {
        this(string);
        this.m_Anchor = string2;
    }

    public Font getFont() {
        return this.m_Font;
    }

    public void setFont(Font font) {
        this.m_Font = font;
    }

    @Override
    public ControlSource getControlSource() {
        return this.m_ControlSource;
    }

    @Override
    public void setControlSource(ControlSource controlSource) {
        this.m_ControlSource = controlSource;
    }

    public void addPainter(Painter painter) {
        this.m_Painter.add(painter);
    }

    public void addPainter(int n, Painter painter) {
        this.m_Painter.add(n, painter);
    }

    public void addAllPainters(Collection<Painter> collection) {
        this.m_Painter.addAll(collection);
    }

    public int indexOfPainter(Painter painter) {
        return this.m_Painter.indexOf(painter);
    }

    public void removePainter(Painter painter) {
        this.m_Painter.remove(painter);
    }

    public void removeAllPainters(Collection collection) {
        this.m_Painter.removeAll(collection);
    }

    public void removeAllPainters() {
        this.m_Painter.clear();
    }

    public Painter getPainter(int n) {
        return this.m_Painter.get(n);
    }

    public int getPainterCount() {
        return this.m_Painter.size();
    }

    public Iterator<Painter> getPainterIterator() {
        return this.m_Painter.iterator();
    }

    public List<Painter> getPainterList() {
        return this.m_Painter;
    }

    public void setPainterList(List<Painter> list) {
        this.m_Painter = list;
    }

    public String getAnchor() {
        return this.m_Anchor;
    }

    public void setAnchor(String string) {
        this.m_Anchor = string;
    }

    public Boolean isCustomPaint() {
        return this.m_CustomPaint;
    }

    public void setCustomPaint(Boolean bl) {
        this.m_CustomPaint = bl;
    }

    public Legend deepCopy() {
        Legend legend = new Legend();
        this.copyInto(legend);
        return legend;
    }

    protected void copyInto(Legend legend) {
        legend.m_Anchor = this.m_Anchor;
        legend.m_CustomPaint = this.m_CustomPaint;
        if (this.m_Font != null) {
            legend.m_Font = this.m_Font.deepCopy();
        }
        if (this.m_ControlSource != null) {
            legend.m_ControlSource = this.m_ControlSource.deepCopy();
        }
        legend.m_Painter = new ArrayList<Painter>();
        for (Painter painter : this.m_Painter) {
            legend.addPainter(painter.deepCopy());
        }
    }
}

