/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.model;

import com.elixirtech.chart2.model.AbstractUi;
import com.elixirtech.chart2.model.MeterInterval;
import com.elixirtech.chart2.model.MeterType;
import com.elixirtech.jdom.Element;
import com.elixirtech.sax.IBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class MeterUi
extends AbstractUi
implements IBean {
    public static final String TYPE_PIE_ENDING = "Meter-Pie-Ending";
    public static final String TYPE_FULL_CIRCLE = "Meter-Full-Circle";
    public static final String TYPE_HALF_CHORD = "Meter-Half-Chord";
    public static final String TYPE_THERMOMETER = "Meter-Thermometer";
    protected List<MeterInterval> m_Interval = new ArrayList<MeterInterval>();
    protected double m_RangeMin;
    protected double m_RangeMax;
    protected String m_Unit;
    protected String m_ValueColor;
    protected String m_NeedleColor;

    public static boolean isHidden(String string) {
        return false;
    }

    public MeterUi() {
    }

    @Override
    public String getTagName() {
        return "meter-ui";
    }

    @Override
    public void loaded() {
        super.loaded();
        Iterator<MeterInterval> iterator = this.m_Interval.iterator();
        while (iterator.hasNext()) {
            ((IBean)iterator.next()).loaded();
        }
    }

    @Override
    public void dispose() {
        if (this.m_Interval != null) {
            Iterator<MeterInterval> iterator = this.m_Interval.iterator();
            while (iterator.hasNext()) {
                ((IBean)iterator.next()).dispose();
            }
        }
        this.m_Interval = null;
    }

    @Override
    public void copyAttrs(Element element) {
        if (this.m_Unit != null) {
            element.setAttribute("unit", this.m_Unit);
        }
        if (this.m_ValueColor != null) {
            element.setAttribute("value-color", this.m_ValueColor);
        }
        if (this.m_NeedleColor != null) {
            element.setAttribute("needle-color", this.m_NeedleColor);
        }
        super.copyAttrs(element);
    }

    @Override
    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        MeterUi meterUi = (MeterUi)super.shallowCopy();
        meterUi.m_RangeMin = this.m_RangeMin;
        meterUi.m_RangeMax = this.m_RangeMax;
        meterUi.m_Unit = this.m_Unit;
        meterUi.m_ValueColor = this.m_ValueColor;
        meterUi.m_NeedleColor = this.m_NeedleColor;
        return meterUi;
    }

    public MeterUi(MeterType meterType) {
        meterType.setMeterUi(this);
    }

    @Override
    public void init() {
        this.m_RangeMin = 0.0;
        this.m_RangeMax = 100.0;
        this.m_ValueColor = "Black";
        this.m_NeedleColor = "Green";
    }

    public void addInterval(MeterInterval meterInterval) {
        this.m_Interval.add(meterInterval);
    }

    public void addInterval(int n, MeterInterval meterInterval) {
        this.m_Interval.add(n, meterInterval);
    }

    public void addAllIntervals(Collection<MeterInterval> collection) {
        this.m_Interval.addAll(collection);
    }

    public int indexOfInterval(MeterInterval meterInterval) {
        return this.m_Interval.indexOf(meterInterval);
    }

    public void removeInterval(MeterInterval meterInterval) {
        this.m_Interval.remove(meterInterval);
    }

    public void removeAllIntervals(Collection collection) {
        this.m_Interval.removeAll(collection);
    }

    public void removeAllIntervals() {
        this.m_Interval.clear();
    }

    public MeterInterval getInterval(int n) {
        return this.m_Interval.get(n);
    }

    public int getIntervalCount() {
        return this.m_Interval.size();
    }

    public Iterator<MeterInterval> getIntervalIterator() {
        return this.m_Interval.iterator();
    }

    public List<MeterInterval> getIntervalList() {
        return this.m_Interval;
    }

    public void setIntervalList(List<MeterInterval> list) {
        this.m_Interval = list;
    }

    public double getRangeMin() {
        return this.m_RangeMin;
    }

    public void setRangeMin(double d) {
        this.m_RangeMin = d;
    }

    public double getRangeMax() {
        return this.m_RangeMax;
    }

    public void setRangeMax(double d) {
        this.m_RangeMax = d;
    }

    public String getUnit() {
        return this.m_Unit;
    }

    public void setUnit(String string) {
        this.m_Unit = string;
    }

    public String getValueColor() {
        return this.m_ValueColor;
    }

    public void setValueColor(String string) {
        this.m_ValueColor = string;
    }

    public String getNeedleColor() {
        return this.m_NeedleColor;
    }

    public void setNeedleColor(String string) {
        this.m_NeedleColor = string;
    }

    @Override
    public MeterUi deepCopy() {
        MeterUi meterUi = new MeterUi();
        this.copyInto(meterUi);
        return meterUi;
    }

    protected void copyInto(MeterUi meterUi) {
        super.copyInto(meterUi);
        meterUi.m_RangeMin = this.m_RangeMin;
        meterUi.m_RangeMax = this.m_RangeMax;
        meterUi.m_Unit = this.m_Unit;
        meterUi.m_ValueColor = this.m_ValueColor;
        meterUi.m_NeedleColor = this.m_NeedleColor;
        meterUi.m_Interval = new ArrayList<MeterInterval>();
        for (MeterInterval meterInterval : this.m_Interval) {
            meterUi.addInterval(meterInterval.deepCopy());
        }
    }
}

