/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.model;

import com.elixirtech.chart2.model.ChartTypeSAXOut;
import com.elixirtech.chart2.model.PieType;
import com.elixirtech.sax.IBean;
import com.elixirtech.sax.ISAXOut;
import org.xml.sax.helpers.AttributesImpl;

public class PieTypeSAXOut
extends ChartTypeSAXOut {
    @Override
    public String getTagName() {
        return "pie";
    }

    @Override
    public void output(ISAXOut iSAXOut, IBean iBean) {
        PieType pieType = (PieType)iBean;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.buildAttributes(pieType, attributesImpl);
        iSAXOut.startElement(iBean.getTagName(), attributesImpl);
        this.outputChild(iSAXOut, pieType);
        this.outputChildren(iSAXOut, pieType);
        iSAXOut.endElement(iBean.getTagName());
    }

    @Override
    public void output(ISAXOut iSAXOut, IBean iBean, String string) {
        PieType pieType = (PieType)iBean;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.buildAttributes(pieType, attributesImpl);
        iSAXOut.startElement(string, attributesImpl);
        this.outputChild(iSAXOut, pieType);
        this.outputChildren(iSAXOut, pieType);
        iSAXOut.endElement(string);
    }

    public void buildAttributes(PieType pieType, AttributesImpl attributesImpl) {
        String string = "inverted";
        attributesImpl.addAttribute("", string, string, "CDATA", pieType.isInverted() ? "Yes" : "No");
        string = "retain-key-order";
        attributesImpl.addAttribute("", string, string, "CDATA", pieType.isRetainKeyOrder() ? "Yes" : "No");
        super.buildAttributes(pieType, attributesImpl);
    }

    public void outputChild(ISAXOut iSAXOut, PieType pieType) {
        super.outputChild(iSAXOut, pieType);
        iSAXOut.output(pieType.getKeySource(), "key-source");
        iSAXOut.output(pieType.getValueSource(), "value-sources");
        iSAXOut.output(pieType.getPieUi(), "pie-ui");
    }

    public void outputChildren(ISAXOut iSAXOut, PieType pieType) {
        super.outputChildren(iSAXOut, pieType);
    }
}

