/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.model;

import com.elixirtech.chart2.model.AbstractUi;
import com.elixirtech.chart2.model.Font;
import com.elixirtech.chart2.model.PieType;
import com.elixirtech.chart2.model.Value;
import com.elixirtech.jdom.Element;
import com.elixirtech.sax.IBean;

public class PieUi
extends AbstractUi
implements IBean {
    public static final String TYPE_PIE = "Pie";
    public static final String TYPE_RING = "Pie-Ring";
    public static final String TYPE_3D = "Pie-3D";
    public static final String TYPE_MULTI = "Pie-Multi";
    public static final String TYPE_MULTI_RING = "Pie-Multi-Ring";
    public static final String TYPE_MULTI_3D = "Pie-Multi-3D";
    protected Value m_Value;
    protected Font m_Font;
    protected String m_LabelFormat;
    protected String m_LabelPosition;
    protected int m_ExplodeSector;
    protected float m_ExplodePercentage;
    protected String m_ValueBackground;

    public static boolean isHidden(String string) {
        return false;
    }

    public PieUi() {
        this.m_Font = new Font(Font.VALUE_FONT);
        this.m_Value = new Value();
        this.m_Value.setVisible(true);
        this.m_LabelFormat = "{0}";
        this.m_LabelPosition = "none";
    }

    @Override
    public String getTagName() {
        return "pie-ui";
    }

    @Override
    public void loaded() {
        super.loaded();
        if (this.m_Value != null) {
            this.m_Value.loaded();
        }
        if (this.m_Font != null) {
            this.m_Font.loaded();
        }
        if (this.m_ValueBackground == null) {
            this.m_ValueBackground = "rgb(255,255,192)";
        }
    }

    @Override
    public void dispose() {
        if (this.m_Value != null) {
            if (this.m_Value != null) {
                this.m_Value.dispose();
            }
            this.m_Value = null;
        }
        if (this.m_Font != null) {
            if (this.m_Font != null) {
                this.m_Font.dispose();
            }
            this.m_Font = null;
        }
    }

    @Override
    public void copyAttrs(Element element) {
        if (this.m_LabelFormat != null) {
            element.setAttribute("label-format", this.m_LabelFormat);
        }
        if (this.m_LabelPosition != null) {
            element.setAttribute("label-position", this.m_LabelPosition);
        }
        element.setAttribute("explode-sector", Integer.toString(this.m_ExplodeSector));
        element.setAttribute("explode-percentage", Float.toString(this.m_ExplodePercentage));
        if (this.m_ValueBackground != null) {
            element.setAttribute("value-background", this.m_ValueBackground);
        }
        super.copyAttrs(element);
    }

    @Override
    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        PieUi pieUi = (PieUi)super.shallowCopy();
        pieUi.m_LabelFormat = this.m_LabelFormat;
        pieUi.m_LabelPosition = this.m_LabelPosition;
        pieUi.m_ExplodeSector = this.m_ExplodeSector;
        pieUi.m_ExplodePercentage = this.m_ExplodePercentage;
        pieUi.m_ValueBackground = this.m_ValueBackground;
        return pieUi;
    }

    public PieUi(PieType pieType) {
        pieType.setPieUi(this);
        this.m_LabelFormat = "{0}";
    }

    public Value getValue() {
        return this.m_Value;
    }

    public void setValue(Value value) {
        this.m_Value = value;
    }

    public Font getFont() {
        return this.m_Font;
    }

    public void setFont(Font font) {
        this.m_Font = font;
    }

    public String getLabelFormat() {
        return this.m_LabelFormat;
    }

    public void setLabelFormat(String string) {
        this.m_LabelFormat = string;
    }

    public String getLabelPosition() {
        return this.m_LabelPosition;
    }

    public void setLabelPosition(String string) {
        this.m_LabelPosition = string;
    }

    public int getExplodeSector() {
        return this.m_ExplodeSector;
    }

    public void setExplodeSector(int n) {
        this.m_ExplodeSector = n;
    }

    public float getExplodePercentage() {
        return this.m_ExplodePercentage;
    }

    public void setExplodePercentage(float f) {
        this.m_ExplodePercentage = f;
    }

    public String getValueBackground() {
        return this.m_ValueBackground;
    }

    public void setValueBackground(String string) {
        this.m_ValueBackground = string;
    }

    @Override
    public PieUi deepCopy() {
        PieUi pieUi = new PieUi();
        this.copyInto(pieUi);
        return pieUi;
    }

    protected void copyInto(PieUi pieUi) {
        super.copyInto(pieUi);
        pieUi.m_LabelFormat = this.m_LabelFormat;
        pieUi.m_LabelPosition = this.m_LabelPosition;
        pieUi.m_ExplodeSector = this.m_ExplodeSector;
        pieUi.m_ExplodePercentage = this.m_ExplodePercentage;
        pieUi.m_ValueBackground = this.m_ValueBackground;
        if (this.m_Value != null) {
            pieUi.m_Value = this.m_Value.deepCopy();
        }
        if (this.m_Font != null) {
            pieUi.m_Font = this.m_Font.deepCopy();
        }
    }
}

