/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.model;

import com.elixirtech.chart2.model.AbstractFormat;
import com.elixirtech.jdom.Element;
import com.elixirtech.sax.IBean;

public class SWFFormat
extends AbstractFormat
implements IBean {
    public static final String NONE = "none";
    public static final String DATE = "date";
    public static final String NUMBER = "number";
    public static final String CURRENCY = "currency";
    protected String m_Pattern;
    protected String m_DecimalSeparatorTo;
    protected int m_Precision;
    protected String m_Rounding;
    protected String m_ThousandsSeparatorTo;
    protected Boolean m_UseThousandsSeparator;
    protected Boolean m_UseNegativeSign;
    protected String m_AlignSymbol;
    protected String m_CurrencySymbol;

    public static boolean isHidden(String string) {
        return false;
    }

    public SWFFormat() {
        this.m_Type = NONE;
        this.m_Rounding = NONE;
        this.m_Precision = -1;
        this.m_DecimalSeparatorTo = ".";
        this.m_ThousandsSeparatorTo = ",";
        this.m_UseThousandsSeparator = true;
        this.m_UseNegativeSign = true;
        this.m_CurrencySymbol = "$";
        this.m_AlignSymbol = "left";
    }

    @Override
    public String getTagName() {
        return "swf-format";
    }

    @Override
    public void loaded() {
        super.loaded();
    }

    @Override
    public void dispose() {
    }

    @Override
    public void copyAttrs(Element element) {
        if (this.m_Pattern != null) {
            element.setAttribute("pattern", this.m_Pattern);
        }
        if (this.m_DecimalSeparatorTo != null) {
            element.setAttribute("decimal-separator-to", this.m_DecimalSeparatorTo);
        }
        element.setAttribute("precision", Integer.toString(this.m_Precision));
        if (this.m_Rounding != null) {
            element.setAttribute("rounding", this.m_Rounding);
        }
        if (this.m_ThousandsSeparatorTo != null) {
            element.setAttribute("thousands-separator-to", this.m_ThousandsSeparatorTo);
        }
        if (this.m_UseThousandsSeparator != null) {
            element.setAttribute("use-thousands-separator", this.m_UseThousandsSeparator != false ? "Yes" : "No");
        }
        if (this.m_UseNegativeSign != null) {
            element.setAttribute("use-negative-sign", this.m_UseNegativeSign != false ? "Yes" : "No");
        }
        if (this.m_AlignSymbol != null) {
            element.setAttribute("align-symbol", this.m_AlignSymbol);
        }
        if (this.m_CurrencySymbol != null) {
            element.setAttribute("currency-symbol", this.m_CurrencySymbol);
        }
        super.copyAttrs(element);
    }

    @Override
    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        SWFFormat sWFFormat = (SWFFormat)super.shallowCopy();
        sWFFormat.m_Pattern = this.m_Pattern;
        sWFFormat.m_DecimalSeparatorTo = this.m_DecimalSeparatorTo;
        sWFFormat.m_Precision = this.m_Precision;
        sWFFormat.m_Rounding = this.m_Rounding;
        sWFFormat.m_ThousandsSeparatorTo = this.m_ThousandsSeparatorTo;
        sWFFormat.m_UseThousandsSeparator = this.m_UseThousandsSeparator;
        sWFFormat.m_UseNegativeSign = this.m_UseNegativeSign;
        sWFFormat.m_AlignSymbol = this.m_AlignSymbol;
        sWFFormat.m_CurrencySymbol = this.m_CurrencySymbol;
        return sWFFormat;
    }

    public String getPattern() {
        return this.m_Pattern;
    }

    public void setPattern(String string) {
        this.m_Pattern = string;
    }

    public String getDecimalSeparatorTo() {
        return this.m_DecimalSeparatorTo;
    }

    public void setDecimalSeparatorTo(String string) {
        this.m_DecimalSeparatorTo = string;
    }

    public int getPrecision() {
        return this.m_Precision;
    }

    public void setPrecision(int n) {
        this.m_Precision = n;
    }

    public String getRounding() {
        return this.m_Rounding;
    }

    public void setRounding(String string) {
        this.m_Rounding = string;
    }

    public String getThousandsSeparatorTo() {
        return this.m_ThousandsSeparatorTo;
    }

    public void setThousandsSeparatorTo(String string) {
        this.m_ThousandsSeparatorTo = string;
    }

    public Boolean isUseThousandsSeparator() {
        return this.m_UseThousandsSeparator;
    }

    public void setUseThousandsSeparator(Boolean bl) {
        this.m_UseThousandsSeparator = bl;
    }

    public Boolean isUseNegativeSign() {
        return this.m_UseNegativeSign;
    }

    public void setUseNegativeSign(Boolean bl) {
        this.m_UseNegativeSign = bl;
    }

    public String getAlignSymbol() {
        return this.m_AlignSymbol;
    }

    public void setAlignSymbol(String string) {
        this.m_AlignSymbol = string;
    }

    public String getCurrencySymbol() {
        return this.m_CurrencySymbol;
    }

    public void setCurrencySymbol(String string) {
        this.m_CurrencySymbol = string;
    }

    @Override
    public SWFFormat deepCopy() {
        SWFFormat sWFFormat = new SWFFormat();
        this.copyInto(sWFFormat);
        return sWFFormat;
    }

    protected void copyInto(SWFFormat sWFFormat) {
        super.copyInto(sWFFormat);
        sWFFormat.m_Pattern = this.m_Pattern;
        sWFFormat.m_DecimalSeparatorTo = this.m_DecimalSeparatorTo;
        sWFFormat.m_Precision = this.m_Precision;
        sWFFormat.m_Rounding = this.m_Rounding;
        sWFFormat.m_ThousandsSeparatorTo = this.m_ThousandsSeparatorTo;
        sWFFormat.m_UseThousandsSeparator = this.m_UseThousandsSeparator;
        sWFFormat.m_UseNegativeSign = this.m_UseNegativeSign;
        sWFFormat.m_AlignSymbol = this.m_AlignSymbol;
        sWFFormat.m_CurrencySymbol = this.m_CurrencySymbol;
    }
}

