/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.chart2.ChartException;
import com.elixirtech.chart2.custom.CustomDrawingSupplier;
import com.elixirtech.chart2.model.Font;
import com.elixirtech.chart2.model.Format;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.Legend;
import com.elixirtech.chart2.model.Painter;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.chart2.renderer.DatasetHolders;
import com.elixirtech.chart2.renderer.IChartRenderer;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.js.LocalJavaScriptEngine;
import com.elixirtech.js.ScriptException;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.title.CompositeTitle;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.VerticalAlignment;

public abstract class AbstractChartRenderer
implements IChartRenderer {
    protected IChart m_Chart;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(AbstractChartRenderer.class);
    private static final ElxLoggerJ m_JSLog = ElxLoggerJ.getLogger((String)"JavaScript");

    public AbstractChartRenderer(IChart iChart) {
        this.m_Chart = iChart;
    }

    @Override
    public abstract JFreeChart getChart(Object var1, DatasetHolder var2) throws ChartException;

    public JFreeChart getChart(Object object, DatasetHolders datasetHolders) throws ChartException {
        throw new ChartException("Not in used, overwrite this method");
    }

    protected static void setLegendPainters(Plot plot, Legend legend) {
        if (!legend.isCustomPaint().booleanValue()) {
            return;
        }
        CustomDrawingSupplier customDrawingSupplier = new CustomDrawingSupplier();
        List<Painter> list = legend.getPainterList();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Painter painter : list) {
            boolean bl = painter.isEnabled();
            if (!bl) continue;
            String string = painter.getColor();
            String string2 = painter.getPattern();
            arrayList.add(string);
            arrayList2.add(string2);
        }
        customDrawingSupplier.setPaints(arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray(new String[arrayList.size()]));
        plot.setDrawingSupplier((DrawingSupplier)customDrawingSupplier);
    }

    protected static void setLegend(JFreeChart jFreeChart, Legend legend, String string) {
        if (legend == null) {
            return;
        }
        jFreeChart.removeLegend();
        AbstractChartRenderer.setLegendPainters(jFreeChart.getPlot(), legend);
        String string2 = legend.getAnchor();
        if ("None".equals(string2) || StringUtil.isEmpty(string2)) {
            return;
        }
        LegendTitle legendTitle = null;
        LegendTitle legendTitle2 = new LegendTitle((LegendItemSource)jFreeChart.getPlot());
        if (StringUtil.notEmpty(string)) {
            BlockContainer blockContainer = new BlockContainer();
            TextTitle textTitle = new TextTitle();
            AbstractChartRenderer.setTitleFont(textTitle, legend);
            textTitle.setText(string);
            blockContainer.add((Block)textTitle, (Object)RectangleEdge.TOP);
            blockContainer.add((Block)legendTitle2, (Object)RectangleEdge.RIGHT);
            legendTitle2.setPosition(AbstractChartRenderer.getEdge(string2));
            legendTitle = new CompositeTitle(blockContainer);
        } else {
            legendTitle = legendTitle2;
        }
        jFreeChart.addSubtitle((Title)legendTitle);
        AbstractChartRenderer.setPosition((Title)legendTitle, string2);
    }

    private static RectangleEdge getEdge(String string) {
        if ("East".equals(string) || "West".equals(string)) {
            return RectangleEdge.RIGHT;
        }
        return RectangleEdge.BOTTOM;
    }

    protected static void setTitle(JFreeChart jFreeChart, com.elixirtech.chart2.model.Title title, String string) {
        if (title == null || StringUtil.isEmpty(string)) {
            jFreeChart.setTitle((TextTitle)null);
            return;
        }
        String string2 = title.getAnchor();
        if ("None".equals(string2)) {
            jFreeChart.setTitle((TextTitle)null);
            return;
        }
        TextTitle textTitle = jFreeChart.getTitle();
        if (textTitle == null) {
            textTitle = new TextTitle();
            jFreeChart.setTitle(textTitle);
        }
        AbstractChartRenderer.setPosition((Title)textTitle, string2);
        AbstractChartRenderer.setTitleFont(textTitle, title);
        textTitle.setText(string);
    }

    private static void setPosition(Title title, String string) {
        if ("Northwest".equals(string)) {
            title.setPosition(RectangleEdge.TOP);
            title.setHorizontalAlignment(HorizontalAlignment.LEFT);
        } else if ("Northeast".equals(string)) {
            title.setPosition(RectangleEdge.TOP);
            title.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        } else if ("North".equals(string)) {
            title.setPosition(RectangleEdge.TOP);
            title.setHorizontalAlignment(HorizontalAlignment.CENTER);
        } else if ("West".equals(string)) {
            title.setPosition(RectangleEdge.LEFT);
        } else if ("West".equals(string)) {
            title.setPosition(RectangleEdge.LEFT);
            title.setVerticalAlignment(VerticalAlignment.CENTER);
        } else if ("East".equals(string)) {
            title.setPosition(RectangleEdge.RIGHT);
            title.setVerticalAlignment(VerticalAlignment.CENTER);
        } else if ("Southwest".equals(string)) {
            title.setPosition(RectangleEdge.BOTTOM);
            title.setHorizontalAlignment(HorizontalAlignment.LEFT);
        } else if ("South".equals(string)) {
            title.setPosition(RectangleEdge.BOTTOM);
            title.setHorizontalAlignment(HorizontalAlignment.CENTER);
        } else if ("Southeast".equals(string)) {
            title.setPosition(RectangleEdge.BOTTOM);
            title.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        }
    }

    private static void setTitleFont(TextTitle textTitle, com.elixirtech.chart2.model.Title title) {
        Font font = title.getFont();
        if (font != null) {
            textTitle.setFont(font.getAWTFont());
            textTitle.setPaint((Paint)StandardColor.lookup(font.getFontColor(), Color.BLACK));
        }
    }

    private static void setTitleFont(TextTitle textTitle, Legend legend) {
        Font font = legend.getFont();
        if (font != null) {
            textTitle.setFont(font.getAWTFont());
            textTitle.setPaint((Paint)StandardColor.lookup(font.getFontColor(), Color.BLACK));
        }
    }

    public static Locale getLocale(IChart iChart, Format format) {
        Locale locale = null;
        if (format != null) {
            locale = format.getLocale();
        }
        if (locale == null) {
            locale = iChart.getLocale();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    protected static String convertStyle(String string, String string2) {
        boolean bl = "bold".equals(string);
        boolean bl2 = "italic".equals(string2);
        if (bl && bl2) {
            return "bold+italic";
        }
        if (bl) {
            return "bold";
        }
        if (bl2) {
            return "italic";
        }
        return "plain";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void processScript(Object object, JFreeChart jFreeChart, Script script) {
        if (Script.notEmpty(script)) {
            LocalJavaScriptEngine localJavaScriptEngine = new LocalJavaScriptEngine();
            localJavaScriptEngine.pushScope(localJavaScriptEngine.toScriptable(jFreeChart));
            localJavaScriptEngine.declareBean("cxt", object);
            try {
                String string = script.getText();
                if (string.indexOf("ui.CustomDrawingSupplier") >= 0) {
                    m_Log.warn((Object)"Use of deprecated class: com.elixirtech.chart2.ui.CustomDrawingSupplier. Change .ui. to .custom.");
                    string = string.replace("ui.CustomDrawingSupplier", "custom.CustomDrawingSupplier");
                }
                localJavaScriptEngine.evaluate("on-configure", string);
            }
            catch (ScriptException scriptException) {
                m_JSLog.warn((Object)("on-configure error: " + scriptException), (Throwable)scriptException);
                for (Throwable throwable = scriptException.getCause(); throwable != null; throwable = throwable.getCause()) {
                    m_JSLog.warn((Object)("Cause: " + throwable), throwable);
                }
            }
            finally {
                localJavaScriptEngine.popScope();
                ((JavaScriptEngine)localJavaScriptEngine).dispose();
            }
        }
    }
}

