/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.util.format.Percent100FormatWrapper;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Locale;

public class Formatter {
    public static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(Formatter.class);

    public static boolean isNone(com.elixirtech.chart2.model.Format format) {
        if (format == null) {
            return true;
        }
        String string = format.getType();
        return string == null || "None".equals(string);
    }

    public static boolean notNone(com.elixirtech.chart2.model.Format format) {
        return !Formatter.isNone(format);
    }

    public static NumberFormat getDefaultNumberFormatter(String string, Locale locale) {
        if (string.equals("Currency")) {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getCurrencyInstance(locale);
            return decimalFormat;
        }
        if (string.equals("Number")) {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
            return decimalFormat;
        }
        if (string.equals("Percent")) {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getPercentInstance(locale);
            return decimalFormat;
        }
        if (string.equals("Percent100")) {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getPercentInstance(locale);
            return new Percent100FormatWrapper(decimalFormat);
        }
        return null;
    }

    public static NumberFormat buildNumberFormatter(com.elixirtech.chart2.model.Format format, Locale locale) {
        String string = format.getCustomPattern();
        if (StringUtil.notEmpty(string)) {
            return new DecimalFormat(string);
        }
        String string2 = format.getType();
        if (string2.equals("Currency")) {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getCurrencyInstance(locale);
            Formatter.configNumberFormatter(decimalFormat, format);
            return decimalFormat;
        }
        if (string2.equals("Number")) {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
            Formatter.configNumberFormatter(decimalFormat, format);
            return decimalFormat;
        }
        if (string2.equals("Percent")) {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getPercentInstance(locale);
            Formatter.configNumberFormatter(decimalFormat, format);
            return decimalFormat;
        }
        if (string2.equals("Percent100")) {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getPercentInstance(locale);
            Formatter.configNumberFormatter(decimalFormat, format);
            return new Percent100FormatWrapper(decimalFormat);
        }
        return null;
    }

    public static Format buildFormatter(com.elixirtech.chart2.model.Format format, Locale locale) {
        String string = format.getType();
        Format format2 = Formatter.buildNumberFormatter(format, locale);
        if (string.equals("Date/Time")) {
            int n = Formatter.getStyle(format.getDateFormat());
            int n2 = Formatter.getStyle(format.getTimeFormat());
            if (n == -1) {
                if (n2 == -1) {
                    n2 = 3;
                }
                format2 = DateFormat.getTimeInstance(n2, locale);
            } else {
                format2 = n2 == -1 ? DateFormat.getDateInstance(n, locale) : DateFormat.getDateTimeInstance(n, n2, locale);
            }
        }
        return format2;
    }

    private static void configNumberFormatter(NumberFormat numberFormat, com.elixirtech.chart2.model.Format format) {
        try {
            numberFormat.setMinimumIntegerDigits(format.getMinIntegerDigits());
            numberFormat.setMaximumIntegerDigits(format.getMaxIntegerDigits());
            numberFormat.setMinimumFractionDigits(format.getMinFractionDigits());
            numberFormat.setMaximumFractionDigits(format.getMaxFractionDigits());
            numberFormat.setGroupingUsed(format.isGroupingUsed());
            DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
            decimalFormat.setGroupingSize(format.getGroupingSize());
            decimalFormat.setDecimalSeparatorAlwaysShown(format.isDecimalSeparatorAlwaysShown());
            DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
            decimalFormatSymbols.setNaN("NaN");
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        }
        catch (Exception exception) {
            m_Log.warn((Object)("configNumberFormatter: " + exception));
        }
    }

    private static int getStyle(String string) {
        if (string == null || string.equals("None")) {
            return -1;
        }
        if (string.equals("Full")) {
            return 0;
        }
        if (string.equals("Long")) {
            return 1;
        }
        if (string.equals("Medium")) {
            return 2;
        }
        if (string.equals("Short")) {
            return 3;
        }
        return 3;
    }
}

